function dotext_MF(str_,x,y,owner,textid,data)
	if (#str_ > 0) then
		local str = str_
		if (str_ == "FUNKYCODE") then
			str = FUNKYCODE
		end
		
		dotext(str,x,y,owner,textid,{offsetx = data[1], style = data[2], offsety = data[3], reveal = data[4]})
	end
end

function dotext(str_,x,y,owner,textid,data,atdata)
	local d = data or {}
	local atd = atdata or {}
	local o = owner or 0
	local tid = textid or "text"
	local group = d.group or "none"
	local xpos = 0
	local ypos = 0
	local xp = 0
	local style = d.style or 0
	local reveal = d.reveal or 0
	
	local width = 0
	
	local str = str_
	local keywords = {}
	for word in string.gmatch(str, "%S+") do
		if (string.sub(word, 1, 1) == "@") then
			table.insert(keywords, string.sub(word, 2))
		end
	end
	
	for i,key in ipairs(keywords) do
		local keyword = "@" .. key
		local replacement = tostring(atd[key]) or "error"
		
		if (string.sub(key, -4) == "unit") then
			if (unitlist[replacement] ~= nil) then
				replacement = unitlist[replacement].name
			end
		end
		
		str = string.gsub(str, keyword, tostring(replacement))
	end
	
	str = string.gsub(str, " _", "")
	
	local offsetx = d.offsetx or 0
	local offsety = d.offsety or 0
	local wrap = d.wrap or 0
	local thisline = {}
	local everyline = {}
	
	local vx,vy = 0,0
	if (owner ~= 0) then
		local own = mmf.newObject(owner)
		vx = own.x
		vy = own.y
	end
	
	local i = 1
	while (i <= #str) do
		local l = string.sub(str, i, i)
		
		if (l ~= " ") and (l ~= ">") then
			local lid = 0
			if (l == ".") then
				lid = 62
			elseif (l == "(") then
				lid = 73
			elseif (l == ")") then
				lid = 74
			elseif (l == ";") then
				lid = 71
			else
				lid = (string.find(gdata.strings[LOOKUP], l) or 1) - 1
			end
			
			local unitid,lwidth = MF_text(lid,style)
			local unit = mmf.newObject(unitid)
			
			unit.values[XPOS] = x + xpos
			unit.values[YPOS] = y + ypos
			unit.values[OWNER] = owner
			unit.strings[TEXTID] = tid
			unit.strings[TEXTGROUP] = group
			unit.layer = d.layer or 2
			table.insert(thisline, unit)
			table.insert(everyline, unit)
			
			unit.x = vx + unit.values[XPOS]
			unit.y = vy + unit.values[YPOS]
			unit.values[XORIGIN] = unit.x
			unit.values[YORIGIN] = unit.y
			
			unit.values[LETTER] = lid
			unit.animFrame = lid
			
			if (reveal > 0) then
				unit.values[REVEAL] = i * reveal + 1
			end
			
			xpos = xpos + lwidth
			xp = xp + 1
		elseif (l == ">") then
			if (offsetx > 0) then
				for a,unit in ipairs(thisline) do
					unit.values[XPOS] = unit.values[XPOS] - math.floor(xpos * offsetx)
					unit.x = vx + unit.values[XPOS]
				end
			end
			
			thisline = {}
			xpos = 0
			xp = 0
			ypos = ypos + 9
		else
			xpos = xpos + 4
			xp = xp + 1
		end
		
		width = math.max(width, xpos)
		i = i + 1
		
		if (l == " ") and (wrap > 0) then
			for j=1,#str-i do
				local l2 = string.sub(str, i+j, i+j)
				
				if (l2 == " ") or (i+j == #str) then
					if (xp + j >= wrap) then
						if (offsetx > 0) then
							for a,unit in ipairs(thisline) do
								unit.values[XPOS] = unit.values[XPOS] - math.floor(xpos * offsetx)
								unit.x = vx + unit.values[XPOS]
							end
						end
						
						thisline = {}
						xpos = 0
						xp = 0
						ypos = ypos + 9
					end
					
					break
				end
			end
		end
		
		if (i > #str) and (offsetx > 0) then
			for a,unit in ipairs(thisline) do
				unit.values[XPOS] = unit.values[XPOS] - math.floor(xpos * offsetx)
				unit.x = vx + unit.values[XPOS]
			end
		end
	end
	
	ypos = ypos + 8
	
	if (offsety > 0) then
		for a,unit in ipairs(everyline) do
			unit.values[YPOS] = unit.values[YPOS] - math.floor(ypos * offsety)
			unit.y = vy + unit.values[YPOS]
		end
	end
	
	return width,ypos
end

function dialogue()
	local stop = false
	MF_closemessages()
	
	if (#gdata.dialogue > 0) then
		while (stop == false) do
			local data = gdata.dialogue[1]
			local c = data[1]
			
			if (c == "TEXT") then
				gdata2.values[HIDEDIALOGUEBAR] = 0
				local text = data[2]
				if (#gdata.dname > 0) then
					text = string.upper(gdata.dname) .. ":>" .. text
				end
				MF_deltext("dialogue")
				dotext(text,4-screenw * 0.5,-20,dialdata.fixed,"dialogue",{reveal = 1, layer = 3, wrap = 78})
				stop = true
			elseif (c == "PIC") then
				gdata2.values[HIDEDIALOGUEBAR] = 0
				local sides = {NIL = 0, RIGHT = 1, LEFT = 2}
				local picid = 0
				local side = sides[data[3]] or 0
				
				if (portraits[data[2]] ~= nil) then
					local d = portraits[data[2]]
					picid = d[1]+1
					gdata.dname = d[2]
				elseif (data[2] ~= "NIL") then
					gdata.dname = ""
				end
				
				if (picid ~= gdata.dpic) or (side ~= gdata.side) then
					MF_dpic(picid,side)
					gdata.dpic = picid
					gdata.side = side
				end
			elseif (c == "BACK") then
				local pic = data[2] or "0"
				local timer = data[3] or "20"
				
				gdata.values[BACKGROUND] = tonumber(pic) - 1
				gdata.values[SCENEDELAY] = tonumber(timer)
				stop = true
			elseif (c == "WAIT") then
				local timer = data[2] or "20"
				gdata.values[SCENEDELAY] = tonumber(timer)
				stop = true
			elseif (c == "HIDE") then
				gdata2.values[HIDEDIALOGUEBAR] = 1
			elseif (c == "TEXT_NAME") then
				gdata.dname = data[2] or ""
			elseif (c == "CLS") then
				MF_deltext("dialogue")
				MF_removedpic()
				gdata.dpic = 0
				gdata.dside = 0
				gdata.dname = ""
				local timer = data[2] or "10"
				gdata.values[SCENEDELAY] = tonumber(timer)
				stop = true
			elseif (c == "MESSAGE") or (c == "MESSAGE_TUTO") then
				MF_deltext("dialogue")
				MF_removedpic()
				gdata.dpic = 0
				gdata.dside = 0
				gdata.dname = ""
				gdata.values[DIALOGUE] = 0
				local pic = tonumber(data[2]) or 0
				local text = data[5]
				local xp = tonumber(data[3]) or 0
				local yp = tonumber(data[4]) or 0
				
				messagebox(text,pic,nil,xp,yp,1,true)
				stop = true
			elseif (c == "FADEOUT") then
				gdata.values[SCENEDELAY] = 80
				MF_deltext("dialogue")
				MF_removedpic()
				gdata.dpic = 0
				gdata.dside = 0
				gdata.dname = ""
				MF_fadeout()
				stop = true
			elseif (c == "CREDITS") then
				dialogue_end(true)
				return
			elseif (c == "MUSICMODE") then
				local mm = tonumber(data[2]) or 2
				gdata2.values[MUSICMODE] = mm
			elseif (c == "SOUND") then
				local sound = data[2] or "bop"
				MF_sound(sound)
			end
			
			table.remove(gdata.dialogue, 1)
			
			if (#gdata.dialogue == 0) or stop then
				stop = true
				return
			end
		end
	else
		dialogue_end()
	end
end

function skipdialogue()
	local data = gdata.dialogue[#gdata.dialogue] or {}
	local c = data[1] or "NIL"
	
	local ending = false
	if (c == "CREDITS") then
		ending = true
	end
	
	MF_closemessages()
	dialogue_end(ending)
end

function dialogue_end(ending_)
	gdata.values[DIALOGUE] = 0
	gdata.values[BACKGROUND] = 0
	gdata2.values[HIDEDIALOGUEBAR] = 0
	gdata.values[SCENEDELAY] = 0
	gdata.dialogue = {}
	gdata.dpic = 0
	gdata.dside = 0
	gdata.dname = ""
	MF_deltext("dialogue")
	local ending = ending_ or false
	
	if (gdata.dtype > 0) then
		if ending then
			gdata2.values[CREDITSTYPE] = 1
			MF_loop("returntocredits",1)
		elseif (gdata.values[OUTCOME] > 0) then
			MF_loop("returntomap",1)
		else
			if (gdata.needselection == false) then
				missionstart()
				MF_music(gdata.music[1],gdata.music[2])
				gdata.values[ENEMYTURN] = 0
			else
				gdata.values[ENEMYTURN] = 3
				MF_music(gdata.music[1],gdata.music[2])
				unitselection()
			end
			
			gdata.values[GAMEMODE] = 0
		end
	end
	
	gdata.dtype = 0
end

function ui_turnsleft()
	MF_deltext("turncount")
	
	if (gdata.values[TURNSLEFT] > 1) then
		dotext(tostring(gdata.values[TURNSLEFT]) .. " turns left",screenw - 4,32,0,"turncount",{offsetx = 1.0})
	elseif (gdata.values[TURNSLEFT] == 1) then
		dotext("Last turn!",screenw - 4,32,0,"turncount",{offsetx = 1.0})
	end
end

function dotooltip(unitid)
	local unit = mmf.newObject(unitid)
	
	local id = unit.strings[TEXTID] .. "_" .. unit.strings[TEXTGROUP]
	local t = ""
	
	if (unit.strings[TEXTGROUP] == "action") and (gdata.values[SELECTED] ~= 0) then
		local u = findunit(gdata.values[SELECTED])
		id = unit.strings[TEXTID] .. "_" .. u.name
	end
	
	if (textlist[id] ~= nil) then
		t = textlist[id]
	elseif (textlist[unit.strings[TEXTID]] ~= nil) then
		t = textlist[unit.strings[TEXTID]]
	end
	
	if (gdata.strings[TOOLTIP] ~= t) then
		gdata.strings[TOOLTIP] = t
		MF_deltext("tooltip")
		dotext(gdata.strings[TOOLTIP],4,screenh - 30,0,"tooltip",{wrap = 47, offsety = 1.0})
	end
end

function leveldata(unitid)
	MF_deltext("levelinfo")
	
	local unit = mmf.newObject(unitid)
	local file = unit.strings[FILE]
	local world = gdata.strings[WORLD]
	
	MF_open("/maps",file)
	local data = MF_parsestring(MF_read(0))
	MF_close()
	
	local title = data[1] or "EMPTY"
	local subtitle = data[2] or ""
	
	dotext(title,4,4,0,"levelinfo",{style = 1})
	
	if (#subtitle > 0) then
		dotext(subtitle,4,14,0,"levelinfo")
	end
end

function closeleveldata()
	MF_deltext("levelinfo")
end

function missioninfo(unitid,infoid)
	MF_deltext("missioninfo")
	MF_deltext("levelinfo")
	
	local unit = mmf.newObject(unitid)
	local file = unit.strings[FILE]
	local world = gdata.strings[WORLD]
	local gameid = getgameid()
	local status = tonumber(MF_load(gameid,file)) or 0
	local team = MF_load(gameid,file .. "team")
	local t = MF_parsestring(team)
	
	MF_open("/maps",file)
	local data = MF_parsestring(MF_read(0))
	MF_close()
	
	local title = data[1] or "EMPTY"
	local subtitle = data[2] or ""
	
	local statustext = "Not completed"
	if (status > 1) and (status <= 3) then
		statustext = "Completed!"
	elseif (status > 3) then
		statustext = "Fully Completed!"
	end
	
	local y = 16
	dotext(title,0,y,infoid,"missioninfo",{offsetx = 0.5, style = 1})
	y = y + 12
	dotext(subtitle,0,y+1,infoid,"missioninfo",{offsetx = 0.5})
	y = y + 24
	dotext(statustext,0,y,infoid,"missioninfo",{offsetx = 0.5, style = 1})
	
	local teamstatus = tonumber(MF_load(gameid,file .. "teamstatus")) or 0
	if (teamstatus == 1) then
		dotext("Team challenge completed!",0,73,infoid,"missioninfo",{offsetx = 0.5})
	end
	
	for i,v in ipairs(t) do
		local tid = MF_create("UI_teamicon")
		local tunit = mmf.newObject(tid)
		tunit.values[2] = 0-#t*0.5+(i-1)
		tunit.layer = 2
		
		for a,b in pairs(unitlist) do
			if (a == v) then
				tunit.values[1] = b.icon
				break
			end
		end
	end
end

function closemissioninfo()
	MF_deltext("missioninfo")
end

function messagebox(text_,pict,name,x,y,timer,cont_)
	local picid = MF_create("UI_messagepic")
	local boxid = MF_create("UI_messagebox")
	
	local pic = mmf.newObject(picid)
	pic.values[1] = boxid
	pic.values[2] = pict
	pic.layer = 3
	
	local box = mmf.newObject(boxid)
	box.values[1] = timer or 240
	box.layer = 3
	
	local cont = cont_ or false
	if cont then
		box.values[7] = 1
	end
	
	local text = text_
	if (name ~= nil) then
		text = string.upper(name) .. ">" .. text_
	end
	
	local w = dotext(text,2,0,boxid,"message",{offsety = 0.5, reveal = 1, layer = 3})
	
	box.values[2] = w + 5
	box.values[XPOS] = x
	box.values[YPOS] = y
	pic.values[XPOS] = x - 24
	pic.values[YPOS] = y - 24
end

function trymessage(unit,style)
	local rndlimit = 6
	local count = MF_countmessages()
	
	if (gdata.lastmessager == unit.name) then
		rndlimit = rndlimit + 10
	end
	
	rndlimit = rndlimit + count * 5
	rndlimit = math.max(rndlimit - gdata.messagetime, 1)
	local rnd = math.random(1, rndlimit)
	
	-- print(tostring(rnd) .. ", " .. tostring(count))
	
	if (rnd == 1) and (count < 2)  then
		local d = messageslist[unit.name] or {}
		if (d[style] ~= nil) then
			local text = ""
			if (type(d[style]) == "string") then
				text = d[style]
			elseif (type(d[style]) == "table") then
				local rnd2 = math.random(1, #d[style])
				text = d[style][rnd2]
			end
			
			if (#text > 0) then
				MF_alert(unit.name .. " says " .. style)
				gdata.lastmessager = unit.name
				gdata.messagetime = 0
				messagebox(text, unit.values[ICONID], unit.name, unit.x, unit.y - 24, 110)
			end
		end
	end
end

function weatherdesc(warningid)
	local warning = mmf.newObject(warningid)
	local text = gdata2.strings[WEATHERDESC]
	dotext(text,warning.x + 13,warning.y - 12,0,"weather")
end

function settingsmenu()
	dotext("SETTINGS",screenw * 0.5,16,0,"settings",{layer = 4, offsetx = 0.5, style = 1})
	
	dotext("Screenshake",16,40,0,"settings",{layer = 4, style = 1})
	dotext("Music",16,72,0,"settings",{layer = 4, style = 1})
	dotext("SFX",16,104,0,"settings",{layer = 4, style = 1})
	
	dotext("Extra turns",120,131,0,"settings",{layer = 4, style = 1})
	dotext("Fullscreen",120,159,0,"settings",{layer = 4, style = 1})
end

function closesettingsmenu()
	MF_deltext("settings")
end

function completiontext()
	local gameid = getgameid()
	local total = tonumber(MF_load(gameid,"total_levels")) or 0
	local totalstars = tonumber(MF_load(gameid,"total_stars")) or 0
	
	local x = 4
	local y = screenh - 12
	
	dotext("Levels cleared: " .. tostring(total),x,y,0,"completion")
	dotext("Stars: " .. tostring(totalstars),x,y - 13,0,"completion")
end

function clearmaptext()
	MF_deltext("completion")
end

function credits()
	local listnum = MF_open("","credits")
	local x = screenw * 0.5
	local y = screenh
	
	MF_alert(listnum)
	
	for i=1,listnum do
		local text = MF_read(i-1)
		
		if (#text > 0) then
			dotext(text,x,y + (i-1) * 12,0,"credits",{layer = 4, style = 0, offsetx = 0.5})
		end
	end
end