rules = {}

function parserules(nosound_)
	local nosound = nosound_ or false
	
	if updaterules then
		rules = {}
		for i,v in ipairs(gdata.baserules) do
			table.insert(rules, {{v[1], v[2], v[3]}})
		end
		
		local islist = {}
		local wmap = {}
		
		for i,unit in ipairs(texts) do
			unit.flags[INRULE] = false
			
			if (unit.wtype == 1) then
				table.insert(islist, unit)
			end
			
			local tid = gettid(unit.xpos, unit.ypos)
			wmap[tid] = unit
		end
		
		for i,unit in ipairs(islist) do
			local x,y = unit.xpos,unit.ypos
			
			local rtid = gettid(x+1,y)
			local utid = gettid(x,y-1)
			local ltid = gettid(x-1,y)
			local dtid = gettid(x,y+1)
			
			if (wmap[rtid] ~= nil) and (wmap[ltid] ~= nil) then
				local u1 = wmap[ltid]
				local u2 = wmap[rtid]
				
				if (u1.wtype == 0) and ((u2.wtype == 2) or (u2.wtype == 0)) then
					local rule = {u1.word, unit.word, u2.word}
					local ids = {u1.values[ID], unit.values[ID], u2.values[ID]}
					
					u1.flags[INRULE] = true
					unit.flags[INRULE] = true
					u2.flags[INRULE] = true
					
					table.insert(rules, {rule, ids})
					
					if (u1.prevactive == false) or (u2.prevactive == false) or (unit.prevactive == false) then
						if (nosound == false) then
							MF_sound("rule" .. tostring(math.random(1,5)))
						end
					end
					
					u1.prevactive = true
					u2.prevactive = true
					unit.prevactive = true
				end
			end
			
			if (wmap[dtid] ~= nil) and (wmap[utid] ~= nil) then
				local u1 = wmap[dtid]
				local u2 = wmap[utid]
				
				if (u1.wtype == 0) and ((u2.wtype == 2) or (u2.wtype == 0)) then
					local rule = {u1.word, unit.word, u2.word}
					local ids = {u1.values[ID], unit.values[ID], u2.values[ID]}
					
					u1.flags[INRULE] = true
					unit.flags[INRULE] = true
					u2.flags[INRULE] = true
					
					table.insert(rules, {rule, ids})
					
					if (u1.prevactive == false) or (u2.prevactive == false) or (unit.prevactive == false) then
						if (nosound == false) then
							MF_sound("rule" .. tostring(math.random(1,5)))
						end
					end
					
					u1.prevactive = true
					u2.prevactive = true
					unit.prevactive = true
				end
			end
		end
		
		for i,unit in ipairs(units) do
			unit.stop = false
			unit.safe = false
			unit.float = false
			unit.boom = false
			unit.weak = false
			
			if (unit.name == "empty") then
				unit.stop = true
			end
			
			if (unit.autosolid == false) then
				unit.solid = false
				
				if (unit.values[VISUAL] == 1) then
					MF_outline(unit.fixed,0.2)
				else
					MF_outline(unit.fixed,0)
				end
			else
				MF_outline(unit.fixed,1)
			end
			
			if unit.prevactive and (unit.flags[INRULE] == false) then
				unit.prevactive = false
			end
		end
		
		local objs = findruleunits("is","unit")
		for i,unit in ipairs(objs) do
			unit.solid = true
			MF_outline(unit.fixed,1)
		end
		
		objs = findruleunits("is","stop")
		for i,unit in ipairs(objs) do
			unit.stop = true
		end
		
		objs = findruleunits("is","safe")
		for i,unit in ipairs(objs) do
			unit.safe = true
		end
		
		objs = findruleunits("is","float")
		for i,unit in ipairs(objs) do
			unit.float = true
		end
		
		objs = findruleunits("is","weak")
		for i,unit in ipairs(objs) do
			unit.weak = true
		end
		
		objs = findruleunits("is","boom")
		for i,unit in ipairs(objs) do
			unit.boom = true
		end
	end
	
	updaterules = false
end

function block()
	visitation()
	
	local objs = findruleunits("is","sink")
	local delthese = {}
	local sound = false
	
	for i,unit in ipairs(objs) do
		local x = unit.xpos
		local y = unit.ypos
		
		local targets = here(x,y,false,unit.values[ID])
		
		for j,tunit in ipairs(targets) do
			if (tunit.safe == false) then
				gdata.values[SHAKE] = 5
				MF_explosion(unit.xpos,unit.ypos,2,unit.values[ORDER]+0.5)
				table.insert(delthese, tunit)
				sound = true
			end
		end
	end
	
	if sound then
		MF_sfx("plop" .. tostring(math.random(1,4)) .. "new")
	end
	sound = false
	
	handledels(delthese)
	delthese = {}
	
	objs = findruleunits("is","boom")
	for i,unit in ipairs(objs) do
		if (unit.safe == false) and (unit.flags[BOOM] == false) then
			local x = unit.xpos
			local y = unit.ypos
			
			local targets = here(x,y,false,unit.values[ID])
			
			if (#targets > 0) then
				unit.flags[BOOM] = true
				boom(unit,true)
				table.insert(delthese, unit)
				sound = true
			end
		end
	end
	
	if sound then
		MF_sfx("exp01_short")
	end
	sound = false
	
	handledels(delthese)
	delthese = {}
	
	objs = findruleunits("is","weak")
	for i,unit in ipairs(objs) do
		if (unit.safe == false) then
			local x = unit.xpos
			local y = unit.ypos
			
			local targets = here(x,y,false,unit.values[ID])
			
			if (#targets > 0) then
				MF_explosion(unit.xpos,unit.ypos,0,unit.values[ORDER]+1)
				gdata.values[SHAKE] = 6
				table.insert(delthese, unit)
				sound = true
			end
		end
	end
	
	handledels(delthese)
	delthese = {}
	
	objs = findruleunits("is","defeat")
	for i,unit in ipairs(objs) do
		local x = unit.xpos
		local y = unit.ypos
		
		local targets = here(x,y,false,unit.values[ID])
		
		for j,tunit in ipairs(targets) do
			if (tunit.safe == false) then
				MF_explosion(unit.xpos,unit.ypos,0,unit.values[ORDER]+1)
				gdata.values[SHAKE] = 6
				table.insert(delthese, tunit)
				sound = true
				
				if tunit.boom then
					boom(tunit)
				end
			end
		end
	end
	
	if sound then
		MF_sfx("pop" .. tostring(math.random(1,5)) .. "new")
	end
	sound = false
	
	handledels(delthese)
	delthese = {}
	
	ui_turnorder()
end

function visitation()
	for i,unit in ipairs(units) do
		if (unit.visited == false) then
			if (unit.strings[TYPE] ~= "unit") then
				if (#here_mechs(unit.xpos,unit.ypos) > 0) then
					unit.visited = true
					
					if (objectives_visitlist[unit.name] ~= nil) then
						unit.flags[VISIT] = true
						MF_sound("visit" .. tostring(math.random(1,4)))
					end
					
					if (gdata.undo.target ~= nil) then
						if (gdata.undo.visit == nil) then
							gdata.undo.visit = {}
						end
						
						table.insert(gdata.undo.visit, unit)
					end
				end
			else
				unit.visited = true
				
				if (gdata.undo.target ~= nil) then
					if (gdata.undo.visit == nil) then
						gdata.undo.visit = {}
					end
					
					table.insert(gdata.undo.visit, unit)
				end
			end
		end
	end
end

function endblock()
	local objs = findruleunits("is","more")
	local done = false
	
	for i,unit in ipairs(objs) do
		local x = unit.xpos
		local y = unit.ypos
		
		for j=1,4 do
			local drs = dirs[j]
			local ox,oy = drs[1],drs[2]
			
			if inbounds(x+ox,y+oy) and (namehere(x+ox,y+oy,unit.name) == false) and (#here(x+ox,y+oy,true) == 0) then
				done = true
				local bunit = createunit(unit.name,x+ox,y+oy,unit.values[DIR])
				bunit.values[XPOS] = x
				bunit.values[YPOS] = y
				table.insert(bunit.queue, {"slide", x = x+ox, y = y+oy, dir = j, dist = 3, speed = 0.2})
				
				if (bunit.autosolid == false) then
					if (bunit.values[VISUAL] == 1) then
						MF_outline(bunit.fixed,0.2)
					else
						MF_outline(bunit.fixed,0)
					end
				else
					MF_outline(bunit.fixed,1)
				end
			end
		end
	end
	
	if done then
		MF_sfx("build")
		
		updaterules = true
		parserules()
	end
end

function hasrule(unit,r2,r3)
	local name = unit.name
	
	for i,ruledata in ipairs(rules) do
		local rule = ruledata[1]
		
		if ((rule[1] == name) or (unit.strings[TEAM] == rule[1])) and (rule[2] == r2) and (rule[3] == r3) then
			return true
		end
	end
	
	return false
end

function checkdels(list)
	for i,v in ipairs(list) do
		if (v.flags[DEAD] == false) and v.safe then
			return false
		end
	end
	
	return true
end

function handledels(list,checksafe_)
	local done = {}
	local checksafe = checksafe_ or false
	local success = true
	
	for i,v in ipairs(list) do
		if (done[v.fixed] == nil) and (v.flags[DEAD] == false) and ((checksafe == false) or (v.safe == false)) then
			local fixed = v.fixed
			local id = v.values[ID]
			done[fixed] = 1
			
			delete(id)
			MF_delete(fixed)
		end
		
		if checksafe and v.safe then
			success = false
		end
	end
	
	parserules()
end

function findruleunits(r2,r3)
	local result = {}
	local names = {}
	
	for i,ruledata in ipairs(rules) do
		local rule = ruledata[1]
		
		if (rule[2] == r2) and (rule[3] == r3) then
			if (names[rule[1]] == nil) then
				names[rule[1]] = 1
			end
		end
	end
	
	for name,v in pairs(names) do
		for i,unit in ipairs(units) do
			if ((unit.name == name) or (unit.strings[TEAM] == name)) and ((unit.strings[TYPE] ~= "text") or (name == "text")) then
				table.insert(result, unit)
			end
		end
	end
	
	return result
end

function dotransform()
	local transforms = {}
	local protects = {}
	local transformed = false
	
	for i,d in ipairs(rules) do
		local rule = d[1]
		local ids = d[2]
		
		if (rule[2] == "is") and (rule[1] == rule[3]) then
			local w1type = -1
			local w3type = -1
			
			if (ids ~= nil) then
				local w1 = findunit(ids[1])
				local w3 = findunit(ids[3])
				w1type = w1.wtype
				w3type = w3.wtype
			else
				local id1 = "text_" .. rule[1]
				local id3 = "text_" .. rule[3]
				local d1 = unitlist[id1] or {}
				local d3 = unitlist[id3] or {}
				w1type = d1.wtype or -1
				w3type = d3.wtype or -1
			end
			
			if (w1type == 0) and (w3type == 0) then
				protects[rule[1]] = 1
			end
		end
	end
	
	for i,d in ipairs(rules) do
		local rule = d[1]
		local ids = d[2]
		
		if (rule[2] == "is") and (protects[rule[1]] == nil) and (rule[1] ~= rule[3]) then
			local w1type = -1
			local w3type = -1
			
			if (ids ~= nil) then
				local w1 = findunit(ids[1])
				local w3 = findunit(ids[3])
				w1type = w1.wtype
				w3type = w3.wtype
			else
				local id1 = "text_" .. rule[1]
				local id3 = "text_" .. rule[3]
				local d1 = unitlist[id1] or {}
				local d3 = unitlist[id3] or {}
				w1type = d1.wtype or -1
				w3type = d3.wtype or -1
			end
			
			if (w1type == 0) and (w3type == 0) then
				if (transforms[rule[1]] == nil) then
					transforms[rule[1]] = {}
				end
				
				local target = rule[3]
				if (target == "mech") then
					target = "worm"
				elseif (target == "enemy") then
					target = "skull"
				elseif (target == "text") then
					target = "text_stop"
				end
				
				table.insert(transforms[rule[1]], target)
			end
		end
	end
	
	local delthese = {}
	for w1,d in pairs(transforms) do
		local targets = findunits(w1,true)
		local happened = false
		
		for a,u in ipairs(targets) do
			for i,v in ipairs(d) do
				if (u.name ~= v) then
					happened = true
					local bunit = createunit(v,u.xpos,u.ypos,u.values[DIR])
					transformed = true
					if (bunit.autosolid == false) then
						if (bunit.values[VISUAL] == 1) then
							MF_outline(bunit.fixed,0.2)
						else
							MF_outline(bunit.fixed,0)
						end
					else
						MF_outline(bunit.fixed,1)
					end
				end
			end
			
			if happened then
				MF_explosion(u.xpos,u.ypos,3,u.values[ORDER]+0.5)
				table.insert(delthese, u)
			end
		end
	end
	
	if (#delthese > 0) then
		gdata2.values[UNDO] = 0
		gdata.undo = {}
	end
	handledels(delthese)
	
	if transformed then
		MF_sfx("done4")
		
		updaterules = true
		parserules()
	end
end

function findrule(r1,r2,r3)
	for i,d in ipairs(rules) do
		local rule = d[1]
		
		if ((r1 == nil) or (rule[1] == r1)) and ((r2 == nil) or (rule[2] == r2)) and ((r3 == nil) or (rule[3] == r3)) then
			return true
		end
	end
	
	return false
end