objectives = {}
objectives_visitlist = {}

objectiveslist =
{
	defeatall =
	{
		desc = "Zero @targetunit _s at the end",
		params = {"targetunit"},
		continuous = true,
		end_if_done = true,
		check = function(data)
			if (countunits(data.targetunit) == 0) then
				return 1
			end
			
			return 0
		end,
	},
	lessthan =
	{
		desc = "Fewer than @count @targetunit _s at the end",
		params = {"targetunit", "count"},
		continuous = true,
		check = function(data)
			local count = tonumber(data.count) or 0
			
			if (countunits(data.targetunit) < count) then
				return 1
			end
			
			return 0
		end,
	},
	morethan =
	{
		desc = "More than @count @targetunit _s at the end",
		params = {"targetunit", "count"},
		continuous = true,
		enemytarget = true,
		check = function(data)
			local count = tonumber(data.count) or 0
			
			if (countunits(data.targetunit) > count) then
				return 1
			end
			
			return 0
		end,
	},
	exactly =
	{
		desc = "Exactly @count @targetunit _s at the end",
		params = {"targetunit", "count"},
		continuous = true,
		enemytarget = true,
		check = function(data)
			local count = tonumber(data.count) or 0
			
			if (countunits(data.targetunit) == count) then
				return 1
			end
			
			return 0
		end,
	},
	protect =
	{
		desc = "Don't let any @targetunit _s get destroyed",
		params = {"targetunit"},
		enemytarget = true,
		setup = function(data)
			local count = countunits(data.targetunit)
			data.initcount = count
		end,
		check_once = function(data)
			if (countunits(data.targetunit) >= data.initcount) then
				return 0
			end
			
			return 2
		end,
	},
	visit =
	{
		desc = "Stop at each @targetunit with a mech",
		params = {"targetunit"},
		continuous = true,
		end_if_done = true,
		setup = function(data)
			if (objectives_visitlist[data.targetunit] == nil) then
				objectives_visitlist[data.targetunit] = 1
			end
		end,
		check = function(data)
			if (countunvisited(data.targetunit) > 0) or (countunits(data.targetunit) == 0) then
				return 0
			end
			
			return 1
		end,
	},
	lowturns =
	{
		desc = "Complete in @movecount or fewer turns",
		params = {"movecount"},
		continuous = true,
		end_if_done = true,
		setup = function(data)
			if (tonumber(data.movecount) ~= nil) then
				gdata.values[TURNSLEFT] = tonumber(data.movecount) + gdata2.values[EXTRATURNS]
			end
		end,
		check = function(data)
			return 1
		end,
	},
	lowmoves =
	{
		desc = "Complete in @movecount or fewer moves",
		params = {"movecount"},
		setup = function(data)
			gdata.moves = 0
			gdata.movecounter = true
			updatemovecounter()
		end,
		check_once = function(data)
			local count = tonumber(data.movecount) or 0
			
			if (gdata.moves <= count) then
				return 0
			end
			
			return 2
		end,
	},
	nomoves =
	{
		desc = "Do not act or move with @targetunit",
		params = {"targetunit"},
		setup = function(data)
			gdata.movedunits = {}
		end,
		check_once = function(data)
			if (gdata.movedunits[data.targetunit] == nil) or (gdata.movedunits[data.targetunit] == 0) then
				return 0
			end
			
			return 2
		end,
	},
	newrule =
	{
		desc = "Rule @rule1name @rule2 @rule3name is always active",
		params = {"rule1","rule2","rule3","rule1name","rule3name"},
		continuous = true,
		end_if_done = true,
		setup = function(data)
			local w1d = unitlist[string.lower(data.rule1)] or {}
			local w3d = unitlist[string.lower(data.rule3)] or {}
			data.rule1name = w1d.name or data.rule1
			data.rule3name = w3d.name or data.rule3
			table.insert(gdata.baserules, {string.lower(data.rule1), string.lower(data.rule2), string.lower(data.rule3)})
		end,
		check = function(data)
			return 1
		end,
	},
	haverule =
	{
		desc = "Rule @rule1name @rule2 @rule3name active at the end",
		params = {"rule1","rule2","rule3","rule1name","rule3name"},
		continuous = true,
		setup = function(data)
			local w1d = unitlist[string.lower(data.rule1)] or {}
			local w3d = unitlist[string.lower(data.rule3)] or {}
			data.rule1name = w1d.name or data.rule1
			data.rule3name = w3d.name or data.rule3
		end,
		check = function(data)
			if findrule(string.lower(data.rule1), string.lower(data.rule2), string.lower(data.rule3)) then
				return 1
			end
			
			return 0
		end,
	},
	newweather =
	{
		desc = " @wname is active",
		params = {"w","wname"},
		continuous = true,
		end_if_done = true,
		setup = function(data)
			local v = data.w
			if (weatherlist[v] ~= nil) then
				gdata.weather[#gdata.weather+1] = {}
				local w = gdata.weather[#gdata.weather]
				
				local wdata = weatherlist[v]
				local wname = wdata.name or "MYSTERY"
				local wdesc = wdata.desc or "It's a mystery!!"
				local whide = wdata.hide or false
				
				w.timer = 0
				w.count = 0
				w.name = wname
				w.desc = wdesc
				w.id = v
				w.hide = whide
				w.done = false
				data.wname = wname
				
				if (whide == false) then
					gdata2.strings[WEATHERDESC] = gdata2.strings[WEATHERDESC] .. wname .. ">" .. wdesc .. ">"
				end
			end
		end,
		check = function(data)
			return 1
		end,
	},
}

function addobjective(name,data,optional)
	local d = objectiveslist[name] or {}
	
	local unitid = MF_create("UI_objective")
	objectives[#objectives + 1] = mmf.newObject(unitid)
	local unit = objectives[#objectives]
	unit.id = #objectives
	unit.name = name
	unit.desc = d.desc or "error"
	
	unit.x = 4
	unit.y = 4 + (#objectives - 1) * 15
	unit.layer = 2
	
	for i,v in pairs(data) do
		unit[i] = v
	end
	
	unit.check = d.check
	unit.check_end = d.check_end
	unit.check_once = d.check_once
	unit.continuous = d.continuous or false
	unit.end_if_done = d.end_if_done or false
	unit.enemytarget = d.enemytarget or false
	unit.optional = optional or false
	unit.values[YORIGIN] = unit.y
	
	if (d.setup ~= nil) then
		d.setup(unit)
	end
	
	if unit.optional then
		unit.desc = "+" .. unit.desc
	end
	
	dotext(unit.desc,14,2,unitid,"objective",nil,unit)
end

function objectivecheck(check,only_neutral_)
	local only_neutral = only_neutral_ or false
	local checkstatus = 0
	
	for i,unit in ipairs(objectives) do
		if (unit[check] ~= nil) and (type(unit[check]) == "function") then
			if (only_neutral == false) or (unit.values[STATUS] == 0) then
				local old = unit.values[STATUS]
				unit.values[STATUS] = unit[check](unit)
				
				if (old ~= unit.values[STATUS]) then
					checkstatus = math.max(checkstatus, unit.values[STATUS])
				end
			end
		end
	end
	
	if (checkstatus == 1) then
		MF_sound("obj1")
	elseif (checkstatus == 2) then
		MF_sound("obj2")
	end
end

function objectivecheck_midway()
	local yes = true
	
	for i,unit in ipairs(objectives) do
		if unit.continuous then
			yes = false
			break
		end
		
		if (unit.continuous == false) and (unit.values[STATUS] == 2) and (unit.optional == false) then
			yes = true
			break
		end
		
		if (unit.values[STATUS] ~= 1) then
			yes = false
			break
		end
	end
	
	if yes then
		missionend()
	end
end

function objectivecheck_endnow()
	local yes = true
	
	for i,unit in ipairs(objectives) do
		if unit.continuous and ((unit.end_if_done == false) or (unit.values[STATUS] ~= 1)) then
			yes = false
			break
		end
		
		if (unit.values[STATUS] ~= 1) then
			yes = false
			break
		end
	end
	
	if yes then
		gdata.values[TURNSLEFT] = 0
		missionend()
	end
end

function objectivecheck_missionend()
	for i,unit in ipairs(objectives) do
		if (unit.values[STATUS] == 0) and (unit.continuous == false) then
			unit.values[STATUS] = 1
		end
	end
end