map = {}
units = {}
texts = {}
gamestate = {}

rolling_id = 1
updaterules = true

function init(dataid,dataid2,dialid,pfpid,mapid,backid,sw,sh)
	gdata = mmf.newObject(dataid)
	gdata.action_targeting = ""
	gdata.action_range = ""
	gdata.action = ""
	gdata.targets = {}
	gdata.dialogue = {}
	gdata.dialogue_end = {}
	gdata.dialogue_win = {}
	gdata.dialogue_lose = {}
	gdata.dpic = 0
	gdata.dside = 0
	gdata.dname = ""
	gdata.unlocks = {}
	gdata.needselection = false
	gdata.levelstatus = 0
	gdata.team = {}
	gdata.teamlimits = {}
	gdata.lastmessager = ""
	gdata.messagetime = 0
	gdata.newunlocks = {}
	gdata.mapid = mapid
	gdata.moves = 0
	gdata.movedunits = {}
	gdata.baserules = {}
	gdata.movecounter = false
	gdata.weather = {}
	gdata.dtype = 0
	gdata.undo = {}
	gdata.music = {"",""}
	
	gdata2 = mmf.newObject(dataid2)
	
	dialdata = mmf.newObject(dialid)
	pfp = mmf.newObject(pfpid)
	background = mmf.newObject(backid)
	
	map = {}
	map.w = 8
	map.h = 8
	map.x = gdata.values[MAPX]
	map.y = gdata.values[MAPY]
	map.maxdist = 8
	map.title = ""
	map.subtitle = ""
	
	screenw = sw
	screenh = sh
end

function initmap(w,h)
	MF_clearmap()
	
	gdata.values[MAPY] = 48
	if (h < 8) then
		gdata.values[MAPY] = 90 - (h * 6 - 6)
	end
	
	map = {}
	map.w = w
	map.h = h
	map.x = gdata.values[MAPX]
	map.y = gdata.values[MAPY]
	map.maxdist = math.max(w,h)
	
	map.title = ""
	map.subtitle = ""
	
	for x=0,w-1 do
		for y=0,h-1 do
			local unitid = MF_create("Tile")
			local unitid2 = MF_create("Tile_top")
			local unit = mmf.newObject(unitid)
			local unit2 = mmf.newObject(unitid2)
			
			unit.values[XACTUAL] = map.x + x * 12 - y * 12
			unit.values[YACTUAL] = map.y + x * 6 + y * 6
			unit.x = unit.values[XACTUAL]
			unit.y = unit.values[YACTUAL]
			unit2.x = unit.x
			unit2.y = unit.y
			
			unit.values[XPOS] = x
			unit.values[YPOS] = y
			unit2.values[XPOS] = x
			unit2.values[YPOS] = y
			
			local tid = gettid(x,y)
			map[tid] = unit
			map[tid].mouse = unit2
		end
	end
end
	
function loadmap(data)
	local start = true
	local line = 1
	local phase = 1
	gdata.unlocks = {}
	gdata.newunlocks = {}
	gdata.teamlimits = {}
	local gameid = getgameid()
	gdata.levelstatus = tonumber(MF_load(gameid,gdata.strings[LEVEL])) or 0
	gdata.team = {}
	local turns = 6
	gdata.baserules = {}
	gdata.moves = 0
	gdata.movedunits = {}
	gdata.movecounter = false
	gdata.weather = {}
	gdata.undo = {}
	gdata.music = {"",""}
	rules = {}
	
	gdata2.values[TERRAIN] = 0
	gdata2.values[WEATHEREFFECTS] = 0
	gdata.values[RESTARTAVAILABLE] = 0
	
	local addthese = {}
	while start do
		local d = data[line]
		
		if (type(d) == "table") then
			local code = d[1]
			
			if (phase == 1) then
				map.title = d[1] or "NONAME"
				map.subtitle = d[2] or ""
				phase = 2
				local terrain_ = d[3] or "0"
				gdata2.values[TERRAIN] = tonumber(terrain_) or 0
				local turns_ = d[4] or "5"
				turns = tonumber(turns_) or 6
			elseif (phase == 2) then
				local music = d[1] or "music1"
				if (music == "default") then
					music = "music1"
				end
				
				local world = gdata.strings[WORLD]
				local path = "Data/assets/" .. world .. "/music/" .. music .. ".ogg"
				
				if (MF_findfile(path) == false) then
					path = "Data/assets/default/music/" .. music .. ".ogg"
					world = "default"
					
					if (MF_findfile(path) == false) then
						path = "Data/assets/default/music/music1.ogg"
						music = "music1"
					end
				end
				
				gdata.music = {world, music}
				phase = 3
			elseif (phase == 3) then
				for i,v in ipairs(d) do
					if (v ~= "nounlock") then
						table.insert(gdata.unlocks, v)
					end
				end
				
				phase = 4
			elseif (phase == 4) then
				local starti = 1
				local style = 0
				
				if (#d > 0) then
					if (d[1] == "not") or (d[1] == "only") then
						if (d[1] == "not") then
							style = 2
						elseif (d[1] == "only") then
							style = 1
						end
						
						starti = 2
					end
					
					if (#d > 1) then
						for i=starti,#d do
							local v = d[i]
							gdata.teamlimits[v] = 1
						end
					end
				end
				
				gdata.teamlimits.style = style
				
				phase = 5
			elseif (phase == 5) then
				local weathertext = ""
				
				if (#d > 0) then
					for i,v in ipairs(d) do
						if (weatherlist[v] ~= nil) then
							gdata.weather[#gdata.weather+1] = {}
							local w = gdata.weather[#gdata.weather]
							
							local wdata = weatherlist[v]
							local wname = wdata.name or "MYSTERY"
							local wdesc = wdata.desc or "It's a mystery!!"
							local whide = wdata.hide or false
							
							w.timer = 0
							w.count = 0
							w.name = wname
							w.desc = wdesc
							w.id = v
							w.hide = whide
							w.done = false
							
							if (whide == false) then
								weathertext = weathertext .. wname .. ">" .. wdesc .. ">"
							end
						end
					end
				end
				
				gdata2.strings[WEATHERDESC] = weathertext
				
				phase = 6
			elseif (phase == 6) then
				if (objectiveslist[code] ~= nil) then
					local v = objectiveslist[code]
					local params = {}
					if (v.params ~= nil) then
						for a,b in ipairs(v.params) do
							local pdata = d[a+1] or ""
							params[b] = pdata
						end
					end
					
					local optional = false
					if (d[#d] == "EXTRA") then
						optional = true
					end
					
					table.insert(addthese, {code,params,optional})
				end
			end
		elseif (d == "---") then
			start = false
		end
		
		if (line >= #data) then
			return
		end
		
		line = line + 1
	end
	
	gdata.values[TURNSLEFT] = turns + gdata2.values[EXTRATURNS]
	
	local w = #data - (line-1)
	local h = #data[line]
	local txt = false
	local txt2 = false
	gdata.dialogue = {}
	gdata.dialogue_end = {}
	gdata.dialogue_win = {}
	gdata.dialogue_lose = {}
	gdata.dpic = 0
	gdata.dside = 0
	gdata.dname = ""
	local specials = {INTRO = "dialogue", END_WIN = "dialogue_win", END_LOSE = "dialogue_lose", ENDING = "dialogue_end"}
	local dtype = ""
	
	for i=line,#data do
		local d = data[i]
		local c = d[1] or "NIL"
		
		if (#dtype > 0) and (specials[c] == nil) then
			local text = ""
			
			if (c == "TEXT") or (c == "MESSAGE") or (c == "MESSAGE_TUTO") then
				local jstart = 2
				if (c == "MESSAGE") or (c == "MESSAGE_TUTO") then
					jstart = 5
				end
				
				for j=jstart,#d do
					text = text .. d[j]
					
					if (j < #d) then
						text = text .. " "
					end
				end
				
				if (c == "TEXT") then
					table.insert(gdata[dtype], {c, text})
				end
			end
			
			if (c == "PIC") then
				local portrait = d[2] or "NIL"
				local side = d[3] or "NIL"
				table.insert(gdata[dtype], {c, portrait, side})
			end
			
			if (c == "BACK") then
				table.insert(gdata[dtype], {c, d[2], d[3]})
			end
			
			if (c == "WAIT") then
				table.insert(gdata[dtype], {c, d[2]})
			end
			
			if (c == "CLS") then
				table.insert(gdata[dtype], {c, d[2]})
			end
			
			if (c == "HIDE") then
				table.insert(gdata[dtype], {c})
			end
			
			if (c == "MESSAGE") then
				table.insert(gdata[dtype], {c, d[2], d[3], d[4], text})
			end
			
			if (c == "MESSAGE_TUTO") then
				table.insert(gdata[dtype], {c, d[2], d[3], d[4], text})
			end
			
			if (c == "TEXT_NAME") then
				table.insert(gdata[dtype], {c, d[2]})
			end
			
			if (c == "FADEOUT") then
				table.insert(gdata[dtype], {c})
			end
			
			if (c == "CREDITS") then
				table.insert(gdata[dtype], {c})
			end
			
			if (c == "MUSICMODE") then
				table.insert(gdata[dtype], {c, d[2]})
			end
			
			if (c == "SOUND") then
				table.insert(gdata[dtype], {c, d[2]})
			end
		end
		
		if (specials[c] ~= nil) then
			txt2 = true
			
			if (c == "INTRO") then
				gdata.values[DIALOGUE] = 1
			end
			
			dtype = specials[c]
		end
		
		if (txt == false) and txt2 then
			txt = true
			w = i - line
		end
	end
	
	initmap(w,h)
	gdata.needselection = false
	if (gdata.levelstatus >= 2) and (gdata2.values[CUSTOMTEAM] == 1) then
		gdata.needselection = true
	end
	
	local hm = {}
	
	for x=0,w-1 do
		for y=0,h-1 do
			local currline = data[line+x] or {}
			local curr = currline[h-y] or "---"
			
			if (curr ~= "---") then
				local code = string.sub(curr, 1, 2)
				local dirtext = string.sub(curr, -1)
				local dirnum = math.random(0,3)
				
				if (dirtext == ">") then
					dirnum = 1
				elseif (dirtext == "^") then
					dirnum = 2
				elseif (dirtext == "<") or (#curr == 2) then
					dirnum = 3
				elseif (dirtext == "v") then
					dirnum = 0
				end
				
				for i,v in pairs(unitlist) do
					if (v.code == code) then
						if (v.unit == nil) or (v.unit == false) then
							dirnum = 0
						end
						
						local uname = i
						if (v.team == "mech") and (gdata.levelstatus >= 2) and (gdata2.values[CUSTOMTEAM] == 1) then
							uname = "pick"
						end
						
						local u = createunit(uname,x,y,dirnum)
						
						if (v.team == "mech") and (uname ~= "pick") then
							table.insert(gdata.team, i)
						end
						
						if (uname == "pick") then
							gdata.needselection = true
							
							table.insert(hm, u)
							
							if (uname ~= i) then
								u.strings[NAME] = "pick"
								u.strings[TYPE] = i
								u.values[ADIR] = 0
								u.values[ASPRITE] = v.sprite or v.anim
								u.values[PREVIEWICONID] = v.anim
							end
						end
						
						break
					end
				end
			end
		end
	end
	
	objectives = {}
	objectives_visitlist = {}
	for i,v in ipairs(addthese) do
		if (v[3] == false) or (gdata.values[MISSION] > 0) then
			addobjective(v[1],v[2],v[3])
		end
	end
	
	if (#gdata.weather > 0) then
		for i,v in ipairs(gdata.weather) do
			if (v.hide == false) then
				local unitid = MF_create("WeatherAlert")
				local unit = mmf.newObject(unitid)
				unit.x = 16
				unit.y = 4 + (#objectives) * 15 + 14
				unit.layer = 2
				unit.values[YORIGIN] = unit.y
				break
			end
		end
	end
	
	for i,u in ipairs(hm) do
		local uid = MF_create("UI_unithere")
		local u2 = mmf.newObject(uid)
		u2.values[XPOS] = u.values[XPOS]
		u2.values[YPOS] = u.values[YPOS]
		u2.layer = 2
	end
	
	gdata.values[OUTCOME] = 0
	updaterules = true
	parserules(true)
	ui_turnsleft()
	ui_turnorder()
	
	if (gdata2.values[RESTARTED] == 1) then
		gdata.values[DIALOGUE] = 0
		gdata.dialogue = {}
	end
	
	if (gdata.values[DIALOGUE] == 1) then
		gdata.values[ENEMYTURN] = 2
		gdata.values[GAMEMODE] = -1
		gdata.dname = ""
		MF_dpic(-1,0)
		gdata.dtype = 1
		
		dialogue()
	elseif gdata.needselection then
		gdata.values[ENEMYTURN] = 3
		unitselection()
	else
		MF_music(gdata.music[1],gdata.music[2])
		missionstart()
	end
end

function addunit(unitid)
	units[#units+1] = mmf.newObject(unitid)
	local unit = units[#units]
	return unit
end

function clearunits()
	map = {}
	texts = {}
	units = {}
	objectives = {}
	objectives_visitlist = {}
	rules = {}
end

function createunit(name,x,y,dir,id_)
	local unitid = MF_create("Object")
	local unit = addunit(unitid)
	
	local data = unitlist[name] or {}
	
	unit.name = name
	unit.visname = data.name or name
	unit.xpos = x
	unit.ypos = y
	unit.xhelper = x
	unit.yhelper = x
	unit.values[XPOS] = x
	unit.values[YPOS] = y
	unit.values[ADIR] = data.animgroup or 0
	unit.values[ASPRITE] = data.sprite or data.anim or 0
	unit.values[AFRAMECOUNT] = data.animframes or 1
	unit.values[ICONID] = data.icon or data.anim or 0
	unit.values[PFP] = data.profilepic or data.anim or 0
	unit.values[PREVIEWICONID] = data.anim or 0
	unit.values[ACT1ICON] = data.act1_icon or data.icon or data.anim or 0
	unit.values[ACT2ICON] = data.act2_icon or data.icon or data.anim or 0
	unit.values[ID] = id_ or newid()
	unit.id = unit.values[ID]
	unit.step = 0
	unit.timer = 0
	unit.xvel = 0
	unit.yvel = 0
	unit.zvel = 0
	unit.queue = {}
	unit.strings[TYPE] = "object"
	unit.strings[NAME] = name
	unit.strings[VISNAME] = unit.visname
	unit.strings[TEAM] = "none"
	unit.values[SPEED] = data.speed or 0
	
	unit.unit = false
	unit.solid = false
	unit.stop = false
	unit.safe = false
	unit.float = false
	unit.visited = false
	unit.weak = false
	unit.boom = false
	unit.prevactive = false
	unit.noturn = data.noturn or false
	
	unit.values[DIR] = dir or 0
	unit.autosolid = false
	
	if (data.ground ~= nil) then
		unit.values[VISUAL] = data.ground or 1
	end
	
	if (data.unit ~= nil) and data.unit then
		unit.unit = true
		unit.solid = true
		unit.autosolid = true
		unit.speed = data.speed or 0
		unit.strings[TEAM] = data.team or "none"
		unit.action = data.action
		unit.action_targeting = data.action_targeting
		unit.action_range = data.action_range
		unit.strings[TYPE] = "unit"
		unit.routestorage = {}
		
		if (unit.strings[TEAM] == "mech") then
			unit.strings[ACT1] = data.action or "none"
		end
		
		if (data.solid ~= nil) then
			unit.solid = data.solid
			unit.autosolid = data.solid
		end
		
		if (unit.strings[TEAM] == "enemy") and (unit.noturn == false) then
			MF_showturnorder()
		end
	end
	
	if (data.text ~= nil) and data.text then
		unit.solid = true
		unit.autosolid = true
		unit.word = data.word or "none"
		unit.wtype = data.wtype or -1
		unit.strings[TYPE] = "text"
		unit.strings[TEAM] = "text"
		table.insert(texts, unit)
	end
	
	if (name == "pick") then
		unit.strings[TYPE] = ""
	end
	
	if (unit.name == "empty") then
		unit.stop = true
	end
	
	return unit
end

function step()
	gdata.values[MOVEGOING] = 0
	local update = false
	
	for i,unit in ipairs(units) do
		if (unit.step == 0) and (#unit.queue > 0) then
			local data = unit.queue[1]
			unit.strings[MOVE] = data[1]
			
			if (data[1] == "walk_mech") then
				unit.xpos = data.x
				unit.ypos = data.y
				unit.xhelper = unit.xpos
				unit.yhelper = unit.ypos
				unit.strings[ROUTE] = data.route
				unit.step = 1
				unit.timer = 999
			elseif (data[1] == "walk") then
				unit.xhelper = data.x
				unit.yhelper = data.y
				unit.strings[ROUTE] = data.route
				unit.step = 1
				unit.timer = 999
			elseif (data[1] == "jump") then
				unit.xpos = data.x
				unit.ypos = data.y
				unit.xhelper = unit.xpos
				unit.yhelper = unit.ypos
				local xdist = unit.xpos - unit.values[XPOS]
				local ydist = unit.ypos - unit.values[YPOS]
				local jumpheight = 8
				local flightlength = jumpheight * 2
				
				unit.xvel = xdist / flightlength
				unit.yvel = ydist / flightlength
				unit.zvel = 0 - jumpheight
				unit.step = 1
				
				MF_sfx("klonk1")
			elseif (data[1] == "slide") then
				local dir = data.dir
				local d = dirs[dir]
				local dist = data.dist or 1
				local bump = data.bump or false
				
				unit.xpos = data.x
				unit.ypos = data.y
				unit.xhelper = unit.xpos
				unit.yhelper = unit.ypos
				unit.slidespeed = data.speed
				
				if bump then
					unit.xhelper = unit.xpos + d[1] * 0.5
					unit.yhelper = unit.ypos + d[2] * 0.5
				end
				
				unit.step = 1
			elseif (data[1] == "wait") then
				unit.step = 1
				unit.timer = data.timer or 10
			elseif (data[1] == "bump") then
				unit.step = 1
				unit.timer = 0
				local defeat = hasrule(unit,"is","defeat")
				local push = data[3] or false
				local pushdist = data[4] or 1
				local pushspeed = 0.1
				if (pushdist > 1) then
					pushspeed = 0.5
				end
				
				if (data[2] ~= nil) and (#data[2] > 0) then
					for a,bunit in ipairs(data[2]) do
						if defeat and (bunit.safe == false) then
							table.insert(bunit.queue, {"defeat"})
						else
							table.insert(bunit.queue, {"bump"})
							
							if push and (data.dir ~= nil) then
								table.insert(bunit.queue, {"sound", sfx = "viuh2"})
								slide(bunit,data.dir,pushdist,nil,nil,pushspeed)
							end
						end
					end
				end
				
				MF_sfx("bop" .. tostring(math.random(1,5)) .. "_l")
			elseif (data[1] == "action") then
				unit.step = 0
				unit.timer = 0
				unit.strings[MOVE] = ""
				data.x = data.x or unit.xpos
				data.y = data.y or unit.ypos
				
				actlist[data.action](unit,data)
			elseif (data[1] == "turn") then
				unit.step = 0
				unit.timer = 0
				unit.strings[MOVE] = ""
				unit.values[DIR] = (unit.values[DIR] + data.dir) % 4
			elseif (data[1] == "turnto") then
				unit.step = 0
				unit.timer = 0
				unit.strings[MOVE] = ""
				unit.values[DIR] = data.dir % 4
			elseif (data[1] == "defeat") then
				unit.step = 1
				
				local sfx = "pop" .. tostring(math.random(1,5) .. "new")
				if (data.sfx ~= nil) then
					sfx = data.sfx
				end
				MF_sfx(sfx)
			elseif (data[1] == "sound") then
				unit.step = 0
				unit.timer = 0
				unit.strings[MOVE] = ""
				MF_sfx(data.sfx)
			end
			
			table.remove(unit.queue, 1)
		end
		
		if (unit.step > 0) then
			gdata.values[MOVEGOING] = 1
			movement_going = true
			
			if (unit.strings[MOVE] == "walk_mech") and (#unit.strings[ROUTE] > 0) then
				unit.timer = unit.timer + 1
				
				if (unit.timer >= 5) then
					unit.timer = 0
					local l = string.sub(unit.strings[ROUTE], unit.step, unit.step)
					local d = tonumber(l) or 0
					local dir = dirs[d] or {0,0}
					local ox,oy = dir[1],dir[2]
					
					local allowed = true
					if (unit.strings[TEAM] == "enemy") then
						local obs,obs_ = here_obs(unit.values[XPOS] + ox, unit.values[YPOS] + oy, unit.values[ID])
						if obs then
							allowed = false
						end
					end
					
					if allowed then
						unit.values[DIR] = math.max(d - 1, 0)
						unit.values[XPOS] = unit.values[XPOS] + ox
						unit.values[YPOS] = unit.values[YPOS] + oy
					
						unit.step = unit.step + 1
						local snum = math.random(1, 6)
						MF_sfx("move_hi" .. tostring(snum))
						
						if (unit.step > #unit.strings[ROUTE]) then
							update = true
							stop(unit)
						end
					else
						unit.xpos = unit.values[XPOS]
						unit.ypos = unit.values[YPOS]
						update = true
						stop(unit)
					end
				end
			elseif (unit.strings[MOVE] == "walk") and (#unit.strings[ROUTE] > 0) then
				unit.timer = unit.timer + 1
				
				if (unit.timer >= 5) then
					unit.timer = 0
					local l = string.sub(unit.strings[ROUTE], unit.step, unit.step)
					local d = tonumber(l) or 0
					local dir = dirs[d] or {0,0}
					local ox,oy = dir[1],dir[2]
					
					local allowed = true
					if (unit.strings[TEAM] == "enemy") then
						local obs,obs_ = here_obs(unit.values[XPOS] + ox, unit.values[YPOS] + oy, unit.values[ID])
						if obs then
							allowed = false
						end
					end
					
					if allowed then
						unit.values[DIR] = math.max(d - 1, 0)
						unit.xpos = unit.xpos + ox
						unit.ypos = unit.ypos + oy
						unit.values[XPOS] = unit.xpos
						unit.values[YPOS] = unit.ypos
					
						unit.step = unit.step + 1
						local snum = math.random(1, 6)
						MF_sfx("move_hi" .. tostring(snum))
						
						if (unit.step > #unit.strings[ROUTE]) then
							update = true
							stop(unit)
						end
					else
						unit.xpos = unit.values[XPOS]
						unit.ypos = unit.values[YPOS]
						update = true
						stop(unit)
					end
				end
			elseif (unit.strings[MOVE] == "jump") then
				unit.values[XPOS] = unit.values[XPOS] + unit.xvel * 0.5
				unit.values[YPOS] = unit.values[YPOS] + unit.yvel * 0.5
				unit.values[ZPOS] = unit.values[ZPOS] + unit.zvel * 0.5
				
				if (unit.values[ZPOS] < 0) then
					unit.zvel = unit.zvel + 1 * 0.5
				else
					MF_sfx("raj")
					update = true
					stop(unit)
				end
			elseif (unit.strings[MOVE] == "slide") then
				local speed = 0.1
				if (unit.slidespeed ~= nil) then
					speed = unit.slidespeed
				end
					
				if (unit.values[XPOS] < unit.xhelper) then
					unit.values[XPOS] = math.min(unit.values[XPOS] + speed, unit.xhelper)
				elseif (unit.values[XPOS] > unit.xhelper) then
					unit.values[XPOS] = math.max(unit.values[XPOS] - speed, unit.xhelper)
				end
				
				if (unit.values[YPOS] < unit.yhelper) then
					unit.values[YPOS] = math.min(unit.values[YPOS] + speed, unit.yhelper)
				elseif (unit.values[YPOS] > unit.yhelper) then
					unit.values[YPOS] = math.max(unit.values[YPOS] - speed, unit.yhelper)
				end
				
				if (unit.values[XPOS] == unit.xhelper) and (unit.values[YPOS] == unit.yhelper) then
					update = true
					stop(unit)
				end
			elseif (unit.strings[MOVE] == "wait") then
				unit.timer = unit.timer - 1
				
				if (unit.timer < 0) then
					stop(unit)
				end
			elseif (unit.strings[MOVE] == "bump") then
				unit.timer = unit.timer + 1
				unit.values[ZPOS] = unit.values[ZPOS] - 0.5
				
				if (unit.timer > 5) then
					stop(unit)
					
					if (unit.weak or unit.boom) and (unit.safe == false) then
						update = true
						MF_explosion(unit.xpos,unit.ypos,0,unit.values[ORDER]+1)
						gdata.values[SHAKE] = 6
						
						if unit.boom then
							boom(unit)
						end
						
						delete(unit.values[ID])
						MF_delete(unit.fixed)
					end
				end
			elseif (unit.strings[MOVE] == "defeat") then
				stop(unit)
				update = true
				MF_explosion(unit.xpos,unit.ypos,0,unit.values[ORDER]+1)
				gdata.values[SHAKE] = 10
				
				if unit.boom then
					boom(unit,true)
				end
				
				delete(unit.values[ID])
				MF_delete(unit.fixed)
			end
		end
	end
	
	if update then
		parserules()
		block()
		dotransform()
		objectivecheck("check")
		objectivecheck("check_once",true)
	end
	
	if (gdata.values[ENEMYTURN] == 0) and (gdata.values[MOVEGOING] == 0) then
		-- objectivecheck_midway()
	end
end

function unitselection()
	local i_ = 1
	local gameid = getgameid()
	
	for i,v in ipairs(unitselectionlist) do
		local name = v
		local always = false
		
		if (string.sub(name, -7) == "_ALWAYS") then
			name = string.sub(name, 1, string.len(name)-7)
			always = true
		end
		
		local status = MF_load(gameid,name)
		local available = true
		if (always == false) and (#status == 0) and (name ~= "baba") and (name ~= "keke") and (name ~= "me") and (name ~= "worm") then
			available = false
		end
		
		if available and ((gdata.teamlimits.style == 0) or ((gdata.teamlimits.style == 1) and (gdata.teamlimits[name] ~= nil)) or ((gdata.teamlimits.style == 2) and (gdata.teamlimits[name] == nil))) then
			local unitid = MF_create("Button_unit")
			local unit = mmf.newObject(unitid)
			unit.x = (i_-1) * 28 + 4
			unit.y = screenh - 28
			unit.layer = 2
			unit.strings[NAME] = name
			
			local udata = unitlist[name] or {}
			local icon = udata.buttonicon or udata.icon or 0
			unit.values[4] = icon
			
			if (gdata.levelstatus < 2) then
				for a,b in ipairs(units) do
					if (b.name == name) then
						unit.values[1] = 1
					end
				end
			end
			
			i_ = i_ + 1
		end
	end
	
	dotext("Select your team members!",screenw - 4,42,0,"unitselection",{offsetx = 1.0})
	
	MF_music(gdata.music[1],gdata.music[2])
end

function unitdescription(name)
	MF_deltext("unitdesc")
	
	if (#name > 0) then
		local udata = unitlist[name]
		local desc = udata.desc or "Sorry nothing"
		
		if (udata.speed ~= nil) then
			desc = desc .. " (Speed " .. tostring(udata.speed) .. ")"
		end
		
		dotext(desc,4,screenh - 31,0,"unitdesc",{offsety = 1.0})
	end
end

function select_unit(unitid,name)
	local unit = mmf.newObject(unitid)
	MF_cleanselections(name)
	
	local udata = unitlist[name]
	unit.strings[TYPE] = name
	unit.values[ADIR] = 0
	unit.values[ASPRITE] = udata.sprite or udata.anim or 0
	unit.values[PREVIEWICONID] = udata.anim or 0
	
	MF_sfx("bopw")
end

function endunitselection()
	MF_deltext("unitselection")
	MF_deltext("unitdesc")
	gdata.values[ENEMYTURN] = 0
	cancel()
	local delthese = {}
	
	for i,unit in ipairs(units) do
		if (unit.strings[NAME] == "pick") then
			createunit(unit.strings[TYPE],unit.values[XPOS],unit.values[YPOS],unit.values[DIR])
			table.insert(delthese, {unit.values[ID], unit.fixed})
			MF_poof(unit.fixed)
			
			table.insert(gdata.team, unit.strings[TYPE])
		end
		
		if (unit.strings[TEAM] == "enemy") and (unit.noturn == false) then
			MF_showturnorder()
		end
	end
	
	for i,v in ipairs(delthese) do
		delete(v[1])
		MF_delete(v[2])
	end
	
	updaterules = true
	parserules()
	ui_turnsleft()
	ui_turnorder()
	missionstart()
end

function dosprites()
	local id1 = MF_create("Object")
	local id2 = MF_create("UI_messagepic")
	local id3 = MF_create("UI_teamicon")
	local id4 = MF_create("UI_preview_unit")
	local id5 = MF_create("Button_unit")
	local id6 = MF_create("UI_preview_ground")
	local id7 = MF_create("Tile")
	local id8 = MF_create("Button_act")
	local id9 = MF_create("UI_profilepic")
	
	local world = gdata.strings[WORLD]
	
	for i,data in pairs(unitlist) do
		local file_ = data.file or i
		local aslot = data.sprite or data.anim or 0
		local agroup = data.animgroup or 0
		local aframes = data.animframes or 1
		local dirs = data.directions or false
		local prevslot = data.anim or 0
		
		local prevfile = file_ .. "_1.png"
		
		if dirs then
			prevfile = file_ .. "_0_1.png"
			
			for a=0,3 do
				for b=1,aframes do
					local file = file_ .. "_" .. tostring(a) .. "_" .. tostring(b) .. ".png"
					replacesprite(id1,file,nil,a * 8,aslot + (b-1))
				end
			end
		else
			for b=1,aframes do
				local file = file_ .. "_" .. tostring(b) .. ".png"
				replacesprite(id1,file,nil,agroup,aslot + (b-1))
			end
		end
		
		replacesprite(id4,prevfile,nil,agroup,prevslot)
		
		if (data.team ~= nil) and (data.team == "mech") then
			if (data.act1_icon ~= nil) then
				local file = "skill_" .. string.sub("00" .. tostring(data.act1_icon), -2)
				replacesprite_button(id8,file,"skills/",data.act1_icon)
			end
			
			if (data.act2_icon ~= nil) then
				local file = "skill_" .. string.sub("00" .. tostring(data.act2_icon), -2)
				replacesprite_button(id8,file,"skills/",data.act2_icon)
			end
			
			local icon = data.buttonicon or data.icon or -1
			if (icon >= 0) then
				local file = "unit_" .. string.sub("00" .. tostring(icon + 1), -2)
				replacesprite_button(id5,file,"ui/",icon)
			end
		end
	end
	
	local count = 100 --countfiles("sprites/portraits/",100)
	for i=1,count do
		local file = "pic_" .. string.sub("00" .. tostring(i), -2) .. ".png"
		replacesprite(pfp.fixed,file,"portraits/",0,i-1,nil,110000)
	end
	
	replacesprite(gdata.mapid,"map.png",nil,0,0,0,0)
	
	count = 20 --countfiles("sprites/backgrounds/",20)
	for i=1,count do
		local file = "back_" .. string.sub("00" .. tostring(i), -2) .. ".png"
		replacesprite(background.fixed,file,"backgrounds/",0,i-1,0,0)
	end
	
	count = 30 --countfiles("sprites/ui/pfp_",30)
	for i=1,count do
		local file = "pfp_" .. string.sub("00" .. tostring(i), -2) .. ".png"
		replacesprite(id2,file,"ui/",0,i-1,0,nil)
	end
	
	count = 30 --countfiles("sprites/ui/teamicon_",30)
	for i=1,count do
		local file = "teamicon_" .. string.sub("00" .. tostring(i), -2) .. ".png"
		replacesprite(id3,file,"ui/",0,i-1,0,0)
	end
	
	count = 30
	for i=1,count do
		local file = "pfpbig_" .. string.sub("00" .. tostring(i), -2) .. ".png"
		replacesprite(id9,file,"ui/",0,i-1,0,0)
	end
	
	count = 20 --math.floor(countfiles("sprites/terrain/",20) / 2)
	for i=1,count do
		local file = "terrain_" .. string.sub("0" .. tostring(i-1), -1) .. "_1.png"
		replacesprite(id6,file,"terrain/",i-1,0,nil,0)
		replacesprite(id7,file,"terrain/",i-1,0,nil,0)
		file = "terrain_" .. string.sub("0" .. tostring(i-1), -1) .. "_2.png"
		replacesprite(id6,file,"terrain/",i-1,1,nil,0)
		replacesprite(id7,file,"terrain/",i-1,1,nil,0)
	end
	
	MF_delete(id1)
	MF_delete(id2)
	MF_delete(id3)
	MF_delete(id4)
	MF_delete(id5)
	MF_delete(id6)
	MF_delete(id7)
	MF_delete(id8)
	MF_delete(id9)
end

function countfiles(path_,maximum_)
	local world = gdata.strings[WORLD]
	
	local path = "Data/assets/" .. world .. "/" .. path_
	local p = string.sub(path, 1, string.len(path) - 1)
	if (MF_finddir(p) == false) then
		path = "Data/assets/default/" .. path_
	end
	
	local maximum = maximum_ or 10
	local count = math.min(MF_listfiles(path .. "*.png"), maximum)
	
	return count
end

function replacesprite(id,file,spath_,ag,as,hx_,hy_)
	local world = gdata.strings[WORLD]
	
	local spath = spath_ or ""
	local path = "Data/assets/" .. world .. "/sprites/" .. spath .. file
	local valid = true
	local hx = hx_ or 100000
	local hy = hy_ or 100000
	
	if (MF_findfile(path) == false) then
		path = "Data/assets/default/sprites/" .. spath .. file
		
		if (MF_findfile(path) == false) then
			valid = false
		end
	end
	
	if valid then
		MF_changesprite(id,ag,as,path,hx,hy)
	else
		MF_alert("Couldn't find " .. file)
	end
end

function replacesprite_button(id,file,spath_,ag)
	local world = gdata.strings[WORLD]
	local spath = spath_ or ""
	
	for i=1,4 do
		local path = "Data/assets/" .. world .. "/sprites/" .. spath .. file .. "_" .. tostring(i) .. ".png"
		local valid = true
		
		if (MF_findfile(path) == false) then
			path = "Data/assets/default/sprites/" .. spath .. file .. "_" .. tostring(i) .. ".png"
			
			if (MF_findfile(path) == false) then
				valid = false
			end
		end
		
		if valid then
			MF_changesprite(id,ag,i-1,path,0,0)
		else
			MF_alert("Couldn't find " .. file)
		end
	end
end

function storegamestate()
	gamestate = {}
	
	for i,unit in ipairs(units) do
		gamestate[unit.values[ID]] = {}
		local data = gamestate[unit.values[ID]]
		data.name = unit.name
		data.x = unit.xpos
		data.y = unit.ypos
		data.dir = unit.values[DIR]
		data.visited = unit.visited
		data.visited_visual = unit.flags[VISIT]
	end
	
	gamestate.moves = gdata.moves
	gamestate.movedunits = {}
	for i,v in pairs(gdata.movedunits) do
		gamestate.movedunits[i] = v
	end
	
	gamestate.objectives = {}
	for i,v in ipairs(objectives) do
		table.insert(gamestate.objectives, v.values[STATUS])
	end
end