function cancel()
	MF_clean()
	gdata.values[ACTION] = -1
	gdata.values[SELECTED] = 0
	gdata.targets = {}
	gdata.action_targeting = ""
	gdata.action_range = ""
	gdata.action = ""
	MF_deltext("unitname")
end

function passturn()
	MF_clean()
	cancel()
	
	local us = findunits("enemy",true)
	for i,u in ipairs(us) do
		local ud = unitlist[u.name] or {}
		if (ud.action_setup ~= nil) then
			ud.action_setup(u)
		end
	end
	
	gdata.values[ENEMYTURN] = 1
	
	if (gdata.values[TURNSLEFT] > 1) then
		MF_sound("pass3")
	end
end

function restartturn()
	MF_clean()
	cancel()
	
	local included = {}
	local delthese = {}
	
	for id,data in pairs(gamestate) do
		if (tonumber(id) ~= nil) then
			local unit = findunit(id)
			local name = data.name
			local x = data.x
			local y = data.y
			local dir = data.dir
			local visited = data.visited
			included[id] = 1
			
			if (unit ~= nil) then
				unit.values[MOVED] = 0
				unit.values[ACTED] = 0
				unit.xpos = x
				unit.ypos = y
				unit.xhelper = x
				unit.yhelper = x
				unit.visited = visited
				unit.values[XPOS] = x
				unit.values[YPOS] = y
				unit.values[DIR] = dir
				unit.flags[VISIT] = data.visited_visual
				
				unit.step = 0
				unit.timer = 0
				unit.xvel = 0
				unit.yvel = 0
				unit.zvel = 0
				unit.queue = {}
			else
				createunit(name,x,y,dir,id)
			end
		end
		
		-- MF_explosion(x,y,3,x+y+0.5)
	end
	
	for i,v in ipairs(gamestate.objectives) do
		objectives[i].values[STATUS] = v
	end
	
	for i,v in ipairs(units) do
		if (included[v.values[ID]] == nil) then
			table.insert(delthese, v)
		end
	end
	
	for x=0,map.w-1 do
		for y=0,map.h-1 do
			MF_explosion(x,y,3,x+y+0.5)
		end
	end
	
	gdata.moves = gamestate.moves
	gdata.movedunits = {}
	for i,v in pairs(gamestate.movedunits) do
		gdata.movedunits[i] = v
	end
	if gdata.movecounter then
		updatemovecounter()
	end
	
	handledels(delthese)
	if (gdata2.values[RESTARTSETTING] >= 0) then
		gdata.values[RESTARTS] = gdata.values[RESTARTS] - 1
	end
	updaterules = true
	parserules()
	
	gdata.values[RESTARTAVAILABLE] = 0
	gdata2.values[UNDO] = 0
	gdata.undo = {}
end

function undomove()
	if (gdata.undo.yes ~= nil) then
		local unit = findunit(gdata.undo.target)
		unit.values[MOVED] = 0
		unit.xpos = gdata.undo.x
		unit.ypos = gdata.undo.y
		unit.values[DIR] = gdata.undo.dir
		
		unit.queue = {}
		cancel()
		stop(unit)
	end
	
	local recheck = false
	if (gdata.undo.visit ~= nil) then
		for i,v in ipairs(gdata.undo.visit) do
			v.visited = false
			
			if (objectives_visitlist[v.name] ~= nil) then
				v.flags[VISIT] = false
				recheck = true
			end
		end
		
		if recheck then
			objectivecheck("check")
			objectivecheck("check_once",true)
		end
	end
	
	gdata2.values[UNDO] = 0
	gdata.undo = {}
end

function nextturn()
	gdata.undo = {}
	gdata2.values[WEATHEREFFECTS] = 0
	
	if (#gdata.weather > 0) then
		for i,v in ipairs(gdata.weather) do
			local d = weatherlist[v.id] or {}
			
			if (d.effect ~= nil) and (v.done == false) then
				d.effect(v)
				v.done = true
				v.count = v.count + 1
			end
			
			if (d.effect_long ~= nil) and (v.done == false) then
				gdata2.values[WEATHEREFFECTS] = 1
			end
		end
	end
	
	if (gdata2.values[WEATHEREFFECTS] == 1) then
		return
	end
	
	objectivecheck("check")
	if (gdata.values[TURNSLEFT] > 1) then
		for i,unit in ipairs(units) do
			if unit.unit then
				if (unit.strings[TEAM] == "mech") or (unit.strings[TEAM] == "enemy") then
					unit.values[MOVED] = 0
					unit.values[ACTED] = 0
					unit.routestorage = {}
				end
			end
		end
		
		gdata.values[ENEMYTURN] = 0
		objectivecheck_endnow()
		
		if (gdata.values[TURNSLEFT] > 0) then
			objectivecheck_midway()
		end
	elseif (gdata.values[TURNSLEFT] == 1) then
		objectivecheck("check_once",true)
		objectivecheck_missionend()
		missionend()
	end
	
	if (#gdata.weather > 0) then
		for i,v in ipairs(gdata.weather) do
			local d = weatherlist[v.id] or {}
			
			if (d.effect_long ~= nil) then
				v.count = v.count + 1
			end
			
			v.done = false
			v.timer = 0
		end
	end
	
	gdata2.values[UNDO] = 0
	gdata.values[TURNSLEFT] = math.max(gdata.values[TURNSLEFT] - 1, 0)
	gdata.values[RESTARTAVAILABLE] = 0
	ui_turnsleft()
	ui_turnorder()
	storegamestate()
end

function weathereffects()
	gdata2.values[WEATHEREFFECTS] = 0
	
	for i,v in ipairs(gdata.weather) do
		local d = weatherlist[v.id] or {}
		
		if (d.effect_long ~= nil) and (v.done == false) then
			gdata2.values[WEATHEREFFECTS] = 1
			d.effect_long(v)
			return
		end
	end
	
	if (gdata2.values[WEATHEREFFECTS] == 0) and (gdata.values[MOVEGOING] == 0) then
		nextturn()
		storegamestate()
	end
end

function missionstart()
	gdata.values[RESTARTS] = gdata2.values[RESTARTSETTING] + 1
	if (gdata2.values[RESTARTSETTING] < 0) then
		gdata.values[RESTARTS] = 99
	end
	MF_missionstart()
	
	if (#gdata.weather > 0) then
		for i,v in ipairs(gdata.weather) do
			local d = weatherlist[v.id] or {}
			
			if (d.effect_start ~= nil) then
				d.effect_start(v)
			end
		end
	end
	
	block()
	dotransform()
	objectivecheck("check",true)
	storegamestate()
end

function missionend()
	gdata.values[ENEMYTURN] = 2
	gdata.values[DELAY] = 10
	local gameid = getgameid()
	local unitid = MF_create("UI_missionresult")
	local unit = mmf.newObject(unitid)
	unit.x = 160 + 320
	unit.y = 90
	unit.layer = 2
	
	MF_closemessages()
	
	local winstar = 0
	local teamstar = 0
	local extrastar = 0
	local currwin = tonumber(MF_load(gameid,gdata.strings[LEVEL])) or 0
	local currteam = tonumber(MF_load(gameid,gdata.strings[LEVEL] .. "teamstatus")) or 0
	local currextra = tonumber(MF_load(gameid,gdata.strings[LEVEL] .. "extrastatus")) or 0
	
	local success = true
	local fullsuccess = true
	local optionals = false
	
	for i,obj in ipairs(objectives) do
		if (obj.values[STATUS] ~= 1) then
			fullsuccess = false
		end
		
		if (obj.values[STATUS] ~= 1) and (obj.optional == false) then
			success = false
		end
		
		if obj.optional then
			optionals = true
		end
	end
	
	local oldstatus = tonumber(MF_load(gameid,gdata.strings[LEVEL])) or 0
	local newstatus = 1
	
	local title = "MISSION COULD'VE GONE BETTER"
	local subtitle = "Not all objectives were completed on time."
	local status = 1
	if success then
		title = "MISSION WENT GREAT"
		subtitle = "All objectives were completed successfully."
		unit.animFrame = 1
		status = 2
		winstar = 1
		
		if (fullsuccess == false) then
			title = "MISSION COULD'VE GONE BETTER"
			subtitle = "Some optional objectives were not completed."
			unit.animFrame = 0
		elseif optionals then
			MF_save(gameid,gdata.strings[LEVEL] .. "extrastatus","1")
			status = status + 1
			extrastar = 1
		end
		
		if fullsuccess then
			local oldteam = MF_load(gameid,gdata.strings[LEVEL] .. "team")
			local ot = MF_parsestring(oldteam)
			local currteam = ""
			
			for i,name in ipairs(gdata.team) do
				currteam = currteam .. name
				
				if (i < #gdata.team) then
					currteam = currteam .. "<"
				end
			end
			
			if (#ot == #gdata.team) and (#currteam > 0) then
				local same = false
				for i,v in ipairs(ot) do
					for a,b in ipairs(gdata.team) do
						if (b == v) then
							same = true
							break
						end
					end
					
					if same then
						break
					end
				end
				
				if (same == false) then
					teamstar = 1
					MF_save(gameid,gdata.strings[LEVEL] .. "teamstatus","1")
					status = status + 1
				end
			end
			
			MF_save(gameid,gdata.strings[LEVEL] .. "team",currteam)
		end
		
		status = 2 + math.max(extrastar, currextra) + math.max(teamstar, currteam)
	end
	
	if success and fullsuccess then
		MF_sound("win")
	else
		MF_sound("lose")
	end
	
	dotext(title,0,-15,unitid,"missionend",{style = 1, offsetx = 0.5})
	dotext(subtitle,0,5,unitid,"missionend",{offsetx = 0.5})
	
	if (oldstatus < 2) and (status > 1) then
		newstatus = 1.5
		local i_ = 0
		
		local nolink = false
		for i,v in ipairs(gdata.unlocks) do
			if (v == "NOLINK") then
				nolink = true
			end
		end
		
		for i,v in ipairs(gdata.unlocks) do
			if (string.sub(v, 1, 5) == "FLAG_") then
				local flag = string.sub(v, 6)
				MF_save(gameid,flag,"1")
				
				if (flag == "customteam") then
					gdata2.values[CUSTOMTEAM] = 1
				elseif (flag == "extraobjective") then
					gdata2.values[EXTRAOBJECTIVE] = 1
				end
			elseif (string.sub(v, 1, 5) == "UNIT_") then
				MF_save(gameid,string.sub(v, 6),"1")
				table.insert(gdata.newunlocks, string.sub(v, 6))
			elseif (v ~= "NOLINK") then
				MF_save(gameid,v,"0.5")
				
				if (nolink == false) then
					MF_save(gameid,gdata.strings[LEVEL] .. "link" .. tostring(i_),v)
					
					i_ = i_ + 1
				end
			end
		end
		
		MF_save(gameid,gdata.strings[LEVEL] .. "links",tostring(i_))
	elseif (oldstatus >= 2) and (status > oldstatus) then
		newstatus = status - 0.5
	end
	
	MF_alert(tostring(status) .. ": " .. tostring(oldstatus) .. " / " .. tostring(newstatus))
	
	if (oldstatus >= 2) and (currteam == 1) and (currextra == 1) and (oldstatus < 4) then
		newstatus = 3.5
		MF_save(gameid,gdata.strings[LEVEL],tostring(newstatus))
	end
	
	if (newstatus > oldstatus) then
		MF_save(gameid,gdata.strings[LEVEL],tostring(newstatus))
	end
	
	local stars = tonumber(MF_load(gameid,"total_stars")) or 0
	local wins = tonumber(MF_load(gameid,"total_levels")) or 0
	if (winstar == 1) and (currwin < 2) then
		wins = wins + 1
		stars = stars + 1
	end
	if (teamstar == 1) and (currteam == 0) then
		stars = stars + 1
	end
	if (extrastar == 1) and (currextra == 0) then
		stars = stars + 1
	end
	MF_save(gameid,"total_stars",tostring(stars))
	MF_save(gameid,"total_levels",tostring(wins))
	
	gdata.values[OUTCOME] = status
end

function ending()
	if (gdata.values[OUTCOME] >= 2) and (#gdata.dialogue_win > 0) then
		gdata.dialogue = gdata.dialogue_win
	elseif (gdata.values[OUTCOME] == 1) and (#gdata.dialogue_lose > 0) then
		gdata.dialogue = gdata.dialogue_lose
	end
	
	if (#gdata.dialogue_end > 0) then
		for i,v in ipairs(gdata.dialogue_end) do
			table.insert(gdata.dialogue, v)
		end
	end
	
	if (#gdata.dialogue > 0) then
		gdata.values[DIALOGUE] = 1
		gdata.values[ENEMYTURN] = 2
		gdata.values[GAMEMODE] = -1
		MF_deltext("unitname")
		MF_deltext("turncount")
		MF_deltext("terrainname")
		MF_deltext("movecounter")
		gdata.dname = ""
		MF_dpic(-1,0)
		
		gdata.dtype = 2
		dialogue()
	else
		gdata.values[ENEMYTURN] = 2
		gdata.values[OUTCOME] = 0
		MF_loop("returntomap",1)
	end
end

function returntomap()
	if (#gdata.newunlocks > 0) then
		gdata.values[NEWUNLOCKS] = 1
	end
end

function newunlocks()
	gdata.values[NEWUNLOCKS] = 0
	local done = false
	
	for i,v in ipairs(gdata.newunlocks) do
		local data = unitlist[v] or {}
		
		local name = data.name or "Error"
		local pic = data.icon or 9
		local text = "You unlocked " .. name .. " for later missions!"
		done = true
		
		messagebox(text,pic,nil,32,48 + (i-1) * 32,240)
	end
	
	if done then
		MF_sfx("start")
	end
	gdata.newunlocks = {}
end

function enemyturn()
	local done = true
	
	if (gdata.values[MOVEGOING] == 0) then
		for i,unit in ipairs(units) do
			if unit.unit then
				if (unit.strings[TEAM] == "enemy") and (unit.values[MOVED] == 0) then
					if (unit.action ~= nil) then
						done = false
						unit.action(unit)
					end
					
					gdata.values[MOVEGOING] = 1
					unit.values[MOVED] = 1
					return
				end
				
				if (unit.step > 0) or (#unit.queue > 0) then
					done = false
					gdata.values[MOVEGOING] = 1
					return
				end
			end
		end
	else
		done = false
	end
	
	if done then
		endblock()
		parserules()
		block()
		dotransform()
		nextturn()
		storegamestate()
	end
end

function ui_turnorder()
	local curr = 1
	
	for i,unit in ipairs(units) do
		if (unit.strings[TEAM] == "enemy") and (unit.flags[DEAD] == false) and (unit.noturn == false) then
			unit.values[MOVEORDER] = curr
			curr = curr + 1
		elseif unit.noturn then
			unit.values[MOVEORDER] = 0
		end
	end
end

function boom(unit,nosfx_)
	gdata.values[SHAKE] = 10
	unit.flags[BOOM] = true
	local nosfx = nosfx_ or false
	local explosion = false
	
	for x=-1,1 do
		for y=-1,1 do
			local targets = here(unit.xpos+x,unit.ypos+y,nil,unit.values[ID])
			
			if (#targets == 0) then
				MF_explosion(unit.xpos+x,unit.ypos+y,0,unit.xpos+x+unit.ypos+y+1)
			else
				for i,u in ipairs(targets) do
					if (u.flags[BOOM] == false) and (u.flags[DEAD] == false) then
						table.insert(u.queue, {"defeat"})
						explosion = true
					end
				end
			end
		end
	end
	
	if explosion and (nosfx == false) then
		MF_sfx("exp02_short")
	end
end

function picktile(x,y)
	local tid = gettid(x,y)
	local tile = map[tid]
	
	if (gdata.values[ONUI] == 0) then
		cancel()
		
		local uhere = here_solids(x,y)
		
		for i,unit in ipairs(uhere) do
			if (unit.strings[TYPE] == "unit") then
				gdata.values[SELECTED] = unit.values[ID]
				MF_deltext("unitname")
				dotext(unit.visname,screenw - 28,screenh - 62,0,"unitname",{offsetx = 0.5})
				
				if unit.unit then
					if (unit.strings[TEAM] == "mech") then
						gdata.values[ACTION] = 0
						
						if (unit.values[MOVED] == 0) then
							drawrange(unit,actlist.movement,{speed = unit.speed})
						end
					elseif (unit.strings[TEAM] == "enemy") or (unit.strings[TEAM] == "neutral") then
						local d = unitlist[unit.name]
						
						if (d.desc ~= nil) then
							dotext(d.desc,4,screenh - 3,0,"unitname",{wrap = 56, offsety = 1.0})
						end
					end
				end
				
				MF_sfx("pick2")
				break
			end
		end
	elseif (gdata.values[ONUI] == 2) then
		if (gdata.values[ACTION] == 0) then
			local indid = MF_indicator(x,y)
			local unitid = gdata.values[SELECTED]
			
			if (indid ~= 0) and (unitid ~= 0) then
				local ind = mmf.newObject(indid)
				local unit = findunit(unitid)
				
				table.insert(unit.queue, {"walk_mech", x = x, y = y, route = ind.strings[ROUTE]})
				unit.values[MOVED] = 1
				gdata.movedunits[unit.name] = 1
				gdata.moves = gdata.moves + 1
				updatemovecounter()
				gdata.values[RESTARTAVAILABLE] = 1
				
				gdata.undo = {}
				gdata.undo.yes = 1
				gdata.undo.target = unit.values[ID]
				gdata.undo.x = unit.xpos
				gdata.undo.y = unit.ypos
				gdata.undo.dir = unit.values[DIR]
				gdata2.values[UNDO] = 1
				MF_sfx("shot1")
				MF_clean()
			end
		elseif (gdata.values[ACTION] == 1) then
			local indid = MF_indicator(x,y)
			local unitid = gdata.values[SELECTED]
			
			if (indid ~= 0) and (unitid ~= 0) then
				local ind = mmf.newObject(indid)
				local unit = findunit(unitid)
				gdata.targets = here_solids(x,y)
				
				local data = {x = x, y = y, dir = ind.values[DIR]}
				
				if (gdata.action_range ~= "") then
					MF_clean()
					gdata.values[ACTION] = 2
					MF_sfx("pup2")
					drawrange(unit,actlist[gdata.action_range],data)
				else
					unit.values[ACTED] = 1
					gdata.movedunits[unit.name] = 1
					gdata.moves = gdata.moves + 1
					updatemovecounter()
					unit.values[DIR] = ind.values[DIR]-1
					gdata.values[RESTARTAVAILABLE] = 1
					gdata2.values[UNDO] = 0
					gdata.undo = {}
					MF_clean()
					actlist[gdata.action](unit,data)
					MF_sfx("shot2")
					cancel()
				end
			end
		elseif (gdata.values[ACTION] == 2) then
			local indid = MF_indicator(x,y)
			local unitid = gdata.values[SELECTED]
			
			if (indid ~= 0) and (unitid ~= 0) then
				local ind = mmf.newObject(indid)
				local unit = findunit(unitid)
				unit.values[ACTED] = 1
				gdata.movedunits[unit.name] = 1
				gdata.moves = gdata.moves + 1
				updatemovecounter()
				unit.values[DIR] = ind.values[DIR]-1
				gdata.values[RESTARTAVAILABLE] = 1
				gdata2.values[UNDO] = 0
				gdata.undo = {}
				
				local data = {x = x, y = y, dir = ind.values[DIR]}
				MF_clean()
				
				actlist[gdata.action](unit,data)
				MF_sfx("shot2")
				cancel()
			end
		end
	end
end

function drawrange(unit,func,data_)
	local data = data_ or {}
	local tiles = func(unit,data)
	
	for i,v in ipairs(tiles) do
		local tileid = MF_create("Tile_indicator")
		local tile = mmf.newObject(tileid)
		tile.values[XPOS] = v.x
		tile.values[YPOS] = v.y
		tile.strings[ROUTE] = v.route or ""
		tile.values[DIR] = v.dir or -1
	end
end

function act(action)
	MF_clean()
	local unit = findunit(gdata.values[SELECTED])
	
	if (gdata.values[ACTION] > -1) then
		if (action == 1) then
			gdata.action_targeting = "adjacent"
			gdata.action_range = ""
			gdata.action = "push"
		elseif (action == 2) then
			gdata.action_targeting = unit.action_targeting or ""
			gdata.action_range = unit.action_range or ""
			gdata.action = unit.action or ""
		end
			
		if (actlist[gdata.action_targeting] ~= nil) then
			drawrange(unit,actlist[gdata.action_targeting])
			gdata.values[ACTION] = 1
			MF_sfx("pup")
		else
			cancel()
		end
	end
end

function slide(unit,dir,amount,x_,y_,speed_,pushbump_,pushbumpdist_)
	local d = dirs[dir]
	local ox,oy = d[1],d[2]
	local dist = amount or 1
	local x = x_ or unit.xpos
	local y = y_ or unit.ypos
	local speed = speed_ or 0.1
	local pushbump = pushbump_ or false
	local pushbumpdist = pushbumpdist_ or 1
	
	for i=1,dist do
		x = x + ox
		y = y + oy
		
		if inbounds(x,y) then
			local obs = here(x,y,true)
			
			if (#obs > 0) then
				x = x - ox
				y = y - oy
				table.insert(unit.queue, {"slide", x = x, y = y, dir = dir, dist = i, bump = true, speed = speed})
				
				local targets = {}
				for a,b in ipairs(obs) do
					if b.solid then
						table.insert(targets, b)
					end
				end
				table.insert(unit.queue, {"bump", targets, pushbump, pushbumpdist, dir = dir})
				
				return false,x,y
			elseif (i == dist) then
				table.insert(unit.queue, {"slide", x = x, y = y, dir = dir, dist = i, speed = speed})
			end
		else
			x = x - ox
			y = y - oy
			table.insert(unit.queue, {"slide", x = x, y = y, dir = dir, dist = i, speed = speed})
			return false,x,y
		end
	end
	
	return true,x,y
end

function stop(unit)
	unit.values[XPOS] = unit.xpos
	unit.values[YPOS] = unit.ypos
	unit.xhelper = unit.xpos
	unit.yhelper = unit.ypos
	unit.values[ZPOS] = 0
	unit.slidespeed = nil
	
	unit.xvel = 0
	unit.yvel = 0
	unit.zvel = 0
	
	unit.timer = 0
	unit.step = 0
	unit.strings[ROUTE] = ""
	unit.strings[MOVE] = ""
	
	if (unit.strings[TYPE] == "text") then
		updaterules = true
	end
end

function drawpath(r,x_,y_,p_)
	local x,y = x_,y_
	local curr = 0
	local prev = 0
	local p = p_ or 0
	
	if (#r > 0) then
		for i=1,#r do
			local l = tonumber(string.sub(r, i, i)) or 1
			local drs = dirs[l] or {0,0}
			local ox,oy = drs[1],drs[2]
			curr = l - 1
			
			if (i > 1) then
				local arrowid = MF_create("Tile_indicator_arrow")
				local arrow = mmf.newObject(arrowid)
				arrow.values[XPOS] = x
				arrow.values[YPOS] = y
				local result = curr
				
				if (i == #r) then
					if (curr == 0) then
						if (prev == 1) then
							result = 17
						elseif (prev == 3) then
							result = 10
						end
					elseif (curr == 1) then
						if (prev == 0) then
							result = 12
						elseif (prev == 2) then
							result = 11
						end
					elseif (curr == 2) then
						if (prev == 1) then
							result = 14
						elseif (prev == 3) then
							result = 13
						end
					elseif (curr == 3) then
						if (prev == 0) then
							result = 15
						elseif (prev == 2) then
							result = 16
						end
					end
				elseif (curr == prev) then
					if (curr == 0) or (curr == 2) then
						result = 5
					elseif (curr == 1) or (curr == 3) then
						result = 4
					end
				else
					if (curr == 0) then
						if (prev == 1) then
							result = 9
						elseif (prev == 3) then
							result = 6
						end
					elseif (curr == 1) then
						if (prev == 0) then
							result = 7
						elseif (prev == 2) then
							result = 6
						end
					elseif (curr == 2) then
						if (prev == 1) then
							result = 8
						elseif (prev == 3) then
							result = 7
						end
					elseif (curr == 3) then
						if (prev == 0) then
							result = 8
						elseif (prev == 2) then
							result = 9
						end
					end
				end
				
				arrow.values[15] = p
				arrow.values[ID] = result
			end
			
			prev = curr
			x = x + ox
			y = y + oy
		end
	end
end

function indicator_arrows(targetid)
	local unit = findunit(gdata.values[SELECTED])
	local target = mmf.newObject(targetid)
	
	if (gdata.values[ACTION] == 0) then
		local r = target.strings[ROUTE]
		local x,y = unit.values[XPOS],unit.values[YPOS]
		drawpath(r,x,y)
	end
end

function pickunit(unitid)
	if (gdata.values[ONUI] == 0) then
		cancel()
		MF_deltext("unitname")
		MF_deltext("unitdesc")
		gdata.values[SELECTED] = 0
		
		if (unitid ~= 0) then
			local unit = mmf.newObject(unitid)
			MF_sfx("pup")
			
			if (unit.strings[TEAM] == "mech") and ((unit.strings[NAME] == "pick") or (gdata.levelstatus >= 2)) then
				cancel()
				MF_deltext("unitname")
				dotext(unit.visname,screenw - 28,screenh - 62,0,"unitname",{offsetx = 0.5})
				gdata.values[SELECTED] = unit.values[ID]
			end
		else
			MF_sfx("pup2")
		end
	end
end

function updatemovecounter()
	local x = screenw - 4
	local y = -42
	MF_deltext("movecounter")
	
	if gdata.movecounter then
		dotext("Moves: " .. tostring(gdata.moves),x,y,0,"movecounter",{offsetx = 1})
	end
end

function unitpreview(unitid)
	local unit = mmf.newObject(unitid)
	local data = unitlist[unit.name] or {}
	
	if (data.preview ~= nil) and (gdata.values[ENEMYTURN] == 0) then
		data.preview(unit)
	end
end

function removeunitpreview()
	MF_removepreviewarrows()
end