unitselectionlist = {"baba", "keke", "it", "jiji", "fofo", "me", "crab", "bird", "worm"}

unitlist =
{
	baba =
	{
		name = "Baba Mech",
		desc = "Baba throws units in long arcs!",
		file = "baba",
		animgroup = 0,
		anim = 0,
		sprite = 0,
		icon = 0,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		team = "mech",
		speed = 3,
		action_range = "line_jump",
		action_targeting = "adjacent",
		action = "throw_slide",
		code = "ba",
		act1_icon = 0,
		act2_icon = 9,
	},
	keke =
	{
		name = "Keke Mech",
		desc = "Keke's skill is to push others away!",
		animgroup = 0,
		anim = 1,
		sprite = 3,
		icon = 1,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		team = "mech",
		speed = 2,
		action_range = "line",
		action_targeting = "adjacent",
		action = "push_long",
		code = "ke",
		act1_icon = 1,
		act2_icon = 10,
	},
	jiji =
	{
		name = "Jiji Mech",
		desc = "Jiji can run really fast and ram into things!",
		animgroup = 0,
		anim = 5,
		sprite = 15,
		icon = 3,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		team = "mech",
		speed = 4,
		action_targeting = "line",
		action = "dash_super",
		code = "ji",
		act1_icon = 3,
		act2_icon = 12,
	},
	it =
	{
		name = "It Mech",
		desc = "It jumps long distances, pushing things nearby!",
		animgroup = 0,
		anim = 3,
		sprite = 9,
		icon = 2,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		team = "mech",
		speed = 2,
		action_targeting = "line_jump",
		action = "jump",
		code = "it",
		act1_icon = 2,
		act2_icon = 11,
	},
	fofo =
	{
		name = "Fofo Mech",
		desc = "Fofo can pull things mysteriously!",
		animgroup = 0,
		anim = 6,
		sprite = 18,
		icon = 4,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		team = "mech",
		speed = 2,
		action_targeting = "lined_up",
		action = "pull",
		code = "fo",
		act1_icon = 4,
		act2_icon = 13,
	},
	me =
	{
		name = "Me Mech",
		desc = "Me can destroy almost anything in their path!",
		animgroup = 0,
		anim = 4,
		sprite = 12,
		icon = 5,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		team = "mech",
		speed = 2,
		action_targeting = "adjacent_any",
		action = "destroy_push",
		code = "me",
		act1_icon = 5,
		act2_icon = 14,
	},
	crab =
	{
		name = "Crab Mech",
		desc = "Crab can throw others around them wrestlishly!",
		animgroup = 0,
		anim = 7,
		sprite = 21,
		icon = 6,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		team = "mech",
		speed = 2,
		action_range = "line_jump_over",
		action_targeting = "adjacent",
		action = "throw_turn",
		code = "cr",
		act1_icon = 6,
		act2_icon = 15,
	},
	bird =
	{
		name = "Bird Mech",
		desc = "Bird can swap places with others!",
		animgroup = 0,
		anim = 8,
		sprite = 24,
		icon = 7,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		team = "mech",
		speed = 2,
		action_targeting = "lined_up_range_3",
		action = "swap",
		code = "bi",
		act1_icon = 7,
		act2_icon = 16,
	},
	worm =
	{
		name = "Worm Mech",
		desc = "Worm has no special abilities but is nevertheless beloved!",
		animgroup = 0,
		anim = 12,
		sprite = 34,
		icon = 8,
		profilepic = 13,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		team = "mech",
		speed = 2,
		action = "none",
		code = "wo",
		act1_icon = 8,
		act2_icon = 17,
	},
	skull =
	{
		name = "Skull",
		animgroup = 0,
		anim = 2,
		sprite = 6,
		animframes = 3,
		directions = true,
		speed = 1,
		unit = true,
		solid = true,
		team = "enemy",
		code = "sk",
		desc = "Moves one tile at a time. When meeting an obstacle, pushes it and turns around.",
		action = function(u)
			local dir = u.values[DIR] + 1
			local d = dirs[dir] or {0,0}
			local ox,oy = d[1],d[2]
			local defeat = hasrule(u,"is","defeat")
			
			local obs = here(u.xpos + ox, u.ypos + oy, true)
			local noturn = true
			
			if (#obs == 0) then
				noturn = slide(u,dir,1)
			else
				noturn = false
				
				for i,v in ipairs(obs) do
					if v.solid then
						slide(v,dir,1)
						
						if defeat and (v.safe == false) then
							table.insert(v.queue, {"defeat"})
						end
					end
				end
			end
			
			if (noturn == false) then
				table.insert(u.queue, {"turn", dir = 2})
				dir = ((u.values[DIR] + 2) % 4) + 1
				slide(u,dir,1)
			end
			
			MF_sfx("push")
		end,
	},
	ufo =
	{
		name = "UFO",
		animgroup = 0,
		anim = 9,
		sprite = 27,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		speed = 0,
		team = "enemy",
		code = "uf",
		desc = "Fires a laser and then rotates clockwise!",
		action = function(u)
			local x,y = u.xpos,u.ypos
			
			table.insert(u.queue, {"action", x = x, y = y, action = "laserbeam"})
			table.insert(u.queue, {"wait", x = x, y = y, timer = 10})
			table.insert(u.queue, {"turn", x = x, y = y, dir = -1})
			table.insert(u.queue, {"wait", x = x, y = y, timer = 10})
		end,
	},
	robot =
	{
		name = "Robot",
		animgroup = 0,
		anim = 10,
		sprite = 30,
		animframes = 3,
		directions = true,
		speed = 2,
		unit = true,
		solid = true,
		team = "enemy",
		code = "ro",
		desc = "Walks two steps towards the nearest mech or mission target and pushes in all directions upon getting there.",
		action_setup = function(u)
			route,cx,cy,enddir,target = getpath(u,{"mech","protect"},2)
			u.routestorage.route = route
			u.routestorage.cx = cx
			u.routestorage.cy = cy
			u.routestorage.enddir = enddir
			u.routestorage.target = target
		end,
		action = function(u)
			local x,y = u.xpos,u.ypos
			local dir = u.values[DIR] + 1
			local drs = dirs[dir]
			local ox,oy = drs[1],drs[2]
			local cx,cy = x,y
			local target
			
			local route = ""
			route,cx,cy,enddir,target = u.routestorage.route,u.routestorage.cx,u.routestorage.cy,u.routestorage.enddir,u.routestorage.target
			
			if (#route > 0) then
				table.insert(u.queue, {"walk", x = cx, y = cy, route = route})
				table.insert(u.queue, {"wait", x = cx, y = cy, timer = 6})
				table.insert(u.queue, {"turnto", x = cx, y = cy, dir = enddir})
			end
			
			if (target ~= nil) then
				table.insert(u.queue, {"action", action = "push_four"})
			end
			
			u.routestorage = {}
		end,
		preview = function(u)
			local route,x,y,enddir = getpath(u,{"mech","protect"},2)
			
			if (#route < 2) then
				route = route .. tostring(enddir+1)
			end
			
			drawpath(route,u.xpos,u.ypos,1)
		end,
	},
	cube =
	{
		name = "Cube",
		animgroup = 0,
		anim = 11,
		profilepic = 12,
		sprite = 33,
		directions = true,
		unit = true,
		solid = true,
		team = "enemy",
		code = "cu",
		desc = "Accidentally misfiled as an opponent. Does nothing.",
		action = function() end,
		noturn = true,
	},
	apple =
	{
		name = "Apple",
		animgroup = 0,
		anim = 13,
		profilepic = 14,
		sprite = 37,
		directions = true,
		unit = true,
		solid = true,
		team = "neutral",
		code = "ap",
		desc = "A succulent and gigantic treat.",
		action = function() end,
	},
	ghost =
	{
		name = "Ghost",
		animgroup = 0,
		anim = 14,
		profilepic = 15,
		sprite = 38,
		animframes = 3,
		directions = true,
		speed = 20,
		unit = true,
		solid = true,
		team = "enemy",
		code = "gh",
		desc = "Flies towards the nearest mech or mission target and pushes it. Moves really far!",
		action_setup = function(u)
			route,cx,cy,enddir,target = getpath(u,{"mech","protect"},32)
			u.routestorage.route = route
			u.routestorage.cx = cx
			u.routestorage.cy = cy
			u.routestorage.enddir = enddir
			u.routestorage.target = target
		end,
		action = function(u)
			local x,y = u.xpos,u.ypos
			local dir = u.values[DIR] + 1
			local drs = dirs[dir]
			local ox,oy = drs[1],drs[2]
			local cx,cy = x,y
			local target
			
			local route = ""
			route,cx,cy,enddir,target = u.routestorage.route,u.routestorage.cx,u.routestorage.cy,u.routestorage.enddir,u.routestorage.target
			
			if (#route > 0) then
				table.insert(u.queue, {"walk", x = cx, y = cy, route = route})
				table.insert(u.queue, {"turnto", x = cx, y = cy, dir = enddir})
			end
			
			if (target ~= nil) then
				table.insert(u.queue, {"action", dir = enddir+1, action = "push_infront"})
			end
			
			u.routestorage = {}
		end,
		preview = function(u)
			local route,x,y,enddir = getpath(u,{"mech","protect"},32)
			
			if (#route < 2) then
				route = route .. tostring(enddir+1)
			end
			
			drawpath(route,u.xpos,u.ypos,1)
		end,
	},
	spire =
	{
		name = "Dread Spire",
		animgroup = 0,
		anim = 15,
		profilepic = 16,
		sprite = 41,
		animframes = 3,
		directions = true,
		unit = true,
		solid = true,
		speed = 0,
		team = "enemy",
		code = "dr",
		desc = "Fires devastating lasers.",
		action = function(u)
			local x,y = u.xpos,u.ypos
			
			table.insert(u.queue, {"action", x = x, y = y, action = "laserbeam"})
			table.insert(u.queue, {"wait", x = x, y = y, timer = 10})
		end,
	},
	mevil =
	{
		name = "Mevil",
		animgroup = 0,
		anim = 16,
		profilepic = 17,
		sprite = 44,
		icon = 10,
		animframes = 3,
		directions = true,
		speed = 3,
		unit = true,
		solid = true,
		team = "enemy",
		code = "mv",
		desc = "Walks 3 steps; destroys everything>around themself both before and after!",
		action_setup = function(u)
			route,cx,cy,enddir,target = getpath(u,{"mech","protect"},3)
			u.routestorage.route = route
			u.routestorage.cx = cx
			u.routestorage.cy = cy
			u.routestorage.enddir = enddir
			u.routestorage.target = target
		end,
		action = function(u)
			local x,y = u.xpos,u.ypos
			local dir = u.values[DIR] + 1
			local drs = dirs[dir]
			local ox,oy = drs[1],drs[2]
			local cx,cy = x,y
			local target
			
			local route = ""
			route,cx,cy,enddir,target = u.routestorage.route,u.routestorage.cx,u.routestorage.cy,u.routestorage.enddir,u.routestorage.target
			
			table.insert(u.queue, {"action", x = x, y = y, dir = dir, action = "destroy_four"})
			if (#route > 0) then
				table.insert(u.queue, {"walk", x = cx, y = cy, route = route})
				table.insert(u.queue, {"wait", x = cx, y = cy, timer = 6})
				table.insert(u.queue, {"turnto", x = cx, y = cy, dir = enddir})
				table.insert(u.queue, {"action", dir = enddir+1, action = "destroy_four"})
				table.insert(u.queue, {"wait", x = cx, y = cy, timer = 12})
			end
			
			u.routestorage = {}
		end,
		preview = function(u)
			local route,x,y,enddir = getpath(u,{"mech","protect"},3)
			
			if (#route < 2) then
				route = route .. tostring(enddir+1)
			end
			
			drawpath(route,u.xpos,u.ypos,1)
		end,
	},
	water =
	{
		name = "Water",
		animgroup = 1,
		anim = 0,
		animframes = 3,
		ground = 2,
		code = "wa",
	},
	lava =
	{
		name = "Lava",
		animgroup = 1,
		anim = 6,
		animframes = 3,
		sprite = 14,
		ground = 2,
		code = "la",
	},
	hill =
	{
		name = "Hill",
		animgroup = 1,
		anim = 1,
		sprite = 3,
		ground = 1,
		code = "hi",
	},
	fruit =
	{
		name = "Fruit",
		animgroup = 1,
		anim = 2,
		sprite = 4,
		ground = 1,
		code = "fr",
	},
	trees =
	{
		name = "Forest",
		animgroup = 1,
		anim = 3,
		sprite = 5,
		animframes = 3,
		ground = 1,
		code = "tr",
	},
	fire =
	{
		name = "Fire",
		animgroup = 1,
		anim = 4,
		sprite = 8,
		animframes = 3,
		ground = 4,
		code = "fi",
	},
	city =
	{
		name = "City",
		animgroup = 1,
		anim = 5,
		sprite = 11,
		animframes = 3,
		ground = 1,
		code = "ci",
	},
	space =
	{
		name = "Space",
		animgroup = 1,
		anim = 7,
		sprite = 17,
		animframes = 3,
		ground = 2,
		code = "sp",
	},
	empty =
	{
		name = "Empty",
		animgroup = 1,
		anim = 8,
		sprite = 20,
		animframes = 1,
		ground = 3,
		code = "em",
	},
	factory =
	{
		name = "Factory",
		animgroup = 1,
		anim = 9,
		sprite = 21,
		animframes = 3,
		ground = 1,
		code = "fa",
	},
	thing =
	{
		name = "Thing",
		animgroup = 1,
		anim = 10,
		sprite = 24,
		animframes = 1,
		ground = 1,
		code = "th",
	},
	text_water =
	{
		name = "Water noun",
		animgroup = 2,
		anim = 0,
		text = true,
		word = "water",
		wtype = 0,
		code = "WA",
	},
	text_hill =
	{
		name = "Hill noun",
		animgroup = 2,
		anim = 1,
		text = true,
		word = "hill",
		wtype = 0,
		code = "HI",
	},
	text_fruit =
	{
		name = "Fruit noun",
		animgroup = 2,
		anim = 4,
		text = true,
		word = "fruit",
		wtype = 0,
		code = "FR",
	},
	text_trees =
	{
		name = "Forest noun",
		animgroup = 2,
		anim = 5,
		text = true,
		word = "trees",
		wtype = 0,
		code = "TR",
	},
	text_fire =
	{
		name = "Fire noun",
		animgroup = 2,
		anim = 6,
		text = true,
		word = "fire",
		wtype = 0,
		code = "FI",
	},
	text_city =
	{
		name = "City noun",
		animgroup = 2,
		anim = 7,
		text = true,
		word = "city",
		wtype = 0,
		code = "CI",
	},
	text_mech =
	{
		name = "Mech noun",
		animgroup = 2,
		anim = 2,
		text = true,
		word = "mech",
		wtype = 0,
		code = "MC",
	},
	text_enemy =
	{
		name = "Enemy noun",
		animgroup = 2,
		anim = 3,
		text = true,
		word = "enemy",
		wtype = 0,
		code = "EN",
	},
	text_water =
	{
		name = "Water noun",
		animgroup = 2,
		anim = 0,
		text = true,
		word = "water",
		wtype = 0,
		code = "WA",
	},
	text_lava =
	{
		name = "Lava noun",
		animgroup = 2,
		anim = 8,
		text = true,
		word = "lava",
		wtype = 0,
		code = "LA",
	},
	text_apple =
	{
		name = "Apple noun",
		animgroup = 2,
		anim = 9,
		text = true,
		word = "apple",
		wtype = 0,
		code = "AP",
	},
	text_mevil =
	{
		name = "Mevil noun",
		animgroup = 2,
		anim = 10,
		text = true,
		word = "mevil",
		wtype = 0,
		code = "MV",
	},
	text_thing =
	{
		name = "Thing noun",
		animgroup = 2,
		anim = 11,
		text = true,
		word = "thing",
		wtype = 0,
		code = "TH",
	},
	text_ghost =
	{
		name = "Ghost noun",
		animgroup = 2,
		anim = 11,
		text = true,
		word = "ghost",
		wtype = 0,
		code = "GH",
	},
	text_skull =
	{
		name = "Skull noun",
		animgroup = 2,
		anim = 11,
		text = true,
		word = "skull",
		wtype = 0,
		code = "SK",
	},
	text_spire =
	{
		name = "Dread Spire noun",
		animgroup = 2,
		anim = 11,
		text = true,
		word = "spire",
		wtype = 0,
		code = "DR",
	},
	text_is =
	{
		name = "Is verb",
		animgroup = 3,
		anim = 0,
		text = true,
		word = "is",
		wtype = 1,
		code = "IS",
	},
	text_sink =
	{
		name = "Sink quality",
		animgroup = 3,
		anim = 1,
		text = true,
		word = "sink",
		wtype = 2,
		code = "SI",
	},
	text_weak =
	{
		name = "Weak quality",
		animgroup = 3,
		anim = 2,
		text = true,
		word = "weak",
		wtype = 2,
		code = "WE",
	},
	text_defeat =
	{
		name = "Defeat quality",
		animgroup = 3,
		anim = 3,
		text = true,
		word = "defeat",
		wtype = 2,
		code = "DE",
	},
	text_more =
	{
		name = "More quality",
		animgroup = 3,
		anim = 4,
		text = true,
		word = "more",
		wtype = 2,
		code = "MO",
	},
	text_safe =
	{
		name = "Safe quality",
		animgroup = 3,
		anim = 5,
		text = true,
		word = "safe",
		wtype = 2,
		code = "SA",
	},
	text_stop =
	{
		name = "Stop quality",
		animgroup = 3,
		anim = 6,
		text = true,
		word = "stop",
		wtype = 2,
		code = "ST",
	},
	text_unit =
	{
		name = "Unit quality",
		animgroup = 3,
		anim = 7,
		text = true,
		word = "unit",
		wtype = 2,
		code = "UN",
	},
	text_boom =
	{
		name = "Boom quality",
		animgroup = 3,
		anim = 8,
		text = true,
		word = "boom",
		wtype = 2,
		code = "BO",
	},
	pick =
	{
		name = "Any Mech",
		animgroup = 4,
		anim = 0,
		animframes = 3,
		team = "mech",
		profilepic = 11,
		unit = true,
		solid = true,
		code = "pi",
	},
}

actlist =
{
	movement = function(u)
		local speedleft = u.speed or 0
		speedleft = speedleft + 1
		
		local done = {}
		local poslist = {}
		local route = ""
		local result = {}
		
		table.insert(poslist, {u.xpos, u.ypos, ""})
		
		while (speedleft > 0) do
			local poslist_ = #poslist
			
			for i=1,poslist_ do
				local v = poslist[1]
				local x,y = v[1],v[2]
				route = v[3]
				table.remove(poslist, 1)
				
				local tid = gettid(x,y)
				done[tid] = 1
				
				if ((x ~= u.xpos) or (y ~= u.ypos)) and (#here(x,y,true) == 0) then
					table.insert(result, {x = x,y = y,route = route})
				end
				
				for j=1,4 do
					local d = dirs[j]
					local ox,oy = d[1],d[2]
					local tid2 = gettid(x+ox,y+oy)
					
					local canpass = false
					local obs = here(x+ox,y+oy,true)
					
					if (#obs == 0) then
						canpass = true
					else
						local success = true
						
						for a,b in ipairs(obs) do
							if (b.strings[TEAM] == "none") or (b.strings[TEAM] ~= u.strings[TEAM]) then
								success = false
								break
							end
						end
						
						if success then
							canpass = true
						end
					end
					
					if u.float then
						canpass = true
					end
					
					if inbounds(x+ox,y+oy) and (done[tid2] == nil) and canpass then
						table.insert(poslist, {x+ox,y+oy, route .. tostring(j)})
					end
				end
			end
			
			speedleft = speedleft - 1
		end
		
		return result
	end,
	
	adjacent = function(u)
		local x_,y_ = u.xpos,u.ypos
		local result = {}
		
		for j=1,4 do
			local d = dirs[j]
			local ox,oy = d[1],d[2]
			local x = x_ + ox
			local y = y_ + oy
			
			if inbounds(x,y) and (#here_solids(x,y) > 0) then
				table.insert(result, {x = x, y = y, dir = j})
			end
		end
		
		return result
	end,
	
	adjacent_any = function(u)
		local x_,y_ = u.xpos,u.ypos
		local result = {}
		
		for j=1,4 do
			local d = dirs[j]
			local ox,oy = d[1],d[2]
			local x = x_ + ox
			local y = y_ + oy
			
			if inbounds(x,y) and (#here(x,y) > 0) then
				table.insert(result, {x = x, y = y, dir = j})
			end
		end
		
		return result
	end,
	
	lined_up = function(u)
		local x_,y_ = u.xpos,u.ypos
		local result = {}
		
		for j=1,4 do
			local d = dirs[j]
			local ox,oy = d[1],d[2]
			
			for i=1,map.maxdist do
				local x = x_ + ox * i
				local y = y_ + oy * i
				
				if inbounds(x,y) and (#here_solids(x,y) > 0) then
					table.insert(result, {x = x, y = y, dir = j})
				end
			end
		end
		
		return result
	end,
	
	lined_up_range_3 = function(u)
		local x_,y_ = u.xpos,u.ypos
		local result = {}
		
		for j=1,4 do
			local d = dirs[j]
			local ox,oy = d[1],d[2]
			
			for i=1,3 do
				local x = x_ + ox * i
				local y = y_ + oy * i
				
				if inbounds(x,y) and (#here_solids(x,y) > 0) then
					table.insert(result, {x = x, y = y, dir = j})
				end
			end
		end
		
		return result
	end,
	
	line_jump = function(u,data)
		local x_,y_ = u.xpos,u.ypos
		local result = {}
		local checks = {}
		
		if (data.dir ~= nil) then
			local d = dirs[data.dir]
			table.insert(checks, {d[1],d[2],data.dir})
		else
			for i,d in ipairs(dirs) do
				table.insert(checks, {d[1],d[2],i})
			end
		end
		
		for j,d in ipairs(checks) do
			local ox,oy = d[1],d[2]
			local dir = d[3]
			
			for i=1,map.maxdist do
				local x = x_ + ox * i
				local y = y_ + oy * i
				
				if inbounds(x,y) and (#here(x,y,true) == 0) then
					table.insert(result, {x = x, y = y, dir = dir})
				elseif (inbounds(x,y) == false) then
					break
				end
			end
		end
		
		return result
	end,
	
	line_jump_over = function(u,data)
		local x_,y_ = u.xpos,u.ypos
		local result = {}
		local checks = {}
		local dir_ = (((data.dir - 1) + 2) % 4) + 1
		
		if (data.dir ~= nil) then
			local d = dirs[dir_]
			table.insert(checks, {d[1],d[2],dir_})
		else
			for i,d in ipairs(dirs) do
				table.insert(checks, {d[1],d[2],i})
			end
		end
		
		for j,d in ipairs(checks) do
			local ox,oy = d[1],d[2]
			local dir = d[3]
			
			for i=1,map.maxdist do
				local x = x_ + ox * i
				local y = y_ + oy * i
				
				if inbounds(x,y) and (#here(x,y,true) == 0) then
					table.insert(result, {x = x, y = y, dir = dir})
				elseif (inbounds(x,y) == false) then
					break
				end
			end
		end
		
		return result
	end,
	
	line = function(u,data)
		local x_,y_ = u.xpos,u.ypos
		local result = {}
		local checks = {}
		local minrange = 2
		
		if (data.dir ~= nil) then
			local d = dirs[data.dir]
			table.insert(checks, {d[1],d[2],data.dir})
		else
			minrange = 1
			for i,d in ipairs(dirs) do
				table.insert(checks, {d[1],d[2],i})
			end
		end
		
		for j,d in ipairs(checks) do
			local ox,oy = d[1],d[2]
			local dir = d[3]
			
			for i=minrange,map.maxdist do
				local x = x_ + ox * i
				local y = y_ + oy * i
				
				if inbounds(x,y) then
					table.insert(result, {x = x, y = y, dir = dir})
					
					if (#here(x,y,true) > 0) then
						break
					end
				elseif (inbounds(x,y) == false) then
					break
				end
			end
		end
		
		return result
	end,
	
	throw_slide = function(unit,data)
		for i,target in ipairs(gdata.targets) do
			table.insert(target.queue, {"jump", x = data.x, y = data.y, dir = data.dir})
			slide(target,data.dir,1,data.x,data.y)
			
			if hasrule(unit,"is","defeat") and (target.safe == false) then
				table.insert(target.queue, {"defeat"})
			end
		end
		
		if (gdata.targets[1] ~= nil) then
			local t = gdata.targets[1]
			local msg = "skill_neutral"
			if (t.strings[TEAM] == "enemy") then
				msg = "skill_enemy"
			elseif (t.strings[TEAM] == "mech") then
				msg = "skill_friend"
			elseif (t.strings[TYPE] == "text") then
				msg = "skill_text"
			end
			
			trymessage(unit,msg)
		end
	end,
	
	throw = function(unit,data)
		for i,target in ipairs(gdata.targets) do
			table.insert(target.queue, {"jump", x = data.x, y = data.y, dir = data.dir})
			
			if hasrule(unit,"is","defeat") and (target.safe == false) then
				table.insert(target.queue, {"defeat"})
			end
		end
	end,
	
	throw_turn = function(unit,data)
		local dir = (((data.dir - 1) + 2) % 4) + 1
		
		for i,target in ipairs(gdata.targets) do
			table.insert(target.queue, {"jump", x = data.x, y = data.y, dir = data.dir})
			target.values[DIR] = dir - 1
			
			if hasrule(unit,"is","defeat") and (target.safe == false) then
				table.insert(target.queue, {"defeat"})
			end
		end
		
		if (gdata.targets[1] ~= nil) then
			local t = gdata.targets[1]
			local msg = "skill_neutral"
			if (t.strings[TEAM] == "enemy") then
				msg = "skill_enemy"
			elseif (t.strings[TEAM] == "mech") then
				msg = "skill_friend"
			elseif (t.strings[TYPE] == "text") then
				msg = "skill_text"
			end
			
			trymessage(unit,msg)
		end
	end,
	
	jump = function(unit,data)
		local x,y = data.x,data.y
		unit.values[DIR] = data.dir - 1
		table.insert(unit.queue, {"jump", x = x, y = y, dir = data.dir})
		table.insert(unit.queue, {"action", x = x, y = y, action = "push_four_msg"})
	end,
	
	swap = function(unit,data)
		local x,y = data.x,data.y
		local ux,uy = unit.xpos,unit.ypos
		
		table.insert(unit.queue, {"jump", x = x, y = y})
		for i,target in ipairs(gdata.targets) do
			table.insert(target.queue, {"jump", x = ux, y = uy})
		end
		
		MF_sfx("swap")
		
		if (gdata.targets[1] ~= nil) then
			local t = gdata.targets[1]
			local msg = "skill_neutral"
			if (t.strings[TEAM] == "enemy") then
				msg = "skill_enemy"
			elseif (t.strings[TEAM] == "mech") then
				msg = "skill_friend"
			elseif (t.strings[TYPE] == "text") then
				msg = "skill_text"
			end
			
			trymessage(unit,msg)
		end
	end,
	
	dash = function(unit,data)
		local dx = math.abs(unit.xpos - data.x)
		local dy = math.abs(unit.ypos - data.y)
		
		unit.values[DIR] = data.dir - 1
		slide(unit,data.dir,dx + dy,nil,nil,0.5,true)
	end,
	
	dash_super = function(unit,data)
		local dx = math.abs(unit.xpos - data.x)
		local dy = math.abs(unit.ypos - data.y)
		
		MF_explosion(unit.xpos,unit.ypos,4 + data.dir - 1,unit.xpos+unit.ypos+1.5)
		unit.values[DIR] = data.dir - 1
		slide(unit,data.dir,dx + dy,nil,nil,0.5,true,math.max(map.w,map.h))
		MF_sfx("viuh2")
		
		trymessage(unit,"skill")
	end,
	
	push_long = function(unit,data)
		MF_explosion(unit.xpos,unit.ypos,4 + data.dir - 1,unit.xpos+unit.ypos+1.5)
		
		for i,target in ipairs(gdata.targets) do
			local dx = math.abs(target.xpos - data.x)
			local dy = math.abs(target.ypos - data.y)
			
			target.values[DIR] = data.dir - 1
			slide(target,data.dir,dx + dy,nil,nil,0.5,true)
			--table.insert(target.queue, {"action", x = data.x, y = data.y, dir = data.dir, action = "push_infront"})
			
			if hasrule(unit,"is","defeat") and (target.safe == false) then
				table.insert(target.queue, {"defeat"})
			end
		end
		
		if (gdata.targets[1] ~= nil) then
			local t = gdata.targets[1]
			local msg = "skill_neutral"
			if (t.strings[TEAM] == "enemy") then
				msg = "skill_enemy"
			elseif (t.strings[TEAM] == "mech") then
				msg = "skill_friend"
			elseif (t.strings[TYPE] == "text") then
				msg = "skill_text"
			end
			
			trymessage(unit,msg)
		end
	end,
	
	push = function(unit,data)
		MF_explosion(unit.xpos,unit.ypos,4 + data.dir - 1,unit.xpos+unit.ypos+1.5)
		
		for i,target in ipairs(gdata.targets) do
			slide(target,data.dir,1)
			if hasrule(unit,"is","defeat") and (target.safe == false) then
				table.insert(target.queue, {"defeat"})
			end
		end
		
		if (gdata.targets[1] ~= nil) then
			local t = gdata.targets[1]
			local msg = "skill_neutral"
			if (t.strings[TEAM] == "enemy") then
				msg = "skill_enemy"
			elseif (t.strings[TEAM] == "mech") then
				msg = "skill_friend"
			elseif (t.strings[TYPE] == "text") then
				msg = "skill_text"
			end
			
			trymessage(unit,msg)
		end
		
		MF_sfx("push")
	end,
	
	pull = function(unit,data)
		for i,target in ipairs(gdata.targets) do
			local dir = (((data.dir - 1) + 2) % 4) + 1
			slide(target,dir,1)
		end
		
		MF_sfx("pull")
		
		if (gdata.targets[1] ~= nil) then
			local t = gdata.targets[1]
			local msg = "skill_neutral"
			if (t.strings[TEAM] == "enemy") then
				msg = "skill_enemy"
			elseif (t.strings[TEAM] == "mech") then
				msg = "skill_friend"
			elseif (t.strings[TYPE] == "text") then
				msg = "skill_text"
			end
			
			trymessage(unit,msg)
		end
	end,
	
	push_four = function(unit,data)
		local x,y = data.x,data.y
		MF_explosion(x,y,4,x+y+1.5)
		MF_explosion(x,y,5,x+y-0.5)
		MF_explosion(x,y,6,x+y-0.5)
		MF_explosion(x,y,7,x+y+1.5)
		local defeat = hasrule(unit,"is","defeat")
		gdata.values[SHAKE] = 4
		
		for i=1,4 do
			local d = dirs[i]
			local ox,oy = d[1],d[2]
			
			if inbounds(x+ox,y+oy) then
				local t = here_solids(x+ox,y+oy)
				
				for j,u in ipairs(t) do
					slide(u,i,1)
					
					if defeat and (u.safe == false) then
						table.insert(u.queue, {"defeat"})
					end
				end
			end
		end
		
		MF_sfx("buum2")
	end,
	
	push_four_msg = function(unit,data)
		local x,y = data.x,data.y
		MF_explosion(x,y,4,x+y+1.5)
		MF_explosion(x,y,5,x+y-0.5)
		MF_explosion(x,y,6,x+y-0.5)
		MF_explosion(x,y,7,x+y+1.5)
		local defeat = hasrule(unit,"is","defeat")
		gdata.values[SHAKE] = 4
		
		local msg = "skill"
		local skilluse = 0
		
		for i=1,4 do
			local d = dirs[i]
			local ox,oy = d[1],d[2]
			
			if inbounds(x+ox,y+oy) then
				local t = here_solids(x+ox,y+oy)
				
				for j,u in ipairs(t) do
					slide(u,i,1)
					skilluse = math.max(skilluse, 1)
					
					if defeat and (u.safe == false) then
						table.insert(u.queue, {"defeat"})
						skilluse = math.max(skilluse, 1)
					end
				end
			end
		end
		
		if (skilluse == 1) then
			msg = "skill_hit"
		elseif (skilluse == 2) then
			msg = "skill_defeat"
		end
		
		trymessage(unit,msg)
		
		MF_sfx("buum2")
	end,
	
	push_infront = function(unit,data)
		local x,y = unit.xpos,unit.ypos
		local defeat = hasrule(unit,"is","defeat")
		
		local d = dirs[data.dir]
		local ox,oy = d[1],d[2]
		
		if inbounds(x+ox,y+oy) then
			local t = here_solids(x+ox,y+oy)
			
			MF_explosion(unit.xpos,unit.ypos,4 + data.dir - 1,unit.xpos+unit.ypos+1.5)
			
			for j,u in ipairs(t) do
				slide(u,data.dir,1)
				
				if defeat and (u.safe == false) then
					table.insert(u.queue, {"defeat"})
				end
			end
		end
	end,
	
	destroy_push = function(unit,data)
		local x,y = data.x,data.y
		local targets = here(x,y)
		for i,target in ipairs(targets) do
			if (target.safe == false) then
				gdata.values[SHAKE] = 6
				table.insert(target.queue, {"defeat"})
			end
		end
		
		local defeat = hasrule(unit,"is","defeat")
		local dir = (((data.dir - 1) + 2) % 4) + 1
		
		for i=1,4 do
			local d = dirs[i]
			local ox,oy = d[1],d[2]
			
			if inbounds(x+ox,y+oy) and (i ~= dir) then
				local t = here_solids(x+ox,y+oy)
				
				for j,u in ipairs(t) do
					slide(u,i,1)
					
					if defeat and (u.safe == false) then
						table.insert(u.queue, {"defeat"})
					end
				end
			end
		end
		
		if (targets[1] ~= nil) then
			local t = targets[1]
			local msg = "skill_neutral"
			if (t.strings[TEAM] == "enemy") then
				msg = "skill_enemy"
			elseif (t.strings[TEAM] == "mech") then
				msg = "skill_friend"
			elseif (t.strings[TYPE] == "text") then
				msg = "skill_text"
			end
			
			trymessage(unit,msg)
		end
	end,
	
	destroy_push_infront = function(unit,data)
		local x,y = data.x,data.y
		local d = dirs[data.dir]
		local ox,oy = d[1],d[2]
		
		if inbounds(x+ox,y+oy) then
			local targets = here(x+ox,y+oy)
			for i,target in ipairs(targets) do
				if (target.safe == false) then
					gdata.values[SHAKE] = 6
					table.insert(target.queue, {"defeat"})
				end
			end
			
			local defeat = hasrule(unit,"is","defeat")
			local dir = (((data.dir - 1) + 2) % 4) + 1
			
			for i=1,4 do
				local d = dirs[i]
				local ox2,oy2 = d[1],d[2]
				
				if inbounds(x+ox2,y+oy2) and (i ~= dir) then
					local t = here_solids(x+ox2,y+oy2)
					
					for j,u in ipairs(t) do
						slide(u,i,1)
						
						if defeat and (u.safe == false) then
							table.insert(u.queue, {"defeat"})
						end
					end
				end
			end
			
			if (targets[1] ~= nil) then
				local t = targets[1]
				local msg = "skill_neutral"
				if (t.strings[TEAM] == "enemy") then
					msg = "skill_enemy"
				elseif (t.strings[TEAM] == "mech") then
					msg = "skill_friend"
				elseif (t.strings[TYPE] == "text") then
					msg = "skill_text"
				end
				
				trymessage(unit,msg)
			end
		end
	end,
		
	destroy_four = function(unit,data)
		local x,y = data.x,data.y
		local targets = {}
		gdata.values[SHAKE] = 6
		MF_sfx("exp03_short")
		
		for i=1,4 do
			local d = dirs[i]
			local ox,oy = d[1],d[2]
			MF_explosion(x+ox,y+oy,0,x+ox+y+oy+1.5)
			
			if inbounds(x+ox,y+oy) then
				local t = here(x+ox,y+oy)
				
				for j,u in ipairs(t) do
					table.insert(targets, u)
					
					if (u.safe == false) then
						table.insert(u.queue, {"defeat"})
					end
				end
			end
		end
		
		if (targets[1] ~= nil) then
			local t = targets[1]
			local msg = "skill_neutral"
			if (t.strings[TEAM] == "enemy") then
				msg = "skill_enemy"
			elseif (t.strings[TEAM] == "mech") then
				msg = "skill_friend"
			elseif (t.strings[TYPE] == "text") then
				msg = "skill_text"
			end
			
			trymessage(unit,msg)
		end
	end,
	
	laserbeam = function(unit,data)
		local x,y = data.x,data.y
		local dir = unit.values[DIR] + 1
		local drs = dirs[dir]
		local ox,oy = drs[1],drs[2]
		
		gdata.values[SHAKE] = 3
		MF_explosion(x,y,8 + unit.values[DIR],99)
		MF_sfx("lasersmall")
		
		for i=1,map.maxdist do
			if inbounds(x + ox * i,y + oy * i) then
				local targets = here(x + ox * i,y + oy * i)
				for i,target in ipairs(targets) do
					if (target.safe == false) then
						gdata.values[SHAKE] = 8
						table.insert(target.queue, {"defeat"})
					end
				end
			else
				break
			end
		end
	end,
}

weatherlist =
{
	chaos =
	{
		name = "CHAOS WIND",
		desc = "Units are pushed randomly every turn",
		effect = function(w)
			for i,unit in ipairs(units) do
				if unit.solid then
					local dir = math.random(1,4)
					local drs = dirs[dir]
					local ox,oy = drs[1],drs[2]
					
					slide(unit,dir,1)
				end
			end
		end,
	},
	wind =
	{
		name = "WINDY WEATHER",
		desc = "All units are pushed down-left>every turn",
		effect_start = function(w)
			w.yp = 0
		end,
		effect_long = function(w)
			local y = map.w - w.yp - 1
			
			if (w.yp < map.w) then
				for x=0,map.w-1 do
					MF_explosion(x,y-1,7,x+y+1.5)
					
					local uh = here(x,y,true)
					for i,unit in ipairs(uh) do
						if unit.solid then
							local dir = 4
							local drs = dirs[dir]
							local ox,oy = drs[1],drs[2]
							
							slide(unit,dir,1)
						end
					end
				end
				
				w.yp = w.yp + 1
			elseif (w.yp >= map.w) and (anymovers() == false) then
				w.yp = 0
				w.done = true
			end
			
			if (w.yp == 2) then
				MF_sfx("windblow")
			end
		end,
	},
	wind2 =
	{
		name = "WINDY WEATHER",
		desc = "All units are pushed top-left>every turn",
		effect_start = function(w)
			w.yp = 0
		end,
		effect_long = function(w)
			local x = w.yp
			
			if (w.yp < map.h) then
				for y=0,map.h-1 do
					MF_explosion(x+1,y,6,x+y+1.5)
					
					local uh = here(x,y,true)
					for i,unit in ipairs(uh) do
						if unit.solid then
							local dir = 3
							local drs = dirs[dir]
							local ox,oy = drs[1],drs[2]
							
							slide(unit,dir,1)
						end
					end
				end
				
				w.yp = w.yp + 1
			elseif (w.yp >= map.h) and (anymovers() == false) then
				w.yp = 0
				w.done = true
			end
			
			if (w.yp == 2) then
				MF_sfx("windblow")
			end
		end,
	},
	boom =
	{
		name = "METEOR STRIKE",
		desc = "A meteor will strike>the marked spots each turn",
		effect_start = function(w)
			w.pos = {}
			local us = findunits("mech",true)
			for i,u in ipairs(us) do
				table.insert(w.pos, {u.xpos, u.ypos})
				MF_marker(u.xpos,u.ypos)
			end
		end,
		effect_long = function(w)
			w.timer = w.timer + 1
			local done = false
			
			if (w.timer == 20) then
				for i,v in ipairs(w.pos) do
					local x = v[1]
					local y = v[2]
					
					if (x ~= nil) and (y ~= nil) then
						gdata.values[SHAKE] = 10
						MF_explosion(x,y,0,x+y+1)
						local r = here(x,y)
						handledels(r,true)
						done = true
					end
				end
				
				MF_cleanmarkers()
				
				w.pos = {}
				local us = findunits("mech",true)
				for i,u in ipairs(us) do
					table.insert(w.pos, {u.xpos, u.ypos})
					MF_marker(u.xpos,u.ypos)
				end
				
				w.done = true
				
				if done then
					MF_sfx("exp03_short")
				end
			end
		end,
	},
	laser =
	{
		name = "GRAND ANTI-FRUIT SATELLITE",
		desc = "Each mech's position is marked,>and something will happen on>those spots!",
		effect_start = function(w)
			w.pos = {}
			local us = findunits("mech",true)
			for i,u in ipairs(us) do
				table.insert(w.pos, {u.xpos, u.ypos})
				MF_marker(u.xpos,u.ypos)
			end
		end,
		effect_long = function(w)
			if (w.count == 0) then
				w.timer = w.timer + 1
				
				if (w.timer < 100) then
					gdata.values[SHAKE] = 6
				end
				
				if (w.timer == 80) then
					local done = false
					
					for i,v in ipairs(w.pos) do
						local x = v[1]
						local y = v[2]
						
						if (x ~= nil) and (y ~= nil) and (namehere(x,y,"empty") == false) then
							MF_laser(x,y,x+y)
							done = true
							
							local r = here(x,y)
							if checkdels(r) then
								handledels(r,true)
							
								createunit("empty",x,y,0)
							end
						end
					end
					
					MF_cleanmarkers()
					
					if done then
						MF_sfx("laserbig")
					end
					
					w.pos = {}
					local us = findunits("mech",true)
					for i,u in ipairs(us) do
						table.insert(w.pos, {u.xpos, u.ypos})
						MF_marker(u.xpos,u.ypos)
					end
				elseif (w.timer == 180) then
					gdata.dialogue = {
						{"PIC","BABA_WHAT","LEFT"},
						{"TEXT","!!!"},
						{"PIC","KEKE_WHAT","LEFT"},
						{"TEXT","!!!"},
						{"PIC","JIJI_WHAT","LEFT"},
						{"TEXT","!!!"},
						{"PIC","FOFO_WHAT","LEFT"},
						{"TEXT","..."},
						{"PIC","IT_WHAT","LEFT"},
						{"TEXT","!!!"},
						{"PIC","BIRD_WHAT","LEFT"},
						{"TEXT","!!!"},
						{"PIC","CRAB_WHAT","LEFT"},
						{"TEXT","!!!"},
						{"PIC","MEVIL_WORRIED","RIGHT"},
						{"TEXT","!!!"},
						{"MESSAGE_TUTO","9","32","48","Note: Empty spaces behave as if they>were solid walls!"},
					}
					
					gdata.values[DIALOGUE] = 1
					gdata.values[ENEMYTURN] = 2
					w.done = true
					dialogue()
				end
			else
				local done = false
				
				for i,v in ipairs(w.pos) do
					local x = v[1]
					local y = v[2]
					
					if (x ~= nil) and (y ~= nil) and (namehere(x,y,"empty") == false) then
						MF_laser(x,y,x+y)
						done = true
						
						local r = here(x,y)
						if checkdels(r) then
							handledels(r,true)
						
							createunit("empty",x,y,0)
						end
					end
				end
				
				MF_cleanmarkers()
				
				if done then
					MF_sfx("laserbig")
				end
				
				w.pos = {}
				local us = findunits("mech",true)
				for i,u in ipairs(us) do
					table.insert(w.pos, {u.xpos, u.ypos})
					MF_marker(u.xpos,u.ypos)
				end
				
				w.done = true
			end
		end,
	},
	laser_nomessage =
	{
		name = "GRAND ANTI-FRUIT SATELLITE",
		desc = "A laser will strike>the marked spots>each turn",
		effect_start = function(w)
			w.pos = {}
			local us = findunits("mech",true)
			for i,u in ipairs(us) do
				table.insert(w.pos, {u.xpos, u.ypos})
				MF_marker(u.xpos,u.ypos)
			end
		end,
		effect = function(w)
			local done = false
			
			for i,v in ipairs(w.pos) do
				local x = v[1]
				local y = v[2]
				
				if (x ~= nil) and (y ~= nil) and (namehere(x,y,"empty") == false) then
					MF_laser(x,y,x+y)
					done = true
					
					local r = here(x,y)
					if checkdels(r) then
						handledels(r,true)
					
						createunit("empty",x,y,0)
					end
				end
			end
			
			if done then
				MF_sfx("laserbig")
			end
			
			MF_cleanmarkers()
			
			w.pos = {}
			local us = findunits("mech",true)
			for i,u in ipairs(us) do
				table.insert(w.pos, {u.xpos, u.ypos})
				MF_marker(u.xpos,u.ypos)
			end
		end,
	},
	msgtest =
	{
		hide = true,
		effect = function()
			messagebox("Testing",0,nil,24,24,1,true)
		end,
	},
}

textlist =
{
	act_1 = "Target unit is pushed away 1 tile.",
	act_2_baba = "Target unit is thrown and slides 1 tile after landing.",
	act_2_it = "It jumps and pushes units around them after landing.",
	act_2_keke = "Target unit is pushed in a line and turns towards that direction.",
	act_2_jiji = "Jiji dashes in a line and pushes any bumped unit until they hit a wall.",
	act_2_fofo = "Target unit on the same row or column with Fofo is pulled 1 tile.",
	act_2_me = "Destroys any target and pushes units around it by 1 tile.",
	act_2_crab = "Target unit is thrown over Crab and turns towards it.",
	act_2_bird = "Target unit within range of 3 swaps places with Bird.",
}

portraits =
{
	BABA = {0, "Baba"},
	BABA_ANGY = {1, "Baba"},
	BABA_SAD = {2, "Baba"},
	BABA_WORRIED = {3, "Baba"},
	BABA_HAPPY = {4, "Baba"},
	BABA_SMUG = {5, "Baba"},
	BABA_WHAT = {6, "Baba"},
	ME = {7, "Me"},
	ME_ANGY = {8, "Me"},
	ME_SAD = {9, "Me"},
	ME_WORRIED = {10, "Me"},
	ME_HAPPY = {11, "Me"},
	ME_SMUG = {12, "Me"},
	ME_WHAT = {13, "Me"},
	KEKE = {14, "Keke"},
	KEKE_ANGY = {15, "Keke"},
	KEKE_SAD = {16, "Keke"},
	KEKE_WORRIED = {17, "Keke"},
	KEKE_HAPPY = {18, "Keke"},
	KEKE_SMUG = {19, "Keke"},
	KEKE_WHAT = {20, "Keke"},
	JIJI = {21, "Jiji"},
	JIJI_ANGY = {22, "Jiji"},
	JIJI_SAD = {23, "Jiji"},
	JIJI_WORRIED = {24, "Jiji"},
	JIJI_HAPPY = {25, "Jiji"},
	JIJI_SMUG = {26, "Jiji"},
	JIJI_WHAT = {27, "Jiji"},
	FOFO = {28, "Fofo"},
	FOFO_ANGY = {29, "Fofo"},
	FOFO_SAD = {30, "Fofo"},
	FOFO_WORRIED = {31, "Fofo"},
	FOFO_HAPPY = {32, "Fofo"},
	FOFO_SMUG = {33, "Fofo"},
	FOFO_WHAT = {34, "Fofo"},
	IT = {35, "It"},
	IT_ANGY = {36, "It"},
	IT_SAD = {37, "It"},
	IT_WORRIED = {38, "It"},
	IT_HAPPY = {39, "It"},
	IT_SMUG = {40, "It"},
	IT_WHAT = {41, "It"},
	CRAB = {42, "Crab"},
	CRAB_ANGY = {43, "Crab"},
	CRAB_SAD = {44, "Crab"},
	CRAB_WORRIED = {45, "Crab"},
	CRAB_HAPPY = {46, "Crab"},
	CRAB_SMUG = {47, "Crab"},
	CRAB_WHAT = {48, "Crab"},
	BIRD = {49, "Bird"},
	BIRD_ANGY = {50, "Bird"},
	BIRD_SAD = {51, "Bird"},
	BIRD_WORRIED = {52, "Bird"},
	BIRD_HAPPY = {53, "Bird"},
	BIRD_SMUG = {54, "Bird"},
	BIRD_WHAT = {55, "Bird"},
	MEPHONE = {56, "Me"},
	MEPHONE_ANGY = {57, "Me"},
	MEPHONE_SAD = {58, "Me"},
	MEPHONE_HAPPY = {59, "Me"},
	SKULL = {60, "Skull"},
	SKULL_WORRIED = {61, "Skull"},
	SKULL_WHAT = {62, "Skull"},
	MEVIL_SHADOW = {63, "???"},
	MEVIL = {64, "Mevil"},
	MEVIL_ANGY = {65, "Mevil"},
	MEVIL_HAPPY = {66, "Mevil"},
	MEVIL_WORRIED = {67, "Mevil"},
	WORM = {68, "Worm"},
	ROBOT = {69, "Robot"},
	ROBOT_WORRIED = {70, "Robot"},
	GHOST = {71, "Ghost"},
	GHOST_SAD = {72, "Ghost"},
}

messageslist =
{
	baba =
	{
		skill_enemy = {"Bababa!", "Baba.", "Ba...!"},
		skill_friend = {"Bababa ba!", "Bababa!", "Ba Bababa...!"},
		skill_neutral = {"Bababa.", "Ba...", "Baba!"},
		skill_text = {"Baba?", "Baba!", "Ba!!"},
		defeat = {"BA?!", "BABA!!"},
	},
	me =
	{
		skill_enemy = {"Graahh!", "Raargh!", "Raagh!!"},
		skill_friend = {"Whoops!!", "Sorry...", "Whops"},
		skill_neutral = {"Take that!", "It had it coming!"},
		skill_text = {"Take that!", "Was that smart?", "Here we go!"},
		defeat = {"BARF!!!"},
	},
	mevil =
	{
		skill = {"Graahh!", "Raargh!", "Raagh!!"},
		skill_enemy = {"Whoops!!", "Sorry...", "Whops"},
		skill_friend = {"Ha ha ha!", "Take that!", "Graah!!"},
		skill_neutral = {"Bye!"},
		skill_text = {"Take that!", "Was that smart?", "Here we go!"},
		defeat = {"BARF!!!"},
	},
	jiji =
	{
		skill = {"Whee!", "Here we go!", "Here it goes..."},
		skill_enemy = {"Boop."},
		skill_friend = {"Let me help you!", "Here you go."},
		skill_neutral = {"Bump."},
		skill_text = {"Bump.", "Let's be careful here..."},
		defeat = {"NOO!", "OH NO!", "ARGH!"},
	},
	keke =
	{
		skill_enemy = {"Go away!", "Bye!", "Yah!", "See you later!", "Alright!"},
		skill_friend = {"Hi! ...And bye!", "Let's do this together!"},
		skill_neutral = {"Careful now...", "There it goes!", "Alright!", "Bye!", "Yah!"},
		skill_text = {"You're needed elsewhere.", "Let's see..."},
		defeat = {"NO!!", "Sorry!", "BLARB!"},
	},
	fofo =
	{
		skill_enemy = {"Yoink.", "Come closer.", "Woo."},
		skill_friend = {"Let's get you out of there.", "Come closer.", "Yoink.", "Come here."},
		skill_neutral = {"Yoink.", "Pulling...", "Woo."},
		skill_text = {"This looks tricky.", "You're needed here."},
		defeat = {"Augh.", "I hate this.", "Welp."},
	},
	it =
	{
		skill = {"And here I am!", "Whee!!", "Hup!"},
		skill_hit = {"Whoops!", "Make way!", "Bonk!", "Push push push!"},
		skill_defeat = {"Whoa!", "Sorry!", "Careful there!"},
		defeat = {"URGH!", "Aaahh!!", "What?!"},
	},
	crab =
	{
		skill_enemy = {"Snap!", "Snap snap!!"},
		skill_friend = {"Snip snap.", "Snip!", "Snaap!"},
		skill_neutral = {"Snip.", "Snip snap.", "Snip!"},
		skill_text = {"Snop.", "Snep."},
		defeat = {"SNAP!","SNIIP!!"},
	},
	bird =
	{
		skill_enemy = {"Check this out!", "Come over!", "What are you doing there?"},
		skill_friend = {"Let me help!", "Coming over!", "We should switch places!"},
		skill_neutral = {"Taking flight!", "This should be here.", "Repositioning this."},
		skill_text = {"This should be here.", "Repositioning this.", "Where should I put this?"},
		defeat = {"Hey!", "Wait!", "HONK!!"},
	},
}