<?php
    //変数初期設定
    $form_command='';
        //表示のみなら未指定
        //change=対象user変更(フォーム指定)
        //edit=編集(編集項目は別途指定する)
        //update=更新、全体プロフィール表示
    $form_subcommand='';
        //name
        //icon
        //about
        //pass
        //mailto(非対応)
    $safe=true; //チェック初期化(有効判定)
    $short_error=''; //エラーの理由

    //サブタイトル
    $sub_title='プロフィール';

    //ログ(表示用)
    $edit_log='';

    //共通設定読み込み
    include './common.php';
    //復帰設定
    $scene_now='profile';
    $url_return=$url_profile; //あとで補正(target追加)

?>
<?php
//引数を取得(追加)

    $target_new='';
    if($form_command=='change') { //対象user変更時
        if(isset($_POST['target_new'])) {
            $target_new = $_POST['target_new'];
        }
        if($target_new<>''){
            $target_new=$url_profile.'?'.$target_new;
            header('location: '.$target_new); //リダイレクト指定
        }
    }
    if($form_command=='edit' or $form_command=='update'){
        //update実行時に受け取る
        if(isset($_POST['form_subcommand'])) {
            $form_subcommand=$_POST['form_subcommand'];
        }
        //edit開始時に受け取る
        if(isset($_POST['change_name'])) {
            $form_subcommand='name';
        }
        if(isset($_POST['change_about'])) {
            $form_subcommand='about';
            $form_command='update'; //updateへ移行
        }
        if(isset($_POST['change_icon'])) {
            $form_subcommand='icon';
        }
        if(isset($_POST['change_mailto'])) {
            $form_subcommand='mailto';
        }
        if(isset($_POST['change_pass'])) {
            $form_subcommand='pass';
        }
        //edit(icon)用
        $new_icon_frame=-1; //-1=未指定
        $new_icon_number=0; //0=変更なし
        if(isset($_POST['new_icon_frame'])) { //新しいicon枠の値
            $new_icon_frame=$_POST['new_icon_frame'];
        }
        if(isset($_POST['new_icon_number'])) { //新しいプリセットicon番号
            $new_icon_number=$_POST['new_icon_number'];
        }
        //edit,update共通
        if(isset($_POST['new_value'])) { //更新後の値
            $new_value=$_POST['new_value'];
        }
        if(isset($_POST['close'])) { //閉じる実行時
            $form_command=''; //updateへ進まない/editを閉じる
        }
    }

//変数追加設定
    //表示対象user
    $target_user=''; //指定なし
    $target_me=0; //1=自分自身を対象とする場合
    $target_found=false; //未発見
    $target_error='';
    if($extra_profile_id<>''){
    //(URL引数による対象id指定あり)
        $target_user=$extra_profile_id; //URLで指定されたuser
    }else{
        if($target_new==''){
            if($login==1){
                //自身を指定して再表示
                $target_new=$url_profile.'?'.$account_id;
                header('location: '.$target_new); //リダイレクト指定
            }else{
                $target_error='プロフィールを表示する対象を指定してください。';
            }
        }
    }
    //自分自身が対象？
    if($login==1 and $target_user==$account_id){
    //(YES)
        $target_me=1;
    }
    //対象user指定ありの場合
    if($target_user<>''){
        //user存在確認
        $target_found=utUserExists($target_user);
        if($target_found==true){
            //Target～取得
            utGetTargetInfo($target_user);
            //復帰URL補正
            $url_return=$url_return.'?'.$target_user;
        }else{
            $target_error='[ '.$target_user.' ]は、存在しません。';
        }
    }
?>
<?php //--------反映処理(update/edit)--------
if($target_me==1 and $form_command=='edit'){ //edit

    if($form_subcommand=='icon'){
        $go_save=0; //セーブ不要

        //アイコン変更(プリセット)
        if($new_icon_number==0){ 
        //(0)
            //変更なし
        }else{
        //(1以上)
            $target_icon_number=$new_icon_number; //icon番号更新
            $target_icon_path=utIconPath($target_icon_number); //path更新
            $me_icon_path=$target_icon_path;
            $go_save=1; //要セーブ
            //独自画像があれば削除
            if(file_exists($user_upicon_path)){
                unlink($user_upicon_path);
            }
            //ログ
            $edit_log=$edit_log.'アイコン画像を変更しました。<br>';
        }

        //枠
        if($new_icon_frame<>-1 and $new_icon_frame<>$target_icon_frame){
            //変数更新
            $target_icon_frame=$new_icon_frame;
            $me_icon_frame=$new_icon_frame;
            $go_save=1; //要セーブ
            $edit_log=$edit_log.'アイコン枠を変更しました。<br>';
        }

        //独自画像
        $file_up=0;
        if(is_uploaded_file($_FILES['file']['tmp_name'])){
            move_uploaded_file($_FILES['file']['tmp_name'], $user_tempfile_path);
			$file_up=1;
        }
        if ($file_up==1){
            //拡大描画キャンバス
            $image_canvas=imagecreatetruecolor(96,96);//キャンバスを作成
            imagecolortransparent($image_canvas,imagecolorallocate($image_canvas,0,0,0));
            //元画像
            $image_icon=imagecreatefrompng($user_tempfile_path); //ロード
            $sx=imagesx($image_icon); //サイズ取得
            $sy=imagesy($image_icon);
            //拡大描画
            imageLayerEffect($image_canvas, IMG_EFFECT_ALPHABLEND);//透過設定
            imagecopyresized($image_canvas, $image_icon,0,0,0,0,96,96,$sx,$sy); //実行
            //ファイルに保存
            imagepng($image_canvas,$user_upicon_path);
            //事後処理
            imagedestroy($image_icon); //破棄
            imagedestroy($image_canvas); //破棄
            unlink($user_tempfile_path); //一時画像を削除
            //変数更新
            $target_icon_number=0;
            $target_icon_path=$user_upicon_path.'?'.date("ymdHis",filemtime($user_upicon_path));
            $go_save=1; //要セーブ
            $edit_log=$edit_log.'アイコンを独自画像に変更しました。<br>';
        }
        //プロフィール保存
        if($go_save==1){
            utUserProfileSave($target_user,$target_nickname,$target_icon_number,$target_icon_frame); //プロフィール保存
        }
    }
}
if($target_me==1 and $form_command=="update"){ //update
    if($form_subcommand=='about'){
        //ログ
        $edit_log='説明文を更新しました。';
        //更新
        $target_about=$new_value;
        //セーブ
        utUserAboutSave($target_user,$new_value);
    }
    if($form_subcommand=='name'){
        $edit_log='ニックネームを更新しました。';
        //更新
        $target_nickname=$new_value;
        $me_nickname=$new_value;
        //セーブ
        utUserProfileSave($target_user,$target_nickname,$target_icon_number,$target_icon_frame);
    }
    if($form_subcommand=='pass'){
        $edit_log='パスワードを更新しました。';
        //更新
        $me_password=$new_value;
        //セーブ
        utUserRegSave($account_id,$me_password,$me_mailto);
    }
    if($form_subcommand=='mailto'){ //仮
        $edit_log='メールアドレスを更新しました。';
        //更新
        $me_mailto=$new_value;
        //セーブ
        utUserRegSave($account_id,$me_password,$me_mailto);
    }

}
?>

<?php //--------共通処理：ページ開始--------

    //対象のフルネームを作成
    $target_fullname=utUserFullName($target_user,$target_nickname);
    if($target_fullname<>''){
        $sub_title=$sub_title.' - '.$target_fullname; //サブタイトル更新
    }
    if($form_command=='edit'){
        $sub_title= $target_fullname.'のプロフィール編集';
    }
    if($extra_log_number<>''){
    //(発言指定あり)
        $sub_title=$target_fullname.'の発言';
    }

    //style読み込み
    include './style.php';

    //head
    echo "<head>";
    $pagetitle=$main_title.'/'.$sub_title;
    $pageurl=$url_profile;
    //基礎設定
    utHeadBasic($pagetitle,$pageicon,$view_width);
    //OGP設定
    utHeadOgp($main_title,$main_title,$pagetitle,$pageurl,$ogppicture);
    echo "</head>";
    //body冒頭
    echo '<body><div id="base">';

    //TOPメニュー
    utPrintTopMenu();
    //報告
    if($edit_log<>''){
        utPrintSuccess($edit_log);
    }
    if($common_error<>''){
        utPrintError($common_error);
    }
?>

<?php //--------共通処理：準備表示--------

    //対象に関する警告
    if($target_error<>''){
        echo '<p>';
        echo '・'.$target_error.'<br>';
        echo '</p>';
    }
    //エラー
    if($short_error<>''){
        echo '<p>';
        echo '・エラー: '.$short_error.'<br>';
        echo '</p>';
    }
?>

<?php //指定発言表示

    if($extra_log_number<>''){
    //(指定あり)
        echo '<content>';
        $view=utPrintLogBox($target_user,$extra_log_number);
        if($view==0){
            echo '・指定された発言('.$extra_log_number.')は表示できません。';
        }
        echo '</content>';
    }
?>

<?php //--------編集UI表示(edit)--------
if($target_me==1 and $form_command=='edit'){

    //フォーム冒頭(編集時)
    echo '<form action="'.$url_profile.'?'.$target_user.'" method="post" enctype="multipart/form-data">';
    if($form_subcommand=="name"){
        echo '<input type="hidden" name="form_subcommand" value="name">';
        echo '<input type="hidden" name="form_command" value="update">'; //閉じてupdate
        echo '<form_content>';
        echo '<title>現在のニックネーム</title>';
        echo '・'.$target_nickname.'';
        echo '</form_content>';
        echo '<form_content>';
        echo '<title>新しいニックネーム</title>';
        echo '';
        echo '<input type="text" name="new_value" value="'.$target_nickname.'" size="30" required placeholder=""></p>';
        echo '';
        echo '</form_content>';
        echo '<form_content>';
        utPrintButtonLike($url_profile.'?'.$target_user,'戻る');echo '　';
        echo '<input type="submit" name="exec" value="決定">';
        echo '</form_content>';
    }
    if($form_subcommand=="icon"){
        echo '<input type="hidden" name="form_subcommand" value="icon">';
        echo '<input type="hidden" name="form_command" value="edit">'; //editのまま更新
        echo '<form_content>';
        echo '<title>現在のアイコン</title>';
        echo '<p>'.utPrintIcon($target_icon_path,$target_icon_frame).'</p>'; //<img>タグ出力
        echo '</form_content>';
        echo '<form_content>';
        echo '<title>新しいアイコン</title>';
        echo '<p>▶独自画像を利用する場合</p>';
        echo '<p>・ファイルを選択してから［アップロード］してください。<br></p>';
        echo '</form_content>';
        echo '<form_content>';
        echo '<p><input type="file" accept=".png" id="fileopen" name="file"></p>';
        echo '<p><input type="submit" value="アップロード"></p>';
        echo '</form_content>';
        echo '<form_content>';
        echo '<p>▶プリセット画像を使用する場合</p>';
        $i_count=0;
        echo '<div id="icon_select">';
        while($i_count<=$last_preset_icon){
            $checked="";
            $skip=0;
            if($i_count==0){
                $radio_title='変更なし';
                $radio_image=$target_icon_path;
                $checked="checked";
            }else{
                $radio_title='No.'.$i_count;
                $radio_image=utIconPath($i_count);
                if($target_icon_number==$i_count){$skip=1;}
            }
            if($skip==0){
                echo '<div id="icon_box">';
                echo '<input class="radio_icon96" type="radio" name="new_icon_number" value="'.$i_count.'" '.$checked.' id="radio_icon_number'.$i_count.'">';
                echo '<label for="radio_icon_number'.$i_count.'">';
                echo $radio_title;
                echo utPrintIcon($radio_image,$target_icon_frame);
                echo '</label><br>';
                echo '</div>';
            }
            $i_count=$i_count+1; //次へ
        }
        echo '</div>';
        echo '<p>※独自画像を利用する場合は、［変更なし］を選んでください。</p>';
        echo '</form_content>';

        echo '<form_content>';
        echo '<p>▶枠</p>';
        $i_count=0;
        $radio_image=utIconPath(0);
        echo '<div id="icon_select">';
        while($i_count<=$last_icon_frame){
            if($i_count==0){$radio_title='ましかく';}
            if($i_count==1){$radio_title='カドまる';}
            if($i_count==2){$radio_title='まんまる';}
            if($target_icon_frame==$i_count){$checked="checked";}else{$checked="";};
            echo '<div id="icon_box">';
            echo '<input class="radio_icon96" type="radio" name="new_icon_frame" value="'.$i_count.'" '.$checked.' id="radio_frame'.$i_count.'">';
            echo '<label for="radio_frame'.$i_count.'">';
            echo $radio_title;
            echo utPrintIcon($radio_image,$i_count);
            echo '</label><br>';
            echo '</div>';
            $i_count=$i_count+1; //次へ
        }
        echo '</div>';
        echo '</form_content>';
        echo '<form_content>';
        echo '<p>▶以上の設定で設定を更新しますか？</p>';
        echo '<p>';
        utPrintButtonLike($url_profile.'?'.$target_user,'戻る');
        echo '　<input type="submit" name="exec" value="更新"></p>';
        echo '</form_content>';

    }
    if($form_subcommand=="mailto"){ //仮
        echo '<input type="hidden" name="form_subcommand" value="mailto">';
        echo '<input type="hidden" name="form_command" value="update">'; //閉じてupdate
        echo '現在のメールアドレス<br>';
        echo '・'.$me_mailto.'<br>';
        echo '新しいメールアドレス<br>';
        echo '<input type="text" name="new_value" value="" size="30" required placeholder=""></p>';
        utPrintButtonLike($url_profile.'?'.$target_user,'戻る');echo '　';
        echo '<input type="submit" name="exec" value="決定">';
    }
    if($form_subcommand=="pass"){
        echo '<input type="hidden" name="form_subcommand" value="pass">';
        echo '<input type="hidden" name="form_command" value="update">'; //閉じてupdate
        echo '<form_content>';
        echo '<title>新しいパスワード</title>';
        echo '<input type="text" name="new_value" value="" size="30" '.$input_password_setting.' required placeholder=""></p>';
        echo '</form_content>';
        echo '<form_content>';
        utPrintButtonLike($url_profile.'?'.$target_user,'戻る');echo '　';
        echo '<input type="submit" name="exec" value="決定">';
        echo '</form_content>';
    }
}
?>

<?php //--------対象あり(プロフィール表示)--------
if($form_command<>'edit' and $target_found==true){

    //フォーム表示
    echo '<form action="'.$url_profile.'?'.$target_user.'" method="post">';
    echo '<input type="hidden" name="form_command" value="edit">';

    echo '<form_content>';
    echo '<title>ID</title>'; //id
    echo ''.$target_user.'';
    echo '</form_content>';

    echo '<form_content>';
    echo '<title>ニックネーム</title>';
    echo ''.$target_nickname.''; //ニックネーム(name)
    if($target_me==1){
        echo '<p><input type="submit" name="change_name" value="編集"></p>';
    }
    echo '</form_content>';


    $icon_title='プリセット No.'.$target_icon_number;
    if($target_icon_number==0){
        $icon_title='初期設定';
        if(strpos($target_icon_path,$account_id)){
            $icon_title='独自画像';
        }
    }
    echo '<form_content>';
    echo '<title>アイコン</title>';
    echo utPrintIcon($target_icon_path,$target_icon_frame); //<img>タグ出力
    echo '<p>※'.$icon_title.'</p>'; //icon名称
    if($target_me==1){
        echo '<p><input type="submit" name="change_icon" value="編集"></p>';
    }
    echo '</form_content>';

    echo '<form_content>';
    if($target_me==1){
    //(自身のabout)
        echo '<title>説明文</title>';
        echo '<p><textarea name="new_value" cols="40" rows="10">'.$target_about.'</textarea></p>';
        echo '<p><input type="submit" name="change_about" value="更新"></p>';
    }else{
    //(他者のabout)
        if(trim($target_about)<>''){
            echo '<title>説明文</title>';
            echo '<p>'.str_replace("\n",'<br>',$target_about).'</p>';
        }
    }
    echo '</form_content>';

    echo '<form_content>';
    echo '<title>メールアドレス</title>';
    if($target_me==1){ //仮実装のため編集非表示
        //自身のみの表示要素
        echo '<p>'.$me_mailto.' (非公開)</p>'; //メアド
        // echo '<p><input type="submit" name="change_mailto" value="編集"></p>';
    }else{
        echo '<p>非公開</p>';
    }
    echo '</form_content>';
    if($target_me==1){
        echo '<form_content>';
        echo '<title>パスワード</title>'; //パスワード
        echo '??? (非表示)';
        echo '<p><input type="submit" name="change_pass" value="編集"></p>';
        echo '</form_content>';
    }

}
?>
<?php //--------対象なし(対象入力)--------
if($form_command<>'edit' and $target_found==false){
    //ページ本文表示(検索)
    echo '<content>';
    echo '<title>プロフィールを表示する対象を指定して[実行]してください。</title>';
    echo '</content>';
    //フォーム表示(検索)
    echo '<form action="'.$url_profile.'" method="post">';
    echo '<input type="hidden" name="form_command" value="change">';
    echo '対象ユーザーのID(半角英数字)<br>';
    echo '<input type="text" name="target_new" size="30" required placeholder="半角英数字でIDを記入"></p>';
    echo '<input type="submit" name="send" value="実行">';
}
?>
<?php //共通処理：フォーム締め

    if($target_found==true and $login==1 and $target_me==0){
    //他者のプロフィール
        echo '<form_content>';
        //フォロー状態を取得
        $answer=utFindListTarget($me_followlist,$target_user);
        if($answer==true){ 
            echo '<title>フォローしているユーザー</title>';
            $temp_href=$url_profile.'?/'.$token.'/follow_off/'.$target_user;
            $temp_title='解除';
        }else{
            echo '<title>フォローしていないユーザー</title>';
            $temp_href=$url_profile.'?/'.$token.'/follow_on/'.$target_user;
            $temp_title='登録';
        }
        echo '<p>';
        utPrintButtonLike($temp_href,$temp_title);
        echo '</p>';
        echo '</form_content>';
    }
    if($login==1){
        echo '<input type="hidden" name="account_id" value="'.$account_id.'">';
        echo '<input type="hidden" name="token" value="'.$token.'">';
    }
    echo '</form>';

?>

<?php //共通処理：発言リスト
    if($form_command<>'edit'){ //※編集中は表示しない
        //発言リストを取得
        utUserHistoryLoad($target_user);
        $count=count($loaded_history);
        //発言リスト表示
        echo '<content>';
        echo '<title>メッセージ履歴</title>';
        $found=0;
        if($count>=1){
            $i_line=1;
            while($i_line<$count){
                //レコードから情報を取得
                $rec=explode(',',$loaded_history[$i_line]);
                if($rec[0]<>'' and $rec[1]<>'' and $rec[2]<>''){
                    $log_theme=$rec[0];
                    $log_number=$rec[1];
                    $log_time=$rec[2];
                    //表示OFF判定
                    $off=0;
                    $head_char=mb_substr($log_theme,0,1); //テーマの先頭1文字
                    if($target_me==0){
                        if($head_char=='(' or $head_char=='@'){
                            $off=1;
                        }
                    }
                    if($off==0){
                        //ファイル確認
                        $temp_path=utUserChatMessageTextPath($target_user,$log_number);
                        if(file_exists($temp_path)){
                            $found=$found+1; //発見数+1
                            //出力
                            $temp_href=$url_profile.'?'.$target_user.','.$log_number;
                            utPrintLogBar($log_theme,$log_time,'');
                        }
                    }
                }
                $i_line=$i_line+1; //次へ
            }
        }
        if($found==0){
            echo '<p>・オープンなメッセージ履歴はありません。</p>';
        }
        echo '</content>';
    }
?>

<?php //共通処理：締め

    //デバッグ情報出力
    utPrintDebugInfo();
    //BOTTOMメニュー
    utPrintBottomMenu();

    echo '</div></body>';

?>