<?php //関数：ユーザー系
    function utUserExists($target_account_id){
    //対象userのアカウントが存在するか検査
        $found=true; //初期値:存在あり
        //本登録データ
        $temp_reg_path=utUserRegPath($target_account_id);
        //保管フォルダ
        global $folder_u_dat;
        $temp_dat_folder=$folder_u_dat.'user_'.$target_account_id.'/';
        //存在確認1
        if(file_exists($temp_reg_path)==false){
            $found=false; //存在なし
        }
        //存在確認2
        if(file_exists($temp_dat_folder)==false){
            $found=false; //存在なし
        }
        //戻り値
        return $found;
    }
    function utPasswordMake(){
    //パスワードを作成して返す
        $pass='';
        //準備
        $max_chars=rand(9,12); //最大文字数
        $count_chars=0; //現在の文字数=0
        $char_one='';
        //作成
        while($count_chars < $max_chars){
            $count_chars++; //+1文字
            //1文字取得
            $char_one = chr(mt_rand(65,90));
            //一部置換(誤認しやすい文字を数字に)
            if($char_one=='D'){$char_one='2';}
            if($char_one=='I'){$char_one='3';}
            if($char_one=='L'){$char_one='4';}
            if($char_one=='O'){$char_one='5';}
            if($char_one=='Q'){$char_one='6';}
            if($char_one=='U'){$char_one='7';}
            if($char_one=='V'){$char_one='8';}
            //結合
            $pass=$pass.$char_one;
        }
        //戻り値(小文字化)
        return strtolower($pass);
    }
    function utUserPrePath($id){
    //指定userの仮登録データpathを返す
        global $folder_u_pre;
        $temp_path=$folder_u_pre.$id.'.txt';
        return $temp_path;
    }
    function utUserRegPath($id){
    //指定userの本登録データpathを返す
        global $folder_u_reg;
        $temp_path=$folder_u_reg.$id.'.txt';
        return $temp_path;
    }
    function utUserRegSave($id,$password,$mailto){
    //本登録データをセーブ
        $temp_path=utUserRegPath($id);
        $fp = fopen($temp_path, "w");
        fwrite($fp, $password."\n"); //1行目:password
        fwrite($fp, $mailto."\n"); //2行目:メアド
        fclose($fp);
    }
    function utUserRegLoad($id){
    //本登録データをロード
        global $loaded_password;$loaded_password='';
        global $loaded_mailto;$loaded_mailto='';
        $temp_path=utUserRegPath($id);
        if(file_exists($temp_path)){
            $lines=0;
            $fp = fopen($temp_path, "r");
            while ($line = fgets($fp)) {
                $lines=$lines+1;
                if($lines==1){$loaded_password=trim($line);} //1行目：password
                if($lines==2){$loaded_mailto=trim($line);} //2行目：メアド
            }
            fclose($fp);
        }
    }
    function utTokenGet($token_path){
    //指定ファイルからトークンの内容を読み込む
        //行番号メモ：1=IP, 2=Token
        global $saved_ip; $saved_ip='';
        global $saved_token; $saved_token='';
        //ファイル確認
        if(file_exists($token_path)){
            $info_lines=0;
            $fp = fopen($token_path, "r");
            while ($line = fgets($fp)) {
                $info_lines=$info_lines+1;
                if($info_lines==1){
                    $saved_ip=trim($line);
                }
                if($info_lines==2){
                    $saved_token=trim($line);
                }
            }
        }
    }
    function utCookieUpdate($new_id,$new_token){
    //cookie更新
        $cookie_limit=time()+3600*24*100; //100日制限
        //更新実行
        setcookie('account_id', $new_id, $cookie_limit);
        setcookie('token', $new_token, $cookie_limit);
    }
    function utUserDataFolder($id){
    //指定userのdatフォルダを返す
        global $folder_u_dat;
        $temp_path=$folder_u_dat.'user_'.$id.'/';
        return $temp_path;
    }
    function utUserTempFilePath($id){
    //指定userの一時ファイルpathを返す
        $temp_path=utUserDataFolder($id).'tempfile.dat';
        return $temp_path;
    }
    function utUserFullName($id,$nickname){
    //指定userのフルネームを返す
        $temp_name=utUserShortName($id,$nickname);
        if($temp_name<>$id){
            $temp_name=$temp_name.'('.$id.')';
        }
        return $temp_name;
    }
    function utUserShortName($id,$nickname){
    //指定userのショート名を返す
        if($nickname==''){
            $temp_name=$id;
        }else{
            $temp_name=$nickname;
        }
        return $temp_name;
    }
    function utUserIconPath($id){
    //指定userのアイコンpathを返す
        //アップロードアイコン存在確認
        $temp_path=utUserUploadedIconPath($id);
        if (file_exists($temp_path)==false){
        //(なし)
            $temp_path='';
        }
        return $temp_path;
    }
    function utUserUploadedIconPath($id){
    //指定userのアップロードアイコンpathを返す
        global $folder_u_res;
        $temp_path=$folder_u_res.$id.'_icon.png';
        return $temp_path;
    }

    function utIconPath($icon_number){
        //指定番号のアイコンpathを返す
            $temp_path='./resources/'.'icon96_'.str_pad($icon_number, 4, 0, STR_PAD_LEFT).'.png';
            return $temp_path;
        }

    function utUserProfilePath($id){
    //指定userのプロフィール保存pathを返す
        $temp_path=utUserDataFolder($id);
        $temp_path=$temp_path.'profile.txt';
        return $temp_path;
    }
    function utUserProfileSave($id,$new_name,$new_icon_number,$new_icon_frame){
    //指定userのプロフィールを保存
        $temp_path=utUserProfilePath($id);
        //セーブ
        $fp = fopen($temp_path, "w");
        fwrite($fp, trim($new_name)."\n"); //1行目：ニックネーム
        fwrite($fp, $new_icon_number."\n"); //2行目：アイコン番号
        fwrite($fp, $new_icon_frame."\n"); //3行目：アイコン枠
        fclose($fp);
    }
    function utUserProfileLoad($id){
    //指定userのプロフィールを読み込む
        //変数準備
        global $loaded_nickname;
        global $loaded_icon_number;
        global $loaded_icon_frame;
        global $loaded_icon_path;
        $loaded_nickname='';
        $loaded_icon_number=0;
        $loaded_icon_frame=0;
        $loaded_icon_path='';
        //path取得
        $temp_path=utUserProfilePath($id);
        //ロード
        $lines=0;
        if(file_exists($temp_path)){
            $fp = fopen($temp_path, "r");
            while ($line = fgets($fp)) {
                $lines=$lines+1;
                if($lines==1){$loaded_nickname=trim($line);} //1行目：ニックネーム
                if($lines==2){$loaded_icon_number=trim($line);} //2行目：アイコン番号
                if($lines==3){$loaded_icon_frame=trim($line);} //3行目：アイコン枠
            }
            fclose($fp);
        }
        if($loaded_nickname==''){
            $loaded_nickname=$id; //ニックネームが空白の場合はIDを代用
        }
        //loaded_icon_path生成
        $loaded_icon_path=utUserIconPath($id); //独自画像
        if($loaded_icon_path<>''){
        //(ファイルあり)
            //path末尾にタイムスタンプ付与
            $loaded_icon_path=$loaded_icon_path.'?'.date("ymdHis",filemtime($loaded_icon_path));
        }else{
        //(ファイルなし)
            $loaded_icon_path=utIconPath($loaded_icon_number); //プリセットに変更
        }
    }
    function utUserAboutPath($id){
    //指定userのabout保存pathを返す
        $temp_path=utUserDataFolder($id);
        $temp_path=$temp_path.'about.txt';
        return $temp_path;
    }
    function utUserAboutSave($id,$new_about){
    //指定userのaboutを保存
        $temp_path=utUserAboutPath($id);
        //セーブ
        $fp = fopen($temp_path, "w");
        fwrite($fp, $new_about);
        fclose($fp);
    }
    function utUserAboutLoad($id){
    //指定userのaboutを読み込む
        //変数準備
        global $loaded_about;
        $loaded_about='';
        //path取得
        $temp_path=utUserAboutPath($id);
        //ロード
        if(file_exists($temp_path)){
            $fp = fopen($temp_path, "r");
            while ($line = fgets($fp)) {
                $loaded_about=$loaded_about.$line;
            }
            fclose($fp);
        }
    }

    function utUserFollowListPath($id){
    //指定userのフォローリスト保存pathを返す
        $temp_path=utUserDataFolder($id);
        $temp_path=$temp_path.'followlist.txt';
        return $temp_path;
    }
    function utUserFollowListSave($id,$followlist){
    //指定userのフォローリストをセーブ
        $temp_path=utUserFollowListPath($id);
        unlink($temp_path);
        utListSave($followlist,$temp_path); //リストセーブ実行
    }
    function utUserFollowListLoad($id){
    //指定userのフォローリストをロード
        global $loaded_list;
        global $loaded_followlist; $loaded_followlist=array();
        $temp_path=utUserFollowListPath($id);
        utListLoad($temp_path); //リストロード実行
        $loaded_followlist=$loaded_list;
    }

    function utUserHistoryPath($id){
    //指定userの発言リスト保存pathを返す
        $temp_path=utUserDataFolder($id).'history.txt';
        return $temp_path;
    }
    function utUserHistorySave($id,$list){
    //指定userの発言リストをセーブ
        $temp_path=utUserHistoryPath($id);
        unlink($temp_path);
        utListSave($list,$temp_path); //リストセーブ実行
    }
    function utUserHistoryLoad($id){
    //指定userの発言リストをロード
        global $loaded_list;
        global $loaded_history; $loaded_history=array();
        $temp_path=utUserHistoryPath($id);
        utListLoad($temp_path); //リストロード実行
        $loaded_history=$loaded_list;
    }

    function utHistoryCount($history){
    //指定historyから発言総数を取得
        $count=0;
        //0行目(発言データ)から取得
        if($history[0]<>''){
            $ex_data=explode(',',$history[0]); //データ行を分解
            if($ex_data[0]==''){ 
                $ex_data[0]=0;
            }
            $count=intval($ex_data[0]); //データ第一項目が発言総数
        }
        return $count;
    }
    function utMeHistoryUpdate($id,$theme,$message,$number,$time){
    //指定内容に応じて$me_historyを更新する
        global $me_history;
        //テーマ追加補正
        $theme1re=strtolower($theme); //小文字化

        //配列数を取得
        $max=count($me_history);

        //0行目：データ行を一度削除
        if(count($me_history)>=1 and $me_history[0]<>''){
            unset($me_history[0]);
        }
        //検索
        $i_line=1;
        while($i_line<$max){
            //レコード分解
            if($me_history[$i_line]<>''){
                $rec=explode(',',$me_history[$i_line]);
                $theme2re=utChatThemeRevision($rec[0]); //テーマ再補正
                $theme2re=strtolower($theme2re); //さらに小文字化
                if($theme2re==$theme1re){
                //(同テーマ)
                    //ファイル消去
                    $del_number=$rec[1];
                    $temp_path=utUserChatMessageTextPath($id,$del_number);
                    if(file_exists($temp_path)){
                        unlink($temp_path);
                    }
                    //レコード消去
                    unset($me_history[$i_line]);
                    break;
                }else{
                //(別テーマ)
                    //無視
                }
            }
            $i_line=$i_line+1; //次へ
        }
        //レコード追加
        if(trim($message)<>''){
            //レコード作成
            $new_record=$theme.','.$number.','.$time.',';
            //先頭に追加
            array_unshift($me_history,$new_record);
        }
        //さらにデータ行を追加
        $new_data=$number.',';
        array_unshift($me_history,$new_data);

        //配列整理
        array_values($me_history);
        //セーブ
        utUserHistorySave($id,$me_history);
    }
    function utUserChatMessageTextPath($id,$number){
    //指定user/指定番号のメッセージファイルのpathを返す
        $temp_path=utUserDataFolder($id);
        $temp_path=$temp_path.'mt_'.$number.'.txt';
        return $temp_path;
    }
    function utUserChatMessageTextSave($id,$theme,$message,$number){
    //発言ファイルをセーブ
        //path取得
        $temp_path=utUserChatMessageTextPath($id,$number);
        unlink($temp_path); //まず削除
        if(trim($message)<>''){ //本文があれば
        //(要セーブ)
            //オープン
            $fp=fopen($temp_path,"w");
            //データ行
            $data=$theme.','."\n";
            fwrite($fp, $data);
            //本文
            fwrite($fp, $message);
            //クローズ
            fclose($fp);
        }
    }
    function utUserChatMessageTextLoad($id,$number){
    //発言ファイルをロード
        global $loaded_log;$loaded_log=array();
        global $loaded_theme;$loaded_theme='';
        global $loaded_message;$loaded_message='';
        global $loaded_timestamp;$loaded_timestamp='';
        global $common_error;
        //path取得
        $temp_path=utUserChatMessageTextPath($id,$number);
        //ロード
        if(file_exists($temp_path)){
            $fp = fopen($temp_path, "r");
            $i_line=0;
            while ($line = fgets($fp)) {
                $loaded_log[$i_line]=$line;
                if($i_line==0){
                //先頭行=データ
                    $rec=explode(',',trim($line));
                    $loaded_theme=$rec[0];
                }else{
                //本文
                    $loaded_message=$loaded_message.$line;
                }
                $i_line=$i_line+1; //次へ
            }
            fclose($fp);
            //タイムスタンプ
            $loaded_timestamp=date("Y/m/d H:i:s",filemtime($temp_path));
        }else{
            $common_error='@'.$id.'/'.$temp_path;
        }
    }
?>