<?php

    //日本語を指定
    mb_language("Japanese");
    //UTF-8を指定
    mb_internal_encoding("UTF-8");

    //タイムスタンプ作成
    $time_stamp=date("Y/m/d H:i:s");

    //ヘッダー関連
    $pageicon='https://nykk.jp/sns/resources/icon_oldsoldier192.png';
    $ogppicture="https://nykk.jp/sns/resources/ogppicture640.png";
    $view_width=512;

    $common_error='';
    $func_error='';

    include './func_ut.php'; //ユーティリティ系の関数を読み込む
    include './func_user.php'; //ユーザー系の関数を読み込む
    include './func_web.php'; //ウェブ系の関数を読み込む

    //メインタイトル
    $main_title='自由研究SNS(仮)';

    //一般情報
    $info_datetime=date("YmdHis");
    //利用者情報
    $ip=$_SERVER['REMOTE_ADDR'];

    //ページ復帰用
    $scene_now=''; //現在のシーン
        //index
        //user
        //home
        //profile
        //theme
    $url_return=''; //復帰先URL

    //システム系path
    $url_top='https://nykk.jp/sns/';
    $url_index=$url_top.'index.php';
    $url_user=$url_top.'user.php';
    $url_home=$url_top.'home.php';
    $url_profile=$url_top.'profile.php';
    $url_theme=$url_top.'theme.php';
    $url_move=''; //ページ遷移用
    $url_ex[0]='';

    //現在のURL全体
    $url_full=$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
    $url_ex=explode('?',$url_full); //URLを?で分割

    //URLからuser指定またはExtraコマンドを取得
    $extra_command[0]='';
    $extra_profile_id='';
    $extra_log_number='';
    $extra_log_theme='';
    if($url_ex[1]<>''){ //option指定あり
        if(gettype(strpos($url_ex[1],'/'))==='integer'){
        //('/'を含む=Extraコマンド)
            $extra_command=explode('/',$url_ex[1]);
        }else{
        //('/'を含まない=Extraコマンドではない)
            if(gettype(strpos($url_ex[1],','))==='integer'){
            //(','を含む=発言指定あり)
                $temp_ex=explode(',',$url_ex[1]);
                $extra_profile_id=$temp_ex[0]; //id
                $extra_log_number=$temp_ex[1]; //発言番号
            }else{
            //(','を含まない)
                $extra_profile_id=$url_ex[1];
            }
        }
    }
    //管理情報
    $min_id=3; //ID最小文字数=3
    $max_id=15; //ID最大文字数=15
    $folder_u_pre='./u_pre/'; //認証前フォルダ 700
    $folder_u_reg='./u_reg/'; //認証後フォルダ 700
    $folder_u_dat='./u_dat/'; //保管フォルダ 700
    $folder_u_res='./u_res/'; //ユーザー画像保管フォルダ 755
    $folder_theme='./theme/'; //テーマ格納フォルダ 700

    //テーマ集
    $file_shelf=$folder_theme.'_shelf.txt'; //テーマ集path
    $theme_shelf=array(); //テーマ集配列

    //定数
    $last_preset_icon=3; //プリセットicon画像数
    $last_icon_frame=2; //枠最終番号 0=ましかく,1=カドまる,2=まんまる
    //password入力欄用の<input>追加設定
    $input_password_setting='pattern="^[0-9a-zA-Z]+$"';
    $input_password_setting=$input_password_setting.' style="-webkit-text-security:disc;"';

    //変数初期化：アカウント関連
    $login=0; //0=未ログイン,1=ログイン済み
    $account_id='';
    $form_password='';
    $form_token='';
    $saved_ip='';
    $saved_token='';
    $me_found=false; //true=アカウント(本登録データ)存在
    $me_password='';
    $me_mailto='';
    $me_nickname='';
    $me_icon_number=0;
    $me_icon_frame=0;
    $me_icon_path='';
    $me_about='';
    $me_followlist=array();
    $me_history=array();
    $me_history_count=0; //発言総数(削除しても減算されない)
    //関数からの読み込み結果
    $loaded_password='';
    $loaded_mailto='';
    $loaded_nickname=''; //プロフィール/ニックネーム
    $loaded_icon_number=0; //プロフィール/アイコン番号
    $loaded_icon_frame=''; //プロフィール/アイコン枠
    $loaded_icon_path=''; //プロフィール/アイコン画像path
    $loaded_about=''; //プロフィール/説明文
    $loaded_list=array(); //一時処理用
    $loaded_followlist=array(); //フォローリスト

    //発言関連
    $loaded_history=array(); //発言リスト
    $loaded_log=array(); //発言(先頭行：データ行/以下本文)
    $loaded_theme='';
    $loaded_message='';
    $loaded_timestamp='';

    $chat_theme='';
    $chat_message='';

    //規定テーマ
    $preset_theme[0]='近況報告';
    $preset_theme[1]='自己紹介';
    $preset_theme[2]='自由研究';

    //引数取得：コマンド
    if(isset($_POST['form_command'])) { 
        $form_command = $_POST['form_command'];
    }

    //引数取得：アカウント関連
    if(isset($_POST['account_id'])) {
        $form_aid = $_POST['account_id'];
        $account_id=$form_aid;
        //補正
        $account_id=trim(mb_convert_kana($account_id, 'as', 'UTF-8')); //半角化
        $account_id=preg_replace('/[^0-9a-zA-Z]/', '', $account_id); //英数字のみに
        $account_id=strtolower($account_id); //小文字化
    }
    if(isset($_POST['password'])) {
        $form_password = $_POST['password'];
    }
    if(isset($_POST['token'])) {
        $form_token = $_POST['token'];
    }
    if(isset($_POST['to'])) {
        $mailto = $_POST['to'];
    }

    //引数取得：ページ復帰用
    $return_id=''; //ログイン後に戻るprofile/user(id)
    if(isset($_GET['return_id'])) { //profileのTOPメニュー[ログイン]でURL指定
        $return_id = $_GET['return_id'];
    }
    if(isset($_POST['return_id'])) { //homeのログインフォームでhidden指定
        $return_id = $_POST['return_id'];
    }

    //cookie取得
    if(isset($_COOKIE['account_id'])) {
        $cookie_aid=$_COOKIE['account_id'];
    }
    if(isset($_COOKIE['token'])) {
        $cookie_token=$_COOKIE['token'];
    }
    if($account_id=='' and $cookie_aid<>''){ //ID補完(フォーム値優先)
        $account_id=$cookie_aid;
    }
    if($form_token=='' and $cookie_token<>''){ //Token補完(フォーム値優先)
        $form_token=$cookie_token;
    }

    //変数設定
    $auto_aid=$account_id; //自動入力するログインID(再入力省略用)

    //仮登録データのpath準備(user:step2+3,homeで必要)
    $pre_path=utUserPrePath($account_id);
    //本登録データのpath準備(user:step3,homeで必要)
    $reg_path=utUserRegPath($account_id);

    //変数設定：ユーザー系path
    $user_dat_folder=utUserDataFolder($account_id); //保管フォルダ
    $user_token_path=$user_dat_folder.'token.txt'; //トークン記憶
    $user_tempfile_path=utUserTempFilePath($account_id); //一時ファイルpath(アップロード用)
    $user_upicon_path=utUserUploadedIconPath($account_id); //アップロードアイコンpath

    //アカウント存在確認
    $me_found=utUserExists($account_id);

    //ログイン処理
    if($form_command=='login'){
        $go=true;
        //カウント存在
        if($me_found==false){
            $login_error='指定されたアカウント('.$account_id.')ではログインできません。';
            $go=false;
        }
        //ログイン時に入力されたパスワード
        $login_password=''; 
        if(isset($_POST['login_password'])) {
            $login_password = $_POST['login_password'];
        }
        if($login_password==''){
            $login_error='ログインに必要なパスワードが指定されていません。';
            $go=false;
        }else{
            //本登録データをロードしておく
            utUserRegLoad($account_id);
        }
        if($go==true){
            //password判定
            if($loaded_password==$login_password){
            //(一致)
                $login=1; //ログイン済み!
                //トークン作成
                $token='t'.rand(100000000000,999999999999);
                //トークン保存
                $fp = fopen($user_token_path, "w");
                fwrite($fp, $ip."\n");//1行目:ip
                fwrite($fp, $token."\n");//2行目:token
                fclose($fp);
            }else{
            //(不一致)
                $login_error='パスワードが一致しないためログインできません。';
                $go=false;
            }
        }
        if($login==1){
        //(成功時)
            //cookie更新
            $cookie_aid=$account_id;
            $cookie_token=$token;
            utCookieUpdate($cookie_aid,$cookie_token);
            //ページ復帰判定
            if($return_id<>''){
                //ページ遷移指定
                $url_move=$url_profile.'?'.$return_id; //profileへ戻る
            }
        }else{
        //(失敗時)
            //そのままhome表示判定へ進む(beforeに移行する)
        }
    }

    //cookie関連：ファイルからトークンの内容を読み込む
    if($form_token<>'' and $login==0){ //トークン指定あり+未ログイン
        if(file_exists($user_token_path)){
            utTokenGet($user_token_path);
            //比較
            if($form_token==$saved_token){
                $login=1; //ログイン済み!
                $token=$form_token;
            }else{
                $common_error='再ログインが必要です。';
            }
        }else{
            $common_error='再ログインが必要です。';
        }
    }

    //ログイン済みの付随処理
    if($login==1){
        //cookie更新
        $cookie_aid=$account_id;
        $cookie_token=$token;
        utCookieUpdate($cookie_aid,$cookie_token);
        //関連データをロード
        utUserRegLoad($account_id); //本登録データ
        $me_password=$loaded_password;
        $me_mailto=$loaded_mailto;
        //自身の保存情報を取得
        utUserProfileLoad($account_id); //プロフィール
        $me_nickname=$loaded_nickname;
        $me_icon_number=$loaded_icon_number;
        $me_icon_frame=$loaded_icon_frame;
        $me_icon_path=$loaded_icon_path;
        utUserAboutLoad($account_id); //about
        $me_about=$loaded_about;
        utUserFollowListLoad($account_id); //フォローリスト
        $me_followlist=$loaded_followlist;

        //個人発言録を取得
        utUserHistoryLoad($account_id);
        $me_history=$loaded_history;
        $me_history_count=utHistoryCount($me_history);
    }

    //chat処理
    if($login==1 and $form_command=='chat'){
        if(isset($_POST['chat_theme'])) {
            $chat_theme=utChatThemeRevision($_POST['chat_theme']); //補正つき
        }
        if(isset($_POST['chat_message'])) {
            $chat_message=utChatMessageRevision($_POST['chat_message']);
        }
        if($chat_theme<>'' or $chat_message<>''){ //テーマorメッセージ指定がある場合のみ
            //テーマ未指定の場合：「近況報告」に
            if($chat_theme==''){
                $chat_theme='近況報告';
            }

            //次の発言番号を取得
            $chat_number=$me_history_count+1; //=発言総数+1

            //全体：テーマファイルを更新
            utThemeOneUpdate($chat_theme,$account_id,$chat_number,$time_stamp,$chat_message);
            //個人：発言履歴を更新+セーブ
            utMeHistoryUpdate($account_id,$chat_theme,$chat_message,$chat_number,$time_stamp);
            //個人：発言を保存
            utUserChatMessageTextSave($account_id,$chat_theme,$chat_message,$chat_number);

            //ページ移動
            $url_move=$url_theme.'?t='.$chat_theme;
        }
    }

    //Extraコマンド処理
    if($login==1 and $extra_command[1]==$token){ //ログイン中かつトークン一致
        if($extra_command[2]=='follow_on'){
            $go=true;
            //対象アカウント取得(小文字化)
            $temp_target=strtolower($extra_command[3]);
            if(utUserExists($temp_target)==false){
            //(対象アカウントが存在しない)
                $go=false;
            }
            if($go==true){
                if(utFindListTarget($me_followlist,$temp_target)==false){
                //(未フォロー)
                    //フォローリストに追加
                    array_unshift($me_followlist,$temp_target);
                    //セーブ
                    utUserFollowListSave($account_id,$me_followlist);
                }
            }
            //ページ遷移指定
            $url_move=$url_profile.'?'.$temp_target; //profileへ戻る
        }
        if($extra_command[2]=='follow_off'){
            $go=true;
            //対象アカウント取得(小文字化)
            $temp_target=strtolower($extra_command[3]);
            if(utUserExists($temp_target)==false){
            //(対象アカウントが存在しない)
                $go=false;
            }
            if($go==true){
                if(utFindListTarget($me_followlist,$temp_target)==true){
                //(フォロー済み)
                    //フォローリストから削除
                    $i_line=0;
                    while($i_line<count($me_followlist)){
                        if($me_followlist[$i_line]==$temp_target){
                        //(発見)
                            $me_followlist[$i_line]='';
                            break;
                        }
                        $i_line=$i_line+1; //次の番号+1
                    }
                    //セーブ
                    utUserFollowListSave($account_id,$me_followlist);
                }
            }
            //ページ遷移指定
            $url_move=$url_profile.'?'.$temp_target; //profileへ戻る
        }
        if($extra_command[2]=='logout'){
            //cookie消去
            $cookie_aid='';
            $cookie_token='';
            utCookieUpdate($cookie_aid,$cookie_token);
            //ページ遷移指定
            $url_move=$url_home; //homeへ
        }
    }

    //ページ遷移実行
    if($url_move<>''){
        header('location: '.$url_move); //リダイレクト指定
        exit;
    }

    //親ページへ戻る

?>