<?php

    //変数初期設定
    $form_command='step1';
        //step1=作成開始
        //step2=本人確認
        //step3=認証

    $safe=true; //チェック初期化(有効判定)
    $short_error=''; //エラーの理由

    //サブタイトル
    $sub_title='ユーザーアカウント作成';

    //共通設定読み込み
    include './common.php';
    //復帰設定
    $scene_now='user';
    $url_return=$url_user;

?>
<?php //--------共通処理：ページ開始--------

    //style読み込み
    include './style.php';

    //head
    echo "<head>";
    $pagetitle=$main_title.'/'.$sub_title;
    $pageurl=$url_user;
    //基礎設定
    utHeadBasic($pagetitle,$pageicon,$view_width);
    //OGP設定
    utHeadOgp($main_title,$main_title,$pagetitle,$pageurl,$ogppicture);
    echo "</head>";
    //body冒頭
    echo '<body><div id="base">';

    //TOPメニュー
    utPrintTopMenu();
    //報告
    if($common_error<>''){
        utPrintError($common_error);
    }

?>

<!-- step1：アカウント作成開始 -->

<?php
if( $form_command=='step1' ){
    //ページ本文表示
    $step_title='手順① ユーザーアカウント作成開始';
    echo '<content>';
    echo '<title>'.$step_title.'</title>';
    echo '<p>ユーザーアカウントのIDと、関連付けるメールアドレスを指定してください。</p>';
    echo '<p>[決定]すると、指定のメールアドレスに仮パスワードが送られます。</p>';
    echo '</content>';
    //フォーム表示
    echo '<form action="./user.php" method="post">';
    echo '<input type="hidden" name="form_command" value="step2">';
    echo 'ID(半角英数字3～15文字)<br>';
    echo '<input type="text" name="account_id" size="30" placeholder="半角3～15文字の英数字でIDを記入"></p>';
    echo 'メールアドレス(半角英数字)<br>';
    echo '<input type="text" name="to" size="30" placeholder="半角英数字でメールアドレスを記入"></p>';
    echo '';
    echo '<input type="submit" name="send" value="決定">';
    echo '</form>';
}
?>

<!-- step2：本人確認(メール送信+パス入力) -->

<?php
if( $form_command=='step2' ){

    //ID文字数チェック
    if(strlen($account_id) < $min_id or strlen($account_id) > $max_id){
        $safe=false; //無効化
        $short_error='ID('.$account_id.')の文字数が不正です（最小'.$min_id.'～最大'.$max_id.'文字）。';
    }
    //ID重複チェック
    if(file_exists($pre_path)==true or file_exists($reg_path)==true){
    //(仮登録or本登録のファイルがある)
        $safe=false; //無効化
        $short_error='そのID('.$account_id.')は利用できません。';
    }

    if($safe==true){
        //password作成
        $new_pass=utPasswordMake();
        //送信準備
        $mailhead = "From: noreply@nykk.jp";
        $mailsubject=$main_title.'/'.$sub_title;
        $mailmsg='ユーザーアカウントの仮登録情報'."\n";
        $mailmsg=$mailmsg.'・ID: '.$account_id."\n";
        $mailmsg=$mailmsg.'・パスワード: '.$new_pass."\n";
        $mailmsg=$mailmsg."\n";
        $mailmsg=$mailmsg.$main_title.'のログインはこちらから'."\n";
        $mailmsg=$mailmsg.''.$url_home."\n";
        //送信実行
        if(mb_send_mail($mailto, $mailsubject, $mailmsg, $mailhead)){
        //(成功)
            //仮登録データをセーブ
            $fp = fopen($pre_path, "w");
            fwrite($fp, $new_pass."\n");//1行目:password
            fclose($fp);

            //報告
            $temp_msg='本人確認メールを送信しました。';
            utPrintSuccess($temp_msg);

            //ページ本文表示
            $step_title='手順② 本人確認';
            echo '<content>';
            echo '<title>'.$step_title.'</title>';
            echo '<p>本人確認メールの内容をご確認ください。</p>';
            echo '<p>・宛先: '.$mailto.'</p>';
            echo '<p>・件名: '.$mailsubject.'</p>';
            echo '<p></p>';
            echo '<p>指定メールアドレスに送られたパスワードを以下に記入してください。</p>';
            echo '<p>[決定]すると認証処理へ進み、ユーザーアカウント作成が終わります。</p>';
            echo '</content>';
            //フォーム表示
            echo '<form action="./user.php" method="post">';
            echo '<input type="hidden" name="form_command" value="step3">';
            echo '<input type="hidden" name="account_id" value="'.$account_id.'">';
            echo '<input type="hidden" name="to" value="'.$mailto.'">';
            echo '<title>ID</title>';
            echo '<p>'.$account_id.'</p>';
            echo '<title>パスワード</title>';
            echo '<p><input type="text" name="password" size="30" placeholder="ここにパスワードを記入"></p>';
            echo '<p></p>';
            echo '<p><input type="submit" name="send" value="決定"></p>';
            echo '</form>';
        }else{
        //(失敗)
            $safe=false;
            $short_error='メール送信に失敗しました。';
        }
    }

    if($short_error<>''){ //エラー報告
        utPrintError($short_error);
    }

    if($safe==false){
        //ページ本文表示
        echo '<content>';
        $step_title='手順② ユーザーアカウント作成に失敗...';
        echo '<title>'.$step_title.'</title>';
        echo '<p>はじめからやり直してください。</p>';
        utPrintSystemBar($main_title.'/'.$sub_title,'',$url_user);
        echo '</content>';
    }
}
?>

<!-- step3：認証 -->

<?php
if( $form_command=='step3' ){

    //仮登録データ存在チェック
    if(file_exists($pre_path)==false){
        $safe=false;
        $short_error='仮登録されていません。';
    }
    //ID重複チェック
    if(file_exists($reg_path)==true){
        $safe=false;
        $short_error='このID('.$account_id.')は利用できません。';
    }

    //仮登録データをロード
    if($safe==true){
        //ロード
        $info_lines=0;
        $fp = fopen($pre_path, "r");
        while ($line = fgets($fp)) {
            $info_lines=$info_lines+1;
            if($info_lines==1){$pre_password=trim($line);}
        }
        fclose($fp);
        //password判定
        if($pre_password<>$form_password){
            $safe=false;
            $short_error='パスワードが一致しません。';
        }
    }

    if($safe==true){
        //仮登録削除
        unlink($pre_path);
        //本登録データをセーブ
        utUserRegSave($account_id,$form_password,$mailto);
        //保管フォルダ作成
        mkdir($user_dat_folder,0700);

        //報告
        $temp_msg='パスワードの一致を確認し、ユーザーアカウントの作成が完了しました！';
        utPrintSuccess($temp_msg);

        //ページ本文表示
        $step_title='手順③ ユーザーアカウント作成の完了';
        echo '<content>';
        echo '<title>'.$step_title.'</title>';
        echo '<p>ID: '.$account_id.'</p>';
        echo '<p>※ホームからログインしてください。</p>';
        utPrintSystemBar($main_title.'/ホーム','',$url_home);
        echo '</content>';
    }

    if($short_error<>''){ //エラー報告
        utPrintError($short_error);
    }

    if($safe==false){
        //仮登録削除
        unlink($pre_path);
        //ページ本文表示
        $step_title='手順③ ユーザーアカウント作成に失敗...';
        echo '<content>';
        echo '<title>'.$step_title.'</title>';
        echo '<p>はじめからやり直してください。</p>';
        utPrintSystemBar($main_title.'/'.$sub_title,'',$url_user);
        echo '</content>';
    }
}
?>

<!-- 共通処理：締め -->
<?php

    //デバッグ情報出力
    utPrintDebugInfo();
    //BOTTOMメニュー
    utPrintBottomMenu();

    echo '</div></body>';

?>