# Xonotic

Xonotic was a [free as in freedom](free_software.md) fast multiplayer arena [first-person-shooter](fps_game.md) [game](game.md) similar to e.g. [Quake](quake.md). It ran on [GNU](gnu.md)/[Linux](linux.md), [Winshit](windows.md), [BSD](bsd.md) and other systems. It was one of the best libre games, i.e. games completely free by both code and data/content. It was available under [GPLv3](gpl.md). Its gameplay, graphics and customizability were pretty great, it may well have been the best in the AFPS genre, even compared to AAA [proprietary](proprietary.md) games -- this kind of quality is very rare among libre/noncommercial games.

UPDATE: **Xonotic as a game died in summer 2023** when the retarded developers couldn't get an erection without CONSOOMING NEW CONTINT and started just blindly pushing bugs and balance breaking changes without listening to player complaints at all (and actually banning many for voicing criticism, including [drummyfish](drummyfish.md)), demonstrating [update culture](update_culture.md) at its worst. The main server became a meme overnight, all [fun](fun.md) (such as friendly push) was removed from the game to create a "safe space" for players, possibly to get the game ready for Steam sales or make it more open to noobs and advertisers. RIP. If you can [fork](fork.md) Xonotic and restore it to its previous glory, please do so.

{ LOL the main server now banned me for voicing criticism of these updates xD RIP, I guess that's it for me. It was a nice journey. ~drummyfish }

{ I used to play Xonotic for years, it was really an excellent game. I've met many nice people there as the players are often programmers and people looking for [FOSS](foss.md). The gameplay was quite addictive and relaxing and you could have a great chat during the game. Of course it's kind of bloated but Xonotic was in a way a masterpiece. ~drummyfish }

The game builds on old ideas and mechanics but adds new weapons, mechanics, ideas and modes -- apart from the traditional [deathmatch](deathmatch.md), team deathmatch, capture the flag, complete the stage (defrag, racing without shooting) and competitive mode (duel), there are a number of new [fun](fun.md) modes such as clan arena (team round-based mode without self-damage and items), freeze tag, key hunt, last man standing and even Nexball -- [football](football.md) in Xonotic!

Xonotic was forked from a game called [Nexuiz](nexuiz.md) after a [trademark](trademark.md) controversy (basically in 2010 the guy who started the project and abandoned it later, an ass called Lee Vermeulen, came back and secretly sold the trademark to some shit company named Illfonic). Nexuiz itself was created on top of liberated Quake 1 engine, so Xonotic still bears a lot Quake's legacy, however it masterfully expands on its core principles and makes the gameplay even better. For example rockets shot by rocket launcher can be guided with mouse while holding down the left button which adds a new skill element. New types of weapons were added to the classic AFPS weapons (e.g. the infamous electro, a [meme](meme.md) spamming weapon used by noobs for its forgiveness of lack of skill). Movement physics was also modified to give better air control and faster movement as a result.

Fun fact: Xonotic even briefly appeared on a TV show: https://yewtu.be/search/watch?v=a0TFejn95Sw.

The game's modified [Quake](quake.md) 1 (YES, 1) engine is called [Darkplaces](darkplaces.md). It can be highly customized and modded. Just like in other Quake engine games, there are many console commands (e.g. *cvars*) to alter almost anything about the game. Advanced programming can be done using [QuakeC](quakec.md). Maps can be created e.g. with [netradiant](netradiant.md).

Though compared to any mainstream [modern](modern.md) games Xonotic is quite nicely written (e.g. runs very fast, doesn't have billions of [dependencies](dependency.md) and despite not being 1.0 yet has fewer bugs than today's AAA games at release), from a more strict point of view it's still very bloated and it's known to contain some shitcode -- for example the engine has frame dependent physics (TODO: cite a specific line in code), uses [floating point](float.md) to represent time, great part of the game is written in a joke language called [QuakeC](quake_c.md), its net code is worse than e.g. that of OpenArena and some people complain about input lag and other bugs. It could definitely be written MUCH better, but as already mentioned it's still a million times better than any new game.

{ The game runs extremely smooth for me even on old PC, I have no input lag. When my Internet connection gets bad I am sometimes unable to play Xonotic but still able to play OpenArena, which says something about the net code, but that happens very rarely. Also on pretty rare occasions I notice bugs such as imperfect culling of players or even projectiles just hanging mid air during whole game (which happens after heavy packet loss) etc., but nothing that would really be so frequent as to bother me. ~drummyfish }

Xonotic is similar to other libre AFPS games such as [OpenArena](openarena.md) and [Red Eclipse](red_eclipse.md). Of these Xonotic clearly looks the most professional, it has the best "graphics" in the [modern](modern.md) sense but still offers the option to turn all the fanciness off. OpenArena, based on Quake 3 engine, is simpler, both technologically and in gameplay, and its movement is slower and with different physics. While OpenArena just basically clones Quake 3, Xonotic is more of an actually new and original game with new ideas and style. Similar thing could be said about Red Eclipse, however it's not as polished and shows some infection with [SJW](sjw.md) poison.

{ OpenArena is great too. ~drummyfish }

As of 2022 the game has a small but pretty active community of regular players, centered mostly in [Europe](europe.md), though there is some [US](usa.md) scene too. There are regulars playing every day, pros, noobs, famous spammers, campers and [trolls](troll.md). Nice conversations can be had during games. There are [memes](meme.md) and inside jokes. The community is pretty neat. Xonotic also has a very dedicated [defrag](defrag.md) ("racing with no shooting") community. There have also been a few small tournament with real cash prizes in Xonotic.

The [GOAT](goat.md) of Xonotic is probably *Dodger*, his skill was just too high even above other pros. The worst player in Xonotic and probably also the biggest idiot on the planet is a player named *111*.

Great news is the development and main servers have so far not been infected by the [SJW poison](tranny_software.md) and (as of 2023) **allow a great amount of [free speech](free_speech.md)** -- another rarity. Even the game itself contains speech that SJWs would consider "offensive", there are e.g. voice lines calling other players "pussies" and "retards". This is great.

## Tips'N'Tricks

Here are some [pro](pro.md) tips to git gud, impress your frens and generally have more [fun](fun.md).

- Read the legendary **beginner guide** at https://xonotic.org/guide/.
- Point'n'click enemies to win.
- **Do NOT fucking spam electro** -- this will make you instantly hated, and rightfully so. Not only is it lame, annoying, makes you easy to kill (opponent can explode your electro balls), enforces more use of electro (electro is countered with electro) and makes the game lag, it can also hurt your teammates, even in no self/team damage modes (as opponents may explode the electro you spray around). Use it appropriately.
- **Learn the weapons and make binds for each one**: learn what every weapons does (good mode for this might be clan arena in which you have all the weapons from the start), bind each one around the movement keys -- it's essential you can switch weapons quickly as the game is designed to reward comboing (the most basic combo is devastator/vortex/mortar). **You HAVE TO combo** to deal good damage. Also note that almost every weapon has a **secondary fire**, for example crylink's primary fire just shoots bouncing balls while the secondary fire shoots a suction ball that can toss enemies out of the map or can be used to accelerate yourself. With devastator (rocket launcher) holding left mouse button allows **guiding the rocket**, right mouse button explodes the rocket in air -- learn this! Then you can easily kill enemies behind corners or flying in air.
- **Learn the movement**: movement is essential in Xonotic, firstly you should learn extremely basic techniques like bunnyhopping, strafe jumping and in-air controls, and secondly you should learn using weapons for movement (blaster jumps, rocket jumps, crylinkg for acceleration and climbing walls, ...). This is important not only for quick relocation, taking shortcuts, dodging enemy fire and quickly running away from enemies, it also saves you from countless deaths by falling into pits.
- **Console**: console is extremely useful in Xonotic; not only can it modify almost any aspect of the game, it also allows you to create fun macros (some people even create what could be considered [cheats](cheating.md) only with the console commands). A very important command is `search x` which will search for other commands and cvars, e.g. if you want to mess with resolution, do `search resolution` etc. There is even a small **stack-based minilanguage** in the console that's invoked with the `rpn` command -- this allows for very advanced stuff. Sadly this isn't well documented, but the thread at https://forums.xonotic.org/showthread.php?tid=2987 provides some basics.
- **Make cool binds**, for example you should modify the standard team messages to something more funny. One of the most basic binds is **taunt** so that you can insult players (e.g. `bind KP_SLASH "cmd voice taunt"`).
- **Lower your mouse sensitivity**, this is really crucial to git gud, it's almost impossible to be good with high sens. Lower sensitivity increases your accuracy greatly, which is just key, it's almost like an instant [cheat](cheating.md); of course you'll need a bit bigger mouse pad. Write down what sensitivity you have as **centimeters per 360 turn** (measure this carefully with a ruler), this will help you achieve exact same sensitivity when you buy a different mouse. Something like 22 cm per 360 turn is probably good. It is good to set your sensitivity as early as possible so you don't have to later relearn you muscle memory.
- **Make basic graphics settings**, for example increase FOV (field of view) to at least 100, disable effects such as zoom animation (so that you can zoom quickly) etc. If you want to play seriously you should also **turn off music** so that you can hear enemies better. You can also downgrade the graphics so as to make it basically look like Quake 1, either for a cool retro look or to play the game on a [potato](potato.md).
- **Don't fall for the F11 [troll](troll.md)** -- when you ask how to do something and people respond with "press F11", don't do it, you'll humiliate yourself. { Faggot devs disabled it now I think. RIP fun. ~drummyfish }
- **Enable cheats with F11**.
- **Spin to win**: you can make a cool spinning macro that makes you look like you have a seizure: e.g. `bind b "toggle vid_stick_mouse; rpn /m_pitch 1 ${vid_stick_mouse} - 0.022 * =;"`.
- Once you have a comfy config, you can remove the write rights to it (`chmod -w ~/.xonotic/data/config.cfg`). This way the game won't be able to modify the config and all settings and experiments you make in the game will only be temporary, until the game restart, so you can't fuck up your settings.
- **Do NOT camp**, it's retarded and wastes other people's time, especially e.g. in clan arena where dead people have to wait for the end of round. Better lose quickly than win or draw by camping.
- **Explosions (and bullets) go through thin walls** by default, so you can e.g. kill someone hiding in the room above you by shooting the ceiling. Very cool.
- **Don't stand at teleport exits**, so as to not get telefragged.
- A quick way to tell how good someone is is the damage deal to damage taken ratio -- once you deal more damage than take, you seize to be a complete noob. When you deal twice as much damage as you take, you are probably reaching a pro level. Of course, this also depends on opponents, mode you play etc., take this just as a quick estimate.
- If you're not doing well, complain about [lag](lag.md).
- **You can turn off the chat** in case there is some retarded conversation going on (just go to setting and HUD editor). New versions also support client side ignore of specific players.
- In addition to chat you can also turn off opponent names if you just want to play without any distraction. Try e.g. `hud_panel_chat 0; hud_panel_centerprint 0; 
hud_shownames 0; hud_panel_scoreboard_maxheight 0.01; hud_panel_notify 
0; hud_panel_scoreboard_namesize 1; hud_panel_score 0; con_chatsound 0; 
hud_panel_infomessages 0;`
- **Slap opponents to humiliate them**: the shotgun secondary fire is a melee slap, which is the best way to kill someone, partly because it's pretty hard to do (there's a delay before the bash). Another humiliating way to eliminate opponents is to kill them with Hagar secondary or push them off the map with blaster, crylink or even Mario kill (very rare -- you jump on someone's head while he's jumping over a pit which makes him fall down). Don't forget to taunt and [teabag](teabag.md).
- If you see someone running fast while crouching in air, he's probably a [pro](pro.md).
- **For more frags listen to sounds enemies make** -- if a player is low on health, he makes a distinct sound when hurt. You should listen to these sounds and just quickly hit these players e.g. with machine gun to get an easy kill.
- **For more frags watch for falling players** -- on space maps watch our for players falling off the map and just quickly hit them with machine gun (secondary fire) before they die, the game will give frag to whoever hit him last.
- `v_psycho 1`, `r_trippy 1` etc.
- **Slow down enemies with crylink secondary**: crylink secondary fire shoots a projectile that "sucks in" anyone in near proximity to the hit -- besides exploiting this for accelerating yourself you can also use it to slow down enemies that try to run away from a fight or who just try to move quickly to avoid being hit. This is extremely annoying to the affected player, so do it as often as you can.
- `cl_handicap` can be used to make yourself weaker by specified multiplier (take more and deal less damage), either to balance the game or provide a challenge.
- `v_flipped 1` flips the rendering so that you see the mirror version of the map, it basically gives you a new map for free and provides a nice challenge. 
- `in_pitch_min` and `in_pitch_max` can remove the limit of looking up and down (set to e.g. -1000 and 1000) -- this way you can turn completely upside down which can be seen by spectators and make them think you're a cheater.
- Typing `/me` in chat makes the chat message be output in a different format; instead of `username: message` it writes `*message` and replaces the `/me` string with your username -- this can create cool and fancy messages.
- Piss people off with **troll votes**: study the `vcall` console command (see `vhelp`), it allows for calling votes on specific things like switching maps, kicking players etc. Some votes allow a parameter string so that you can make a funny message with it, e.g. `vcall bots play better than player X`. Due to weird code numbers can be specified with almost arbitrary number of leading zeros, so you can just call a vote to set fraglimit to 1 with 100 leading zeros to spam people's screen and confuse them. Where enabled, `vcall grunt` will try to turn on grunt sound that many players hate. If you want to leave, a fancy way to do it is to call a vote to kick yourself.
- The game outputs chat into terminal, you can filter these messages out and redirect them to [espeak](espeak.md) for a fun experience :)
- **Electro spammers are easy to kill**: when someone is raping electro and just spraying everything, simply shoot at him with electro primary fire -- this explodes the balls he's spamming and hits him AND his teammates with huge damage. Don't forget to teabag and taunt him once he's dead.
- Standing in front of a nub with Hagar is dangerous.
- Switch left and right hand for a challenge.
- Play drunk and/or high for a challenge.
- Change your name to some unicode monstrosity like ^6.̸̡͋̽̍̎͗̊͛̋̂̃̌͗͘^5.̸̨̧̯̙̞̟͙̖̞͈̬͙̞̖͎͉̽̿̇̔̂̎͗͌͆́̕͝͠͝͝ͅ^1.̷͕́͛̈́. { [RIP](rip.md) if your reader can't [Unicode](unicode.md) well :) ~drummyfish }
- [Doom](doom.md) challenge: disable looking up and down with console.
- If you're slow, [strafe](strafe_jumping.md) harder.
- Move to [Europe](europe.md) to actually enjoy the game with good ping.
- { My config is at https://codeberg.org/drummyfish/my_text_data/src/branch/master/configs/xonotic_config.cfg. ~drummyfish }
- Buy premium account for extra skins and [lootboxes](lootbox.md). Just kidding :)
- Don't [ragequit](ragequit.md), you'll give your opponent the ultimate satisfaction. Making someone ragequit is better than just [raping](rape.md) him.
- Bully players that admit to be playing on [Window$](windows.md).
- There are [minigames](minigame.md) in the game menu, can serve to kill time while waiting to respawn in some modes.
- If you want to win in a team game and your team is losing, just quickly switch to the winning team before the end. Gotta keep them xonstats high.
- Sound is important, firstly you can hear where enemies are (especially when you turn off music) and secondly you can also spot low HP players by sound (they make a specific hurt sound when low HP).
- Just spec good players and do what they do.
- All americans in the game are cheaters without exception, just like in [real life](irl.md). You spot americans by ping and high score despite playing like pre beginners when you spectate them, and by crying like babies when you criticize [capitalism](capitalism.md) and tech consumerism.
- some **tactics/strategy/habits**:
  - **Chasing low health players is usually a bad idea** and a mistake made by nubs: such player, if he's not a complete newbie, can just spam electro/nades behind himself and easily kill you.
  - **Unpredictable movement and positioning is key** to avoiding damage: nubs think that when they move fast they won't get hit -- this is only partially true, it is about just as important to move unpredictably and avoid spots that get regularly spammed by enemies. When you move from point A to B on a map and the enemy sees you doing so, you should take a randomly long short pause in doing so, or maybe even switch direction completely, otherwise he can quite accurately predict when and where you'll appear at the destination and kill you with prefire. It's a great advantage if your opponent doesn't know where you are. One sneaky tactical move is "the return" when you pretend you run away from somewhere, then wait 3 seconds and return back (the opponent expects you to run anywhere but to where you ran away from).
  - When in fight, **don't be an easy target and don't stand near a wall** (this makes you be easily hit with splash damage). Don't stand in a corner. Try to always have a quick escape path.
  - **Stay together with your teammates** (if you want to win). Fighting alone against multiple enemies is usually just a quick death without dealing much damage, even if you're very good and they're mediocre. Especially if you're a nub playing clan arena, stay with your team or else you'll die in 3 seconds and will have to wait until the end of the round.
  - **Higher ground is usually good**.
  - When microcamping (camping for a short time with vortex somewhere), the only direction you can be hit from should be the one you're looking in. Nubs sometimes camp in a spot that can be seen from multiple directions -- that's just asking to be fragged.
  - **Use machine gun (MG) secondary to finish off low HP enemies**: MG is [hitscan](hitscan.md), i.e. it hits instantly on a distance and its easier to hit with than vortex (which fires just one strong shot) -- the secondary fire has no bullet spread unlike the primary fire, so it's ideal to just deal quick small hit that's enough to finish someone. But watch out, some people bitch about using MG this way being too nub, going for slap will entertain the audience better.
  - **Take items**, many new players just walk by mega health without taking it, that's pretty stupid.
  - It's sometimes good in a fight to be directly above or under the opponent as it's harder for him to aim precisely looking completely up or down, and with many weapons it's generally harder to just hit someone in air, especially for noobs. Noobs mostly don't even see you if you're above their heads (they have FOV set to low), it's basically free damage.

## See Also

- [OpenArena](openarena.md)