# Semiconductor

{ For a physicist and electronics guys there's probably quite a lot of simplification, this is written from the limited point of view of a programmer. ~drummyfish }

Semiconductors are materials with electric conductivity between insulators and conductors, their conductivity may vary greatly with conditions such as temperature, illumination, their purity or applied voltage; semiconductor elements, especially [silicon](silicon.md) (Si), are an essential part for building electronic circuits and [computers](computer.md), but also many other things such as [solar panels](solar_panel.md). In their properties semiconductors are unlike insulators who generally don't conduct electricity very well (have a great [resistivity](resistivity.md)) and conductors who do. Besides silicon there are also other semiconductor elements like germanium, selenium or compound ones (composed of multiple elements).

Semiconductors are important for computers because they help implement the [binary](binary.md) [logic circuits](logic_circuit.md), they can behave like a switch that is either on (1) or off (0). Besides that they can serve e.g. for making measurements (a component whose resistivity depends on its illumination can be used to measure amount of light by measuring the resistivity). Especially important electronic components based on semiconductors are the **[diode](diode.md)** (lets current flow only one way)  and **[transistor](transistor.md)** (a purely electrical "switch" that can be made extremely tiny).

Semiconductor elements are those with some special properties related to their atomic structure -- in atoms there are so called *orbitals*, certain discrete "levels" at which electrons "orbit" around the nucleus (distribution of electrons in these orbitals is given by what kind of atom it is, i.e. how many electrons there are in total) and when atoms are together (in a solid), these orbitals create kind of energy [bands](band.md) that electrons can occupy. The outermost energy band that has electrons is called the *valence band*, the band immediately above it (which is normally empty) is called the *conduction band*. Conductor elements are those that don't have the valence band completely filled, so that there is space for electrons to move around and conduct electricity. Insulators on the other hand have the valence band completely filled up, so those electrons can't move easily -- they don't conduct electricity well. Similarly semiconductors in their normal state have the valence band filled, but unlike with insulators the gap between the valence band and conduction band is quite small, so electrons can relatively easily jump from valence band to conduction band and move to conduct electricity -- still semiconductors don't conduct too well at room temperature (they conduct better at higher temperatures, unlike metals), but the small energy gap between the upper bands allows us to increase their conductivity by so called **doping** -- introducing small impurities of other elements. Of course increasing their conductivity in itself wouldn't achieve much as we still have materials that conduct well by themselves (the conductor elements), but as we'll see, doping leads to creating two possible types of semiconductors that when combined give rise to some extremely useful things. The two types of semiconductors are:

- **N type**: By adding e.g. an arsenic atom to a grid of silicon atoms we get an extra free electron because arsenic has 5 outer electrons while silicon has 4. Arsenic binds its 4 electrons with neighboring silicon atoms (with so called covalent bond, sharing pairs of electrons), but will have one unbound electron, which thanks to not being bound can move easily and help conduct electricity (note that when the electron does move away, arsenic will still want to get another electron because it will become positive charged, but the fifth electron is simply always more "loose" thanks to not being bound). In this type of semiconductor we have negative particles, the **electrons**, moving around.
- **P type**: By similarly adding e.g. an boron atom to a silicon grid, we get a similar situation; boron only has 3 outer electrons, so it will only bind to 3 silicon atoms, leaving one the bond with one silicon incomplete, forming a **hole**. This hole can be seen as a [virtual](virtual.md) positively charged particle, it is simply a lack of electron. An electron can temporarily jump in this hole but will want to move away as boron doesn't want it there. In this type of semiconductor we can imagine the holes moving around (even though physically only electrons are moving, of course).

If we connect a P and N type semiconductors, we get so called **PN junction** which only conducts current one way and is used in [diodes](diode.md) and [transistors](transistor.md). After putting P and N materials together, at the boundary some electrons from the N type material fill the holes in the P type material which creates a small *depletion region* of certain width. This region is an electric field that's negative on the P side and positive on the N side (because negative electrons have moved from N to P). If we connect the PN junction to a voltage source, with P side to the positive and N side to the negative terminal, we create an opposite electric field which will eliminate the depletion region and allow the flow of current. Connecting the sides the other way around will result in increasing the width of the depletion region and blocking the current flow.