# Richard Stallman

{ RMS is a legend and overall a great human, but let's be reminded we shouldn't be creating any [heroes](hero_culture.md) or celebrities. ~drummyfish }

The great doctor Richard Matthew Stallman (RMS, also [GNU](gnu.md)/Stallman, chief GNUisance and saint IGNUcius, born 1953 in New York) is one of the biggest figures in software [history](history.md), inventor of [free (as in freedom) software](free_software.md), its lifelong advocate, founder of the [GNU project](gnu.md), [Free Software Foundation](fsf.md), a great [hacker](hacking.md) and the author of a famous text editor [Emacs](emacs.md) besides others. He is a non-religious [Jew](jew.md) and an [atheist](atheism.md) (though he is the highest saint of [Church Of Emacs](church_of_emacs.md)), a man who firmly stands behind his beliefs, who always acts in conformance with them and who's been advocating for [ethics](ethics.md) and user freedom in the computing world. He has also been called the *king of software [cloning](clone.md)*, for he started the wave of making free, ethical clones of [proprietary](proprietary.md) programs. Stallman doesn't wear a [suit](suit.md), he never shaves and doesn't use a cellphone, he talks even if what he says is unpopular -- if he didn't make history, these things alone would make him one of the most based men of our time. However, on a completely serious note, let's not make gods out of people -- Richard Stallman also does some very retarded things, for example he plays along with the [fight culture](fight_culture.md) and started conforming to the [SJW](sjw.md) newspeak, thumbs down on that.

```
   _..._
  /   \ \
 (= =  )))
 (.-._ ) ))
 /    \\  \
 ".,,,;,''' 
```

*[ASCII art](ascii_art.md) of Richard Stallman*

Stallman's life along with free software's history is documented by a free-licensed book named *Free as in Freedom: Richard Stallman's Crusade for Free Software* on which he collaborated. You can get it gratis e.g. at [Project Gutenberg](https://www.gutenberg.org/ebooks/5768). You should read this!

Richard Stallman is also famous for having foreseen and foretold virtually all the atrocities that [corporations](corporation.md) would do with computer technology, such as all the spying through cell phones, trade of personal data and abusing secrecy and "[intellectual ownership](intellectual_property.md)" of source code for bullying others, though to be honest it doesn't take a genius to foresee that corporations will want to rape people as much as possible, it's more of a surprise he was one of very few who did. The important thing is he acted immediately he spotted this -- though corporations indeed did go on to rape people anyway, Richard Stallman made some very important steps early on to make the impact much less catastrophic nowadays. We should be all grateful.

It seems that **Stallman had at least one girlfriend**; in the 1999 book called *Open Sources* he says that he originally wanted to name the [HURD](hurd.md) kernel Alix after a [girl](woman.md) that was at the time his "sweetheart".

[tl;dr](tldr.md): At 27 as an employee at [MIT](mit.md) [AI](ai.md) labs Stallman had a bad experience when trying to fix a Xerox printer who's [proprietary](proprietary.md) software source code was made inaccessible; he also started spotting the betrayal of hacker principles by others who decided to write proprietary software -- he realized proprietary software was inherently wrong as it prevented studying, improvement and sharing of software and enable abuse of users. From 1982 he was involved in a "fight" against the Symbolics company that pushed aggressive proprietary software; he was rewriting their software from scratch to allow Lisp Machine users more freedom -- here he proved his superior programming skills as he was keeping up with the whole team of Symbolics programmers. By 1983 his frustration reached its peak and he announced his [GNU](gnu.md) project on the [Usenet](usenet.md) -- this was a project to create a completely [free as in freedom](free_software.md) [operating system](os.md), an alternative to the proprietary [Unix](unix.md) system that would offer its users freedom to use, study, modify and share the whole software, in the hacker spirit. He followed by publishing a manifesto and establishing the [Free Software Foundation](fsf.md). GNU and FSF popularized and standardized the term [free (as in freedom) software](free_software.md), [copyleft](copyleft.md) and free licensing, mainly with the [GPL](gpl.md) license. In the 90s GNU adopted the [Linux](linux.md) operating system kernel and released a complete version of the GNU operating system -- these are nowadays known mostly as "Linux" [distros](distro.md). As a head of FSF and GNU Stallman more or less stopped programming and started traveling around the world to give talks about free software and has earned his status of one of the most important people in software history.

Regarding [software](software.md) Stallman has for his whole life strongly and tirelessly promoted free software and [copyleft](copyleft.md) and has himself only used free software; he has always practiced what he preached and led the best example of how to live without [proprietary](proprietary.md) software. This in itself is extremely amazing and rare, regardless of whether he ever slipped (which we aren't aware of) or to what degree we agree with his ideas; his moral strength and integrity is really what makes him special among basically all other great people of recent centuries, it's really as if he comes from a different time when people TRULY internally believed something so much they would die for it, that they wouldn't sell even a small part of that belief for any kind of personal benefit; this is something that really puts him alongside the greatest philosophers such as [Plato](plato.md) or [Socrates](socrates.md) (who followed his own principles so much that he voluntarily died for them).

Fun fact: there is a [package](package.md) called *[vrms](vrms.md)*, for virtual RMS, that checks whether you have any non-free packages installed. Ironically it seems to not even tolerate non-free documentation under [GFDL](gfdl.md) with invariant sections, which is very correct but probably not something Stallman himself would do since GFDL is basically his own invention :)

This said, we naturally also have to state we don't nearly agree with all he says. For example he isn't too concerned about [bloat](bloat.md) (judging by the GNU software and his own creation, [Emacs](emacs.md)) and he also doesn't care that much about [free culture](free_culture.md) (some of his written works prohibit modification, see [GFDL](gfdl.md)'s "invariant seciotns", and his GNU project allows proprietary non-functional data as long as they are not "software"). Sadly he has also shown signs of being a [type A fail](fail_ab.md) personality by writing about some kind of [newspeak](newspeak.md) "*gender neutral language*" and by seeming to be caught in a [fight culture](fight_culture.md). On his website he also has an [American](usa.md) flag and claims to be a patriot, i.e. leaning to nationalism and therefore [fascism](fascism.md). Nevertheless he definitely can't be accused of populism or hypocrisy as he basically tells what he considers to be the truth no matter what, and he is very consistent in this. Some of his unpopular opinions (mostly those opposing [pedophile](pedophilia.md) witch hunt, with which we DO agree) brought him a lot of trouble and an endless wrath of [SJW](sjw.md)s. For this **he was [cancelled](cancel_culture.md)** and in 2019 was forced to resigned from the position of president of the FSF but continues to support it.

He is a weird guy, having been recorded on video eating dirt from his feet before giving a lecture besides others -- another time he was even recorded raging on stage after being stressed out but that's actually odd -- he practically always keeps a calm, monotone, very rational speech (much different from any politician or revolutionary). In the book *Free as in Freedom* he admits he might be slightly [autistic](autism.md). Nevertheless he's extremely smart, has magna [cum](cum.md) laude degree in [physics](physics.md) from Harvard, 10+ honorary doctorates, fluently speaks English, Spanish, French and a little bit of Indonesian and has many times proven his superior programming skills (even though he later stopped programming to fully work on promoting the FSF). He is really good at public speaking, and that despite the mentioned calmness of his speech -- here possibly his inner autism shines because he just speaks in very simple but cold rational and logical ways that everyone from an expert to a complete layman understands, he rarely stops to say something like "ummm... wait", he's just letting out carefully crafted sentences as if you were reading them from a book, showing ways from facts to logical conclusions without cheap rhetoric tricks like wild gesticulation, rising voice or using buzzwords and strong terms. His interviews are however often awkward for the same reasons: it's usually the interviewer asking a question and then waiting 15 minutes for Stallman to print out the whole answer without giving a chance to be interrupted.

Stallman has a beautifully [minimalist](minimalism.md) website at http://www.stallman.org where he actively comments on current news and issues. He also made the famous free software song (well, only the lyrics, the melody is taken from a Bulgarian folk song Sadi Moma) -- he often performs it in public himself (he is pretty good at keeping the weird rhythm of the song while at the same time also singing, that's impressive).

Stallman has been critical of [capitalism](capitalism.md) though he probably isn't a hardcore anticapitalist (he's an [American](usa.md) after all). [Wikidata](wikidate.md) states he's a proponent of [alter-globalization](alter_globalization.md) (not completely against globalization in certain areas but not supporting the current form of it).

In the book *Free As In Freedom* it is also mentioned that **Stallman had aversion to passwords and secrecy in general** -- at MIT he used the username RMS with the same password so that other people could easily log in through his account and access [ARPANET](arpanet.md) (the predecessor of [Internet](internet.md)). Indeed, we applaud this, the "[security](security.md)" hysteria is killing the computing world.

As [anarchists](anarchism.md) we of course despise the idea of worshiping people, creating [heroes](hero_culture.md) and cults of personalities, but the enormous [historical](history.md) significance of Stallman has to be stressed as a plain and simple fact and though we may disagree with some of his methods and even opinions, it's as clear as it can be that he acted [selflessly](selflessness.md), in favor of all people -- something that can be said about very few, if anyone at all. Most other old time hackers, such as [Eric S. Ramyond](esr.md) and [Rob Pike](rob_pike.md) immediately abandoned all ideals of ethics and jumped the capitalist train with the first sight of money, Stallman stayed opposed to it, and for this he has our uttermost respect. Even though in our days his name is overshadowed in the mainstream by rich businessman and creators of commercially successful technology and even though we ourselves disagree with Stallman on some points, in the future [history](history.md) may well see Stallman as perhaps the greatest man of the software era, and rightfully so. Stallman isn't a mere creator of a commercially successful software product or a successful politician, he is an extremely morally strong philosopher, a great example to others, a prophet, someone who sees the truth and shows it to people -- he brilliantly foresaw the course of history and quickly defined ethics needed for the new era of mass available programmable computers at the right time, before the hammer hit. And not only that, he also basically alone established this ethics as a standard IN SPITE of all the world's [corporations](corporation.md) [fighting](fight_culture.md) back, in a field that back then was relatively obscure, unpopular in mainstream and hence not much supported by any mass media. He is also extremely unique in not pursuing self interest, in TRULY living his own philosophy, dedicating his whole life to his cause and refusing to give in even partially. All of this is at much higher level than simply becoming successful and famous within the contemporary capitalist system, his life effort is pure, true and timeless, unlike things achieved by pieces of shit such as [Steve Jobs](steve_jobs.md).

**Is Richard Stallman a celebrity?** This question is important to [us](lrs.md) because we dislike any celebrities. The answer is probably this: to a certain level he is a celebrity (though not nearly a Hollywood level celebrity, 99% of normal people never heard of him), but at least to a similar level he is just a well known expert on certain things. So yes, partially we have to dislike his celebrity part -- any worship of him as a God is acceptable only as a [meme](meme.md), we must never see him as a [hero](hero_culture.md). He seems to be a very rare case of a mini celebrity that managed to keep some morality, perhaps because his celebrity status, very uncommonly, came to him more because he wasn't careful enough to avoid it rather than because he actively pursued it. It's not an excuse -- if someone doesn't want to become a celebrity, he cannot become one -- but it may be an extenuating circumstance. This is to say: yes, it sucks he's a celebrity to some degree, but he's probably at least among the least harmful ones.

## See Also

- [John Gilmore](john_gilmore.md)
- [Alexandre Oliva](alexandre_oliva.md)
- [Jesus](jesus.md)
- [Einstein](einstein.md)
- [vrms](vrms.md)
- [gentoo](gentoo.md)
- [Linus Torvalds](torvalds.md)
- [Alan Cox](alan_cox.md)
- [Larry Wall](larry_wall.md)
- [people](people.md)