# Raycastlib

Raycastlib (RCL) is a [public domain](public_domain.md) ([CC0](cc0.md)) [LRS](lrs.md) [C](c.md) [library](library.md) for advanced 2D [raycasting](raycasting.md), i.e. ["2.5D/pseudo3D"](pseudo3d.md) [rendering](3d_rendering.md). It was made by [drummyfish](drummyfish.md), initially as an experiment for [Pokitto](pokitto.md) -- later he utilized the library in his game [Anarch](anarch.md). It is in spirit similar to his other LRS libraries such as [small3dlib](small3dlib.md) and [tinyphysicsengine](tinyphysicsengine.md); just as those raycastlib is [kept extremely simple](KISS.md), it is written in pure C99, with zero dependencies (not even [standard library](stdlib.md)), it's written as a single file single header library, using no [floating point](float.md) and tested to run interactively even on very weak devices (simplified version was made run on [Arduboy](arduboy.md) with some 2 KiB of RAM). It is very flexible thanks to use of [callbacks](callback.md) for communication, allowing e.g. programming arbitrary "[shader](shader.md)" code to implement all kinds of effects the user desires or using [procedurally generated](procgen.md) environments without having to store any data. The library implements advanced features such as floor and ceiling with different heights, textured floor, opening door, simple [collision detection](collision_detection.md) etc. It is written in just a bit over 2000 [lines of code](loc.md).

The repository is available at https://codeberg.org/drummyfish/raycastlib.

```
................................................................................
................................................................................
................................................................................
................................................................................
................................................................................
................................................................................
...........XXXXXXXXXXXX/..........XXXXXXXXXXXXXXXXXXXXXX.......................o
...........XXXXXXXXXXXX////.......XXXXXXXXXXXXXXXXXXXXXX......................oo
XXXXXXXXXXXXXXXXXXXXXXX//////.....XXXXXXXXXXXXXXXXXXXXXX...............ooooooooo
XXXXXXXXXXXXXXXXXXXXXXX/////////..XXXXXXXXXXXXXXXXXXXXXX........oooooooooooooooo
XXXXXXXXXXXXXXXXXXXXXXX//////////.XXXXXXXXXXXXXXXXXXXXXXXXXXXooooooooooooooooooo
XXXXXXXXXXXXXXXXXXXXXXX//////////XXXXXXXXXXXXXXXXXXXXXXXXXXXXooooooooooooooooooo
XXXXXXXXXXXXXXXXXXXXXXX//////////.XXXXXXXXXXXXXXXXXXXXXXXXXXXooooooooooooooooooo
XXXXXXXXXXXXXXXXXXXXXXX/////////..XXXXXXXXXXXXXXXXXXXXXX........oooooooooooooooo
XXXXXXXXXXXXXXXXXXXXXXX//////.....XXXXXXXXXXXXXXXXXXXXXX...............ooooooooo
...........XXXXXXXXXXXX////.......XXXXXXXXXXXXXXXXXXXXXX......................oo
...........XXXXXXXXXXXX/..........XXXXXXXXXXXXXXXXXXXXXX.......................o
................................................................................
................................................................................
................................................................................
................................................................................
```

*Simple rendering made with raycastlib.*