# RAM

RAM stands for *random access memory*, a type of [computer](computer.md) [memory](memory.md) characterized by allowing access to arbitrary addresses (as opposed to [SAM](sam.md) -- sequential memories, such as tapes, which only allow sequential access); a bit [confusingly](often_confused.md) (for historical reasons) the term RAM came to be used more as a synonym for so called **main memory**, i.e. the computer's **working memory** (memory used for performing the actual computation, as opposed to e.g. persistent storage or [read only memory](rom.md)). It is true that working memory is very often a random access memory, but it doesn't always have to be so and there exist random access memories that don't serve as the main working memory. Similarly confusing is the fact that RAM is often opposed to [ROM](rom.md) (read only memory) -- again, it is true that many computers use RAM as main working memory and ROM as the "other" kind of memory used for static data so in practice these two complement each other, but it is entirely possible for random access memory to be read-only (so RAM can also be ROM) and so on. Nevertheless, though it's imprecise, in this articles we WILL conform to the established terminology a lot -- implicitly we will see RAM as meaning a **[volatile](volatile.md) random access read/write memory serving as a working memory** (volatile meaning it's erased on power off).

RAM is one of the main components of a computer, it closely cooperates with the [CPU](cpu.md); in fact CPU without RAM would be basically useless; RAM serves the CPU as a "scratchpad" where it keeps intermediate results to perform more complex calculations. RAM, being a relatively fast memory, is also often used to temporarily load parts of bigger [data](data.md) for faster access, sometimes it may also store the instructions of the program being executed by the CPU. For this RAM is, along with the CPU, one of the two components which can never be missing in a computer. A computer can work without a [hard disk](hdd.md), without keyboard, mouse and monitor, but it can never meaningfully work without RAM.

**RAM is relatively fast**, in [memory hierarchy](memory_hierarchy.md) only the CPU registers and CPU [cache](cache.md) are faster than RAM, RAM is a lot faster than [disk](hdd.md). How much faster exactly depends on a few things, firstly the exact types of both memories, and secondly on how you access the memories, e.g. with sequential access RAM may be only 10 times faster, but with random access it can even be 100000 times faster. The speed of RAM is often (in PCs always, but may be missing e.g. in [embedded](embedded.md)) boosted by the mentioned cache memory (standing between RAM and CPU), but again that will only work if we access the RAM correctly (respecting the principle of locality, i.e. not make big jumps in memory).

There are two main types of electronic RAM:

- **SRAM** (static RAM): After assigning a value (0 or 1) to a memory cell, the cell retains the value as long as the power is on. This is usually implemented with [flip flop](flip_flop.md) logic circuits. SRAMs are very fast but expensive (a flip flop requires several transistors) and also consume more [power](power.md) than DRAMs (when not idle), so  in PCs they are actually NOT often used to implement the main memory (which this article is about), instead SRAMs are used for the smaller memories like CPU registers and [caches](cache.md). But simpler computers with low RAM (e.g. [embedded](embedded.md)) may use SRAM even for main memory.
- **DRAM** (dynamic RAM): After assigning a value to a memory cell, the cell will hold the value only for some time, therefore the cells have to be periodically refreshed (usually at least once in 64 milliseconds) so that they retain their values for long time (hence the name *dynamic*). This behavior exists because DRAMs are usually implemented with [capacitors](capacitor.md) which lose charge over time. DRAMs are cheaper (a cell just requires a transistor and capacitor) but slower, so these are often used to implement the main memory.

Furthermore there are many other types like [SDRAM](sdram.md), [DDR](ddr.md), [DDR2](ddr2.md) etc.

**RAM from programmer's point of view**: in your [programming language](programming_language.md) [variables](variables.md) are typically places in RAM (the variable name is just a name for some RAM memory address), so the more variables you need (note that most significant are [arrays](array.md) and other "big" variables), the more RAM your program will consume. Though it may not be so simple, some variables whose value doesn't change (e.g `static const` or string literals in [C](c.md)) may be rather placed in ROM by the compiler/optimizer. Also some small scope variables may be just stored in CPU registers. WATCH OUT: under a typical [operating system](os.md) the main memory is [virtualized](virtual_memory.md) so the addresses your program sees are generally not the physical addresses in RAM.

Also thanks to virtual memory **your computer may actually be able to use more RAM than there is physically present** by temporarily storing some less used memory pages on to the disk to free space in RAM. This is called **[swapping](swap.md)** and normally results in huge slowdown of the computer; swapping is many times a sign of [memory leak](memory_leak.md) or some other atrocity.

Saving content of RAM to disk is also exploited by **[hibernation](hibernation.md)**.

**How much RAM do we need?** Not much, definitely not NEARLY as much as you see on a typical today's consumer PC which come with 16 or 32 GB of RAM, that's just too much, you never need that much memory and this craziness only exists for [consumerism](consumerism.md) and due to extremely shitty [capitalist software](capitalist_software.md) whose efficiency probably doesn't surpass 1%. The amount of RAM we need firstly depends on the task at hand and secondly on the details of our computer (e.g. if it stores the program itself in RAM or not, if we have helper coprocessors that save us some work, if we have a fast CPU and can afford to sacrifice some of its speed for needing less memory etc.) and what exactly we define as RAM (whether e.g. we see [video memory](vram.md) as RAM or if we are allowed to store a lot of read-only data in ROM). Generally speaking for simple mathematical problems, such as solving a quadratic equation, a few [bytes](byte.md) may be enough. With a few hundred bytes we can make simple games such as [Tetris](tetris.md). With a few [kilobytes](kb.md) we can already make more complex games, e.g. something akin [Wolf 3D](wolf3d.md) or [chess](chess.md) with basic AI, we can make a simple text editor, probably even a [programming language](programming_language.md) capable of compiling itself (see e.g. games for [Arduboy](arduboy.md) which possesses 2.5 KB of RAM). Surpassing some 30 KB we can already make [Doom](doom.md)-like games ([Anarch](anarch.md) runs on [GB Meta](gb_meta.md) with 32 KB of RAM) and basic versions of most of the tools we need on a personal computer such as text editor, image editor, music composer, programming editor, ... though still typically running on [bare metal](bare_metal.md) (without [operating system](os.md)). 1 MB is about 30 times that, so unless dealing with some memory-heavy task, such as processing HD video, **with [good programming](lrs.md) you should practically never need more than 1 MB of RAM**. If your computer has 1 GB of RAM, it already has 1000 times the overkill amount, so it can do all kind of fancy stuff like running an [operating system](os.md) that runs several programs at once ([multitasking](multitasking.md)), some of which may be doing even memory heavy tasks.

## See Also

- [SAM](sam.md)
- [ROM](rom.md)
- [VRAM](vram.md)
- [flash](flash.md)
- [EEPROM](eeprom.md)
- [hard disk](hdd.md)
- [memory](memory.md)