# Pseudominimalism

Pseudominimalism is the kind of technology design which aims to appear [minimalist](minimalism.md) on the outside while being [bloated](bloat.md) on the inside. Rather than trying to achieve a [truly good](lrs.md), minimalist design from the ground up, with all its advantages, pseudominimalism merely attempts to hide the ugliness of its internals and appeal purely by the looks. A typical example might be a website that has a minimalist look -- a blank background with sans-serif [font](font.md) text and a few nice looking vector shapes -- which in the background sneakily uses dozens of [JavaScript](js.md) frameworks and libraries and requires a high end [CPU](cpu.md) in order to even appear responsive. Essentially all [modern](modern.md) "retro" video [games](game.md) are pseudominimalist in design, they use pixelated graphics but are created in enormous frameworks such as [Unity](unity.md) or [Godot](godot.md); even projects calling themselves "minimalist", such as many [fantasy consoles](fantasy_console.md), are in truth only pseudominimalist, written in extremely high level languages such as [JavaScript](javascript.md). [Apple](apple.md) is heavily practicing pseudominimalism.

While true minimalists do appreciate minimalist look as well, pseudominimalists are obsessed with visuals, the casing, the shell and that is their true goal to which they sacrifice the internal beauty, so after a while you learn to spot pseudominimalist just by their attempts at what they call a "clean design" or "user experience" -- a true minimalist uses minimalism so that bullshit doesn't stands in his way, a **pseudominimalist is just a snob** using visuals to pretend he's an intellectual or, as he loves to say, an "artist". You will see the sweat that went into font choice, spacing of paragraphs with this tryharding leaking even to language in which he tries to use minimum of words which just makes it hard to understand what he wants to say. A typical example is the [shitty 100r wiki](xxiivv.md).

Another example is presented by many "[modern](modern.md)" [CLI](cli.md) programs which [code monkeys](coder.md) use to impress their [YouTube](youtube.md) viewers or to feel like matrix haxors. Some people believe that anything running in the command line has to be minimalist by some kind of law of nature -- this is less and less true as we progress into the [future](future.md). A lot of [capitalist software](capitalist_software.md) add a CLI interface ex post **on top** of an already bloated program (they even invented a term for this: "[headless](headless.md)"), often by simply disabling [GUI](gui.md) (but leaving all its [dependencies](dependency.md) in). An example may be the [gomux](gomux.md) chat client.

Another form of pseudominimalism is making a minimalist tool for something that in itself is a non-minimalist [bullshit](bullshit.md) -- for example minimalist frontend for Facebook, minimalist Steam client, minimalist password manager, minimalist minimalist [Bitcoin](bitcoin.md) wallet etc.

And that's not all -- another kind of pseudominimalism appearing among the new generation of crippled pseudoprogrammers is all about writing very few [lines of code](loc.md) in some incredibly bloated language and calling that "minimalism". Something like a *Minecraft clone in 100 LOC of Python using only Python standard library*, the catch of course being that [Python](python.md) itself is hugely bloated and its standard library is enormous, therefore they just hide all the complexity out of view. Effort like that is indeed completely useless and only serves for flexing in front of beginners who can't spot the obvious trick. Even if obvious, it has to be noted that **minimalist software cannot be written in a bloated language**.