# Proprietary

The word proprietary (related to the word *property*) is used for intellectual works (such as texts, songs, computer programs, ...) that are someone's fully owned "[intellectual property](intellectual_property.md)" (by means of [copyright](copyright.md), [patents](patent.md), [trademarks](trademark.md) etc.), i.e. those that are not [free as in freedom](free.md) because they cannot be freely copied, shared, modified, studied etc. This word has a negative connotation because proprietary works serve capitalist overlords, are used to abuse others and go against freedom. The opposite of proprietary is [free (as in freedom, NOT price)](free.md) (also *libre*): free works are either those that are completely [public domain](public_domain.md) or technically owned by someone but coming with a free (as in freedom) [license](license.md) that voluntarily waives all the harmful legal rights of the owner. There are two main kinds of proprietary works (and their free counterparts): proprietary [software](sw.md) (as software was the first area where these issues arose) (versus [free software](free_software.md)) and proprietary [art](art.md) of other kind (music, pictures, data, ...) (versus [free cultural](free_culture.md) art).

As said, proprietary software is any software that is not [free (as in freedom)](free_software.md)/[open source](open_source.md) software. Such software denies users and creators their basic freedoms (freedom of unlimited use, studying, modifying and sharing) and is therefore [evil](evil.md); proprietary software is mostly [capitalist software](capitalist_software.md) designed to abuse its user in some way. Proprietary code is often secret, not publicly accessible, but there are many programs whose source code is [available](source_available.md) but which is still proprietary because no one except the "owner" has any legal rights to fixing it, improving it or redistributing it.

Examples of proprietary software are [MS Windows](windows.md), [MacOS](macos.md), [Adobe Photoshop](photoshop.md) and almost every [game](game.md). Proprietary software is not only extremely [harmful](harmful.md) to [culture](culture.md), technology and society in general, it is downright dangerous and in some cases life-threatening; see for example cases of medical implants such as pacemakers running secret proprietary code whose creator and maintainer goes bankrupt and can no longer continue to maintain such devices already planted into bodies of people -- such cases have already appeared, see e.g. *Autonomic Technologies* nervous system implants.

Proprietary software licenses are usually called [EULAs](eula.md).

By extension besides proprietary software there also exist other proprietary works, for example proprietary [art](art.md) or databases -- these are all works that are not [free cultural works](free_culture.md). Even though for example a proprietary movie probably isn't IMMEDIATELY as dangerous as proprietary software, it may be just as dangerous to society in the long run. Examples of proprietary art is basically anything mainstream that's not older than let's say 50 years: [Harry Potter](harry_potter.md), all Hollywood movies, basically all pop music, basically all AAA video [game](game.md) art and lore etcetc.

**Is it ever okay to use proprietary software?** If you have to ask, the answer is no, you should avoid proprietary software as much as possible (considering in today's society you probably can't even take a shit without using some form of proprietary software). Proprietary software is [cancer](cancer.md), it is like hard drugs, poison, radioactive toxic material, biological virus -- you have to treat it as such. For this reason to most people, especially newcomers to the free world, the best, simplest and safest advice is to completely avoid anything proprietary; this helps you get out of the addiction, break out of the system, find free alternatives and avoid harm to yourself and others. Once one becomes an expert he start to see the answer may be more complex of course, as with everything -- for example in order to make a free [clone](clone.md) of something proprietary, we often have to [reverse engineer](reverse_engineering.md) it, which often means having to run it; however this has to only be done by experts who know the dangers and how to handle them, just like handling of a highly dangerous biological virus should only ever be done by an expert in safe laboratory under strictly controlled conditions.