# Programming

*Not to be [confused](often_confused.md) with [coding](coding.md).*

Programming is the act, [science](science.md) and [art](art.md) of writing [computer](computer.md) [programs](program.md); it involves creation of [algorithms](algorithm.md) and [data structures](data_structure.md) and implementing them in [programming languages](programming_language.md). It may involve related activities such as [testing](testing.md), [debugging](debugging.md), [hacking](hacking.md) and drinking coffee.

You may also encounter the term [coding](coding.md) which is used by [noob](noob.md) [wannabe programmers](soydev.md), so called "coders" or [code monkeys](code_monkey.md). "Coding" doesn't reach the quality of programming, it is done in baby handholding languages like [Python](python.md), [JavaScript](javascript.md) or [Rust](rust.md) by people with very shallow knowledge of technology and its context, barely qualified to turn on a computer (like [jewtubers](youtube.md)), who have flooded the computer industry since it became lucrative. It is mostly done for money and/or creating an image for oneself. What they do is not real programming. Do not try to imitate them.

At high level programming becomes [spiritual](spirituality.md). Check out e.g. [zen](zen.md) and the famous [Tao of Programming](tao.md) (yes, it's kind of a [joke](jokes.md) but it's rooted in the reality of a common hacker's mindset, programming can truly be kind of a [meditation](meditation.md) and pursuit of enlightenment, often leading one to asking deeper questions about the world). Many people say that learning programming opens your eyes in a certain new way (with some however claiming the contrary that programming will rather close your eyes), you then see the world like never before (but that's probably kind of true of almost all skills taken to a high level so this may be a [shit](shit.md) statement). Others say too much programming cripples you mentally and gives you [autism](autism.md). Anyway it's [fun](fun.md) and changes you somehow. **Programming requires a good knowledge of advanced [math](math.md)**. Also probably at least above average [IQ](iq.md), as well as below average social intelligence. Being a [white](white.md) [man](man.md) is an advantage.

**Can you do programming without math?** Short answer: no. Long answer: no, you can't.

## How To Learn Programming And Do It Well

*See also [programming tips](programming_tips.md) and [exercises](exercises.md).*

At first you have to learn two basic rules that have to be constantly on your mind:

1. **You cannot be a good programmer if you're not good at [math](math.md)** -- real programming is pure math.
2. **[Minimalism](minimalism.md) is the most important concept in programming.** If you don't like, support or understand minimalism, don't even think of becoming a programmer.

OK, now the key thing to becoming a programmer is learning a [programming language](programming_language.md) very well (and learning many of them), however this is not enough (it's only enough for becoming a [coding](coding.md) monkey), you additionally have to have a wider knowledge such as general knowledge of [computers](computer.md) ([electronics](electronics.md), [hardware](hardware.md), theory or [computation](computation.md), [networks](networking.md), ...), tech [history](history.md) and culture ([free software](free_software.md), [hacker cutlure](hacking.md), [free culture](free_culture.md), ...), [math](math.md) and [science](science.md) in general, possibly even society, philosophy etc. Programming is not an isolated topic (only coding is), a programmer has to see the big picture and have a number of other big brain interests such as [chess](chess.md), voting systems, linguistics, physics, [music](music.md) etc. Remember, becoming a good programmer takes a whole life, sometimes even longer.

**Can you become a good programmer when you're old?** Well, as with everything to become a SERIOUSLY good programmer you should have probably started before the age of 20, the majority of the legend programmers started before 10, it's just like with sports or becoming an excellent musician. But with enough enthusiasm and endurance you can become a pretty good programmer at any age, just like you can learn to play an instrument or run marathon basically at any age, it will just take longer and a lot of energy. You don't even have to aim to become very good, becoming just average is enough to write simple gaymes and have a bit of fun in life :) Just don't try to learn programming because it seems cool, because you want to look like movie haxor, gain followers on youtube or because you need a job -- if you're not having genuine fun just thinking before sleep about how to swap two variables without using a temporary variable, programming is probably not for you. **Can you become a good programmer if you're black or [woman](woman.md)?** No. :D Ok, maybe you can, but all the above applies, don't do it for politics or money or followers -- if you become a seriously based programmer (from [LRS](lrs.md) point of view) of unlikely minority, we'll be more than happy to put an apology here, in ALL CAPS and bold letters :) Hopefully this will inspire someone...

**Which programming language to start with?** This is the big question. Though languages such as [Python](python.md) or [JavaScript](javascript.md) are objectively really REALLY bad, they are nowadays possibly the easiest way to get into programming, so you may want to just pick one of these two, knowing you'll abandon it later to learn a true language such as [C](c.md) (and knowing the bad language will still serve you in the future in some ways, it's not a wasted time). Can you start with C right away? It's probably not impossible for a genius but it will be VERY hard and you'll most likely end up failing, overwhelmed, frustrated and never returning to programming again. In *How To Become A Hacker* ESR actually recommends to learn C, Lisp or [Go](golang.md) as the first language, but that recommendation comes to aspiring hackers, i.e. the most talented and ambitious programmers, so think about whether you fit this category. Absolutely do NOT even consider [C#](c_sharp.md) (shit, unusable), [Java](java.md) (shit, slow, bloated, unusable), [C++](cpp.md) (like C but shit and more complicated), [Haskell](haskell.md) (non-traditional, hard), [Rust](rust.md) (shit, bad design, unusable), [Go](go.md) (prolly hard), [Lisp](lisp.md) (non-traditional), [Prolog](prolog.md) (lol) and similar languages -- you may explore these later. Whichever language you pick for the love of god **avoid [OOP](oop.md)** -- no matter what anyone tells you, when you see a tutorial that uses "classes"/"objects" just move on, learn normal [imperative](imperative.md) programming. OOP is a huge pile of shit meme that you will learn anyway later (because everyone writes it nowadays) so that you see why it's shit and why you shouldn't use it.

{ I really started programming in [Pascal](pascal.md) at school, it was actually a good language as it worked very similarly to C and the transition later wasn't that hard, but nowadays learning Pascal doesn't make much sense anymore. ~drummyfish }

**[Games](game.md) are an ideal start project** because they're [fun](fun.md) (having fun makes learning much faster and enjoyable), there are many noob tutorials all over the Internet etc. However keep in mind to **start EXTREMELY simple.** -- this can't be stressed enough, most people are very impatient and eager and start making an RPG game or networking library without really knowing a programming language -- this is a GUARANTEED spectacular failure. At the beginning think in terms of "snake" and "minesweeper". Your very first project shouldn't even use any [GUI](gui.md), it should be purely [command-line](cli.md) text program, so a text-only tiny interactive story in [Python](python.md) is possibly the absolutely best choice as a first project. Once you're more comfortable you may consider to start using graphics, e.g. Python + [Pygame](pygame.md), but still [KEEP IT SIMPLE](kiss.md), make a flappy bird clone or something. As you progress, consider perhaps buying a simple toy computer such as an [open console](open_console.md) -- these toys are closer to old computers that had no operating systems etc., they e.g. let you interact directly with hardware and teach you a LOT about good programming by teaching you how computers actually work under the hood. One day you will have to make the big step and **learn [C](c.md)**, the best and most important language as of yet, but be sure to only start learning it when you're at least intermediate in your start language (see our [C tutorial](c_tutorial.md)). To learn C we recommend our [SAF](saf.md) library which will save you all headaches of complex APIs and your games will be nice and compatible with you small toy computers.

As with everything, you learn by doing -- reading is extremely important and necessary, but to actually learn anything you have to spend thousands of hours practicing the art yourself. So **program, program and program**, live by programming, look for ways of using programming in what you're already doing, try to automatize anything you do, think about programming before sleep etc. If you can, **contribute to some project**, best if you can help your favorite [FOSS](foss.md) program -- try this at least once as being in the company of the experienced just teaches you like nothing else, a month spent contributing to a project may be worth a year of just reading books.

TODO