# Patent

Patent is a form of extreme "[intellectual property](intellectual_property.md)" that allows owning useful ideas, oppressing and bullying people and preventing others from using ideas -- software patents are especially harmful to society and [technology](tech.md). Patents are currently along with [copyright](copyright.md) likely the most [harmful](harmful.md) kind of "intellectual property" in technology -- even though copyright is probably a more pressing issue at the moment because it is the most common form of IP oppression, patents can be just as harmful in individual cases. Of course we're not even talking about the whole gigantic bullshit bureaucracy and business connected to patents that just wastes man centuries of effort. Examples of patents in software are  minigames on loading screens in games (this patent has already expired), [shadow volume](shadow_volume.md) algorithm for rendering shadows, [mp3](mp3.md) format (also expired), various [compression](compression.md) techniques, even such broad ideas as **public key encryption** (yes, the whole idea that's the basis of [cryptography](cryptography.md) was patented and unusable until 1977) etc.

There is an article on software patents at https://www.gnu.org/philosophy/software-patents.en.html. There is even a site and initiative dedicated to ending software patents at https://wiki.endsoftwarepatents.org/wiki/Main_Page.

Patents are kind of similar to but also very different from copyright ([Richard Stallman](rms.md) stressed the differences and says it is dangerous to think of copyright and patents as similar): while copyright applies to [art](art.md) and is granted automatically, patents apply to ideas (which should ideally be new inventions but in practice can be just any trivially stupid ideas), have to be registered and are kept recorded somewhere. Patents also last a shorter time than copyright (generally 20 years as opposed to copyright's lifetime plus 70 years) and are territorial, i.e. not world-wide. These facts make patents a bit less disastrous than copyright, however they still cause a great deal of damage -- not only do they prevent technological progress (a new ideas such as a new efficient [algorithm](algorithm.md) is simply prohibited to be used by anyone but it's "owner" and those who the owner sells a license), they also allow so called **patent trolling** (patent scams) -- patent trolling takes advantage of the fact that it is practically impossible to safely check if some idea is not patented, i.e. safe to use. There exist troll companies whose sole business is to register trivial patents and then sue random people who unknowingly implement this idea in their projects (there is e.g. a famous video about how this happened to the developer of X-plane, trolled by Uniloc company that had patented the idea of using a "play store" to distribute programs) -- the companies often bully developers to off court settlement for paying a lower free but this includes a contract that **prevents the affected developers from talking about this**.

Granting and checking patents is also becoming progressively more difficult, expensive and sometimes basically impossible, as any new filed patent has to be checked for how "innovative" it is. This means someone has to literally go through all ideas ever invented in computer science (impossible even for the biggest brain on the planet) and check if the new submitted idea is really new -- given that computer science progresses by lightning speed, every day it is becoming more and more difficult to check patents. As time for checking a patent is limited, the result is many false positives, errors and grants of patents on trivial or non-innovative ideas, which has disastrous consequences. And of course, we're not even talking about corruption -- patents are highly lucrative and it would be naive to believe there are no cases of someone just buying a patent grant.

Many (probably most) [free software](free_software.md) proponents, and just many programmers in general, including for example [Richard Stallman](rms.md), [John Carmack](john_carmack.md) or [Donald Knuth](knuth.md), have highly criticized the existence of software patents. [Richard Stallman](rms.md) himself has been warning of the dangers and has likened the world of patents to a **mine field** because when you're programming, you have no idea whether an idea you get and implement in your program isn't in fact "owned" by anyone, programming itself poses risk of stepping on mines (patents).

As a good [free software](free_software.md) developer you should **use [licenses](license.md)/[waivers](waiver.md) to get rid of patents!** Similarly to copyright, your software should come with a license or waiver that ensure patents won't prevent others from exercising the four essential freedom rights, i.e. there should be a legal document that says you grant others rights to any of your patented ideas hiding in your source code so that others are safe from you suing them if they reuse your potentially patent-infected code (still, there may unfortunately be hiding patents from third parties which cannot be addressed). Some licenses, such as [GPL](gpl.md) or [Apache](apache_license.md) include patent grants, however others such as [MIT](mit.md) or [CC0](cc0.md) don't or have to be slightly modified to do so. This is an issue because there is for example no nice way of dedicating one's work completely to the [public domain](public_domain.md) complete with patent grants, as [CC0](cc0.md), [Unlicense](unlicense.md) and [WTFPL](wtfpl.md) don't address the patent issue -- with these an extra patent waiver has to be manually added! Unlike with copyright, patent waivers aren't always completely necessary, it is very possible that in many simple and non-innovative projects there are no patented ideas, however one can never be sure, so it is better to use a patent waiver just in case, one can never go wrong by including it.

**Which patent waiver to use?** You may for example copy-paste the waiver from [our own wiki](wiki_rights.md).

Some patents are [fun](fun.md) and bullshit, e.g. there exist bizarre patents that claim to achieve impossible things such as [perpetuum mobile](perpetuum_mobile.md) or infinitely efficient [compression](compression.md) of random data (nicely analyzed at http://gailly.net/05533051.html).

## See Also

- [intellectual property](intellectual_property.md)
- [copyright](copyright.md)
- [trademark](trademark.md)
