# Name Is Important

Name of a philosophy, project, movement, group, [ideology](ideology.md) etc. plays a more significant role than a common man believes. A naive view is that name is just an arbitrary identifier whose value lies at most being "catchy" and "easily remembered" (see also [marketing](marketing.md)), a common man will rather believe promise of politician than the name of his party which he will disregard just as a "bunch of unimportant words"; however name is much more than a mere string of letters, it is the single most stable defining feature of an entity; everything else, all the books and knowledge associated with it may be distorted by [history](history.md), but the name will always stay the same and will hold a scrutiny over all actions of the entity, it will always be a permanent reminder to every follower of what he is trying to achieve. But what if the name of the movement changes? Then it will be by definition a new, different movement, and everyone will have to decide if he wants to abandon the old movement to join the new. The name very often points towards the one true goal.

HOWEVER, it may also not be completely true -- few things in Universe hold absolutely. Hear this **warning**: firstly [human language](human_language.md) itself (i.e. meanings of all words that exist in it) changes, the process is slow but in several hundred years this effect becomes significant. Secondly although the power of name is great, it is not infinite, the discussed stress of the importance of name should just remind us that the force of the name is greater than one might expect, but may still be broken if stronger forces are at play -- there have been many cases of **name abuse** in history, notably e.g. by [Nazism](nazi.md) whose name stands for "national socialism" but whose actions were completely antisocialist, or so called ["Anarcho" capitalism](ancap.md) which abuses the name *[anarchism](anarchism.md)* despite being completely antianarchist. The moral of the story here is that we should put a great effort in choosing a name, but we shouldn't think we'll be safe as long as we do -- we will probably never be safe from the fuzziness of language and its potential to be abused, but we should try to do our best.

We have to keep in mind two things:

- When encountering a new movement/philosophy/ideology etc., we can tell a lot about it from its name: the name is its ultimate goal which **will be pursued on detriment of other goals**. A lot of times the bad movements are those **named after the means** (e.g. *[capitalism](capitalism.md)* or *[open source](open_source.md)*) **or [people](hero_culture.md)** (e.g. Maoism) rather than goals (e.g. *pacifism*) because by this dominance the focus on means will inevitably subordinate the goal.
- When starting a new movement, we have to pay very careful attention to giving it a name.

Let us comment on a few examples:

- **[Capitalism](capitalism.md)**: The goal is maximization of capital -- capital should be the means to achieving "something" (what lol?), but it instead becomes the goal. There is no promise of a good society, it is not mentioned in the name, and indeed what we get is a system that evolves corporations that get progressively better at maximizing capital, on the detriment of people.
- **[Free Software Movement](free_software.md)**: The movement is about user's freedom and therefore ethics. Notice that even though definitions of free software may slightly differ between different branches of it, the groups calling themselves *free software* movements always pursue freedom. This is why capitalism couldn't embrace free software: because thanks to the name it always firmly stands against abusing the user. Of course, even the meaning of the word *freedom* may eventually be shifted and the movement may get spoiled too, but it has stood for a long time and has already proven a great resistance.
- **[Open Source Movement](open_source.md)**: The movement has been born from the Free Software Movement with a specific goal of abandoning ethics and supporting business. The ethics (freedom) has been dropped from the name and was replaced with the word "open", and indeed what we're seeing is software that is somewhat "open" -- whatever that means -- but mostly [capitalism software](capitalist_software.md) abusing and restricting its users by means other than proprietary licenses (see e.g. [Firefox](firefox.md)).
- **[Feminism](feminism.md)**: The goal is to benefit the females, i.e. make the superior to males. There is no mention of equality of sexes in the name even this idea might have appeared somewhere in the movement's beginning. And indeed, what we're seeing is a progressively more aggressive fascist movement that is downright hostile to males, is completely uninterested in inequality in the opposite direction and only ever looks for empowering the women, without any concern of equality.
- **[LGBT](lgbt.md)**: Same as feminism.
- **[Anarchism](anarchism.md)**: anarchism means "without a ruler" which has shown to be a good name, clearly opposing the idea of one man standing above another and so, again, keeps resisting attempts at being twisted to go against this basic goal. We rarely see the name being abused by the powerful because someone who wants to rule others simply cannot promote something that clearly indicates there should be no rulers. Indeed, there exist attempts at abusing the name, such as ["Anarcho" capitalism](ancap.md), but we observe the shear absurdity of such attempt is quickly spotted by most people who know what the word *anarchism* means.
- ...

{ A note from my friend: "[coding](coding.md)" gaining popularity over "[programming](programming.md)" maybe shows a subconscious shift towards [productivity cult](productivity_cult.md), a shift from focusing on the  process and doing it well (programming) towards just shitting out quantities of code (coding). ~drummyfish }