#!/bin/sh
# Auto generates stats article.

echo "making stats"

FILE_NAME="wiki_stats.md"

printf "# LRS Wiki Stats\n\nThis is an autogenerated article holding stats about this wiki.\n\n" > $FILE_NAME

printf -- "- number of articles: " >> $FILE_NAME
ls *.md | wc -l >> $FILE_NAME

printf -- "- number of commits: " >> $FILE_NAME
git rev-list --count --all >> $FILE_NAME

printf -- "- total size of all texts in bytes: " >> $FILE_NAME
cat *.md | wc -c >> $FILE_NAME

printf -- "- total number of lines of article texts: " >> $FILE_NAME
cat *.md | wc -l >> $FILE_NAME

printf -- "- number of script lines: " >> $FILE_NAME
cat *.sh | wc -l >> $FILE_NAME

printf -- "- occurences of the word \"person\": " >> $FILE_NAME
grep -o -i "person[s \n\.,]" *.md | wc -l >> $FILE_NAME

printf -- "- occurences of the word \"nigger\": " >> $FILE_NAME
grep -o -i "[^\[]nigger" *.md | wc -l >> $FILE_NAME

printf "\nlongest articles:\n\n" >> $FILE_NAME
ls -1hSs *.md | head -n 20 | sed "s/ *\([^ ]*\) \+\([^ ]*\)\.md/- [\2](\2.md): \1/g" >> $FILE_NAME
printf "\n" >> $FILE_NAME

printf "top 50 5+ letter words:\n\n" >> $FILE_NAME
cat *.md | sed "s/([^ ]\+\.md/ /g" | tr -cs "[:alpha:]" "\n" | \
  sed -r "/^.{,4}$/d" | tr "A-Z" "a-z" | sort | uniq -c | sort -nr | \
  head -n 50 | sed "s/ \+\([^ ]*\) \+\([^ ]*\)$/- \2 (\1)/g" >> $FILE_NAME
printf "\n" >> $FILE_NAME

printf "latest changes:\n\n\`\`\`\n" >> $FILE_NAME
git log --name-only | head -n 50 | grep "Date:\|.*\.md" | sed "s/\([^ ]*\.md\)/  \1/g" >> $FILE_NAME
printf "\`\`\`\n" >> $FILE_NAME

printf "\nmost wanted pages:\n\n" >> $FILE_NAME

cat ./*.md | sed -n 's/.*\[.*\](\([^\)\(]*\)).*/\1/p' | sort | uniq -c | sort -nr > tmp.txt

rm tmp2.txt
touch tmp2.txt

while read -r line; do
  fname=`echo "$line" | grep -o "[^ ]*\.md" -`

  if ! [ -f $fname ]; then
    printf -- "- [" >> tmp2.txt
    printf $fname | sed "s/^\([^ ]*\)\.md/\1](${fname}) (/g" >> tmp2.txt
    echo $line | sed "s/^ *\([0-9]*\).*$/\1)/g" >> tmp2.txt
  fi
done < tmp.txt

cat tmp2.txt | head -n 20 >> $FILE_NAME
rm tmp.txt tmp2.txt

printf "\nmost popular and lonely pages:\n\n" >> $FILE_NAME

rm tmp.txt
touch tmp.txt

for fname in *.md; do
  count=`grep -F -o "($fname)" *.md | wc -l`
  echo "$count $fname" >> tmp.txt
done

rm tmp2.txt

cat tmp.txt | sort -n -r | head -n 30 > tmp2.txt
echo "- ..." >> tmp2.txt
cat tmp.txt | sort -n -r | tail -n 30 >> tmp2.txt
cat tmp2.txt | sed "s/ *\([^ ]*\) \+\([^ ]*\)\.md/- [\2](\2.md) (\1) /g" >> $FILE_NAME

rm tmp2.txt
rm tmp.txt

printf "\n" >> $FILE_NAME
