# Hacking

*Not to be [confused](often_confused.md) with [cracking](cracking.md).*

Hacking (also hackerdom) in the widest sense means exploiting usually (but not necessarily) a [computer](computer.md) [system](system.md) in a clever, "thinking outside the box" way. In context of computers the word *hacker* was originally -- that is in 1960s -- used for very good [programmers](programming.md) and people who were simply good with computers, the word *hacking* had a completely positive meaning; hacker could almost be synonymous with computer [genius](genius.md) (at the time people handling computers were usually physicists, engineers or mathematicians), someone who enjoyed handling and programming computers and could playfully look for very clever ways of making them do what he wanted. Over time hackers evolved a whole **hacker culture** with its own slang, set of values, behavioral and ethical norms, in jokes and rich lore. As time marched on, computer [security](security.md) has started to become an important topic and some media started to use the word *hacker* for someone breaking into a computer system and so the word gained a negative connotation in the mainstream -- though many refused to accept this new meaning and rather used the word *[cracker](cracker.md)* for a "malicious hacker", there appeared new variants such as *white hat* and *black hat* hacker, referring to ethical and malicious hackers. With onset of online [games](game.md) the word *hacking* even became a synonym for [cheating](cheating.md). The original positive meaning has recently seen some comeback with popularity of sites such as [hacker news](hacker_news.md) or hackaday, the word *life hack* has even found its way into the non-computer mainstream dictionary, however a "[modern](modern.md) hacker" is a bit different from the oldschool hacker, usually for the worse (for example a modern self proclaimed "hacker" has no issue with wearing a [suit](suit.md), something that would be despised by an oldschool hacker). We, [LRS](lrs.md), advocate for using the original, oldschool meaning of the word *hacker*.

## Original Hacker Culture

The original hacker culture is a culture of the earliest computer programmers, usually smart but socially rather isolated nerds -- at the time mostly physicists, mathematicians and engineers -- who shared deep love for programming and pure joy of coming up with clever computer tricks, exploration of computers and freely sharing their knowledge and computer programs with each other. The culture started to develop rapidly at [MIT](mit.md) in about the second half of 1960s, though other hacker communities existed earlier and in other places as well (still mostly at universities).

Nowadays this original culture is very sadly becoming almost completely extinct, owing to the [modern](modern.md) world whose values -- such as self interest, consumerism, secrecy, praise of censorship, "inclusivity" of the incompetent, materialism etc. -- are mostly polar opposites of the original hacker values: a newly born man would have to reject 99% of the culture he grew up in to be able to adopt the hacker mindset. The culture seems to live on mostly in individuals, mostly the old hackers themselves, and partially in some extremely underground communities such as that of the [demoscene](demoscene.md), but even there it's degenerating greatly.

The word *hack* itself seems to have come from a model train club at MIT in whose slang the word referred to something like a project of passion without a specific goal; before this the word was used around MIT for a specific kind of clever but harmless pranks. Members of the model train club came to contact with early computers at MIT and brought their slang along. These early punch-card computers were expensive and sacred, hackers treated them as almost supernatural entities; in the book *Hackers* it is mentioned that those who were allowed to operate the machines were called *Priests* -- Priests would often carry out a little prayer to please the machine so that it would bless them with computation. During 60s and 70s so called [phreaking](phreaking.md) -- hacking the phone network -- was popular among hackers.

Many ideas -- such as the beauty of [minimalism](minimalism.md) -- that became part of hacker culture later came from the development of [Unix](unix.md) and establishment of its [programming philosophy](unix_philosophy.md). Many hackers came from the communities revolving around [PDP 10](pdp_10.md) and [ARPANET](arpanet.md), and later around networks such as [Usenet](usenet.md). At the time when computers started to be abused by corporations, [Richard Stallman's](rms.md) definition of [free software](free_software.md) and his [GNU](gnu.md) project embodied the strong hacker belief in information freedom and their opposition of [intellectual property](intellectual_property.md). When computer technology became invaded and raped by [capitalism](capitalism.md), hackers separated themselves from the influx of coding monkeys and managers not only culturally, but also by retaining their programming philosophy -- programming of a hacker is very different from the ugly "software development" of a [corporation](corporation.md), a hacker writes [beautiful](beauty.md), [minimal](minimalism.md) code. He doesn't merely aim to "get the job done", he creates art, a code that works well while being a beauty of engineering on the inside, he isn't afraid to throw away code and rewrite it from scratch just to make it a little better (as opposed to patching it up, [bloating](bloat.md) and extending it, as a corporation would do).

The culture has a deep lore and its own literature consisting of books that hackers usually like (e.g. The Hitchhiker's Guide to the Galaxy) and books by hackers themselves. Bits of the lore are in forms of short stories circulated as folklore, very popular form are so called Koans. Perhaps the most iconic hacker story is the [Story of Mel](story_of_mel.md) which tells a true story of a master hacker keeping to his personal ethical beliefs under the pressure of his corporate employers -- a conflict between manager employers ("suits") and hacker employees is a common theme in the stories. Other famous stories include the *TV typewriter* and *Magic Switch*. One of the most famous hacker books is the **[Jargon File](jargon_file.md)**, a collectively written dictionary documenting hacker culture in detail. A 1987 book *[The Tao of Programming](tao_of_programming.md)* captures the hacker wisdom with Taoist-like texts that show how spiritual hacking can get -- this reflects the above mentioned sacred nature of the early computers. Hacker culture very frequently mimics eastern religions and philosophies such as Taoism, Buddhism or various martial arts. The *textfiles* website features many text files on hacking at https://textfiles.vistech.net/hacking/. See also *Ten Commandments for C Programmers* etc. A lot about hackers can be learned from books about them, e.g. the [free](free_culture.md) book *Free as in Freedom* about [Richard Stallman](rms.md) (available e.g. [here](https://www.gutenberg.org/ebooks/5768)). A prominent hacker writer is [Eric S. Raymond](esr.md) who produced a very famous essay *The Cathedral and the Bazaar*, edited the Jargon File and has written guides such as *How To Become A Hacker* and *How To Learn Hacking* -- these are all good resources on hackerdom, even though Raymond himself is kind of shitty, he for example prefers the "[open source](open_source.md)" movement to [free software](free_software.md).

As a symbol of hackerdom the glider symbol from [game of life](game_of_life.md) is sometimes used, it looks like this:

```
 _____
|_|0|_|
|_|_|0|
|0|0|0|
```

Let us now attempt to briefly summarize what it means to be a hacker:

- **Hacker is a kind of artist who builds and creates** (though not every artist is a hacker!), [cracker](cracker.md) is someone who breaks and destroys, many times due to being less competent or unworthy of true hacking -- destroying something is easier than creating something.
- **Hacker greatly values [freedom](freedom.md)**, among which are the **freedom of [information](information.dm)**, **[free software](free_software.md)**, **[free speech](free_speech.md)**, **free thinking**, free access to computers etc. Therefore he supports sharing, even if it is called for example "[piracy](piracy.md)", and despises things going against said freedoms such as [proprietary](proprietary.md) software, [passwords](password.md) and [security](security.md) (preventing information freedom), [censorship](censorship.md), [copyright](copyright.md), [patents](patent.md), pretense and deceit etc.
- **Hackers are non-conformists, reject authority and don't respect social norms, hacking is a way of life**; a hacker wears old cheap clothes, long hair and unkept beard without conforming to any fashion, he sees caring about looks as a wasted time that would better be spent by hacking computers. Hacker is a basement dwelling nerd without social life because he has rich inner intellectual life, he's usually a kisless virgin, even a [wizard](wizard.md), partly because of his looks but also again because typical adult life would require him to do less hacking. He doesn't program for money, he literally lives his whole life as a hacker (a typical example is e.g. focusing on powers of two, such as aiming for 1024 words in his essays, rather than using powers of ten like normal people).
- **Hacker values [fun](fun.md) and playfulness** -- despite his serious dedication to the art, he hates seriousness of the business guys and "suits", as well as the self-centered, egoistic attitude of "modern hackers" who might see or present themselves as kind of [superheroes](hero_culture.md). A hacker will give his programs funny names rather than names that would make for a good business product, a hacker will insert jokes in his source code (e.g. [hex](hexadecimal.md) values such as 0xBEEFFACE), documentation and speech ([Jargon File](jargon_file.md) has a whole section on how hackers construct and use words).
- **Hacker aims for ingenuity, cleverness, elegance, [minimalism](minimalism.md), thinking out of the box** etc. As such he loves [math](math.md), puzzles, intellectual challenges (such as [code golfing](code_golf.md)) and despises ugly commercial ways of mainstream technology, i.e. that which is [bloated](bloat.md), hastily made to impress by visuals or cheap "killer features" while hiding ugly internals etc.
- **Hacker loves hacking and tinkering in itself -- hacking is the goal, not the means. Hacking is [art](art.md) and carries deep intellectual and even spiritual value.** To a hacker it is a joy to program computers and he aims for nothing more than enjoy endless hours of programming, programming is NOT a tool to achieve low goals such as monetary profit or mainstream fame. Many hackers claim that hacking is better than [sex](sex.md) (though it is questionable whether many of them have experience with the latter).
- **Hacker is an elitist, attitude is not enough for being a hacker**, skill is of essential importance. Correct attitude and mindset are important and necessary but not sufficient (as ESR writes: "attitude is no substitute for competence") -- if you don't excel at hacking, you are not a hacker. This is in contrast e.g. with music genre fans where you can "identify yourself" as being "punk" or "metal" even if you can't play any musical instrument or with the [modern](modern.md) "inclusive" "[coder](coding.md)" culture in which you can easily be called a game developer even if you cannot [program](programming.md) etc. Part of hackerdom is also an aim for good reputation among others, to be called a hacker by OTHERS, HOWEVER this has to be achieved without asking or self promotion, merely through doing good hacking, you must not beg others to "please call you a hacker" or promote your programs with marketing to achieve cheap popularity -- no, reputation or the title of hacker is NOT the goal in itself, the goal is good hacking and reputation is an indication you achieved it.
- **Hacker has strong opinions about technology**, for example about what the best [text editor](text_editor.md) or best [programming language](programming_language.md) is. However hackers may also sometimes disagree which results in **[holy wars](holy_war.md)**.

Let's mention a few [people](people.md) who were at their time regarded by at least some as true hackers, however note that many of them betrayed some of the hacker ways either later in life or even in their young years -- people aren't perfect and no single individual is a perfect example of a whole culture. With that said, those regarded hackers included Melvin Kaye aka [Mel](mel.md), [Richard Stallman](rms.md), [Linus Torvalds](linus_torvalds.md), [Alan Cox](alan_cox.md), [Eric S. Raymond](esr.md), [Ken Thompson](ken_thompson.md), [Dennis Ritchie](dennis_ritchie.md), [Richard Greenblatt](greenblatt.md), [Bill Gosper](bill_gosper.md), [Steve Wozniak](wozniak.md), [John Gilmore](john_gilmore.md) or [Larry Wall](larry_wall.md).

## "[Modern](modern.md)" "Hackers"

Many modern [zoomer](zoomer.md) [soydevs](soydev.md) call themselved "hackers" but there are basically none that would stay true to the original ethics and culture and be worthy of being called a true hacker, they just abuse the word as a cool term or a brand (see e.g. ["hacker" news](hacker_news.md), a capitalist circlejerk website where self proclaimed smartass "hackers" come to advertise their ugly bloated [rapeware](rapeware.md) and talk about how to best exploit the market). It's pretty sad the word has become a laughable parody of its original meaning by being associated with groups such as [Anonymous](anonymous.md) who are just a bunch of 14 year old children trying to look like "movie hackers". The hacker culture has been spoiled basically in the same ways the rest of society, and the difference between classic hacker culture and the "modern" one is similar to the difference between [free software](free_software.md) and [open source](open_source.md), though perhaps more amplified -- the original culture of strong ethics has become twisted by [capitalist](capitalism.md) trends such as self-interest, commercialization, [fashion](fashion.md), mainstreamization, even shitty movie adaptations etc. The modern "hackers" are idiots who have never seen [assembly](assembly.md), can't do [math](math.md), they're turds in suits who make [startups](startup.md), aren't afraid to suck corporation dicks and work as [influencers](influencer.md), they are tech consumers with who use and even create [bloat](bloat.md), and possibly even [proprietary](proprietary.md) software. For the love of god, do NOT mimic such caricatures or give them attention -- not only are they not real hackers, they are simply retarded attention whores.

## Security "Hackers"

*Hacker* nowadays very often refers to someone involved in computer [security](security.md) either as that who "protects" (mostly by looking for vulnerabilities and reporting them), so called *white hat*, or that who attacks, so called *black hat*. Those are not hackers in the original sense, they are hackers in the mainstream adopted meaning of someone breaking into a system. **This kind of "hacker" betrays the original culture by supporting secrecy and censorship**, i.e. "protection" of "sensitive information" mostly justified by so called "[privacy](privacy.md)" -- this is violating the original hacker's pursuit of absolute information freedom (note that e.g. [Richard Stallman](rms.md) boycotted even the use of passwords at MIT, Raymond discourages from using anonymous handles and rather recommends going by your real name). These people are obsessed with anonymity, [encryption](encryption.md), [cryptocurrencies](crypto.md), [cryptofascism](cryptofascism.md) and are also more often than not egoist people with shitty personalities. In addition they don't generally adhere to the original hacker culture in any way either, they are simply people breaking into systems for some kind of self benefit (yes, even the *white hats*), nothing more than that. Again, do NOT try to mimic these abominations.

## Examples Of Hacks

{ As a redditfag I used to follow the r/devtricks subreddit, it contained some nice examples of hacks. ~drummyfish }

A great many commonly used tricks in programming could be regarded as hacks even though many are not called so because they are already well known and no longer innovative, a true hack is something new that impresses fellow hackers. And of course hacks may appear outside the area of technology as well. The following is a list of things that were once considered new hacks or that are good examples demonstrating the concept:

- **[bit hacks](bit_hack.md)**: Clever manipulations of [bits](bit.md) -- for example it is possible to swap two variable without a temporary variables by using the [xor](xor.md) function. Another simplest example is implementing division by 2 as binary shift by 1 (this hack is used in real life by people for quickly dividing by 10, we just remove the last digit).
- **[copyleft](copyleft.md)**: A legal hack by [Richard Stallman](rms.md), connected to [free software](free_software.md), working on the basis of the following idea: "If [copyright](copyright.md) lets me put any conditions on my work, I may impose a condition on my work that says that any modified version must not impose any restrictive conditions".
- In minimalist [C](c.md) programming mainly two standards of the language are used: C89 and C99. To distinguish between them in source code one can e.g. exploit the fact that C99 introduced line comments (starting with `//`) and make such code that C99 sees part of it commented out while C89 doesn't. For example the following two lines: `int isC89 = 1 //**/ 2`, `; isC89 = !isC89;`.
- **[fast inverse square root](fast_inverse_sqrt.md)**: Famous hack that was used in the [game](game.md) Quake, it [approximates](approximation.md) an inverse of [square root](sqrt.md) of a [floating point](float.md) number by treating it as an integer and bashing it with a [magic constant](magic_constant.md), which is about four times faster than computing the value with the obvious floating point division.
- **memory [rape](rape.md) in [C](c.md)**: E.g. instead of doing proper memory allocation with potentially inefficient and bloated `malloc` one may try to do a custom memory allocation without any libraries by abusing allocation on stack -- allocate a variable size array in main, set some global pointer to it and then manage this chunk of memory with your own allocation functions.
- **actually portable executable** (https://justine.lol/ape.html): Justine Tunney found a way to create an executable format that passes as a valid NATIVE executable on all major systems including [GNU](gnu.md)/[Linux](linux.md), [Windows](windows.md) and [Mac](mac.md), i.e. it is possible to compile a native program (e.g. with [C](c.md)) and then have it natively run on any major OS.
- **[game of life](game_of_life.md) patterns**: Stable patterns such as glider or even programming game of life in game of life is a nice example of game hacking -- in fact exactly game of life hacking stood at the beginning of hacker culture.
- **[bytebeat](bytebeat.md)**: A [demoscene](demoscene.md) hack that utilizes integer [overflows](overflow.md) to create rhythm and produce music.
- Computer [graphics](graphics.md) uses many clever tricks that could possibly be called hacks, e.g. in times when 3D graphics was primitive and didn't allow achieving such effects as mirror reflections easily, some [games](game.md) faked mirrors simply with a hole in the wall behind which the whole mirrored room was placed -- this achieved the same effect as a mirror and didn't require any extra rendering passes or shaders.
- **[quine](quine.md)**: A cleverly constructed self-replicating program in [programming language](programming_language.md) that prints its own source code -- this is a common exercise of language hackers.
- **MetaGolfScript [esoteric languages](esolang.md)**: rather than being a nicely designed [code golfing](code_golf.md) language MetaGolfScript invents infinitely many languages, each of which solves one problem with a zero-length program, making it possible to win any golfing contest that allows arbitrary choice of language just by choosing the correct MetaGolfScript language.
- **Appending "in Minecraft" to avoid legal responsibility**: some people try to avoid legal responsibility for threats by talking about the situation as if it was harmlessly happening in a video game such as Minecraft, for example "Bitch I'm going to come to your house and murder you in sleep, in Minecraft." Though this is a nice hack and should work, the dystopian governments can do whatever they want and still arrest you for this -- this happened e.g. in New Jersey when one guy threatened to kill a sheriff like this.
- **[polyglot](polyglot.md) programs**: another fun activity by programming language enthusiasts; a polyglot is source code that's a valid in more than one programming language.
- [Richard Stallman](rms.md) called some musical compositions hacks, specifically 4'33 (just silence) and Ma Fin Est Mon Commencement ([palindromic](palindrome.md) music).
- TODO: moar

## See Also

- [demoscene](demoscene.md)
- [cracking](cracking.md)
- [databending](databending.md)
