# Good Enough

A good enough solution to a problem is a solution that solves the problem satisfyingly (not necessarily precisely or completely) while achieving minimal cost (effort, complexity, [maintenance](maintenance.md), implementation time etc.). This is contrasted with an [overkill](overkill.md), a solution that's "too good" (for a higher cost). For example a word-for-word translation of a text is a primitive way of translation, but it may be good enough to understand the meaning of the text; in many climates a tent is a good enough accommodation solution while a luxury house is a solution of better quality (more comfortable, safe, ...) for a higher cost. It's been said that the [perfect is the enemy of good](perfect_is_the_enemy_of_good.md).

To give an example from the world of programming, [bubble sort](bubble_sort.md) is in many cases better than quick sort for its simplicity, even though it's much slower than more advanced sorts. [ASCII](ascii.md) is mostly good enough compared to [Unicode](unicode.md). And so on.

In technology we are often times looking for good enough solution to achieve [minimalism](minimalism.md) and save valuable resources (computational resources, programmer time etc.). It rarely makes sense to look for solutions that are more expensive than they necessarily need to be, however in the context of [capitalist software](capitalist_software.md) we see this happen many times as a part of killer feature battle and also driving prices artificially up for economic reasons (e.g. increasing the cost of maintenance of a software eliminates any competition that can't afford such cost). An example of this is the trend in smartphones to have 4 and more physical cameras. This is only natural in [capitalism](capitalism.md), we see the tendency for wasting resources everywhere. This of course needs to be stopped.