# Free Culture

Free (as in freedom) culture is a movement aiming for the relaxation of [intellectual property](intellectual_property.md) restrictions, mainly that of [copyright](copyright.md), to allow free usage, reusing and sharing of [artworks](art.md) and other kind of [information](information.md). Free culture argues that our society has gone too far in forcefully restricting the natural freedom of information by very strict laws (e.g. by authors holding copyright even 100 years after their death) and that we're hurting art, creativity, education and progress by continuing to strengthen restrictions on using, modifying ([remixing](remix.md)) and sharing things like [books](book.md), [music](music.md) and scientific papers. The word "free" in free culture refers to freedom, not just price -- free cultural works have to be more than just available gratis, they must also give its users some specific legal rights. Nevertheless free culture itself isn't against commercialization of art, it just argues for rather doing so by other means than selling legal rights to it. The opposite of free culture is [permission culture](permission_culture.md) (culture requiring permission for reuse of intellectual works).

The promoters of free culture want to relax intellectual property laws ([copyright](copyright.md), [patents](patent.md), [trademarks](tm.md) etc.) but also promote an ethic of sharing and remixing being good (as opposed to the demonizing anti-"[piracy](piracy.md)" propaganda of today), they sometimes mark their works with words **"some rights reserved"** or even "no rights reserved", as opposed to the traditional "all rights reserved".

Free culture is kind of a younger sister movement to the **[free software](free_software.md)** movement, in fact it has been inspired by it (we could call it its [fork](fork.md)). While free software movement, established in 1983, was only concerned with freedoms relating to computer program source code, free culture later (around 2000) took its ideas and extended them to all information including e.g. artworks and scientific data. There are **clearly defined criteria** for a work to be considered free (as in freedom) work, i.e. part of the body of free cultural works. The criteria are very similar to those of free software (the definition is at https://freedomdefined.org/Definition) and can be summed up as follows:

A free cultural work must allow anyone to (legally and practically):

1. **Use it** in any way and for any purpose, even commercially. 
2. **Study it**.
3. **Share it**, i.e. redistribute copies, even commercially.
4. **Modify it** and redistribute the modified copies, even commercially.

Some of these conditions may e.g. further require a source code of the work to be made available (e.g. sheet music, to allow studying and modification). Some conditions may however still be imposed, as long as they don't violate the above -- e.g. if a work allows all the above but requires crediting the author, it is still considered free (as in freedom). [Copyleft](copyleft.md) (also share-alike, requirement of keeping the license for derivative works) is another condition that may be required. This means that many (probably most) free culture promoters actually rely and even support the concept of e.g. copyright, they just want to make it much less strict.

IMPORTANT NOTE: **[fair use](fair_use.md) (or exclusive author permission) is unacceptable in free culture!** It is an extremely common mistake, happening even among people long contributing to free culture, to think that within free culture you can use a piece of proprietary art under so called *fair use* while keeping the whole work adhering to free culture -- you cannot do this (even though e.g. [Wikipedia](wikipedia.md) does this for which it actually seizes to be a completely free work). Fair use is a legal concept that allows people to use any kind of art -- even proprietary -- in some "fair" ways even without the permission of the copyright holder, i.e. for example you can likely use someone's copyrighted photograph on your website as long as you have a good justification for it (e.g. documenting a historical event with this being the only existing photo of it), if you only include a low resolution version and if you're not making money off of it -- this could be judged fair use by the court, i.e. you wouldn't be violating copyright. However a work that is to be free licensed must allow ANY use, not just fair use, i.e. it mustn't contain any part under fair use, or even under EXCLUSIVE author's permission for it to be used within that project, because such part would only limit the work to be used in the "fair use" way ONLY. While in some contexts, e.g. in hobbyist projects, such work will likely be legal, i.e. fair use, in other context, like commercial ones (which free culture MUST enable), this fair use part will suddenly seize to be fair use and the use will be illegal. Similarly if you e.g. want to use someone's music in your free culture movie, it is NOT enough to get the author's permission to use the music in your movie, the author has to give permission to EVERYONE to use it in ANY WAY, because if your movie is to be under a free license, anyone will be able to take any part out of your movie and use it in any other way. { I actually managed to get some characters out of the [SuperTuxKart](supertuxkart.md) game for this reason, there were some mascots that were used under exclusive permission, which was unacceptable and Debian maintainers sorted this out. So just for the confirmation of this fact: Debian also confirmed this. ~drummyfish }

It was in 2001 when **[Lawrence Lessig](lessig.md)**, an American lawyer who can be seen as the movement's founder, created the **[Creative Commons](creative_commons.md)**, a non-profit organization which stands among the foundations of the movement and is very much connected to it. By this time he was already educating people about the twisted intellectual property laws and had a few followers. Creative Commons would create and publish a set of [licenses](license.md) that anyone could use to release their works under much less restrictive conditions than those that lawfully arise by default. For example if someone creates a song and releases it under the [CC-BY](cc_by.md) license, he allows anyone to freely use, modify and share the song as long as proper attribution is given to him. It has to be noted that **NOT all Creative Commons licenses are free culture** (those with NC and ND conditions break the above given rules)! It is also possible to use other, non Creative Commons licenses in free culture, as long as the above given criteria are respected.

In 2004 Lessig published his **book** called Free Culture that summarized the topic as well as proposed solutions -- the book itself is shared under a Creative Commons license and can be downloaded for free (however the license is among the non-free CC licenses so the book itself is not part of free culture [lmao](lmao.md), big fail by Lessig).

{ I'd recommend reading the Free Culture book to anyone whose interests lie close to free culture/software, it's definitely one of the essential works. ~drummyfish }

In the book Lessig gives an overview of the history of copyright -- it has been around since about the time of invention of [printing press](printing_press.md) to give some publishers exclusive rights (an artificial [monopoly](monopoly.md)) for printing and publishing certain books. The laws evolved but at first were not so restrictive, they only applied to very specific uses (printing) and for limited time, plus the copyright had to be registered. Over time corporations pressured to make it more and more restrictive -- nowadays copyright applies to basically everything and lasts for 70 years AFTER the death of the author (!!!). This is combined with the fact that in the age of computers any use of information requires making a copy (to read something you need to download it), i.e. copyright basically applies to ANY use now. I.e. both scope and term of copyright have been extended to the extreme, and this was done even AGAINST the US constitution -- Lessig himself tried to fight against it in court but lost. This form of copyright now restricts culture and basically only serves corporations who want to e.g. **kill the [public domain](public_domain.md)** (works that run out of copyright and are now "free for everyone") by repeatedly prolonging the copyright term  so that people don't have any pool of free works that would compete (and often win simply by being gratis) with the corporate created "content". In the books Lessig also mentions many hard punishments for breaking copyright laws and a lot of other examples of corruption of the system. He then goes on to propose solutions, mainly his Creative Commons licenses.

Free culture has become a relative success, the free Creative Commons licenses are now widely used -- **[Wikipedia](wikipedia.md) is one of the most famous examples of free culture** as it is licensed under the [CC-BY-SA](cc_by_sa.md) and its sister project [Wikimedia Commons](wm_commons.md) hosts over 80 million free cultural works! [Openstreetmap](osm.md) is a free cultural collaborative project offering maps of the whole world, [libregamewiki](lgw.md) and [opengameart](oga.md) are sites focused on creation of free cultural video games and game assets and there are many more. There are famous promoters of free culture such as [Nina Paley](nina_paley.md), there exist webcomics, books, songs etc. In development of libre [games](game.md) free cultural licenses are used (alongside free software licenses) to liberate the game assets -- e.g. the [Freedoom](freedoom.md) project creates free culture content replacement for the game [Doom](doom.md). Many scientists release their data to public domain under [CC0](cc0.md). And of course, [LRS](lrs.md) highly advocated free culture, specifically [public domain](public_domain.md) under [CC0](cc0.md).

**BEWARE of fake free culture**: there are many resources that look like or even call themselves "free culture" despite not adhering to its rules. This may be by intention or not, some people just don't know too much about the topic -- a common mistake is to think that all Creative Commons licenses are free culture -- again, this is NOT the case (the NC and ND ones are not). Some think that "free" just means "gratis" -- this is not the case (free means freedom, i.e. respecting the above mentioned criteria of free cultural works). Many people don't know the rules of copyright and think that they can e.g. create a remix of some non-free pop song and license it under CC-BY-SA -- they CANNOT, they are making a derivative work of a non-free work and so cannot license it. Some people use licenses without knowing what they mean, e.g. many use CC0 and then ask for their work to not be used commercially -- this can't be done, CC0 specifically allows any commercial use. Some try to make their own "licenses" by e.g. stating "do whatever you want with my work" instead of using a proper waiver like CC0 -- this is with high probability legally unsafe and invalid, it is unfortunately not so easy to waive one's copyright -- DO use the existing licenses. Educate yourself and if you're unsure, ask away in the community, people are glad to give advice.

## See Also

- [free software](free_software.md)
- [free universe](free_universe.md)
- [freedom distance](freedom_distance.md)
- [copyfree](copyfree.md)
- [kopimi](kopimi.md)