# Doom

Doom is a legendary video [game](game.md) released in December [1993](1990s.md), perhaps the most famous video game of all time, the game that popularized the [first man shooter](first_person_shooter.md) genre and shocked by its at the time extremely advanced [3D](pseudo_3D.md) graphics (yes, **Doom is 3D**) and caused one of the biggest revolutions in video game history. It was made by [Id Software](id_software.md), most notably by [John Carmack](john_carmack.md) (graphics + engine programmer) and [John Romero](john_romero.md) (tool programmer + level designer) -- all in all the game was developed by about 5 to 6 men in about a year. Doom is sadly [proprietary](proprietary.md), it was originally distributed as [shareware](shareware.md) (a gratis "demo" was available for playing and sharing with the option to buy a full version). However the game engine was later (1999) released as [free (as in freedom) software](free_software.md) under [GPL](gpl.md) which gave rise to many source [ports](port.md) and "improved" "[modern](modern.md)" engines (which however look like shit, the original looks by far the best, if you want to play Doom use Chocolate Doom or Crispy Doom, avoid anything with GPU rendering). The assets remain non-free but a completely free alternative is offered by the [Freedoom](freedoom.md) project that has created [free as in freedom](free_culture.md) asset replacements for the game. [Anarch](anarch.md) is an official [LRS](lrs.md) game inspired by Doom, completely in the [public domain](public_domain.md). Doom named a whole generation of so called [doomers](doomer.md).

Doom has a cool wiki at https://doomwiki.org.

{ Great books about Doom I can recommend: *Masters of Doom* (about the development) and *Game Engine Black Book: Doom* (details about the engine internals). ~drummyfish }

Partially thanks to the release of the engine under a [FOSS](foss.md) license and its relatively [suckless](suckless.md) design ([C](c.md) language, [software rendering](sw_rendering.md), ...), Doom has been [ported](port.md), both officially and unofficially, to a great number of platforms (e.g. [Gameboy Advance](gba.md), [PS1](playstation.md), even [SNES](snes.md)) and has become a kind of **de facto standard [benchmark](benchmark.md)** for computer platforms -- you will often hear the phrase: **"but does it run Doom?"** Porting a Doom to any platform has become kind of a [meme](meme.md), someone allegedly even ported it to a pregnancy test (though it didn't actually run on the test, it was really just a display). { Still [Anarch](anarch.md) may be even more portable than Doom :) ~drummyfish }

The major leap that Doom engine's graphics brought was unprecedented, however Doom was not just a game with good graphics, it had extremely good gameplay, legendary [music](music.md) and art style and introduced the revolutionary [deathmatch](deathmatch.md) multiplayer (the name *deathmatch* itself was coined by Romero during Doom multiplayer sessions), as well as a HUGE modding and mapping community. It was a success in every way -- arguably no other game has since achieved a greater revolution than Doom (no, not even [Minecraft](minecraft.md), [World of Warcraft](wow.md) etc.). Many reviews of it just went along the lines: "OK, Doom is the best game ever made, now let's just take a look at the details...". The game's style was also extremely cool, as were the developers themselves, Doom was very appealing by its sincere style of simply being a pure metal/bloody/gory/demon slaying shooter without any corporate garbage stuffed in for more popularity that you'd see today. It was simply a game made by a few guys who did it the way they liked it without giving shit about anything, you won't see that anymore, Doom simply didn't pretend to be some kind of pompous, glorious work and so for example didn't give much shit about the backstory, everyone knew the game was about shooting and so they just made it a bloody shooter. John Carmack famously stated that story in a video game is like story in a porn movie -- it's expected to be there but not very important. Nowadays you may see developers try to imitate this attitude but it's always laughable, it will only ever be a pretense because the times when you could simply make a game with artistic freedom, without having to bow to managers, gender departments, publishers and other overlords are simply long gone.

Doom wasn't the first 3D game, nor was it the first FPS, there were games before that were "more 3D" in a sense -- for example flight simulators -- what was special about Doom was how it used all the graphic tricks and combined them with excellent gameplay to achieve unprecedented "immersion", such that many weren't ready for. For example Doom had fully textured environments, including floors and ceilings, which along with the fog and lighting made the player really feel present in the game despite not being able to e.g. look up and down.

As stated, the game's backstory was simple and didn't stand in the way of gameplay, it's basically about a tough marine (so called *Doomguy*) on a Mars military base slaying hordes of demons from hell, all in a rock/metal style with a lot of gore and over-the-top violence (chain saws n stuff).

Doom was followed by Doom II in 1995, which "content-wise" was basically just a data disc, the same game with new levels and some minor additions. Later there were some other releases and rereleases, notable is Doom III from 2004, Doom 2016 ("reboot") and Doom: Eternal (2020).

Some **[interesting](interesting.md) things** about Doom:

- Someone created a Doom system monitor for [Unix](unix.md) systems called [psDooM](psdoom.md) where the monsters in game are the operating system [processes](process.md) and killing the monsters kills the processes.
- Someone (kgsws) has been [hacking](hacking.md) the ORIGINAL Doom engine in an impressive way WITHOUT modifying the source code or the binary, rather using [arbitrary code execution](arbitrary_code_execution.md) bug; he added very advanced features known from newer source ports, for example an improved 3D rendering algorithms allowing geometry above geometry etc. (see e.g. https://yt.artemislena.eu/watch?v=RdbRPNPUWlU). It's called the Ace engine.
- Doom sprites were made from photos of physical things: weapons are modified photos of toys, enemies were made from clay and then photographed from multiple angles (actually a great alternative to [3D modeling](3d_model.md) that's less dependent on computers and produces more realistic results).
- The strongest weapon in the game is name BFG9000, which stands for "big fucking gun".
- TODO

## Doom Engine/Code

*See also [game engine](game_engine.md) for the list of different Doom engines.*

Doom source code is written in [C89](c.md) and is about 36000 [lines of code](loc.md) long. The original system requirements stated roughly a 30 MHz [CPU](cpu.md) and 4 MB [RAM](ram.md) as a minimum. It had 27 levels (9 of which were shareware), 8 weapons and 10 enemy types. The engine wasn't really as flexible in a way "[modern](modern.md)" programmers expect, many things were hard coded, there was no [scripting](script.md) or whatever (see? you don't fucking need it), new games using the engine had to usually modify the engine internals.

The code itself looks alright, files are nicely organized into groups by their prefix (`g_`: game, `r_`: rendering, `s`: sound etc.). The same goes for the function names. There seems to be tabs mixed with spaces though, sometimes a bit shitty formatting, but overall MUCH better than [duke 3D](duke3D)'s code (well, that doesn't say much though). [Comments](comment.md) are plentiful.

The game only used [fixed point](fixed_point.md), no [float](float.md)!

The **Doom engine** (also called *id Tech 1*) was revolutionary and advanced (not only but especially) video game graphics by a great leap, considering its predecessor [Wolf3D](wolf3D.md) was really primitive in comparison (Doom basically set the direction for future trends in games such as driving the development of more and more powerful [GPUs](gpu.md) in a race for more and more impressive visuals). Doom used a technique called **[BSP rendering](bsp.md)** (levels were made of convex 2D sectors that were then placed in a BSP tree which helped quickly sort the walls for rendering front-to-back) that was able to render [realtime](realtime.md) 3D views of textured (all walls, floors and ceilings) environments with primitive lighting (per-sector plus diminishing lighting), enemies and items represented by 2D [billboards](billboard.md) ("[sprites](sprite.md)"). No [GPU](gpu.md) acceleration was used, graphics was rendered purely with [CPU](cpu.md) (so called [software rendering](sw_rendering.md), GPU rendering would come with Doom's successor [Quake](quake.md), and would also later be brought to Doom by newer community made engines, though the original always looks the best). This had its limitations, for example the camera could not look up and down, there could be no tilted walls and the levels could not have rooms above other rooms. The geometry of levels was only static, i.e. it could not change during play (only height of walls could), because rendering was dependent on precomputed BSP trees (which is what made it so fast). For these reasons some call Doom "[pseudo 3D](pseudo3d.md)" or 2.5D rather than "true 3D", some retards took this even as far as calling Doom 2D with its graphics being just an "illusion", as if literally every 3D graphics ever wasn't a mere illusion. Nevertheless, though with limitations, Doom did present 3D views and internally it did work with 3D coordinates (for example the player or projectiles have 2D position plus height coordinate), despite some dumb YouTube videos saying otherwise. For this reason we prefer to call Doom a **primitive 3D** engine, but 3D nonetheless. Other games later used the Doom engine, such as Heretic, Hexen and Strife. The Doom engine was similar to and competing with [Build](build_engine.md) engine that ran games like [Duke Nukem 3D](duke_3d.md), Blood and Shadow Warrior. All of these 90s shooters were amazing in their visuals and looked far better than any [modern](modern.md) shit. Build engine games had similar limitations to those of the Doom engine but would improve on them (e.g. faking looking up and down by camera tilting, which could in theory be done in Doom too, or allowing sloped floor and dynamic level geometry).

Indexed ([palette](palette.md)) mode with "only" 256 colors was used for rendering. Precomputed color tables were used to make dimming of colors faster. Similarly a [look up table](lut.md) was used for [random number generation](rng.md) -- two independent [pseudorandom](pseudorandomness.md) generators are present, one is used for things such as visual effects while the other one is utilized purely for the game simulation so that it stays deterministic independently on graphics etc.

Doom also has a [deterministic](determinism.md) [FPS](fps.md)-independent physics which allows for efficient recording of [demos](demo.md) of its gameplay and creating [tool assisted speedruns](tas.md), i.e. the time step of game simulation is fixed (35 tics per second). Such demos can be played back in high quality while being minuscule in size and help us in many other ways, for example for verifying validity of [speedruns](speedrun.md). This is very nice and serves as an example of a well written engine (unlike later engines from the same creators, e.g. those of [Quake](quake.md) games which lacked this feature -- here we can see how things get progressively shittier in computer technology as we go forward in time).

There is no [antialiasing](antialiasing.md) in the engine, i.e. aliasing can be noticed on far-away textures, but it is suppressed by the use of low-res textures and dimming far-away areas. There is also no edge smoothing (kind of misleadingly known as "antialiasing") in the geometry rendering, the engine is [subpixel](subpixel.md) accurate in rendering of the top and bottoms of the walls, i.e. the line these boundaries form may result in rasterizing slightly different pixels even if the start and end pixel is the same, depending on the subpixel position of the start and endpoint -- this feature doesn't much help in static screenshots but makes animation nicer.

## See Also

- [Anarch](anarch.md)
- [Duke 3D](duke3d.md)
- [Gloom](gloom.md) (fun [Amiga](amiga.md) Doom clone)
- [Quake](quake.md)
- [Jedi engine](jedi_engine.md)
- [Build engine](build_engine.md)
- [Chasm: The Rift](chasm_the_rift.md)
- [raycasting](raycasting.md)
