# Democracy

Democracy (also *democrazy*) stands for *rule of the people*, it is a form of [government](government.md) that somehow lets all citizens collectively make political decisions, which is usually implemented by voting but possibly also by other means. The opposite of democracy is [autocracy](autocracy.md) (for example [dictatorship](dictatorship.md)), the absolute rule of a single individual; possible yet greater opposite of democracy is final stage [capitalism](capitalism.md), rule of no people at all, with money enslaving everyone. It can also be contrasted with [oligarchy](oligarchy.md), the rule of a few (e.g. [plutocracy](plutocracy.md), the rule of the rich, which we see under advanced [capitalism](capitalism.md)). Democracy may take different forms, e.g. direct (people directly vote on specific questions) or representative (people vote for officials who then make decisions on their behalf).

**Democracy does NOT equal voting**, even though this simplification is too often made. Voting doesn't imply democracy and democracy doesn't require voting, an alternative to voting may be for example a [scientifically](science.md) made decision. Democracy in the wide sense doesn't even require a [state](state.md) or legislation -- true democracy simply means that rules and actions of a society are controlled by all the people and in a way that benefits all the people. Even though we are led to believe we live in democratic society, the truth is that a large scale largely working democracy has never been established and that nowadays most of so called democracy is just an illusion as society clearly works for the benefit of the few richest and most powerful people while greatly abusing everyone else, especially the poorest majority of people. **We do NOT live in true democracy**. A true democracy would be achieved by ideal models of society such as those advocated by (true) [anarchism](anarchism.md) or [LRS](less_retarded_society.md), however some anarchists may be avoiding the use the term democracy as that in many narrower contexts implies an existence of government.

Nowadays the politics of most first world countries is based on elections and voting by people, but despite this being called democracy by the propaganda the reality is [de facto](de_facto.md) not a democracy but rather an [oligarchy](oligarchy.md), the **rule THROUGH the people**, creating an illusion of democracy which however lacks a real choice (e.g. the [US](usa.md) two party system in which people can either vote for capitalists or capitalists) or pushes the voters towards a certain choice by huge propaganda, misinformation and manipulation. Take one example from [Czechia](czechia.md), a so called "democratic" country -- in the 90s it adopted capitalism and as capitalism progresses, the age at which you can retire is getting higher and higher, recently getting very close to your life expectancy -- do you think anyone from the people wants this? Ask literally anyone if he wants to work until death, 1000 people of 1000 will tell you they don't want retirement age to increase. Why then -- if will of people should be realized under "democracy" -- is it happening? Because in reality the country is ruled by 5 richest people in it and these want everyone to work until death, so that's what will happen. That's what they call "democracy".

Also nowadays democracy has mostly degenerated to "let's bully those who disagree with majority", i.e. "rule of the mainstream" (and of course, the mainstream is fully controlled by handful of rich etcetc.).

Small brain simplification of democracy to mere "voting" may be highly ineffective and even dangerous. Democracy was actually considered to be very weak or even downright bad by many Greek philosophers such as Plato and Aristotle. We have to realize that **sometimes voting is awesome, but sometimes it's an extremely awful idea**. Why? Consider the two following scenarios:

- **On simple issues wisdom of the crowd work very well**, as demonstrated by the famous experiment in which averaging guesses of many people on a number of beans in a jar resulted in an extremely precise estimate, a much more precise than any man alone could give. This is an example of when voting is the superior solution to making a decision.
- **Non-experts voting on complex issues and voting on issues requiring large vision is a disaster** (which is why we mostly don't have direct democracy but rather representative one). Many retarded rightists believe direct democracy would somehow be "better" -- no, it would indeed be infinitely worse to let braindead rednecks vote on complex issues. When a [chess](chess.md) grandmaster plays against thousands of people who make moves by voting, the master easily wins, as demonstrated e.g. by the Karpov vs the World (or Twitch plays Pokémon lol) experiment (later projects such as Kasparov vs the World had to somehow moderate and filter the move votes to give the world a chance). The reason is that the majority of weak moves voted by non-experts outweight the few good votes of experts, but also ADDITIONALLY even if only expert votes are takes, the result may be inferior because different long-term plans and visions will collide with the long term plans of others, which is probably the reason why e.g. Romans used to elect a single dictator in times of a crisis rather than relying on a council of experts. In such cases democracy may be similar to wanting to create a nice picture by averaging all pictures ever made by all people, the result will probably be just an ugly gray noisy blob (imagine e.g. creating a picture by having many pictures "vote" on color of every pixel simply by voting for the color they have on the same pixel position { Actually I've tried this now and yes, it looks just like a noisy gray blob. ~drummyfish } ). This is why it's a very bad idea to have people vote directly e.g. on complex economic or diplomatic issues. We have to say [we](we.md) do NOT advocate for dictators (we are anarchists) -- we rather believe in implementing a [decentralized](decentralization.md), self-regulating society in which we avoid the need for any dictators or governments.

The democracy **[paradox](paradox.md)**: what happens when it is democratically decided that democracy is not a good tool for decision making? I.e. what if democracy denies its own validity? If we believe democracy is valid, then we have to accept its decision and stop believing in democracy, but then if we stop believing in democracy we can just reject the original decision because it was made by something that's not to be trusted, but then...