# Deferred Shading

In computer [graphics](graphics.md) programming deferred shading is a technique for speeding up the rendering of (mainly) [shaded](shading.md) 3D graphics (i.e. graphics with textures, materials, [normal maps](normal_mapping.md) etc.). It is nowadays used in many advanced 3D engines. In principle of course the idea may also be used in 2D graphics and outside graphics.

The principle is following: in normal forward shading (non-deferred) the shading computation is applied immediately to any rendered pixel (fragment) as they are rendered. However, as objects can overlap, many of these expensively computed pixels may be overwritten by pixels of other objects, so many pixels end up being expensively computed but invisible. This is of course wasted computation. Deferred shading only computes shading of the pixels that will end up actually being visible -- this is achieved by **two rendering passes**:

1. At first geometry is rendered without shading, only with information that is needed for shading (for example [normals](normal.md), material IDs, texture IDs etc.). The rendered image is stored in so called G-buffer which is basically an image in which every pixel stores the above mentioned shading information.
2. The second pass applies the shading effects by applying the pixel/fragment [shader](shader.md) on each pixel of the G-buffer.

This is especially effective when we're using very expensive/complex pixel/fragment shaders AND we have many overlapping objects. **Sometimes deferred shading may be replaced by simply ordering the rendered models**, i.e. rendering front-to-back, which may achieve practically the same speed up. In simple cases deferred shading may not even be worth it -- in [LRS](lrs.md) programs we may use it only rarely.

Deferred shading also comes with complications, for example **rasterization [anti aliasing](anti_aliasing.md) can't be used** because, of course, anti-aliasing in G-buffer doesn't really make sense. This is usually solved by some [screen-space](screen_space.md) antialiasing technique such as [FXAA](fxaa.md), but of course that may be a bit inferior. **Transparency also poses an issue**.