# Copyright

*"When copying is outlawed, only outlaws will have culture."* --[Question Copyright website](https://questioncopyright.org/)

Copyright (better called *copyrestriction*, *copyrape* or *copywrong*) is one of many types of so called "[intellectual property](intellectual_property.md)" (IP), a legal concept that allows "ownership", i.e. restriction, [censorship](censorship.md) and artificial [monopoly](monopoly.md) on certain kinds of [information](information.md), for example prohibition of sharing or viewing useful [information](information.md) or improving [art](art.md) works. Copyright specifically allows the copyright holder (not necessarily the author) a monopoly (practically absolute power) over [art](art.md) creations such as images, songs or texts, which also include source code of computer [programs](program.md). Copyright is a [capitalist](capitalism.md) mechanism for creating [artificial scarcity](artificial_scarcity.md), enabling censorship and elimination of the [public domain](public_domain.md) (a pool of freely shared works that anyone can use and benefit from). It is a mechanism that by definition smothers true, useful [progress](progress.md) -- in a world that advanced technologically so much that it is already possible to freely copy and share information instantly, with zero cost, with anyone anywhere, copyright tries to set up artificial measures to prevent this so as to keep the old ways of allowing only the privileged to copy and publish intellectual works, it is quite literally force sustaining mechanism of Middle Ages. Copyright is not to be confused with [trademarks](trademark.md), [patents](patent.md) and other kinds of "intellectual property", which are similarly [harmful](harmful.md) but legally different. Copyright is symbolized by C in a circle or in brackets: (C), which is often accompanies by the phrase "all rights reserved".

When someone creates something that can even remotely be considered artistic expression (even such things as e.g. a mere collection of already existing things), he automatically gains copyright on it, without having to register it, pay any tax, announce it or let it be known anywhere in any way. He then practically has a full control over the work and can successfully sue anyone who basically just touches the work in any way (even unknowingly and unintentionally). Therefore **any work (such as computer code) without a [free](free_software.md) license attached is implicitly fully "owned" by its creator** (so called "all rights reserved") and can't be used by anyone without permission. It is said that copyright can't apply to ideas (ideas are covered by [patents](patent.md)), only to expressions of ideas, however that's [bullshit](bs.md), the line isn't clear and is arbitrarily drawn by judges; for example regarding stories in books it's been established that the story itself can be copyrighted, not just its expression (e.g. you can't rewrite the [Harry Potter](harry_potter.md) story in different words and start selling it).

As if copyright wasn't bad enough of a [cancer](cancer.md), **there usually exist extra oppressive copyright-like restrictions called related rights or neighboring rights  such as "[moral rights](moral_rights.md)", "[personal rights](personal_rights.md)" etc.** Such "rights" differ a lot by country and can be used to restrict and censor even copyright-free works. This is a stuff that makes you want to commit [suicide](suicide.md). Waivers such as [CC0](cc0.md) try to waive copyright as well as neighboring rights (to what extent neighboring rights can be waived is debatable though).

The current extreme form of copyright (as well as other types of IP such as software patents) has been highly criticized by many people, even those whom it's supposed to "protect" (small game creators, musicians etc.). Strong copyright laws basically benefit mainly [corporations](corporation.md) and "trolls" on the detriment of everyone else. It smothers creativity and efficiency by prohibiting people to reuse, remix and improve already existing works -- something that's crucial for art, science, education and generally just making any kind of progress. Most people are probably for *some* form of copyright but still oppose the current extreme form which is pretty crazy: **copyright applies to everything without any registration or notice and last usually 70 years (!!!) AFTER the author has died (!!!)** and is already rotting in the ground. This is 100 years in some countries. In some countries it is not even possible to waive copyright to own creations -- just think about what kind of twisted society we are living in when it PROHIBITS people from making a selfless donation of their own creations to others. Some people, including [us](lrs.md), are against the very idea of copyright (those may either use waivers such as [CC0](cc0.md) or [unlicense](unlicense.md) or protest by not using any licenses and simply ignoring copyright which however will actually discourage other people from reusing their works). Though copyright was originally intended to ensure artists can make living with their works, it has now become the tool of states and corporations for universal censorship, control, bullying, surveillance, creating scarcity and [bullshit jobs](bullshit_job.md); states can use copyright to for example take down old politically inconvenient books shared on the Internet even if such takedowns do absolute not serve protection of anyone's living but purely political interests.

Prominent critics of copyright include [Lawrence Lessig](lessig.md) (who established [free culture](free_culture.md) and [Creative Commons](creative_commons.md) as a response), [Nina Paley](nina_paley.md) and [Richard Stallman](rms.md). There are many movements and groups opposing copyright or its current form, most notably e.g. the [free culture](free_culture.md) movement, [free software](free_software.md) movement, [Creative Commons](creative_commons.md) etc.

The book *Free Culture* by Lessig talks, besides others, about how copyright has started and how it's been shaped by corporations to becoming their tool for monopolizing art. The concept of copyright has appeared after the invention of [printing press](printing_press.md). The so called *Statute of Anne* of 1710 allowed the authors of books to control their copying for **14 years** and only after **registartion**. The term could be prolonged by anothert 14 years if the author survived. The laws started to get more and more strict as control of information became more valued and eventually the term grew to **life of author plus 70 years**, without any need for registration or deposit of the copy of the work. Furthermore with new technologies, the scope of copyright has also extended: if copyright originally only limited *copying* of books, in the Internet age it started to cover basically any use, as any manipulation of [digital](digital.md) data in the computer age requires making local copies. Additionally the copyright laws were passing despite being unconstitutional as the US constitution says that copyright term has to be finite -- the corporations have found a way around this and simply regularly increased the copyright's term, trying to make it [de-facto](de_facto.md) [infinite](infinity.md) (technically not infinite but ever increasing). Their reason, of course, was to firstly forever keep ownership of their own art but also, maybe more importantly, to **kill the [public domain](public_domain.md)**, i.e. prevent old works from entering the public domain where they would become a completely free, unrestricted work for all people, competing with their [proprietary](proprietary.md) art (who would pay for movies if there were thousands of movies available for free?). Nowadays, with coprporations such as [YouTube](youtube.md) and [Facebook](facebook.md) de-facto controlling most of infromation sharing among common people, the situation worsens further: they can simply make their own laws that don't need to be passed by the government but simply implemented on the platform they control. This way they are already killing e.g. the right to [fair use](fair_use.md), they can simply remove any content on the basis of "copyright violation", even if such content would normally NOT violate copyright because it would fall under fair use. This would normally have to be decided by court, but a corporation here itself takes the role of the court. So in terms of copyright, corporations have now a greater say than governments, and of course they'll use this power against the people (e.g. to implement censorship and surveillance).

Copyright rules differ greatly by country, most notably the US measures copyright length from the publication of the work rather than from when the author died. It is possible for a work to be copyrighted in one country and not copyrighted in another. It is sometimes also very difficult to say whether a work is copyrighted because the rules have been greatly changing (e.g. a notice used to be required for some time), sometimes even retroactively copyrighting public domain works, and there also exists no official database of copyrighted works (you can't safely look up whether your creation is too similar to someone else's). All in all, copyright is a huge mess, which is why we choose [free licenses](free_software.md) and even [public domain](public_domain.md) waivers.

In some countries copyright terrorists already establishes a kind of tax that is paid when buying a storage device such as a USB stick -- it is now assumed the device will be used to share copyrighted material so you pay extra money in advance to copyright holders for this crime you are found guilty of before you commit it. Welcome to [21st century](21st_century.md).

[Copyleft](copyleft.md) (also share-alike) is a concept standing against copyright, a kind of anti-copyright, invented by [Richard Stallman](rms.md) in the context of [free software](free_software.md). It's a license that grants people the rights to the author's work on the condition that they share its further modification under the same terms, which basically [hacks](hacking.md) copyright to effectively spread free works like a "virus".

Copyright does **not** (or at least should not) apply to facts (including mathematical formulas) (even though the formulation of them may be copyrighted), ideas (though these may be covered by [patents](patent.md)) and single words or short phrases (these may however still be [trademarked](trademark.md)) and similarly trivial works. As such copyright can't e.g. be applied to game mechanics of a computer [game](game.md) (it's an idea). It is also basically proven that copyright doesn't cover [computer languages](programming_language.md) (Oracle vs Google). Also even though many try to claim so, copyright does NOT arise for the effort needed to create the work -- so called "sweat of the brow" -- some say that when it took a great effort to create something, the author should get a copyright on it, however this is NOT and must NOT be the case (otherwise it would be possible to copyright mere ideas, simple mathematical formulas, rules of games etc.). Depending on time and location there also exist various peculiar exceptions such as the freedom of panorama for photographs or uncopyrightable utilitarian design (e.g. no one can own the shape of a generic car). But it's never good to rely on these peculiarities as they are specific to time/location, they are often highly subjective, fuzzy and debatable and may even be retroactively changed by law. This constitutes a huge legal [bloat](bloat.md) and many time legal unsafety. Do not stay in the gray area, try to stay safely far away from the fuzzy copyright line.

A work which is not covered by copyright (and any other IP) -- which is nowadays pretty rare due to the extent and duration of copyright -- is in the **[public domain](public_domain.md)**.

[Free software](free_software.md) (and free art etc.) is **not** automatically public domain, it is mostly still copyrighted, i.e. "owned" by someone, but the owner has given some key rights  to everyone with a free software license and by doing so minimized or even eliminated the negative effects of full copyright. The owner may still keep the rights e.g. to being properly credited in all copies of the software, which he may enforce in court. Similarly software that is in public domain is **not** automatically free software -- this holds only if source code for this software is available (so that the rights to studying and modifying can be executed).

**Copyright encourages murder.** The sooner the author dies, the sooner his material will run out of copyright, so if you want some nice work to enter public domain soon, you are literally led by the law to try for him to die as soon as possible.

## See Also

- [bullshit](bullshit.md)
- [trade dress](trade_dress.md)
- ["moral rights"](moral_rights.md)
- [free culture](free_culture.md)
- [copyleft](copyleft.md)
- [derivative work](derivative_work.md)
- [fair use](fair_use.md)
- [creative commons](cc.md)
- [license](license.md)
- [patent](patent.md)
- [trademark](trademark.md)
- [public domain](pd.md)
- [intellectual property](intellectual_property.md)
- [plagiarism](plagiarism.md)






