# Bloat Monopoly

Bloat monopoly is an exclusive control over or [de-facto](de_facto.md) ownership of [software](software.md) or even a whole area of technology not by legal means but by means of [bloat](bloat.md), or generally just abusing bloat in ways that lead to gaining monopolies, e.g. by establishing standards or even legal requirements (such as the EU mandatory content filters) which only the richest may conform to. Even if given software is [FOSS](foss.md) (that is its source code is public and everyone has basic legal rights to it), it can be malicious due to bloat, for example it can still be made **practically** controlled exclusively by the developer because the developer is the only one with sufficient resources and/or know-how to be able to execute the basic rights such as meaningful modifications of the software, which goes against the very basic principle of [free software](free_software.md). Bloat monopoly is seeks to **maximize [freedom distance](freedom_distance.md)**.

**Example**: take a look at the [web](www.md) and how [Google](google.md) is gaining control over it by getting the search engine monopoly. It is very clear web along with web browsers has been becoming bloated to ridiculous levels -- this is not a coincidence, bloat is pushed by [corporations](corporation.md) such as Google to eliminate possible emerging competition. If practically all websites require [JavaScript](js.md), [CSS](css.md), [HTTPS](https.md) and similar nonsense, it is becoming much more difficult to crawl them and create a web index, leaving the possibility to crawl the web mostly to the rich, i.e. those who have enough money, time and know-how to do this. Alongside this there is the web browser bloat -- as websites have become extremely complex, it is also extremely complex to make and maintain a web browser, which is why there is only a few of them, all controlled (despite FOSS licenses) by corporations and malicious groups, one of which is Google itself. For these reasons Google loves bloat and encourages it, e.g. simply by ranking bloated webpages better in their search results, and of course by other means (sponsoring, lobbying, advertising, ...).

Bloat monopoly is [capitalism](capitalism.md)'s circumvention of [free](free.md) licenses and taking advantage of their popularity. With bloat monopoly capitalists can stick a [FOSS](foss.md) license to their software, get an automatic approval (**[openwashing](openwashing.md)**) of most "open-source" fanbois as well as their free work time, while really staying in control almost to the same degree as with [proprietary](proprietary.md) software.

**Bloat monopolies are currently mostly built on top of "[security](security.md)" obsession leading to hardcore [update culture](update_culture.md).** It is very well known that complex, bloated software is almost synonymous with security vulnerabilities -- bloat monopolies (who often claim to "care about security") love security vulnerabilities because that's what allows them to sustain the monopoly, the business of "keeping security", and that is why they make their code bloated, i.e. doing exact opposite of "caring about security" -- a huge, gigantic codebase will inevitably contain an ocean of vulnerabilities. No one is even thinking about ever fixing all of them, the mindset today is just this: there exists a huge pool of vulnerabilities and they get randomly discovered by "bad hackers", we just have to keep quickly fixing them as they appear so that "you are protected". I.e. bloat monopoly software makes it so that you cannot take some stable version and just keep using it without updates, the software will even refuse to work when it's too old, it will justify this as "protecting you". So this requires a team of people constantly watching the software 24/7 and fixing any vulnerability that pop up as soon as possible so that "the bad hackers don't have enough time to abuse the vulnerabilities" -- here it's not possible to have one or two volunteers who will be fixing security patches "maybe in a month or two" when they have time for it. It is therefore impossible for anyone to fork the software because then he'd have to start paying the same team of people who will be doing the same police works. Non-commercial communities of volunteers are by this takes out of the game, even if the code is "open source". This is why software is kept bloated and therefore vulnerable in terms of security by those who claim to "care about security" -- it's the [antivirus_paradox](antivirus_paradox.md) of capitalism: they don't care about security, they care about keeping the monopoly by creating vulnerabilities which they then keep fixing.

At the time of writing this if you want to compile so called "[open source](open_source.md)" [Android](android.md), you will need a computer with at least 400 GB of space, 16 GB of RAM (but recommended is 32 or 64), a [modern](modern.md) 64 bit CPU with multiple cores, and many hours of computational time. How long before we need a million dollar supercomputer to compile an "open source" program? Now ask yourself, is this still real freedom?

Examples of bloat monopoly include mainstream web browsers ([furryfox](firefox.md), [chromium](chromium.md), ...), [Android](android.md), [Linux](linux.md), [Blender](blender.md) etc. This software is characteristic by its difficulty to be even compiled, yet alone understood, maintained and meaningfully modified by a lone average programmer, by its astronomical [maintenance](maintenance.md) cost that is hard to pay for volunteers, and by aggressive [update culture](update_culture.md).
