# Bit

Bit (for *[binary](binary.md) digit*, symbol *b*, also *shannon*) is the lowest commonly used unit of [information](information.md), equivalent to a choice between two equally likely options (e.g. an answer to the question "Was the coin flip heads?"), in computers used as the smallest unit of [memory](memory.md), with 1 bit being able to hold exactly one value that can be either [1](one.md) or [0](zero.md). From bit a higher memory unit, [byte](byte.md) (8 bits), is derived. In [quantum computing](quantum.md) the equivalent of a bit is [qubit](qubit.md), in [ternary](ternary.md) computers the analogy is [trit](trit.md).

**Can there exist a smaller quantity of information than 1 bit?** Well, yes, for sure we can get zero information and it certainly also makes sense to speak of fractions of bits; for example one [decimal](decimal.md) digit carries log2(10) ~= 3.32 bits of information. [Entropy](entropy.md) is also measured in bits and can get smaller than 1 bit, e.g. for an unfair coin toss; an answer to the question "Will the Sun rise tomorrow?" gives less than 1 bit of information -- in fact it gives almost no information as we know the answer will most definitely be yes, though the certainty can never be absolute. Another idea: imagine there exist two people for whom we want to know, based on their sexes, whether they may reproduce together -- answer to this question takes 1 bit (yes or no) and to obtain it we have to know both of these people's sexes so we can say whether they differ. Now if we only know the sex of one of them, then in the context of the desired answer we might perhaps say we have a half of one bit of information, as if we also know the other one's sex (the other half of the bit), we get the whole 1 bit answer.