# Bazaar (The Cathedral And The Bazaar)

*The Cathedral and the Bazaar* (shortened to *catb*) is a very famous [software engineering](sw_engineering.md) paper from 1997 by [Eric S. Raymond](esr.md) (ESR, a famous oldschool hacker writer) which analyzes the development method of [Linux](linux.md), at the time a new way of mass developing [FOSS](foss.md) software by many volunteers over the [Internet](internet.md) with relatively little central planning -- this method is called the *Bazaar* (the word used for marketplace in middle east) and is contrasted with so called *Cathedral* method, i.e. the traditional, highly centralized development of software (not necessarily of [proprietary](proprietary.md) software). This essay was later being expanded, updated and made into a whole book -- the short version of it can be read on ESR's website. It played a role in [corporations](corporation.md) adopting "[open source](open_source.md)" (Netscape, i.e. Firefox, was "open sourced" basically because of this essay).

Watch out: Raymond used to be an oldschool [hacker](hacking.md) who however, like many others, later turned to the evil side once he smelled money and fame; he basically became hardcore [capitalist](capitalism.md), promoting [open $ource](open_source.md), free markets and even doing business himself. It can very well be seen in the essay -- it's not about [programming](programming.md), it is about software engineering, i.e. managing and manipulating masses of people to work like machines who will be continuously producing lines of code. It focused on things such as ["productivity"](productivity_cult.md) and basically how to develop [bloat](bloat.md) in fastest way and for least cost. It takes things such as [update culture](update_culture.md), rapid development, gigantic software projects and existence of software companies for granted. Therefore *The Cathedral and the Bazaar* is of no use to [less retarded software](lrs.md) but it may be good to read for the big picture view.

{ The online version is not very long, the writing style is good and there are nice, catchy observations about software development, however it's still quite shitty, towards the end I was falling asleep, only the capitalist trigger words kept me awake eventually. But there are some nice things, like "plan to throw one away", i.e. when you want to write something, you'll probably have to write it once badly, by which you really understand the issue, then you throw it away and implement it again, this time well. ~drummyfish }

Here is a small **summary**: ESR used to believe software beyond some complexity threshold (e.g. [operating system](os.md) kernel or a big text editor) has to be developed mainly by a small team that closely communicates, carefully fixes bugs that users report and releases stable versions once in relatively long time -- yes, even if the software is [FOSS](foss.md) and development is transparent. This is called the *Cathedral* method as the development is similar to the careful, highly centrally planned building of a cathedral -- one example was e.g. [gcc](gcc.md) (and any proprietary software, as they basically have no other option). However after seeing [Linux](linux.md) (a very complex project) being developed by great many people in a very decentralized manner, with the central coordinator doing relatively little work, and having very short release cycles (even of buggy, unstable versions), he concluded it can work differently -- he called this the *Bazaar* method, i.e. one that looks a bit [chaotic](chaos.md) at first, but which statistically still converges to establishing good design in the end. He says the biggest invention of [Linus Torvalds](torvalds.md) isn't Linux but its development model. He examines how and why it works because he sees it as the superior method, and he also tests the method on his own project ([fetchmail](fetchmail.md)) with which he immediately sees a great success. He notes several things, e.g. the following. Users being at the same time programmers (codevelopers) and vice versa is key because firstly programmers really care about what they write (because they use it) and secondly we get nice bug reports (in programmer terms). "Given enough eyeballs, all bugs are shallow" (*Linus's law*) says that with many users/programmers basically all bugs get spotted and fixed quickly, which is helped by the rapid release cycles -- if someone fixes it quickly, others see it's fixed and stop working on their more complicated fixes. This kind of parallelizes [debugging](debugging.md) (and also other things such as design change exploration). Quick releases reward contributors, they see their fixes immediately, contributors get motivated ("Treat your testers as your most valuable resource and they will respond by becoming your most valuable resource."), even the "work no one wants to do" gets done. Bazaar project needs several things. Firstly good Internet (that's why Linux coincided with cheap access to Internet). Secondly it can't be started from scratch, someone has to make some basic project basically alone, and it should be some truly honest project (not something that just aims for profit), usually starting with a programmer "scratching his [own itch](own_itch.md)" -- it's enough to make a project that shows promise so that people start jumping in. The ["leader"](bdfl.md) doesn't have to be genius but he has to be able to recognize good design choices of contributors and he must be "good with people". Then he goes on to compare it to free market and other crap, he basically concludes managers are useless and they just pretend to be useful :D