# Axiom Of Choice

In [mathematics](math.md) (specifically [set theory](set_theory.md)) axiom of choice is a possible [axiom](axiom.md) which basically states we can arbitrarily choose elements of sets and which is famous for being controversial and problematic because it causes trouble both when we accept or reject it. Now it's actually been included in [ZFC](zfc.md), a kind of "commonly used base for mathematics", but its controversial nature stands. Note that this topic can go to a great depth and lead to philosophical debates, there is a huge rabbit hole and mathematicians can talk about this for hours; here we'll only state the very basic and quite simplified things, mostly for those who aren't professional mathematicians but need some overview of mathematics (e.g. programmers).

Indeed, **what really IS the axiom of choice?** It is an [axiom](axiom.md), i.e. something that we can't prove but can either accept or reject as a basic fact so that we can use it to prove things. Informally it says that given any collection of sets (even an infinite collection of infinitely large sets), we can make an arbitrary selection of one element from each set. More mathematically it says: if we have a collection of sets, there always exists a [function](function.md) *f* such that for any set *S* from the collection *f(S)* is an element of *S*.

This doesn't sound weird, does it? Well, in many normal situations it isn't. For example if we have finitely many sets, we can simply write out each element of the set, we don't need to define any selection function, so we don't need axiom of choice to make our choice of elements here. But also if we have infinitely many sets that are well ordered (we can compare elements), for example infinitely many sets of [natural numbers](natural_number.md), we can simply define a function that takes e.g. the smallest number from each set -- here we don't need axiom of choice either. The issues start if we have e.g. infinitely many sets of [real numbers](real_number.md) (which can't be well ordered without the axiom of choice, consider that e.g. open intervals don't have lowest number) -- here we can't say how a function should select one element from each set, so we have to either accept axiom of choice (we say it simply can be done "somehow", e.g. by writing each element out on an infinitely large paper) or reject it (we say it can't be done). Here it is again the case that what's normally completely non-problematic starts to get very weird once you involve [infinity](infinity.md).

**Why is it problematic?** Once you learn about axiom of choice, your first question will probably be why should it pose any problems if it just seems like an obvious fact. Well, it turns out it leads to strange things. If we accept axiom of choice, then some weird things happen, most famously e.g. the [Banach-Tarski paradox](banach_tarski.md) which uses the axiom of choice to prove that you can disassemble a sphere into finitely many pieces, then move and rotate them so that they create TWO new spheres, each one identical to the original (i.e. you duplicate the original sphere). But if we reject the axiom of choice, other weird things happen, for example we can't prove that every vector space has a basis -- it seems quite elementary that every vector space should have a basis, but this can't be proven without the axiom of choice and in fact accepting this implies the axiom of choice is true. Besides this great many number of proofs simply don't work without axiom of choice. So essentially either way things get weird, whether we accept axiom of choice or not.

**So what do mathematicians do?** How do they deal with this and why don't they kill themselves? Well, in reality most of them are pretty chill and don't really care, they try avoid it if they can (their proof is kind of stronger if it relies on fewer axioms) but they accept it if they really need it for a specific proof. Many elementary things in mathematics actually rely on axiom of choice, so there's no fuss when someone uses it, it's very normal. Turns out axiom of choice is more of something they argue over a beer, they usually disagree about whether it is INTUITIVELY true or false, but that doesn't really affect their work.