# Artificial Intelligence

Artificial intelligence (AI) is an area of [computer science](compsci.md) whose effort lies in making [computers](computer.md) simulate thinking of humans and possibly other biologically [living beings](life.md). This may include making computers play [games](game.md) such as [chess](chess.md), compose music, paint pictures, understand and processing audio, images and text on high level of [abstraction](abstraction.md) (e.g. translation between natural languages), making predictions about complex systems such as stock market or weather or even exhibit a general human-like behavior. Even though today's focus in AI is on [machine learning](machine_learning.md) and especially [neural networks](neural_network.md), there are many other usable approaches and models such as "hand crafted" state tree searching algorithms that can simulate and even outperform the behavior of humans in certain specialized areas.

There's a concern that's still a matter of discussion about the dangers of developing a powerful AI, as that could possibly lead to a [technological singularity](tech_singularity.md) in which a super intelligent AI might take control over the whole world without humans being able to seize the control back. Even though it's still likely a far future and many people say the danger is not real, the question seems to be about *when* rather than *if*.

By about 2020, "AI" has become a [capitalist](capitalism.md) [buzzword](buzzword.md). They try to put machine learning into everything just for that AI label -- and of course, for a [bloat monopoly](bloat_monopoly.md).

By 2023 neural network AI has become extremely advanced in processing visual, textual and audio information and is rapidly marching on. Networks such as [stable diffusion](stable_diffusion.md) are now able to generate images (or modify existing ones) with results mostly indistinguishable from real photos just from a short plain language textual description. Text to video AI is emerging and already giving nice results. AI is able to write computer programs from plain language text description. Chatbots, especially the proprietary [chatGPT](chatgpt.md), are scarily human-like and can already carry on conversation mostly indistinguishable from real human conversation while showing extraordinary knowledge and intelligence -- the chatbot can for example correctly reason about advanced mathematical concepts on a level much higher above average human. AI has become [mainstream](mainstream.md) and is everywhere, normies are downloading "AI apps" on their phones that do funny stuff with their images while spying on them. In games such as [chess](chess.md) or even strategy video [games](game.md) neural AI has already been for years far surpassing the best of humans by miles.

# See Also

- [artificial life](artificial_life.md)