# Abstraction

Abstraction is an important concept in [programming](programming.md), [mathematics](math.md) and other fields of [science](science.md), philosophy and [art](art.md), which in simple words can be described as "viewing an issue from a distance", thinking in higher-level concepts, i.e. paying less attention to fine detail so that one can see the bigger picture. In programming for example we distinguish [programming languages](programming_language.md) of high and low level of abstraction, depending on how close they are "to the [hardware](hardware.md)" (e.g. [assembly](assembly.md) being low level, [JavaScript](js.md) being high level); in [art](art.md) high abstraction means portraying and capturing things such as ideas, feelings and emotions with shapes that may seem "distant", not resembling anything concrete or familiar. We usually talk about different **levels of abstraction**, depending on the "distance" we take in vieweing the issue at hand -- this concept may very well be demonstrated on [sciences](science.md): particle [physics](physics.md) researches the world at the lowest level of abstraction, in extreme close-up, for example by examining individual atoms that make up our brains, while [biology](biology.md) resides at a higher level of abstraction, viewing the brain at the level of individual cells, and finally [psychology](psychology.md) shows a very high level of abstraction because it looks at the brain from great distance and just studies its behavior.

In mainstream [programming](programming.md) education it is generally taught to "abstract as much as possible" because that's aligned with the [capitalist](capitalism.md) way of technology -- high abstraction is easy to handle for incompetent programming monkeys, it helps preventing them from making damage by employing billions of safety mechanisms, it also perpetuates the cult of never stopping layering of the abstraction sandwich, creating [bloat](bloat.md), [hype](hype.md), bullshit jobs, it makes computers slower, constantly outdated and so drives software [consumerism](consumerism.md). As with everything in capitalism, new abstractions are products hyped on grounds of immediate benefit: creating more comfort, being something new and "[modern](modern.md)", increasing "[productivity](productivity_cult.md)", lowering "barriers of entry" so that ANYONE CAN NOW BE A PROGRAMMER without even knowing anything about computers (try to imagine this e.g. in the field of medicine) etc. -- of course, long term negative effects are completely ignored. **This is extremely wrong.** It is basically why technology has been on such a huge downfall in the latest decades. Opposing this, [LRS](lrs.md) advocates to employ only as little abstraction as needed, so as to support [minimalism](minimalism.md). **Too much abstraction is bad.** For example a widely used general purpose programming language should basically only have as much abstraction as to allow [portability](portability.md), it should definitely NOT succumb high abstraction such as [object obsessed programming](oop.md).

In a more detailed view abstraction is not one-dimensional, we may abstract in different directions ("look at the issue from different angles"); for example [functional](functional.md), [logic](logic_paradigm.md) and [object](object.md) paradigms are different ways of programming languages abstracting from the low level, each one in different way. So the matter of abstracting is further complicated by trying to **choose the right abstraction** -- one kind of abstraction may work well for certain kinds of problems (i.e. solving these problems will become simple when applying this abstraction) but badly for other kinds of problems. The art of choosing right abstraction ([model](model.md)) is important e.g. in designing computer [simulations](simulation.md) -- if we want so simulate e.g. human society, do we simulate individual people in it or just societies as whole entities? Do we simulate wars as a simple dice roll or do we let individual soldiers fight their own battles? Do we represent roads as actual surfaces on top of which cars move according to laws of physics, or do we simplify to something like mathematical graph connecting cities with mere abstract lines, or something in between like a cellular automaton maybe? Do we consider beings living on a round planet, with possibilities like meteor impacts and space flights, or do we simply consider people living on a flat 2D sheet of paper? Similar though has come to designing [games](game.md) (another kind of simulation).

Let's take a look at a possible division of a [computer](computer.md) to different levels of abstraction, from lowest to highest (keep in mind it's also possible to define the individual levels differently):

- **[physics](physics.md)**: Computer is a collection of atoms and subatomic particles such as electrons, operating with terms such as [energy](energy.md), charge, spin or quantum effects.
- **[electronic](electronics.md) circuit**: Computer is an [analog](analog.md) circuit in which electricity flows through wires and electronic components, operating with terms such as [voltage](voltage.md), [current](current.md), [transistor](transistor.md), resistor or electronic interference.
- **[logic circuit](logic_gate.md)**: Computer is a [binary](binary.md) [digital](digital.md) circuit; this is abstracting electricity away, now we are only considering two possible values carried by the wires: 1s and 0s. Operating with terms such as [logic gate](logic_gate.md), logic function, [multiplexer](multiplexer.md) or sequential circuit.
- **[machine code](machine_code.md)/[assembly](assembly.md)**: Computer is a machine with a specific [instruction architecture](isa.md), executing an [algorithm](algorithm.md) encoded as simple binary instructions, such as "add two numbers" or "write a number to memory", in a specific format that's different for different types of computers. Operating with terms such as CPU cycle, [opcode](opcode.md), [register](register.md), memory or [interrupt](interrupt.md).
- **low level [portable](portability.md) language**: Computer is a machine capable of performing algorithms written in a structured language resembling human language and it's a machine that's essentially the same as other computers, even of different types, i.e. all computers can understand the same language (programs are [portable](portability.md)), typically e.g. [C](c.md). Operating with terms such as structured data type, procedure, signed/unsigned type, [memory management](memory_management.md) etc. 
- **high level language**: Computer is a machine capable of performing algorithms while handling many things (such as memory allocation or ensuring safety) automatically and dynamically (on-the-go) and understanding more complex and abstract descriptions of problems, allowing for very fast and comfortable programming in languages like [Python](python.md) or [JavaScript](javascript.md). Operating with terms such as [objects](oop.md), dictionaries, pure functions and [polymorphism](polymorphism.md).
- **very high level, [artificial intelligence](ai.md)**: Computer is a machine capable of simulating human thinking and therefore able to lead a conversation with human, it can perform commands given in natural language and even reason and create on its own. Operating with terms such as training, data sets and ethics.

## See Also

- https://unixsheikh.com/articles/we-have-used-too-many-levels-of-abstractions-and-now-the-future-looks-bleak.html