# Update Culture

Update culture is a malicious mindset emerging in a [capitalist](capitalism.md) society which in [technology](tech.md) manifests by developers of a (typically [bloated](bloat.md)) program creating frequent modifications called "updates" (sometimes also more sneakily masked under terms such as [progress](leading_the_pig_to_the_slaughterhouse.md) or [modernization](modern.md)) and forcing users to keep [consuming](consumerism.md) them, e.g. by deprecating or neglecting old versions, dropping [backwards compatibility](backwards_compatibility.md) (e.g. [Python](python.md)) or by downright forcing updates in code. This often manifests by a familiar pop-up message:

*"Your software is too old, please update to the latest version."*

In software this process is a lot of times automatized and known as [autoupdates](autoupdate.md), but update culture encompasses more than this, it's the whole mentality of having to constantly keep up, update one's software, hardware and other products, it is part of [fear culture](fear_culture), [bullshit](bullshit.md) and [consumerism](consumerism.md). Normies get all neurotic when they haven't received their weekly updates that give them new content or fake sense of "[security](security.md)". The truth is updates break more things that they fix and make software progressively [shittier](modern.md). STOP FUCKING UPDATING EVERYTHING EVERY 3 SECONDS YOU IDIOTS. [Good software](lrs.md) is written once and works for hundreds of years without [maintenance](maintenance.md).

A typical example falling under update culture are [web browsers](browser.md) or proprietary [operating systems](operating_system.md) that strive for [bloat monopoly](bloat_monopoly.md). Normalizing the practice of having to consume updates leads to the convenient opportunity for abuse of users: with the stuff you need you may be fed stuff you don't want.

Update culture is however not limited to computers or technology, hell no. It is the mood of the whole society and applies to things such as fashion, business, gossip, watching TV news every day, browsing social media or constantly updating laws, it is the acceptance and approval of living in a constant stress of having to extort extreme amounts of energy just to keep up with artificially made up [bullshit](bullshit.md), to race against oneself and others in a never ending artificially sustained race with no winners, just with extremely exhausted participants. Current system of law requires constant everyday maintenance that's extremely costly, law needs to be constantly remade and rewritten to reflect any emerging trend in society because it is so unbelievably complex and tries to encompass every single aspect of our society. Of course we eventually oppose any kind of formal law, however the kind of update culture law is yet orders of magnitude worse -- if we see law as a tool to serve society, this kind of law is an utterly shitty tool similar to a hammer that has to be repaired every second just to keep functioning.

Software updates are usually justified by "muh [security](security.md)" and "muh [modern](modern.md) [features](feature.md)". Users who want to avoid these updates or simply can't install them, e.g. due to using old incompatible hardware or missing dependency packages, are ridiculed as *poorfags*, idiots and their suffering is ignored. In fact, update culture is [cancer](cancer.md) because:

- **It is a form of software [consumerism](consumerism.md)**, even if the updates themselves are gratis, they always come at a cost such as potential unstability, requiring new hardware, forcing installing more dependencies, required learning to use the new version, or even dropping of old features and malicious code in the updates.
- **It is dangerous**, updates regularly break things, and there are cases where a lot depends on software running smoothly.
- It is [bullshit](bullshit.md) effort, **wasting human work and creating an intentionally high [maintenance](maintenance.md) cost**. Humans, both users and programmers, become slaves to the software.
- **The [security](security.md) justifications are lies**: a true concern for security would lead to unbloating and creating a minimal, stable and well tested software. Update culture in fact constantly pushes newly created vulnerabilities with the updates which are only better in not having been discovered yet, i.e. relying on **security by obscurity**. This creates an intentionally **endless cycle of creating something that will never be finished** (even if it well could be).
- **It kills freedom**. E.g. with the example of web the constant meaningless updates of JavaScript and addition of "features" eliminates any small competition that can't afford to keep up with the constantly changing environment. **This is why we have no good web browsers**.
- **It is painful for the user** while at the same time being unnecessary, i.e. it's plainly artificial discomfort forced on users. The user has to keep caring about his software like some kind of [tamagotchi](tamagotchi.md), becoming a slave to it.
- **It creates a mindset of not aiming to [finish](finished.md) anything** and normalizing this -- developers accept they release unfinished software, users accept they use unfinished software, society depends on technology that's not been finished, is buggy, unstable, randomly changing from one day to another etcetc.
- **It is actually a huge security risk** (yes, we don't really buy intro security but this still holds). The developer, whoever it is, has the power to remotely push and execute any code at any time to the devices of many users. In fact this can be seen as the definition of [backdoor](backdoor.md). This is not just an issue of [proprietary](proprietary.md) software, there have been many [FOSS](foss.md) projects pushing [malware](malware.md) this way (look up e.g. the projects that targeted malware at Russians during the Russia-Ukraine war).