# Unix

*"Those who don't know Unix are doomed to reinvent it, poorly."* --obligatory quote by Henry Spencer

Unix (plurar *Unixes* or *Unices*) is an [old](old.md) [operating system](operating_system.md) developed since 1960s as a research project of [Bell Labs](bell_labs.md), which has become one of the most influential pieces of software in history and whose principles (e.g. the [Unix philosophy](unix_philosophy.md), [everything is a file](everything_is_a_file.md), ...) live on in many so called  Unix-like operating systems such as [Linux](linux.md) and [BSD](bsd.md) (at least to some degree). The original system itself is no longer in use (it was later followed by a new project, [plan9](plan9.md), which itself is now pretty old), the name UNIX is nowadays a [trademark](trademark.md) and a certification. However, as someone once said, *Unix is not so much an operating system as a way of thinking*.

In one aspect Unix has reached the highest level a software can strive for: it has transcended its implementation and became a [de facto standard](de_facto_standard.md). This means it has become a set of interface conventions, "paradigms", [cultural](culture.md) and philosophical ideas rather than being a single system, it lives on as a concept that has many implementations. This is extremely important as we don't depend on any single Unix implementation but we have a great variety of choice between which we can switch without greater issues. This is very important for [freedom](freedom.md) -- it prevents monopolization -- and its one of the important reasons to use unix-like systems.

The main highlights of Unix are possibly these:

- **[Unix philosophy](unix_philosophy.md)**: a kind of general mindset of software development, usually summed up as **"do one things well"** (rather than ["do everything but poorly"](windows_philosophy.md)) and "make programs work in collaboration with other programs", advising on using universal text interfaces for communication etc. This often comes with the idea of **[pipes](pipe.md)**, a way of chaining programs (typically using the pipe `|` operator, hence the name) by sending one program's output to other program's input.
- **[everything is a file](everything_is_a_file.md)**: Unix chose to use the [file](file.md) abstraction to enable universal communication of programs with hardware and among themselves, i.e. on unices most things such as printing, reading keyboard, networking etc. will be likely implemented as reading or writing to/from some special (sometimes just virtual) file. This has the advantage of being able to just use some file reading library or syscall, not having to access physical memory bits in memory, which may be difficult, unsafe etc.
- Text centrism (great [command line](cli.md) preference), value on [portability](portability.md) (even over performance), sharing of source code, freedom of information and openness, connection to [hacker culture](hacking.md), valuing human time over machine time, ...
- ...

Unix is greatly connected to software [minimalism](minimalism.md), however most unices are still not minimalist to absolute extreme and many unix forks (e.g. [GNU](gnu.md)/[Linux](linux.md)) just abandon minimalism as a priority. So the question stands: **is Unix [LRS](lrs.md) or is it too [bloated](bloat.md)?** The answer to this will be similar to our stance towards the [C](c.md) language (which itself was developed alongside Unix); from our point of view Unix -- i.e. its concepts and some of their existing implementations -- is relatively good, there is a lot of wisdom to take away (e.g. "do one thing well", modularity, "use text interfaces", ...), however these are intermixed with things which under more strict minimalism we may want to abandon (e.g. "everything is a file" requires we buy into the file [abstraction](abstraction.md) and will often also imply existence of a file system etc., which may be unnecessary), so in some ways we see Unix as a temporary "[least evil](least_evil.md)" tool on our way to truly good, extremely minimalist technology. [DuskOS](duskos.md) is an example of operating system more close to the final idea of LRS. But for now Unix is very cool, some Unix-like systems are definitely a good choice nowadays.

There is a semi humorous group called the *UNIX HATERS* that has a mailing list and a whole book that criticizes Unix, arguing that the systems that came before it were much better -- though it's mostly just [joking](jokes.md), they give some good points sometimes. It's like they are the biggest boomers for whom the Unix is what [Windows](windows.md) is to the Unix people.

## History

In the 1960s, Bell Labs along with other groups were developing [Multics](multics.md), a kind of [operating system](os.md) -- however the project failed and was abandoned for its complexity and expensiveness of development. In 1969 two Multics developers, [Ken Thompson](key_thompson.md) and [Dennis Ritchie](dennis_ritchie.md), then started to create their own system, this time with a different philosophy; that of [simplicity](minimalism.md) (see [Unix philosophy](unix_philosophy.md)). They weren't alone in developing the system, a number of other hackers helped program such things as a file system, [shell](shell.md) and simple utility programs. At VCF East 2019 Thompson said that they developed Unix as a working system in three weeks. At this point Unix was written in [assembly](assembly.md).

In the early 1970s the system got funding as well as its name Unix (a pun on Multix). By now Thompson and Richie were developing a new language for Unix which would eventually become the [C](c.md) language. In version 4 (1973) Unix was rewritten in C.

Unix then started being sold commercially. This led to its fragmentation into different versions such as the [BSD](bsd.md) or [Solaris](solaris.md). In 1983 a version called System V was released which would become one of the most successful. The fragmentation and a lack of a unified standard led to so called [Unix Wars](unix_wars.md) in the late 1980s, which led to a few Unix standards such as [POSIX](posix.md) and Single Unix Specification.

For [zoomers](genz.md) and other noobs: Unix wasn't like [Windows](windows.md), it was more like [DOS](dos.md), things were done in [text interface](cli.md) -- if you use the command line in "[Linux](linux.md)" nowadays, you'll get an idea of what it was like, except it was all even more primitive. Things we take for granted such as a [mouse](mouse.md), [copy-pastes](copy_paste.md), interactive text editors, having multiple user accounts or [running multiple programs at once](multitasking.md) were either non-existent or advanced features in the early days. Anything these guys did you have to see as done with stone tools.
