# Real Number

Real numbers are all [numbers](number.md) found on the infinite, continuous one dimensional number line, they often represent what we generally just mean by the term "number" and include for example [zero](zero.md), [pi](pi.md) or -39/11. The [set](set.md) or real numbers includes all [whole numbers](integer.md) as well as all [rational numbers](rational_number.md) (fractions with integer numerator and denominator), but in addition contains infinitely many "special" numbers such as [pi](pi.md), [e](e.md) or [square root](sqrt.md) of 2, numbers that are mathematically very interesting because they for example produce infinitely many digits in our traditional number notation without showing any obvious patterns. However it has to be noted real numbers still do NOT include for example [infinity](infinity.md) or [complex numbers](complex_number.md) (kind of "2D extension" of real numbers) such as [i](i.md). Real numbers really represent a **[continuum](continous.md)**, between any two numbers that are not the same there is always infinitely many real numbers that have no gaps in between -- this leads to the fact that not only is there infinitely many real numbers, but there is **[uncountably many](uncountable.md)** of them, i.e. simply put there is "more than traditional infinity" of real numbers. [Mathematically](math.md) the set of real numbers and operations with them form a structure called a *[field](field.md)* (so you'll often hear the term "field of real numbers").

WATCH OUT: even though in programming we sometimes encounter [data types](data_type.md) named *real*, they usually don't represent true real numbers! In [programming](programming.md) we mostly only [approximate](approximation.md) real numbers with [floating](float.md) or [fixed](fixed_point.md) point numbers, which really are only rational numbers -- this is practically always [good enough](good_enough.md), we don't ever need an exact value of pi, a few decimal digits of accuracy is enough to an engineer, but to a mathematician real numbers represent a completely new, different world with some fundamental differences, which even a mere programmer should be at least aware of. Real numbers are tied to questions of the continuum, infinitely big and infinitely small, and they can really eventually lead to deep philosophical debates.

TODO: history?

## The Greater, Uncountable Infinity Of Reals

Compared to the basic sets of numbers, such as [natural](natural_number.md) and [rational numbers](rational_number.md), real numbers are special because **there are [uncountably](uncountable.md) many** of them, i.e not just [infinitely](infinity.md) many; in a sense the infinity representing how many real numbers there are is a **"bigger infinity"** than that representing the size (better said [cardinality](cardinality.md)) of sets of for example natural and rational numbers (which are still infinite, but only *countably* infinite); even if we consider just real numbers between 0 and 1, there is still kind of "more" of them than there are e.g. all possible fractions (with integer numerator and denominator). At first it looks like fractions and real numbers are kind of the same, but this is not true, fractions are still kind of sparse, [discrete](discrete.md), even though we can use fractions to infinitely divide the number line, there will always be kind of "gaps" between them; on the other hand real numbers are TRULY continuous in nature: there are infinitely many "special" numbers among real numbers, such as [pi](pi.md) and [e](e.md) (but most just without any special name, e.g. [square root](sqrt.md) of 2), that can never be written as a fraction of integers or as a number with finite decimal expansion (which is really the same thing as being a fraction), i.e. some real numbers we can approximately write down in decimal expansion (i.e. like 1.23456...) but never finish as their decimal expansion goes on forever and lacks any simple pattern. This is what gives rise to the fact that there are many more real numbers than integers and fractions -- due to this possibility of having "infinitely many arbitrary digits after the decimal point" **we cannot produce an ordered list of real numbers**, i.e. we cannot create a system that would say "this is the first real number, this is the second, this is third, ..." in a way that would eventually list out all the real numbers. I.e. we cannot establish a 1:1 mapping between natural numbers and real numbers, something that IS possible with integers and fractions (though with fractions it's less obvious), even considering things like negative numbers, we can order integers e.g. like: 0, 1, -1, 2, -2, 3, -3, .... With real numbers this is impossible, so we say the infinite size of the set of real numbers is uncountable.

At first this is usually confusing and hard to comprehend, keep in mind we are dealing with [infinities](infinity.md) here and so intuition fails us, what we mean by "size" of an infinite set is better called a [cardinality](cardinality.md) because this is not really a size as we understand it with finite sets, it's a kind of generalization of it that allows us to examine infinity, but as we start dealing with infinities we have to be careful as things we usually take for granted may no longer hold -- for example here we may have a superset of a set of numbers (e.g. all integers, including negative ones, is a superset of natural numbers, which exclude negative numbers) with both sets having the same "size"/cardinality, i.e. something that with finite sets can't happen. With infinities we cannot measure size with counting elements -- there are always infinitely many -- but we can try with making mappings between the sets, which does tell us new things. But we are still in a different realm where our traditional language doesn't work and at best we sometimes have only "close enough" terms for things we encounter there.

**Is this of use to a programmer?** Not to a "normal" programmer, in practical programming we basically never deal with true real numbers in all their generality, we just [approximate](approximation.md) them with [floats](float.md) (i.e. rational numbers), though a programmer should definitely at least be aware of all this, this is just very basics of higher math and should be common knowledge to anyone dealing with math in any way. Of course some specialized programming (e.g. symbolic computation) and theoretical computer science will come to deal with this, so there it is a must know.

Here is a **[proof](proof.md)** by contradiction of not being able to create an ordered list of real numbers, by so called *diagonalization*. Let us only consider (without loss of generality) real numbers between 0 and 1, written in [binary](binary.md), i.e. numbers written only with digits 0 and 1 that always start with `0.`. Suppose we have found ordering of ALL real numbers in which real numbers go one after another like this: *R1*, *R2*, *R3* etc., each *RN* having the digits (after `0.`) *RN_1*, *RN_2*, *RN_3* etc. We can write these numbers into a table that expands infinitely to the right and bottom:


| number | digit 1 | digit 2 | digit 3 | digit 4 | ... |
| ------ | ------- | ------- | ------- | ------- | --- |
| R1     | R1_1    | R1_2    | R1_3    | R1_4    | ... |
| R2     | R2_1    | R2_2    | R2_3    | R2_4    | ... |
| R3     | R3_1    | R3_2    | R3_3    | R3_4    | ... |
| ...    | ...     | ...     | ...     | ...     | ... |

Now however we can consider a number *X* whose digits are `not(R1_1)`, `not(R2_2)`, `not(R3_3)`, `not(R4_4)` etc., i.e. the number is obtained by taking the table's diagonal and inverting all the digits (1s to 0s and vice versa). We can see number *X* is not present in the table because it is different from every other number in the table -- with any number *RN* it will differ AT LEAST by the *N*th bit. By this we arrive at the contradiction with the original claim that we have an ordered list of ALL real numbers, therefore such list cannot exist.

Another **cool view of real numbers** is this: imagine fractions (rational numbers) in fact sitting on a 2D grid, having coordinates given by their denominator and numerator, e.g. number 3/2 sits at [2,3], i.e. has *x* coordinate 2 and *y* coordinate 3. We are standing at point [0,0] and so every number projects to our field of view, i.e. to an angle from -90 degrees to 90 degrees (with these extremes representing minus and plus infinity, looking straight forward we see [zero](zero.md)). Notice that for example numbers 2/3 and 4/6 exactly overlap from out point of view, as they represent the same value:

```

     ...^ numerator     
      6 |. . . . . . . __/ 2/3 = 4/6 = 8/12 = ...
      5 |. . . . . .__/
      4 |. . . . __/ .
      3 |. . .__/. . . 
      2 |. ._/ . . . .
      1 |_/. . . . . .
us -> 0 +-------------> denominator
     -1 |1 2 3 4 5 6 7 ...
     -2 |. . . . . . .
     -3 |. . . . . . .
     ...|. . . . . . .
```

From our point of view we can see all number, not just the fractions (which only sit on the integer grid points) -- all numbers, including real numbers, project to our field of view. Here fractions represent all the GRID points we see, i.e. a very dense set of points, however there are still gaps shining through which represent the real numbers that aren't fractions -- for example [pi](pi.md); if we shoot a ray from our standpoint in the exact angle that represents pi, the ray will go on forever without ever hitting any grid point! Such line will nearly miss some points, such as 355/113, which represents a good approximation of pi, but it will never hit any point exactly. So real numbers here are represented by the WHOLE, CONTINUOUS field of view.

**Are there bigger sets than those of real numbers?** Of course, a superset of real number is e.g. that of [complex numbers](complex_number.md) and [quaternions](quaternion.md), though they still have the same cardinality. But there are even sets that have bigger cardinality than reals, e.g. the set of all subsets of real numbers (so called [power set](power_set.md) of real numbers). In fact there are infinitely many such infinities of different cardinality.