# Public Domain

If an "intellectual work" (song, book, computer program, ...) is in the public domain (PD), it has no "owner", meaning no one has any exclusive rights (such as [copyright](copyright.md) or [patent](patent.md)) over the work, no one can dictate how and by whom such work can be used and so anyone can basically do anything with such work (anything that's not otherwise illegal of course).

[LRS](lrs.md) highly supports public domain and recommends programmers and artists put their works in the public domain using [waivers](waiver.md) such as [CC0](cc0.md) (this very wiki is of course released as such).

Public domain is the ultimate form of freedom in the creative world. In public domain the creativity of people is not restricted. Anyone can study, remix, share and improve public domain works in any way, without a fear of being legally bullied by someone else.

The term "public domain" is sometimes used vaguely to mean anything under a free license, however this use is incorrect and greatly retarded. **Public domain is NOT the same thing as [free (as in freedom) software](free_software.md), [free culture](free_culture.md) or freeware (gratis, free as in beer) software**. The differences are these:

- Unlike public domain, **[free software](free_software.md) and [free cultural](free_culture.md) works are usually still "owned" by someone**, they just try to relax the rules and make them less oppressive. A public domain work is completely unlimited and belongs to everyone and no one, while free software/culture may still require and legally enforce certain freedom-compatible conditions such as giving credit to the author or [copyleft](copyleft.md).
- **Public domain software is not always [free software](free_software.md)** -- PD software is free (as in freedom) only if its source code is available and also in the public domain (without source code freedoms 1 and 2 in the definition of free software are violated).
- **Freeware/gratis just means available for no price**, very often under specific restrictive conditions such as "for personal use" only and without the access to the source code. Public domain is not only gratis but also without any legal limitations on use.

## Which Works Are In The Public Domain?

This is not a trivial question, firstly because the term *public domain* is not clearly defined: the definition varies by each country's laws, and secondly because it is non-trivial and sometimes very difficult to assess the legal status of a work.

Corporations and [capitalism](capitalism.md) are highly hostile towards public domain and try to destroy it, make it effectively non-existing, as to eliminate "free" works competing with the consumerist creations of the industry. Over many years they have pushes towards creating laws that make it extremely difficult and rare for works to fall into public domain.

Sadly due to these shitty laws most works created in latest decades are NOT in the public domain because of the [copyright](copyright.md) [cancer](cancer.md): copyright is granted automatically, without any registration or fee, to the author of any shitty artistic creation, and its term lasts mostly for **the whole life of the author plus 70 years!** In some countries this is life + 100 years. In the US, copyright lasts 96 years from the publication of the work (every January 1st there is so called public domain day celebrating new works entering the US public domain). In some countries it is not even possible to legally waive (give up) one's copyright. And to make matters worse, copyright isn't the only possible restriction of an intellectual work, there are also **[patents](patent.md)**, **[trademarks](trademark.md)**, [personality rights](personality_rights.md) and other kinds of [intellectual property](intellectual_property.md).

Another bad news is that works in a **"weak" public domain**, i.e. most recent PD works or works that entered PD by some obscure little law, may as well stop being PD by introducing some shitty retroactive law (which has happened). So one may not be feeling completely safe going crazy by utilizing some recent PD works.

We therefore devise the term **safe/strong public domain**. Under this we include works that are pretty safely PD more or less world-wide, even considering possible changes in laws etc. Let us include these works:

- Works published at least 100 years ago whose author probably died at least 70 years ago.
- Works **clearly and properly** marked by a reliable PD [waiver](waiver.md) such as [CC0](cc0.md). However an extra effort needs to be taken to assure that the work e.g. isn't a derivative work of copyrighted work, or that patents are waived with software.
- Works that under any "reasonable" law can not be covered by "intellectual property", e.g. math equations, colors etc.

[Creative commons](creative_commons.md) has created a **public domain mark** that helps mark and find works that should be in a world-wide public domain (this is not a waiver though, it is basically only used as a metadata for very old works to be better searchable).

There are a number of places on the internet to look for public domain works, for a list see below.

**Should you release you own works to the public domain?** Definitely yes! From [our](lrs.md) point of view public domain is the only option as we deem any "intellectual property" immoral, however even if you disagree with us, you may want to release at least some of your works into public domain, if only out of altruism, no longer caring about your old works, out of curiosity or to make yourself a bit popular in the free culture community (thought this is a motivation we don't entirely embrace). **Are you afraid to do so?** It is natural, letting go of something you spend part of your life on can raise a bit of anxiety, but this is just a fear of making the first step to the unknown, a fear almost entirely artificial, created by [capitalist](capitalism.md) propaganda; making this decision will really most likely only have positive effects unless you actually had SERIOUS plans to make a business of your proprietary art. Practically the worst that can happen is that your work goes unnoticed and unappreciated. If you are still hesitant, try to go slowly, first release one thing, something small, and see what happens.

**But isn't releasing a work into public domain dangerous?** Doesn't that just invite someone to take the work and claim it as his own? This is a pretty common question so let's take a look at it. Firstly know that **releasing a work into public domain DOES NOT give others the right to claim it as their work** -- it gives them the right to use that work in any way, even to make money (although it will be hard to make money solely by selling something that's already available for free), but someone claiming to have created a work he did not in fact create is simply [plagiarism](plagiarism.md), lying and false claim of copyright, which is not only unethical and will hurt the reputation of the individual if it's proven (which can easily be done, e.g. by showing you released the work earlier through Internet Archive etc.), but may even be punishable by law (even though plagiarism is usually not a crime in itself, it may be deemed for example a fraud). Yes, some people may still attempt to do it (just like people practice [piracy](piracy.md) despite it being illegal), but please note they can just as easily do this even if the work isn't public domain -- they can simply (though illegally) take it and claim it as their own even if you keep your copyright on it. The only "protection" against this is to simply never release the work publicly at all, i.e. the fact that you make your work public domain doesn't make it more easy to be plagiarized. From this point of view it' actually probably much more "dangerous" to for example publish the work anonymously (even if you keep "all rights reserved"), i.e. concealing your real identity when publishing the work (to which you may be pushed by the [privacy](privacy.md) hysteria of today's culture), as this will make it impossible for you to later on prove it was you who made it; if someone takes the work and starts milking it, you cannot sue him as you can't prove you hold copyright on it and he may claim it was him who originally published it anonymously (well, it actually further depends on each country how anonymously published works are treated, but in general it will be more messy and the fact you can't prove your authorship stays).

{ I remember myself how anxious I was about making the decision to release all my work into public domain, despite knowing it was the right thing to do and that I wanted to do it. I felt emotional about giving away rights to art I put so much love and energy into, fearing the evil vultures of the Internet would immediately "steal" it all as soon as I release it. I overcame the fear and now, many years later, I can say that not once have I regretted it, literally not a single case of abuse of my work happened (that I know of anyway), despite some of it becoming kind of popular. I only received love of many people who found my work useful, and even received donations from people. I've seen others put my work to use, improve it, I get mail from people thanking me for I've done. Of course this all is not why I did it, but it's nice, I write about it to share a personal experience that will maybe give you the courage to do the right thing as well. ~drummyfish }

## How To Create Public Domain Works

To create a public domain work you must ensure that after you release it, no one will hold exclusive [intellectual property](intellectual_property.md) rights to it -- most notably we will be trying to remove [copyright](copyright.md) from the work (which arises automatically, last extremely long and is most annoying), but know that there are potentially also other rights to take into account, e.g. [patents](patent.md), [trade marks](trade_mark.md), trade dress, personality rights, etc. (in usual cases you don't have to deal with these as they apply only to some things in some situations, but for things like program [source code](source_code.md) you may need to look into them). We will remove such rights with [licenses](license.md) or [waivers](waiver.md), i.e. a legal text which we attach to our works and which says we just give up our rights. Sadly this is not trivial to do.

If you want to create a PD work, then generally in that work **you must not reuse any non-public domain work**. So, for example, you can NOT create a public domain fan fiction story about [Harry Potter](harry_potter.md) because Harry Potter and his universe is copyrighted (your fan fiction here would be so called [derivative work](derivative_work.md) or a copyrighted work). Similarly you can't just use randomly googled images in a game you created because the images are most likely copyrighted. Small and obscure exceptions (trivial bitmap fonts, freedom of panorama, ...) to this may exist in laws but it's never good to rely on such quirky laws (they may differ between countries etc.), it's best to keep it safe and simply avoid utilizing anything non-PD within your works. If you can, create everything yourself, that's the safest bet.

Note that even things such as music/sound samples, text fonts or paint brushes may sometimes be copyrighted. Just be careful, try to make everything from scratch -- yes, it sucks, because copyright sucks, but this is simply how we bypass it. Making everything yourself from the ground up also teaches you a lot and makes your art truly original, it's not a wasted time.

Also **you must NOT use anything under [fair use](fair_use.md)**! Even though you could lawfully use someone else's copyrighted work under fair use, inclusion of such material would, by the fair use rules, limit what others would be able to do with your work, making it restricted and therefore not public domain. Example: you can probably write a noncommercial Harry Potter fan fiction and share it with friends on the internet because that's fair use, however this fan fiction can never be public domain because it can't e.g. be used commercially, that would no longer fall under fair use, i.e. there is a non-commercial-use-only restriction burdening your work. It doesn't even help if you get an explicit permission to use a copyrighted work in your work unless such permission grants all the right to everyone (not just your work). { I got a mascot removed from [SuperTuxKart](supertuxkart.md) by this argument, mere author's permission to use his work isn't enough to make it free as in freedom. ~drummyfish }

Also **do NOT USE [AI](ai.md)**, not even for things like upscaling and enhancements. NO JUST DO NOT. NO, your argument is invalid, just DO NOT USE IT. In theory it may be legit, but there's just huge amount of doubt, uncertainty and legal mess. To name a few potential issues: AI may create a derivative work of something it has seen in its training dataset (which even if "open"-licensed still may contain material of non-free things that may be legal in the context of the dataset but not in the context of the generated result, e.g. "freedom of panorama"), the copyright status of AI works themselves is not as of yet clear and even once it's established, it may differ by country AND there is a danger of retroactive changes (once it becomes too easy to create PD works with AI capitalists can just push a law that will say AI can't be used for this because "[economy](crime_against_economy.md)" and yes, it may even be used retroactively, [yes, they can do it](yes_they_can.md), it already happened). Furthermore even if AI works are made legit, terms and condition of most usable AI software will still negate this (they already do, EVEN if you pay for it), it's not even clear if they can do this (or it may depend on territory and time) but it's a threat. Also AI is shit, [bloat](bloat.md) and serves mostly [capitalists](capitalism.md) to produce huge quantities of cheap shit for consumerist games, we just don't need this. You may think "haha I'll create one trillion PD textures and post them to Opengameart and save the world" -- that's literally what everyone is doing right now, it's the worst kind of spam that is now just killing the site, please don't even think of this. Create something small but nice, something whose legitimacy as your own work that you give away can not be questioned.

So you can only use your own original creations and other public domain works within your PD work. Here you should highly prefer your own creations because that is legally the safest, no one can ever challenge your right to reuse your own creation, but there is a low but considerable chance that someone else's PD work isn't actually PD or will seize to be PD by some retroactive law change. So when it only takes a small effort to e.g. photograph your own textures for a game instead of using someone else's PD textures, choose to use your own.

{ NOTE: The above is kind of arguing for reinventing wheels which goes a little bit against our philosophy of remixing and information sharing, but we are forced to do this by the system. We are forced to reinvent wheels to ensure that users of our works can't be legally bullied. ~drummyfish }

In cases where you DO reuse other PD works, try to minimize their number and try to make sure they belong to the actual **safe** public domain (see above). This again minimizes legal risk and additionally makes it easy to document and prove the sources.

As a next step make sure you clearly **document** your work and the sources you use. This means you write down where all the works contained in your work come from, e.g. in your [readme](read_me.md). Explicitly mention which things you have created yourself (*"I, ..., have created everything myself except for X, Y and Z"*) and which things come from other people and where you have found them. It is great to also archive the proofs of the third party source being public domain (e.g. use the [Internet Archive](internet_archive.md) to snapshot the page with a PD texture you've found). For works that allow it (e.g. source code, text, websites, ...) it is good to use [version control systems](vcs.md) such as [git](git.md) that record WHAT, WHEN and by WHO was contributed. This can all help prove that your work is actually safe and/or remove contributions that caused some legal trouble.

If you collaborate with someone on the work, it must be clear that ALL contributors to the work follow what we describe here (e.g. that they all agree to the license/waiver you have chosen etc.). It is safer if there are fewer contributors as with more people involved the chance of someone starting to "make trouble" increases.

Finally you need to actually release your work into the public domain. Remember that you want to achieve a **safe, world-wide public domain** (so again you shouldn't try to rely on some weird/obscure laws of your own small country). It must be stressed that it is NOT enough to write *"my work is public domain"*, this is simply legally insufficient (and in many countries you can't even put your work into public domain which is why you need a more sophisticated tool). You need to use a public domain [waiver](waiver.md) (similar to a [license](license.md)) which you just put alongside your work (e.g. into the `LICENSE` file), plus it is also good to explicitly write (e.g. in your readme) a sentence such as **"I, ..., release this work into public domain under CC0 1.0 (link), public domain"**. Bear in mind that the WORDING may be very important here, so try to write this well: we mention the license name AND its version (CC0 1.0, it may even be better to fully state *Creative Commons 1.0*) as well as a link to its exact text and also mention the words *public domain* afterwards to make the intent of public domain yet clearer to any doubters. Here we used what's currently probably the best waiver you can use: [Creative Commons Zero](cc0.md) (CC0) -- this is what we recommend. However note that CC0 only waives copyright and not other things like [trademarks](trademark.md) or [patents](patent.md), so e.g. for [software](software.md) you might need to add an extra waiver of these things as well.

{ I personally use the following waiver IN ADDITION to CC0 with my software to attempt waiving of patents, trademarks etc. I made it by taking some standard waiver companies use to steal "rights" of their employees and modifying it to make it a public domain waiver. If you want to use it, make sure you mention it is an EXTRA, additional waiver alongside CC0. The waiver text follows. ~drummyfish

*Each contributor to this work agrees that they waive any exclusive rights, including but not limited to copyright, patents, trademark, trade dress, industrial design, plant varieties and trade secrets, to any and all ideas, concepts, processes, discoveries, improvements and inventions conceived, discovered, made, designed, researched or developed by the contributor either solely or jointly with others, which relate to this work or result from this work. Should any waiver of such right be judged legally invalid or ineffective under applicable law, the contributor hereby grants to each affected person a royalty-free, non transferable, non sublicensable, non exclusive, irrevocable and unconditional license to this right.* }

NOTE: You may be thinking that it doesn't really matter if you waive your rights properly and very clearly if you know you simply won't sue anyone, you may think it's enough to just write "do whatever you want with my creation". But you have to remember others, and even you yourself, can't know if you won't change your mind in the future. A clear waiver is a **legal guarantee** you provide to others, not just a *vague promise of someone on the Internet*, and this guarantee is very valuable, so valuable that whether someone uses your work or not will often come down to this. So waiving your "rights" properly may increase the popularity and reusability of your work almost as much as the quality of the work itself.

For an example of a project project properly released into public domain see the repository of our [LRS](lrs.md) game [Anarch](anarch.md).

## Where To Find Public Domain Works

There are quite a few places on the Internet where you may find public domain works. But firstly let there be a warning: you always **have to** check the public domain status of works you find, it is extremely common for people on the Internet to not know what public domain is or how it works so you will find many *false positives* that are called public domain but are, in fact, not. This article should have given you a basic how-to on how to recognize and check public domain works. With this said, here is a list of some places to search (of course, this list will rot with time):

- Very **old works and traditional folk art** are mostly in the public domain, e.g. Shakespeare's plays or folk songs. Nice example of reusing folk art is e.g. [Richard Stallman's](rms.md) *Free Software Song* that takes the melody of a Bulgarian folk song *Sadi Moma*. However watch out for traps, e.g. [trademarks](trademark.md) that may exist despite no copyright (e.g. Encyclopedia Britannica) or weird nationalist laws against disrespecting a country's folklore that may possibly exist too.
- **[Wikimedia Commons](https://commons.wikimedia.org/wiki/Main_Page)**: Contains only free as in freedom works among which are many PD ones. You can search for them with queries such as `cat incategory:cc-zero`. This site is quite reliable and serious about licensing, if you find a work marked as PD here, you can be reasonably sure this information is true.
- **[Internet Archive](https://archive.org/)**: The biggest Internet archive, huge amount of mainly old works such as scanned books and photos. Beware that this site contains all kinds of works from PD to [proprietary](proprietary.md) and works marked as PD should be checked as there can be errors. There is an *advanced search* tool that can help in searching for PD works, for example [this query](https://archive.org/search.php?query=possible-copyright-status%3A%28NOT_IN_COPYRIGHT%29%20OR%20licenseurl%3A%28%22http%3A%2F%2Fcreativecommons.org%2Fpublicdomain%2Fmark%2F1.0%2F%22%29%20OR%20licenseurl%3A%28%22http%3A%2F%2Fcreativecommons.org%2Fpublicdomain%2Fzero%2F1.0%2F%22%29) tries to achieve this.
- **[Opengameart](https://opengameart.org/)**: Site for sharing free as in freedom [game](game.md) art (pictures, 3D models, sounds, ...) among which are many under [CC0](cc0.md), i.e. PD. Submitted works are checked reasonably well so any CC0 work you find here is likely truly PD.
- **[Freesound](https://freesound.org/)**: Site for sharing sound recordings and sound effects, contains many [CC0](CC0.md) sounds that should be PD.
- **[Project Gutenberg](https://www.gutenberg.org/)**: Archive of old digitized books. NOT ALL are PD, but the real old ones should be. Generally books from before the 20th century should be PD.
- **[Stocksnap](https://stocksnap.io)**: Quality photos and "stock images" under [CC0](CC0.md), i.e. PD.
- **[Librivox](https://librivox.org)**: Public domain audiobooks made by volunteers that read PD books from Project Gutenberg.
- **[Wikisource](https://en.wikisource.org/wiki/Main_Page)**: Repository of texts, similar to Project Gutenberg, same rules apply (not all texts here will be PD but the real old ones should be).
- **[Openclipart](http://openclipart.org)**: Vector graphics, all under [CC0](cc0.md), i.e. PD in theory, **however** there do appear pictures that are derivative works of copyrighted works for which of course this is irrelevant. Check very well anything you download from here.
- **[Blendswap](https://www.blendswap.com/)**: Site for exchanging 3D models for [Blender](blender.md), not all models are PD but the ones marked CC0 should be, however **NOT those marked as "fan art"!**
- **[Wikidata](https://www.wikidata.org/wiki/Wikidata:Main_Page)**: Database of "everything", published as a whole under [CC0](cc0.md) which should make it PD, **however** it will contain information about proprietary works which may make this status questionable sometimes. If you only use data that don't fall under this you should be safe.
- ...