# Programming Tips

This is a place for sharing some practical programming tips.

- **Add by small steps**, spare yourself [debugging](debugging.md) hell later, do one step after another (see also [orthogonality](orthogonality.md)): when adding features/functionality etc. into your code, do it by very small steps and test after each step. Do NOT add multiple things at once. If you add 3 features at once and then find out the program doesn't work, you will have an extremely hard time finding out the bug because it may be in feature 1, feature 2, feature 3 or ANY COMBINATION of them, so you may very well never find the bug. If you instead test after adding each step, you find potential bugs immediately which will make fixing them very quick and easy.
- **Program on a weak computer** or alternatively use some utility such as [cpulimit](cpulimit.md) to make your hardware weaker, this will help you make your program efficient (and learn [how to do it](optimization.md)), any inefficiency will be immediately apparent as your program will simply run slow or swap. Using a physically weak computer is best as it is limited in all aspects so it will also help you make the program easy to develop on such computer etc., small [embedded](embedded.md) devices such as [open consoles](open_console.md) are ideal.
- **No indentation for temporary code**: Tiny "workflow" tip: when adding new code, keep it unindented so that you know it's the newly added code and can delete it at any time. Only when you test the added code, indent it correctly to incorporate it as the final code. Of course, this fails in languages where indentation matters ([Python](python.md) cough cough) but similar effects can be achieved e.g. by adding many empty lines in front of/after the temporary code.
- **[Comments](comment.md)/[preprocessor](preprocessor.md) to quickly hide code**: It is a basic trick to comment out lines of code we want to temporarily disable. However preprocessor may work even better, e.g. in C if you want to be switching between two parts of code, instead of constantly commenting one part and uncommenting the other just use `#if 0` and `#else` directives around the two parts. You can switch between them by just changing 0 to 1 and back. This can also disable parts of code that already contain multiline comments (unlike a comment as nested multiline comments aren't allowed).
- **[KEEP IT SIMPLE](kiss.md)** and keep it [LRS](lrs.md), do not blindly follow mainstream ways and "workflows" as those are more often than not horrible. For example instead of using some uber bug tracker, you should use a simple plaintext TODO.txt file; instead of using and IDE use [vim](vim.md) or something similar. Stay away from [OOP](oop.md), [dependencies](dependency.md) etc.
- **Never listen to advice of anyone who does programming for living** (not [anymore](21st_century.md)), he's most definitely accustomed to the worst ways of programming and will try to push you to [OOP](oop.md), [bloat](bloat.md), [proprietary](proprietary.md) tech, [tranny software](tranny_software.md), [GitHub](github.md) etc. Listening to advice of such people is like taking advice on whether to take drugs from a drug dealer.
- **Most true programming is done away from the computer** -- soydevs think that a good programmer just spends hours in front of a computer bashing the keyboard and drinking litres of coffee to stay alive and [PRODUCTIVE](productivity_cult.md); indeed, they usually do, but they are not good programmers, their time is spent slaving the computer doing [maintenance](maintenance.md), debugging, googling, updating and socializing on Twitter. A good programmer actually programs everywhere: when going for walk, before falling asleep, when sleeping, when watching a movie etc. He only starts writing a serious program after years of thinking about it and already having most of it programmed in his head; sitting in front of a computer and writing the algorithm down is only the final smaller part of the journey.
- It can't be repeated enough times: minimize ALL kinds of [dependencies](dependency.md), don't use what you don't necessarily need -- this doesn't just apply to libraries but also design decisions. E.g. if you're making a compiler, make it a single pass compiler if at all possible, don't perform several source code passes if that's not absolutely necessary (which would however likely signify some flaw in the design of your language). Use [fixed point](fixed_point.md) instead of [floating point](float.md) if you can, [software rendering](sw_rendering.md) instead of GPU rendering etc. If you're making something that transforms text to another text (e.g. machine translation), make it a [filter](filter.md) with constant memory complexity if that's possible, i.e. do not require the program to load a whole input file to memory. Etcetc.
- During development turn off optimization flags for faster compiling and turn on verbosity and various checks, e.g. `-Werror -Wall -Wextra -Wpedantic` for [C](c.md).
- By [Unix philosophy](unix_philosophy.md) **don't be afraid to throw away your code and start over and better** -- next time you'll most likely write the same program a lot better and if you're a Unix programmer, your programs are small, possible to be reimplemented quicky. This has even been generalized into a wisdom that says "plan to throw away one", i.e. when approaching a new issue, you quite frequently start writing a program you know you will throw away when it's finished, just to start over and better; the first program just serves to help you understand the true essence of the problem and foresee the real problems you will face.
- **Go out!** This is related to the other point -- you shouldn't just sit at the computer when programming, get up and go for a walk, do something else, take a shower, go swim, do something in the garden, repair some stuff or something like that. Fresh air and sunlight helps the brain, it makes you feel better and it's been shown that walking helps activate some important brain centers, many people [actually](ackchyually.md) say they have to walk when thinking hard { Can confirm. ~drummyfish } Changing your environment and getting out of the current focus on the letter on the screen can kick off some real great idea, seeing seemingly unrelated things in nature can spark some inspiration. If you're stuck, take a day off, just sleeping and approaching the problem fresh does miracles. This really does help. It may help to **carry around a blog for taking notes** so that you don't have to stress about forgetting the ideas -- prefer paper blog, leave all electronics at home.
- Insert funny [hexadecimal](hexadecimal.md) constant in your program such as `0xED1B1EFAECE5`.
- TODO: moar