# Often Confused Terms

There are many terms that are very similar and can many times be used interchangeably. This isn't wrong per se, a slight difference may be insignificant in certain contexts. However it's good to know the differences for the sake of those cases where they matter. The following list tries to document some of the often confused/similar terms.

- **[AI](ai.md)** vs **[machine learning](machine_learning.md)** vs **[neural networks](neural_net.md)**
- **[algebra](algebra.md)** vs **[arithmetic](arithmetic.md)**
- **[algorithm](algorithm.md)** vs **[program](program.md)** vs **[process](process.md)** vs **[heuristic](heuristic.md)**
- **America** vs **[USA](usa.md)**
- **[analog](analog.md)** vs **[mechanical](mechanical.md)**
- **[anarchy](anarchism.md)** vs **[chaos](chaos.md)**
- **[argument](argument.md)** vs **[parameter](parameter.md)**
- **[array](array.md)** vs **[list](list.md)** vs **[tuple](tuple.md)** vs **[set](set.md)** vs **[multiset](multiset.md)**
- **[ASCII](ascii.md)** vs **[plain text](plain_text.md)** vs **[Unicode](unicode.md)**
- **[ASCII art](ascii_art.md)** vs **[ANSI art](ansi_art.md)** vs **[Unicode](unicode.md) art**
- **[assembler](assembler.md)** vs **[assembly](assembly.md)** vs **[machine code](machine_code.md)**
- **[attribution](attribution.md)** vs **[credit](credit.md)**
- **binary** vs **[executable](executable.md)**
- **[binary](binary.md)** vs **[boolean](boolean.md)**
- **[black](black.md) [race](race.md)** vs **[nigger](nigger.md)** vs **[negro](negro.md)**
- **[branchless](branchless.md) programming** vs **ifless programming**
- **[brute force](brute_force.md)** vs **[heuristic search](heuristic_search.md)**
- **[bug](bug.md)** vs **[glitch](glitch.md)** vs **[error](error.md)** vs **[exception](exception.md)** vs **[fault](fault.md)** vs **[failure](fail.md)** vs **[defect](defect.md)**
- **[cache](cache.md)** vs **[cash](money.md)**
- **[causation](causation.md)** vs **[correlation](correlation.md)** (le [reddit](reddit.md) scientist rule)
- **[cepstrum](cepstrum.md)** vs **[spectrum](spectrum.md)**
- **[chaos](chaos.md)** vs **[randomness](random.md)** vs **[pseudorandomness](pseudorandom.md)** vs **[entropy](entropy.md)** vs **[statistics](statistics.md)** vs **[probability](probability.md)** vs **[stochasticity](stochastic.md)**
- **[class](class.md)** vs **[set](set.md)**
- **[closed source](closed_source.md)** vs **[proprietary](proprietary.md)**
- **[CLI](cli.md)** vs **[TUI](tui.md)** vs **[terminal](terminal_emulator.md)** vs **[console](console.md)**
- **[college](college.md)** vs **[university](university.md)**
- **[color model](color_model.md)** vs **[color space](color_space.md)**
- **[communism](communism.md)** vs **[Marxism](marxism.md)** vs **[socialism](socialism.md)**
- **[complex](complexity.md)** vs **[complicated](complicated.md)**
- **[complex number](complex_number.md)** vs **[imaginary number](imaginary_number.md)**
- **[computer language](computer_language.md)** vs **[programming language](programming_language.md)**
- **[computer science](compsci.md)** vs **[information technology](it.md)** vs **[informatics](informatics.md)** vs **[cybernetics](cybernetics.md)** vs **[computer engineering](computer_engineering.md)** vs **[software engineering](software_engineering.md)**
- **[concurrency](concurrency.md)** vs **[parallelism](parallelism.md)** vs **[quasiparallelism](quasiparallelism.md)** vs **[distribution](distributed.md)**
- **[conjecture](conjecture.md)** vs **[hypothesis](hypothesis.md)** vs **[theory](theory.md)**
- **[constant](constant.md)** vs **[literal](literal.md)**
- **[coding](coding.md)** vs **[programming](programming.md)** vs **[software engineering](software_engineering.md)**
- **[codec](codec.md)** vs **[container format](container_format.md)**
- **[coherence](coherence.md)** vs **[consistency](consistency.md)**
- **[computational model](computational_model.md)** vs **[model of computation](model_of_computation.md)**
- **[convolution](convolution.md)** vs **[correlation](correlation.md)**
- **[copyright](copyright.md)** vs **[patent](patent.md)** vs **[trademark](trademark.md)** vs **[intellectual property](intellectual_property.md)** vs **[moral right](moral_rights.md)** etc.
- **[currency](currency.md)** vs **[money](money.md)**
- **[crossplatform/multiplatform](multiplatform.md)** vs **[portable](portability.md)**
- **[cryptography](cryptography.md)** vs **[security](security.md)**
- **[data](data.md)** vs **[information](information.md)** vs **[entropy](entropy.md)** vs **[signal](signal.md)**
- **[data structure](data_structure.md)** vs **[data type](data_type.md)**
- **[decentralized](decentralization.md)** vs **[distributed](distributed.md)**
- **[declaration](declaration.md)** vs **[definition](definition.md)**
- **[demo](demo.md)** vs **[intro](intro.md)**
- **[democracy](democracy.md)** vs **[voting](voting.md)**
- **[desktop environment](de.md)** vs **[window manager](wm.md)**
- **[duck typing](duck_typing.md)** vs **[weak typing](weak_typing.md)** vs **[dynamic typing](dynamic_typing.md)**
- **[digit](digit.md)** vs **[number](number.md)** vs **[value](value.md)** vs **figure** vs **numeral**
- **[digital](digital.md)** vs **[electronic](electronics.md)**
- **[directed acyclic graph](dag.md)** vs **[tree](tree.md)**
- **[directory](directory.md)** vs **[folder](folder.md)**
- **[discrete Fourier transform](dft.md)** vs **[discrete time Fourier transform](dtft.md)**
- **[electric](electricity.md)** vs **[electronic](electronics.md)**
- **electronic game** vs **[video game](video_game.md)**
- **[emoticon](emoticon.md)** vs **[emoji](emoji.md)** vs **[smiley](smiley.md)**
- **[emulation](emulation.md)** vs **[simulation](simulation.md)**
- **[entity](entity.md)** vs **[object](object.md)**
- **[equation](equation.md)** vs **[expression](expression.md)** vs **[inequality](inequality.md)**
- **[equivalence](equivalence.md)** vs **[implication](implication.md)**
- **[ethics](ethics.md)** vs **[morality](morality.md)**
- **[Euler's number](e.md)** vs **[Euler number](euler_number.md)**
- **[evolutionary programming](evolutionary.md)** vs **[evolutionary algorithm](evolutionary.md)** vs **[genetic programming](genetic_programming.md)** vs **[genetic algorithm](genetic_algorithm.md)**
- **[equality](equality.md)** vs **[identity](identity.md)** (in programming languages)
- **[floating point number](float.md)** vs **[real number](real_number.md)**
- **[font](font.md)** vs **[typeface](typeface.md)**
- **[forwarding](forwarding.md)** vs **[routing](routing.md)** vs **[switching](switching.md)**
- **[framework](framework.md)** vs **[library](library.md)**
- **[free software](free_software.md)** vs **[open source](open_source.md)** vs **[public domain](public_domain.md)** vs **[source available](source_available.md)** vs **[freeware](freeware.md)**
- **[geek](geek.md)** vs **[nerd](nerd.md)**
- **[GNU](gnu.md)/Linux** vs **[Linux](linux.md)**
- **[goniometry](goniometry.md)** vs **[trigonometry](trigonometry.md)**
- **[gradient noise](gradient_noise.md)** vs **[value noise](value_noise.md)**
- **[hyperlink](hyperlink.md)** vs **[link](link.md)** vs **[URI](uri.md)** vs **[URL](url.md)**
- **[ID](id.md)** vs **[token](token.md)** vs **[hash](hash.md)** vs **[handle](handle.md)** vs **[identifier](identifier.md)**
- **[infinite](infinity.md)** vs **[arbitrarily large/unbounded](unbounded.md)**
- **[Internet](internet.md)** vs **[web](web.md)**
- **[Java](java.md)** vs **[JavaScript](js.md)**
- **[kB/mB/gB/tB](memory_units.md)** vs **[KiB/MiB/GiB/TiB](memory_units.md)**
- **[latency/ping/lag](latency.md)** vs **[throughput/bandwidth](throughput.md)**
- **[leftism](left_right.md)** vs **[pseudoleftism](pseudoleft.md)**
- **[lemma](lemma.md)** vs **[theorem](theorem.md)**
- **[liberalism](liberalism.md)** vs **[libertarianism](libertarianism.md)**
- **[license](license.md)** vs **[waiver](waiver.md)**
- **main [memory](memory.md)** vs **working memory** vs **[RAM](ram.md)**
- **[mass](mass.md)** vs **[weight](weight.md)**
- **[method](method.md)** vs **[methodology](methodology.md)**
- **[mod](mod.md)** vs **[mode](mode.md)**
- **[modem](modem.md)** vs **[router](router.md)** vs **[switch](switch.md)**
- **[multisampling](multisampling.md)** vs **[supersampling](supersampling.md)**
- **[nationalism](nationalism.md)** vs **[patriotism](patriotism.md)**
- **[NP](p_vs_np.md)** vs **[NP-hard](np_hard.md)** vs **[NP-complete](np_complete.md)**
- **[paging](paging.md)** vs **[virtual memory](virtual_memory.md)**
- **[path tracing](path_tracing.md)** vs **[ray tracing](ray_tracing.md)** vs **[ray casting](ray_casting.md)**
- **[pointer](pointer.md)** vs **[reference](reference.md)**
- **[principal square root](principal_sqrt.md)** vs **[square root](sqrt.md)** (especially when defining [i](i.md))
- **[probability](probability.md)** vs **[probability density](probability_density.md)**
- **[pseudo](pseudo.md)** vs **[quasi](quasi.md)**
- **[pseudoleft](pseudoleft.md)** vs **[left](left.md)**
- **[pseudoskeptic](pseudosceptic.md)** vs **[skeptic](skeptic.md)**
- **[shading](shading.md)** vs **[shadows](shadow.md)**
- **[science](science.md)** vs **[soyence](soyence.md)**
- **[Unicode](unicode.md)** vs **[UTF](utf.md)**
- **[webpage](webpage.md)** vs **[website](website.md)**
- **[wrap around](wrap.md)** vs **[overflow](overflow.md)**
- ...

## See Also

- [often misunderstood](often_misunderstood.md)