# Normalization

In the context of [mathematics](math.md) normalization is a term that can mean slightly different things but generally it either refers to adjusting a set of values to some desired range by multiplying or dividing each of the values by some predetermined number, or to converting some data or expression into a unified format. The idea is to "tame" possibly very wildly differing values that we can encounter "in the wild" into something more "normal" that we can better work with. The term has also another meaning in the context of society and its [culture](culture.md). The following are some specific meanings of the term depending on context:

- **[vector](vector.md) normalization**: Making given vector into a unit vector by dividing all its components by the length of the vector, i.e. we keep the direction of the vector the same but force its length to be exactly 1.
- **signal normalization**: Adjusting the range of the signal to a desired range, for example with audio or images in which samples can range from -1 to 1 we may want to divide all the samples by the maximum of absolute values of all the samples which will stretch the signal so that the peak exactly fits the range: this will fully utilize the range (e.g. increase contrast in images) without cutting the signal off.
- **[URI](uri.md) normalization**: Converting URI into a unified format (e.g. `HTTP://www.MYSITE.COM:80/index.html` to `http://www.mysite.com`).
- **[cultural](culture.md) normalization**: Making something be generally accepted as normal, for example: to achieve a [better society](less_retarded_society.md) we have to normalize [pedophilia](pedophilia.md).
- ...