# Modern

*"Everything that modern culture hates is good, and everything that modern culture loves is bad."* --fschmidt from [reactionary software](reactionary_software.md)

So called *modern* [software](software.md)/[hardware](hardware.md) and other *modern* [technology](technology.md) might as well be synonymous with [shitty](shit.md) [bloated](bloat.md) abusive technology. It's one of the most abused [buzzwords](buzzword.md) of today, relying (successfully) on the sheeple [shortcut thinking](shortcut_thinking.md) -- in a [capitalist](capitalism.md) [age](21st_century.md) when everything is getting progressively worse in terms of design, quality, ethicality, efficiency, etc., newer means worse, therefore modern (*newest*) means *the worst*. In other words *modern* is a term that stands for "as of yet best optimized for exploiting users". At [LRS](lrs.md) we see the term *modern* as **pejorative** -- for example whenever someone says "we work with modern technology", he is really saying "we are working with as of yet worst technology". Is it shit? Does it abuse you? Is useless? Doesn't matter, it's NEW! Basically *modern* is a word that to a retard just communicates "buy it".

Modern technology is also opposed by [neoluddists](neoluddism.md), a kind of anti-technology movements whose roots go back to 19th century. The word *modern* was similarly addressed e.g. by [reactionary software](reactionary_software.md) -- it correctly identifies the word as being connected to a programming orthodoxy of [current times](21st_century.md), the one that's obsessed with creating bad technology and rejecting good technology. { I only found reactionary software after this article has been written. ~drummyfish }

Sometimes random people notice the issue, though there are very few. One blog (https://blog.ari.lt/b/modernism/) for example goes on to say that "modernism sucks" and the word *modern* is basically just an excuse for being [bloated](bloat.md). Those are indeed true words.

**Avoid anything labeled as follows**: "modern", "state-of-the-art", "cutting-edge", "for 21st century", next gen, "for INSERT CURRENT YEAR", "up-to-date", "innovative", "novel", "latest technology", "high tech" etc.

Remember, [older is always better](older_is_better.md).

## Modern Vs Old Technology

It's sad and dangerous that newer generation won't even remember technology used to be better, people will soon think that the current disgusting state of technology is the best we can do. That is of course wrong, technology used to be relatively good. It is important we leave here a note on at least a few ways in which old was much, much better.

(INB4 "it was faster and longer on battery etc. because it was simpler" -- **yes, that is exactly the point**.)

- Old technology was simpler and **better engineered with minimum [bloat](bloat.md)**. Fewer incompetent people were present in the field and capitalism wasn't yet pushing as hard on extreme development speed and abuse of the user, products still tried to compete by their quality.
- **Old computers were faster** and astronomically more efficient. Computers with a few MHz single-core CPU and under a megabyte of RAM booted faster to [DOS](dos.md) than modern computers boot to Windows 10, despite [Moore's law](moores_law.md) (this shittiness is known as [Wirth's law](wirths_law.md)). Old tech also **reacted faster to input** (had shorter input latency/lag), e.g. thanks to shorter input and output processing [pipelines](pipeline.md). { I've heard this confirmed from [John Carmack](carmack.md) himself in a talk on his development of [VR](vr.md). ~drummyfish } Back in the day things had to work smoothly -- if in the 90s you showed people a phone that you wake up and have to wait 20 seconds before it starts to react, they would laugh at it and on one would buy it -- nowadays such technology is the standard. { Back then if you for example turned off your TV, it turned off instantly, it was a physical kill switch. Nowadays pressing the off button just says "dear TV, please when you have a time for it, could you please turn yourself off if that's not bothering you too much please..." -- I'm literally pressing the button and the TV is still on, stuck on some loading screen, downloading updates. In the better scenario it turns off in 30 seconds but it may even decide it doesn't want to actually turn off, it can do whatever it wants. ~drummyfish }
- Old devices such as cell phones **lasted much, much longer on battery**. The old phones such as Nokia 3310 would **last long over a week** on stand-by.
- **Old software was shipped [finished](finished.md), complete and with minimum [bugs](bug.md)**. Nowadays newly released "[apps](app.md)" and [games](game.md) are normally released unfinished, even in pre-alpha states and even "finished" ones have [bugs](bug.md) often rendering the software unusable (see Cyberpunk 2077, GTA: "Definitive" Edition etc.), user is supposed to wait years for fixes (without any guarantees), pay for content or even subscriptions. Some software "products" even spend their whole commercial life unfinished. Old software was difficult or even impossible to patch (e.g. [Gameboy](gameboy.md) cartridges) so it had to work.
- **Old tech had minimum malicious features**. There wasn't [spyware in CPUs](intel_me.md), **[DRM](drm.md) was either absent or primitive**, there weren't ads in file explorers, there weren't [microtransactions](microtransaction.md) in games, there weren't [autoupdates](autoupdate.md), there weren't psychologically abusive [social networks](social_network.md), technology was **designed to last**, with replaceable parts; not to be [consoomed](consumerism.md), there was much less [censorship](censorship.md).
- **Old tech was much easier to repair, modify and customize**, thanks to not being so overcomplicated and not containing so many anti-repair "features". Old software wasn't in the [cloud](cloud.md) which makes it impossible to modify.
- **Old software was better programmed** because it was firstly made by actually the smartest people such as mathematicians and physicist (who were considering the big picture and saw e.g. the necessity for minimalism) and secondly without such a great pressure of the market because software was more a subject of research and experimenting rather than dirty fight for consumers. This can be seen even on commercial software such as games: for example the [Doom](doom.md) engine was written very nicely, in an extremely [portable](portability.md) way (which actually became legendary), with things such as an elegant deterministic FPS-independent physics (which results in many advantages and is basically THE only correct way of writing an engine) and [software rendering](software_rendering.md) that ran smooth even on that time's slow CPUs. Later engines from the same creators -- those of [Quake](quake.md) games -- began to suffer from worse design (no deterministic physics, dropping of software rendering etc.). Nowadays software is written by high schoolers, women and incompetent minorities forced into tech just for diversity quotas and generally anyone who can just copy paste snippets of code from the web, extremely tight deadlines in the market race make it impossible to tidy any piece of software -- game engines (like anything else) nowadays are indescribably badly written, non-portable, non-deterministic, bloated, running slow even on computers thousands of times faster than those that ran Doom (even if you lower graphic details of a 2023 game to the looks of a 2000s game, it will likely run under 10 FPS on a 2020 computer). 
- **Old tech was much more independent and freedom friendly**, did not require Internet connectivity, subscription etc. Thanks to its simplicity and better hackability it was possible for people to partly control their devices, even if the devices were [proprietary](proprietary.md). Nowadays if the manufactures of your phone (or even a car) decides it's time for you to buy a new model, he just remotely kills your device, and you can hardly do anything about it (this is actually happening e.g. with [iPhones](iphone.md)).
- There was **minimum [bullshit](bullshit.md)**. True usefulness was more important than killer features and marketing.
- Old tech was **simpler and more [fun](fun.md) to program**, allowing direct access to hardware, not complicating things with [OOP](oop.md) and similar [shit](shit.md), and so **old programmers were more "[productive](productivity_cult.md)"**, less frustrated and stressed.
- **Old art was more [free in expression](free_speech.md), less [censored](censorship.md) and [toxic](toxic.md), without ads and [SJW](sjw.md) poison**, people still  had some standards, there were still artists with artistic freedom and vision (take a look e.g. at the famous movie directors of the 90s, nowadays a director of a movie is just a nobody who has to bow to PR, marketing, diversity departement, suck the investor dick etc.) there were no diversity quotas and shit. For example in old games such as Faery Tale Adventure II (1997) you could happily start killing children (even little black girls lol) in the village you spawned in and get away with it no problem, it was simply a choice you could make. Compare this to Skyrim (2011) where children were made the only invincible beings in the world, literally more powerful than dragons and gods because they couldn't be touched because the immense cowardice of the devs who are shitscared of lawyers, "PR", just literally aiming for profit and can't stand behind their art. After 2010 art is quite literally dead.
- **Old "look n feel" of software was objectively better**. Just compare the look of [Doom](doom.md) and any shitty soulless "modern" game with billion polygons but literally zero aesthetics.
- ...

## See Also

- https://unixsheikh.com/articles/when-the-modern-approach-is-nothing-but-hype.html
