# Minimalism

*No gain, no pain.*

In context of [technology](tech.md) minimalism is a design philosophy which puts great emphasis on [simplicity](kiss.md), it says technology should be as simple as possible while still achieving given goal, possibly even a little bit simpler. Minimalism is one of the most (if not the most) important concepts in [programming](programming.md) and technology in general, it could almost be said that becoming a true expert in technology is strongly connected to realizing the importance of simplicity (see e.g. [Unix philosophy](unix_philosophy.md)). One of the first things to stress about minimalism is that it's firstly about **internal simplicity**, i.e. the simplicity of design/repairing/[hacking](hacking.md), and only secondly about the simplicity from the [user](user.md)'s point of view (otherwise we are only dealing with [pseudominimalism](pseudominimalism.md)). The opposite of minimalism is [maximalism](maximalism.md). See also [minimal viable program](minimal_viable_program.md).

Antoine de Saint-Exupéry sums it up with a quote: *we achieve perfection not when there is nothing more to add but when there is nothing left to take away.*

The concept of minimalism is also immensely important in [art](art.md), for example in architecture and design, and in addition there also exists the generalized concept of **life minimalism** which applies said philosophy to all areas of [life](life.md) and which numerous technological minimalists quite naturally start to follow along the way -- life minimalism is about letting go of objects, thoughts and desires that aren't necessarily needed because such things enslave us and mostly just make us more miserable; from time to time you should meditate a little bit about what it is that you really want and need and only keep that. Indeed this is nothing new under the Sun, this wisdom has been present for as long as humans have existed, most religions and philosophers saw a great value in [asceticism](asceticism.md), frugality and even poverty, as owning little leads to [freedom](freedom.md). For instance owning a [car](car.md) is kind of a slavery, you have to clean it, protect it, repair it, [maintain](maintenance.md) it, pay for parking space, pay for gas, pay for insurance -- this is not a small commitment and you sacrifice a significant part of your life and [head space](head_space.md) to it (especially considering additional commitments of similar magnitude towards your your house, garden, clothes, electronics, furniture, pets, bank accounts, social networks and so forth), a minimalist will rather choose to get a simple [suckless](suckless.md) bicycle, travel by public transport or simply walk.

Minimalism is a sign of high [IQ](iq.md) and better developed mind, it is something that requires an intellect strong enough to overcome the human instinct for hoarding to which the unintelligent is a slave -- an instinct that was important in times of scarce resources but one that's become harmful in times when certain resources are abundant and can be consumed without limits. It is like with overeating: the intelligent man is able to restrain from unhealthy overeating to which he is pushed by his instinct.

**Minimalism is necessary for [freedom](freedom.md)** as a free technology can only be that over which no one has a [monopoly](bloat_monopoly.md), i.e. which many people and small parties can utilize, study and modify with affordable effort, without needing armies of technicians just for the maintenance of such technology. Minimalism goes against the creeping overcomplexity of technology which always brings huge costs and dangers, e.g. the cost of [maintenance](maintenance.md) and further development, obscurity, inefficiency ("[bloat](bloat.md)", wasting resources), consumerism, the increased risk of bugs, errors and failure.

There is a so called *[airplane rule](airplane_rule.md)* that states a plane with two engines has twice as many engine problems than a plane with a single engine.

Up until recently in history every engineer would tell you that *the better machine is that with fewer moving parts*. This still seems to hold e.g. in [mathematics](math.md), a field not yet so spoiled by huge commercialization and mostly inhabited by the smartest people -- there is a tendency to look for the most minimal equations -- such equations are considered [beautiful](beauty.md). Science also knows this rule as the [Occam's razor](occams_razor.md). In technology invaded by aggressive commercialization the situation is different, minimalism lives only in the underground and is ridiculed by the mainstream propaganda. Some the minimalist movements, terms and concepts at least somewhat connected to minimalism include (watch out for SJWs, [pseudominimalism](pseudominimalism.md), Nazis etc., we don't automatically fully embrace all things on this list):

- [suckless](suckless.md)
- [cat-v](cat_v.md)
- [bitreich](bitreich.md)
- [Collapse OS](collapseos.md)/[Dusk OS](duskos.md), [collapse](collapse.md) computing
- [less retarded software](lrs.md)
- [Unix philosophy](unix_philosophy.md)
- [KISS](kiss.md)
- [countercomplex](countercomplex.md)
- [permacomputing](permacomputing_wiki.md) (SJW cancer warning)
- [less is more](less_is_more.md)/[worse is better](worse_is_better.md)
- [appropriate technology](appropriate_tech.md)
- [neoluddism](neoluddism.md)
- [reactionary software](reactionary_software.md) (bordering with [pseudominimalism](pseudominimalism.md))
- [plan9](plan9.md), [openbsd](openbsd.md), KISS GNU/Linux and similar (however often obsessed with [bloatcryption](encryption.md), may contain [pseudominimalism](pseudominimalism.md))
- [100rabbits](100rabbit.md) (beware of [SJW](sjw.md) poison)
- [small Internet](small_internet.md), web 1.0, web 0.5, [gopher](gopher.md), [gemini](gemini.md) (watch out: gemini is SJW pseudominimalist bloatcryption poison), ...
- [primitivism](primitivism.md)/[anarcho primitivism](anprim.md), [low tech](low_tech.md), ...
- for potential weaker links to minimalism also check out [retro](retro.md)/[old](old.md)/[boomer](boomer.md) tech, [salvage computing](salvage_computing.md), [degrowth](degrowth.md), [Amish](amish.md), [technophobia](technophobia.md), [demoscene](demoscene.md), [code golf](golf.md), [lightweight](lightweight.md) software, [fantasy consoles](fantasy_console.md) (sadly mostly pseudominimalism), communities around [plain text](plain_text.md), [pubnixes](pubnix.md), some GNU/Linux distros (e.g. [Arch](arch.md), [Gentoo](gentoo.md), KISS Linux, ...), [IRC](irc.md) communities and so on.
- ...

Under [capitalism](capitalism.md) technological minimalism is suppressed in the mainstream as it goes against [corporate](corporation.md) interests, i.e. those of having monopoly control over technology, even if such technology is "[FOSS](foss.md)" (which then becomes just a cool brand, see [openwashing](openwashing.md)). We may, at best, encounter a "shallow" kind of minimalism, so called [pseudominimalism](pseudominimalism.md) which only tries to make things appear minimal, e.g. aesthetically, and hides ugly overcomplicated internals under the facade. [Apple](apple.md) is infamous for this [shit](shit.md).

**Does minimalism mean we have to give up the nice things?** Well, not really, it is more about giving up the [bullshit](bullshit.md), getting rid of addiction and changing an attitude. People addicted to [modern](modern.md) consumerist technology often worry that with minimalism they will lose their drug, typically [games](game.md) or something similar. Remember that with minimalism **we can still have technology for entertainment**, just a non-consumerist one -- instead of consuming a new game each month we may rather focus on creating deeper games that may last longer, e.g. those of a [easy to learn, hard to master](easy_to_learn_hard_to_master.md) kind and building communities around them, or on modifying existing games rather than creating new ones from scratch over and over. Sure, technology would LOOK different, our computer interfaces may become less of a thing of fashion, our games may rely more on aesthetics than realism, but ultimately minimalism can be seen just as trying to achieve the same effect while minimizing waste. If you've been made addicted to bullshit such as buying a new GPU each month so that you can run games at 1000 FPS at progressively higher resolution then of course yes, you will have to suffer a bit of a withdrawal just as a heroin addict suffers when quitting the drug, but just as him in the end you'll be glad you did it.

Remember, you can't lose if you don't play.

A possible **real life analogy** of the mainstream bloated software vs minimalist software is for example this: the bloated, mainstream computing environment (Windows, Mac, "Linux" distros, mainstream web browsers, virtual machines etc.) is like a skyscraper in a city whereas minimalist software is a small, self-sufficient caravan somewhere in the woods. The skyscraper offers luxury but for an enormous price: it's extremely expensive to just build, just its realization requires tons and tons of bullshit like getting permissions, reviewing environmental and economic impacts, paying architects, planning the building process, ensuring safety, keeping to all regulations, getting enough capital, finding companies to contract and so on -- erecting the building will be an enormously stressful and risky task for many dozens of companies which it will be extremely difficult to just coordinate and once the building stands, it will continue to be extremely expensive to just maintain in habitable state, the rent will be enormous as you're paying for maintenance of the whole building, cleaning the stairs, for energies, clean water pumped to high altitudes, security systems, high speed internet and so on, plus you as someone who even "owns" an apartment in the skyscraper will have practically no control over it besides arranging furniture in the room you "own" while also in the end, for getting this kind of "luxury" of maybe getting a nice view of the city, it will even be inferior in many ways: you'll live in constant noise of the city, in polluted air, bombarded by ads and neons from the streets, you'll have to take the lift to your apartment (good luck if electricity goes out), you can't make much noise to not bother the neighbors, you'll have to work your ass off to just pay the bills, you'll have to be constantly cleaning all the marble and glass, becoming slave to the apartment, while risking conflicts with neighbors and so on. Your "apartment" (or a computer program) isn't even really a thing you own, it's just basically a tiny bit of something trivial (four walls) on top of some gigantic platform (the skyscraper inside the big city, the enormous operating system inside a virtual sandbox running in a [cloud](cloud.md) etc.), expensive just by being at this "privileged" location -- in this case we may substitute the word *platform* for *prison*. On the other hand your off-the-grid caravan will be cheap to get and maintain, you'll have complete control over it, be able to make absolutely any modifications to it, you can repair most things yourself (unlike e.g. with a "smart" apartment), it won't bother you with bullshit, there are no loud or annoying neighbors, [ads](marketing.md), no lifts, no safety regulations (in case of fire it's even much safer than living in skyscraper), you won't even have to pay extra taxes you'd pay for a "real" building, you'll be living in a nice, quiet and relaxing environment, have cleaner air, be more self sufficient, making your own solar electricity (and generally not needing so much electricity), flexible, able to move anywhere at any time. All this for basically giving up having a bathtub made of marble. Anyone with half a brain must see the stupidity of choosing to live in the skyscraper.

With increased interest in minimalism the word *minimalism* itself gets misused and abused. Let's be reminded that true minimalism aims to minimize everything that's unnecessary, it starts with good, minimalist design, but ultimately grows outwards and becomes a life philosophy that doesn't stop at the internals of machines, it tries to minimize for example even the desires of the user of the technology. Stopping at minimalist design of internals shouldn't be called minimalism because minimalist design is simply good design -- there is no such thing as a good, non-minimalist internal design. And then there is the shallow capitalist pseudominimalism that bets purely on the looks. The following table sums up the differences:

| what             | internal minimalism | external minimalism |
| ---------------- | ------------------- | ------------------- |
| true minimalism  | yes                 | yes                 |
| good design      | yes                 | no                  |
| pseudominimalism | no                  | yes                 |
| bloat            | no                  | no                  |

[Rob Pike](rob_pike.md), who was once a great [hacker](hacking.md), once stated 5 programming rules which besides others say that "fancy algorithms are slow when *n* is small and *n* is usually small" and "fancy algorithms are buggier than simple ones and they are much harder to implement; use simple algorithms as well as simple data structures."

## Importance Of Minimalism: Simplicity Brings Freedom

It can't be stressed enough that minimalism is absolutely required for technological freedom, i.e. people having, in **practical** ways, control over their tools. While in today's society it is important to have legal freedoms, i.e. support [free software](free_software.md), we must not forget that this isn't enough, a freedom on paper means nothing if it can't be practiced. We need both legal AND [de facto](de_facto.md) freedom over technology, the former being guaranteed by a free [license](license.md), the latter by minimalism. Minimal, simple technology will increase the pool of people and parties who may practice the legal freedoms -- i.e. those to use, study, modify and share -- and therefore ensure that the technology will be developed according to what people need, NOT according to what a corporation needs (which is usually the opposite).

Even if a user of software is not a programmer himself, it is important he chooses to use minimal tools because that makes it more likely his tools can be repaired or improved by SOMEONE from the people. Some people naively think that if they're not programmers, it doesn't matter if they have access and rights to the program's source code, but indeed that is not the case. You want to choose tools that can easily be analyzed and repaired by someone, even if you yourself can't do it. This is measure by so called **[freedom distance](freedom_distance.md)**.

Someone once said: "What I cannot build I do not understand". It is indeed so. And that which one doesn't understand one doesn't control. Using tools you don't control is insanity. These tools will control you.

Minimalism and simplicity increases freedom even of [proprietary](proprietary.md) technology which can be seen e.g. on [games](game.md) for old systems such as [GameBoy](gameboy.md) or [DOS](dos.md) -- these games, despite being proprietary, can and are easily and plentifully played, modified and shared by the people, DESPITE not being free legally, simply because it is easy to handle them due to their simplicity. This just further confirms the correlation of freedom and minimalism.

## See Also

- [KISS](kiss.md)
- [primitivism](primitivism.md)
- [single instruction computer](single_instruction.md)