#!/bin/sh
# Creates HTML version of the wiki.

echo "making HTML"

./make_stats.sh

rm -rf html
mkdir html

cp report.html html
cp pimp_my_lrs.html html
cp ./*.css ./html/

DATE=`date +"%D"`
FILECOUNT=`ls *.md | wc -l`
FILELIST="wiki_pages"
RANDPAGE="random_page"
HEADER1="<html><head><link rel=\"stylesheet\" href=\"style.css\"><title> LRS Wiki: "
HEADER2="</title></head><body><h1>less_retarded_wiki</h1><span class=\"nav\"><a href=\"main.html\">main page</a>, <a class=\"notdead\" href=\"$FILELIST.html\">file list ($FILECOUNT)</a>, <a class=\"notdead\" href=\"https://git.coom.tech/drummyfish/less_retarded_wiki/archive/master.zip\">source</a>, <a class=\"notdead\" href=\"lrs_wiki.7z\">all in md+txt+html+pdf</a>, <a class=\"notdead\" href=\"report.html\">report abuse</a>, <a class=\"notdead\" href=\"wiki_stats.html\">stats</a>, <a class=\"notdead\" href=\"$RANDPAGE.html\">random article</a>, <a class=\"notdead\" id=\"fancylink\" href=\"pimp_my_lrs.html?p=main.html&s=style_fancy.css\">consoomer version</a></span><hr />"
FOOTER="<hr /><p> Powered by nothing. All content available under <a class=\"notdead\" href=\"https://creativecommons.org/publicdomain/zero/1.0/\">CC0 1.0</a> (public domain). Send comments and corrections to drummyfish at disroot dot org. </p></body></html>"

rm $RANDPAGE.md

ls *.md > tmp.txt
ls *.md >> tmp.txt
ls *.md >> tmp.txt
cat tmp.txt | shuf > tmp2.txt

printf "# Random Article\n\nPlease kindly click random link.\n\n" >> $RANDPAGE.md

while read f; do
  echo "[*]($f)" >> $RANDPAGE.md
done <tmp2.txt

rm tmp.txt tmp2.txt

printf "# Wiki Files\n\nThis is an autogenerated page listing all pages.\n\n" > $FILELIST.md

firstFile=true

for f in *.md; do
   fname=$(echo "$f" | sed "s/\.md//g")
   if [ "$firstFile" = true ] ; then
     firstFile=false
   else
     printf " -- " >> $FILELIST.md
   fi

   printf "**[$fname]($f)** ($(cat $f | wc -l))" >> $FILELIST.md
done

for f in *.md; do
   fname=$(echo "$f" | sed "s/\.md//g")
   f2="html/${fname}.html"
   echo "$HEADER1 $fname $HEADER2" > $f2
   cmark-gfm -e table $f | sed "s/\.md\"/.html\"/g" >> $f2
   echo $FOOTER >> $f2
done

# this uses a C program to mark dead links, you can optionally remove this
gcc -O3 mark_dead_links.c -o mark_dead_links
cd html
cp ../mark_dead_links .

for f in *.html; do
   cat $f | ./mark_dead_links > tmp
   mv tmp $f
done

rm mark_dead_links
cd ..
# mark dead links end

echo "$HEADER1 redirect $HEADER2<a href="main.html">Go to main page.</a>$FOOTER" >> html/index.html

echo "</ul> $FOOTER" >> html/$FILELIST

./make_html_single.sh

cp ./lrs_wiki.html html/lrs_wiki_full.html

echo "done"
