# Making Living

*See also [how to](how_to.md) live, [homelessness](homeless.md) etc.*

The question of how to make the ends meet by making something that's to be given out [for free](gratis.md) and without limitations is one of the top question asked in the context of "[FOSS](foss.md)"/[free culture](free_culture.md) under they dystopian [capitalist](capitalism.md) system. Noobs often avoid this area just because they think it can't be done, even though there are ways of doing this and there are many people making living on FOSS, albeit ways perhaps more challenging than those of [proprietary](proprietary.md) products.

One has to be constantly aware that **[money](money.md) and commercialization always brings a high risk of profit becoming the highest priority** (which is a "feature" hard-wired in [capitalism](capitalism.md)) which will compromise the quality and ethics of the produced work. Profiting specifically requires abusing someone else, taking something away from someone. Making money by donations often stands on being popular and being popular often means self censorship, hypocrisy and populism. Therefore **it is ideal to create [LRS](lrs.md) on a completely voluntary basis, for free, in the creator's spare time**. This may be difficult to do but one can choose a lifestyle that minimizes expenses and therefore also time needed to spend at [work](work.md), which will give more free time for the creation of [LRS](lrs.md). This includes living frugally, not consuming hardware and rather reusing [old machines](ancientware.md), making savings, not spending on unnecessary things such as smoking or fashion etc. And of course, if you can't make LRS full-time, you can still find relatively ethical ways of it supporting you and so, again, giving you a little more freedom and resources for creating it.

Also if you can somehow rip off a rich [corporation](corporation.md) and get some money for yourself, do it. Remember, corporations aren't people, they can't feel pain, they probably won't even notice their loss and even if you hurt them, you help the society by hurting a predator.

**Is programming software the only way to make money with LRS?** No, you can do anything related to LRS and you don't even have to know [programming](programming.md). You can create [free](free_culture.md) art such as [game](game.md) assets or writings, you can educate, write articles etc.

## Making Money With "FOSS"

For inspiration we can take a look at traditional ways of making money in FOSS, even if a lot of them may be unacceptable for us as the business of the big FOSS is many times not so much different from the business of big tech corporations.

With "[open source](open_source.md)" it is relatively easy to make money and earn salary as it has become quite successful on the market (though by sacrificing focus on freedom exactly to be able to make money better) -- the simplest way is to simply get a job at some company making open source software such as [Mozilla](mozilla.md), [Blender](blender.md) etc. However the [ethics](ethics.md) of the open source business is quite questionable, in great many cases it's just as harmful as the proprietary industry, "open source" is often nothing more than a brand nowadays. Even though open source technically respects the rules of [free software](free_software.md) licenses, it has (due to its abandonment of ethics) found ways to abuse people in certain ways, e.g. by being a [capitalist software](capitalist_software.md). Therefore open source software is not really [LRS](lrs.md) and we consider this way of making money rather harmful to others.

Working for [free software](free_software.md) organizations such as the [FSF](fsf.md) is probably a better way of making living, even though still not perfect: FSF has been facing some criticism of growing corruption and from the [LRS](lrs.md) point of view they do not address many issues of software such as [bloat](bloat.md), [public domain](public_domain.md) etc.

## Way Of Making Money With LRS

Considering all things mentioned above, here are some concrete things of making money on LRS. Keep in mind that a lot of services (PayPal, Patreon etc.) listed here may possibly be [proprietary](proprietary.md) and unethical, so always check them out and consider free alternatives such as [Liberapay](liberapay.md). The methods are following:

- **[donations](donation.md)**: You may ask for donations e.g. on your website or Patreon (people often ask for [cryptocurrencies](crypto.md) or traditional money via services like [Liberapay](liberapay.md), PayPal or Buy Me a Coffee). For significant earnings you need to be somewhat popular because people donate extremely rarely, but if your work is good, there sometimes appears a generous donor who sends you a lot of money ({Happened to me a few times. I hereby thank all those kind people <3 ~drummyfish}). It can help if you create "content" such as programming videos alongside your project to get some "following", but it may also distract you and take some of your energy. People like [Luke Smith](luke_smith.md) seem to make quite some big money like this. A lot of [free culture](free_culture.md) artists are successful in creating free art this way, even completely [public domain](public_domain.md), for example Kenney (the number one creator at [opengameart](oga.md)). If you are really good at what you do and decide to share freely, the freedom lovers WILL spot you and appreciate your effort as it's still the case most free works out there are sadly super amateur.
- **[crowd funding](crowd_funding.md)**: A method similar to donations but a little more "encouraging" for the donors. You set a financial goal and if enough people donate to reach that goal, you get the money and create the project. Patreon and Kickstarter are typically used for this. Open consoles like [Arduboy](arduboy.md) and [Pokitto](pokitto.md) are examples of FOSS projects founded like this. Disadvantage is you have to reach some kind of popularity and respect rules of the funding platforms, so you'll have to sell part of your soul, will have to censor yourself, do "[marketing](marketing.md)" etc., so it may actually suck.
- **[pay what you want](pay_what_you_want.md)**: Here you create the work and then offer a download with optional payment, typically with some suggested price. People who can't afford to pay don't have to. This method has the advantage of not putting you under deadline pressures like the crowd funding method, also you just don't have to care much about sucking someone's... ehm, you know. Sites like [itch.io](https://itch.io/) are friendly to this option, but don't expect this to make you much.
- **selling physical products and [merchandise](merch.md)** ("merch"): This method makes use of the fact that selling physical items is considered less (even though not completely!) unethical, unlike selling copies of [information](information.md). So you can e.g. create a [free](free_software.md) video [game](game.md) and then sell T-shirts or coffee mugs with that video game's themes. You may write a public domain book and then sell physical printed books (of course, others will be able to sell your book too). In the past some [GNU](gnu.md)/[Linux](linux.md) distros used to sell their systems on nice "officials" CDs, but nowadays CDs are kind of dead. [Open consoles](open_console.md) kind of do this as well, they create [FOSS](foss.md) games and tools and then sell hardware that runs these games.
- You can specifically **make use of the advantages of LRS** and get some company to pay you. For example an [open console](open_console.md) creator will be highly interested in an engine for 3D games that will run on very low-spec embedded hardware because that will increase interest in their product. Existing FOSS engines, even the lightweight ones, are [bloated](bloat.md) and won't run on such hardware, however LRS ones, such as [small3dlib](small3dlib.md), will. Even if the company doesn't pay you directly, they might at least send you their product for free ({I got some open consoles for free for porting [Anarch](anarch.md) to them. ~drummyfish}).
- **selling services**: Like with merchandise, selling services is normally not considered unethical and so we can do it. The services can e.g. be running a server with [LRS](lrs.md) software with paid accounts or offering maintenance/configuration of someone else's servers. This supports the development of the software in question and helps you get paid.
- **selling on proprietary sites** (CONTROVERSIAL): This may not be acceptable by everyone, but it can be possible to create a free work and then distribute it under [free](free_software.md) conditions in some places and simultaneously sell this item in places distributing [proprietary](proprietary.md) assets. E.g. one may create a 3D model and put it under a free license on [opengameart](oga.md) while also selling it in 3D models stores like TurboSquid -- this will make the model available for everyone as free but will make people who don't bother to search the free sites pay for it. This may potentially bring much more money than the other methods as the proprietary stores have big traffic and people there are specifically willing to spend money. However, this supports the [intellectual property](intellectual_property.md) business. **Important note**: read the terms&condition of the proprietary site, it may for example be illegal for you to share your assets elsewhere if the proprietary site makes you *sign* an exclusive deal for them. {I am actually guilty of this, been selling some small 3D models on TurboSquid. It provides a kind of stable mini-income of about $3/month. ~drummyfish}
- **[non-profit](non_profit.md)**: It is possible to run a non-profit organization that creates [software](software.md) (or hardware or whatever) for public benefit -- details differ by each country but a non-profit may receive funding from the state and be exempted from taxes. Check out [EU](eu.md) grants etc. This method may however require a lot of effort (as running an organization is much more difficult than setting a donation website) and may potentially be limiting in some ways (governments may have condition for the funding etc.).
- **abuse state and your employer**: You may at least temporarily avoid [work](work.md) by e.g. registering as unemployed and living on welfare (possibly combined with your saved money), getting some kind of disability pension (pretend you're autist or something) or by getting employed somewhere and becoming "sick" (give something to your doctor so he gives you a sick paper -- if you're a [woman](woman.md) you may for example suck his dick). Do this every few months.
- ...