# Left Vs Right (Vs Pseudoleft)

Left and right are two basic opposing political sides that roughly come down to the pro-equality (left) and pro-hierarchy (right). Historically the terms *left* and *right* came from the opposing sides at which members of national assembly physically sit during 1789 French revolution, however since then they evolved into possessing more generalized meanings of simply anti and pro hierarchy. Unfortunately there is a lot of confusion and vagueness about these terms nowadays, so let us now define them as used on this wiki:

- The (true) **left is pro social equality**, i.e. against social hierarchies. This includes equality of all living beings, period. Note that social equality does NOT imply people being made (or being made to appear) equal in other ways, e.g. physically -- true left accepts difference between people and [races](race.md) and doesn't hide them. Even if the perfectly ideally leftist society can't be completely achieved, true left tries to get **as close to it as possible**. The values of true left are for example sharing, [love](love.md), [selflessness](selflessness.md), [altruism](altruism.md), forgiveness and nonviolence. Groups and movements that are at least highly truly leftist include [anarcho pacifism](anpac.md), [veganism](veganism.md), [free software](free_software.md), [free culture](free_culture.md) and of course [LRS](lrs.md).
- The **right is pro social hierarchy**, i.e. against social equality. This means some people standing above others, be it by strength, power, wealth, social status, privileges etc. The rightist values are mostly those associated with [evil](evil.md), i.e. violence, oppression, conflict, war, revenge, survival of the fittest etc. Among rightism can be included [fascism](fascism.md) (i.e. extreme rightism), [capitalism](capitalism.md), US republican party, states, the military etc. One of right's identifying features is **hypocrisy**, i.e. it judges what's good/bad only by against whom it is targeted, e.g. violence is bad when targeted against "us" ("those Muslims are bad, they want to kill us!") but good when targeted against "them" ("we have to kill those Muslims because they're violent!"); so animals killing humans is judged as "bad" but humans killing animals is "good". In other words right has no sense of morality, only the sense of [self interest](self_interest.md).
- The **pseudoleft** is pretending to be left while in fact being right due to e.g. using non-leftist means (such as violence) or even having non-leftist goals (e.g. benefit of specific minority as opposed to benefit of everyone). Among pseudoleftist movements are [feminism](feminism.md), [LGBT](lgbt.md), [Antifa](antifa.md) or [Marxism](marxism.md). This fact is also supported by the [naming](name_matters.md) of these movements.

There exists a "theory" called a horse shoe. It says that the extremes of the left-right spectrum tend to be alike (violent, hating, radical), just as the two ends of a horse shoe. This is only an illusion caused by ignoring the existence of pseudoleft. The following diagram shows the true situation:

```
TRUE LEFT (peace, selflessness, forgiveness, ...)
     <-------------------.
               /          \
              |            |  <== illusion of horse shoe
              |            |
               \          /
                V        V
           PSEUDOLEFT  RIGHT
    (violence, conflict, aggressivity, ...)
```

We see pseudoleft is something that began as going away from the right but slowly turned around back to its values, just from a slightly different direction. This is because rightism is very easy, it offers tempting short-term solutions such as violence, and so it exhorts a kind of magnetic force on every human -- most cannot resist and only very few get to the true left despite this force.

The current US-centered culture unfortunately forces a **right-pseudoleft false dichotomy**. It is extremely important to realize this dichotomy doesn't hold. Do not become [type A/B fail](fail_ab.md).

What's called *left* in the [modern](modern.md) western culture usually means *pseudoleft*. The existence of pseudoleftism is often overlooked or unknown. It used to be found mainly in the [US](us.md), however globalization spreads this [cancer](cancer.md) all over the world. Pseudoleft justifies its actions with a goal that may seem truly leftist, such as "equality", but uses means completely unacceptable by true left (which are in fact incompatible with equality), such as [violence](violence.md), bullying, lynching, [cancelling](cancel_culture.md), [censorship](censorship.md) or brainwashing. Pseudoleft is aggressive. It believes that **"ends justify the means"** and that **"it's fine to bully a bully"** ("eye for an eye"). A pseudoleftist movement naturally evolves towards shifting its goals from a leftist one such as equality towards a [fascist](fascism.md) one such as a (blind) *fight for some group's rights* (even if that group may already have achieved equality and more).

The difference between left and pseudoleft can be shown in many ways; one of them may be that pseudoleft always wants to **[fight](fight_culture.md)** something, usually the right (as they're essentially the same, i.e. natural competitors). True left wants to end all fights. Pseudoleft invents [bullshit](bullshit.md) artificial issues such as [political correctness](political_correctness.md) that sparks conflict, as it lives by conflict. Left tries to find peace by solving problems. Pseudoleft sees it as acceptable to do bad things to people who commited something it deems bad. True left knows that violence creates violence, it "turns the other cheek", it cures hate with love.

Pseudoleft is extra harmful by deceiving the public into thinking what it does really is leftist. Most normal people that don't think too much therefore stand between a choice of a lesser of two evils: the right and pseudoleft. True left, the true good, is not known, it is overshadowed. Let us now compare a few existing movements/ideologies/groups:

|                            | [LGBT](lgbt.md)   | [Feminism](feminism.md) | [Antifa](antifa.md) | [Nazism](nazi.md) | [MGTOW](mgtow.md) | [BLM](blm.md)       | [Marxism](marxism.m) | [LRS](lrs.md) |
| -------------------------- | ----------------- | ----------------------- | ------------------- | ----------------- | ----------------- | ------------------- | -------------------- | ------------- |
| class                      | pseudoleft        | pseudoleft              | pseudoleft          | right             | right?            | pseudoleft          | pseudoleft           | true left     |
| fights for                 | gay/bi/etc.       | women                   | antifa, pseudoleft  | own race/nation   | men               | black               | proletariat          | no one        |
| fights against             |straight, anti-LGBT| men, anti-Feminists     | right, anti-Antifa  | Jews, other r/n   | women             | non-black, anti-BLM | other classes        | no one        |
| official motive            | "social justice"  | "social justice"        | "self defense"      | "self defense"    | "self defense"    | "self. def.", ...   | superiority          | love          |
| bullying/violence?         | yes               | yes                     | yes                 | yes               | yes               | yes                 | yes                  | no            |
| fanaticism/hysteria?       | yes               | yes                     | yes                 | yes               | probably          | yes                 | yes                  | no            |
| propaganda/brainw./censor.?| yes               | yes                     | yes                 | yes               | probably          | yes                 | yes                  | no            |
|cults of personality/heroes?| yes               | yes                     | yes                 | yes               | yes               | yes                 | yes                  | no            |
| ends justify the means?    | yes               | yes                     | yes                 | yes               | probably          | probably            | yes                  | no            |

Why is there no pseudoright? Because it doesn't make sense :) Left is good, right is a sincere evil and pseudoleft is an evil pretending to be good. A good pretending to be evil doesn't probably exist in any significant form.

**Centrism** means trying to stay somewhere mid way between left and right, but it comes with issues. From our point of view it's like trying to stay in the middle of good and evil, it is definitely pretty bad to decide to be 50% evil. Another issue with centrism is that it is **unstable**. Centrism means balancing on the edge of two opposing forces and people naturally tend to slip towards the extremes, so a young centrist will have about equal probabilities of slipping either towards extreme left or extreme right, and as society polarizes this way, people become yet more and more inclined to defend their team. Knowing centrism is unsustainable, we realize we basically have to choose which extreme to join, and we choose the left extreme, i.e. joining the good rather than the evil.

{ I came to the realization that rightists are actually much more bearable than pseudoleftists -- it makes sense though, pseudoleft is like right, fascist, but with extra evil of added pretence and sneakiness. While rightists are at their core evil, they are actually many times tolerant as they often value free speech, so you can coexist with a rightist, he will tell you your opinions are stupid but he will let you share them, he is like that one friend who you disagree with but still can have a talk with. Yes, that's right, **a rightist is more tolerant than pseudoleftist**. I do by no means defend rightism, it is pure evil, but the fact that it seems bearable compared to pseudoleft says something about pseudoleft -- pseudoleft is just pure psychopathy. A rightist sometimes at least holds some values, for example he will respect your courage to stand behind an opinion you hold even if he hates it, a pseudoleftist has none of that, an SJW just has no emotion except for hate and rage, he has that soulless robotic stare with the word "EXTERMINATE" flashing before his eyes. You mention a trigger word and he bans you on all servers, you'll be lucky if he doesn't call for your public lynching. ~drummyfish }

## See Also

- [SJW](sjw.md)
