# IQ

```
    ________
   /        \
  /          \ 
 |   UNDER    |
 |CONSTRUCTION|
  \          /
   \________/
   
Please wear a hard hat when reading this page.
```

IQ (intelligence quotient) is a non-perfect but [still kind of useful](good_enough.md) measure of one's intelligence, it is a numeric score one gets on a standardized test that tries to estimate his intellectual ability at different tasks ([logic](logic.md), [memory](memory.md), language skills, spatial skills, ...) and express them with a single number. The tests are standardized and the scoring is usually tuned so that the value 100 means average intelligence -- anything above means smarter than average, anything below dumber than average. IQ is a quite controversial topic because it shows intellectual differences between [races](race.md) and sexes and clashes with [political correctness](political_correctness.md), there is also a great debate about "what intelligence even is" (i.e. what the test should measure, what weight should be given to different areas of intelligence), if it is even reasonable to simplify "intelligence" down to a single number, how much of a cultural bias there is (do we really measure pure intellectual capacity or just familiarity with some concepts of our western culture?) and the accuracy of the tests is also highly debated (which can be an issue if we e.g. start using IQ tests to determine who should get higher education and who shouldn't) -- nevertheless it's unquestionable that IQ DOES correlate with intellectual abilities, IQ tests are a tool that really does something, the debates mostly revolve around how useful the tool is, how it should be used, what conclusions can we make with it and so on. Basically only people with the lowest IQ say that IQ is completely useless. The testing of IQ was developed only during 20th century, so we don't know IQs of old geniuses -- if you read somewhere (including this article) that Newton's IQ was 200, it's just someone's wild guess.

IQ follows the normal [probability](probability.md) distribution, i.e. it is modeled by the [bell curve](bell_curve.md) that says how many people of the total population will fall into any given range of IQ score. Though this has been challenged too, one of the basic laws of human stupidity says that the probability that someone is stupid is independent of any other of his characteristics (education, profession, race, sanity, ...). There are various IQ scales, almost all use the Gaussian (bell) curve that's centered at 100 (i.e. 100 is supposed to mean the average intelligence) and have [standard deviation](standard_deviation.md) 15 (but other have been used as well) -- this is what we'll implicitly suppose in the article from now. This means that about 2/3rds of people will fall in the range 85 to 115 but no more than 1% will have IQ higher than 145 or lower than 55. Sometimes you may also encounter so called **percentile** which says what percentage of population is below your IQ.

**Average global IQ is decreasing**, according to https://www.fourmilab.ch/documents/IQ/1950-2050/ it dropped from 91.64 in 1950 to 88.08 in 2020. Reasons for this may range from wider spread of [capitalism](capitalism.md), [feminism](feminism.md) and similar brain diseases to rapidly increasing poverty as well as more brainwashing (ads, [soyence](soyence.md) propaganda etc.) etc.

TODO: more details, history, where to measure (web vs Mensa vs SAT etc.)

```
    * Ada Lovelace * Hitler * Miley Cyrus
   * Donald Trump        * Lassie                                              * Knuth      * Goethe * Kim Ung-Yong
           * Bill Gates              * Neil De Grass                      * Charles Babbage         * Terence Tao
   * Adam Smith * Elon Musk * Bjarne Stroustrup                                     * Unabomber      * Grigori Perelman
            * Steve Jobs                    * Pikachu                             * Einstein       * Jara Cimrman
--------------capitalists-----------                                                          * Terry Davis
  ----------------blacks----------------           * Britney Spears   * ChatGPT  * Chomsky         * Kasparov
  ------------------women (white)---------------------         * Richard Feynman                    * William Sidis
  ----------CEOs------------
 -trees-  ----------webdevs----------  ------janitors-----    ------------true programmers------------
-rocks-    --soldiers--         ------apolitical/centrist/confused------           --------LRS--------
 -bacteria--   ------------coders------------   ------teachers-------    ---------mathematicians------
---feminists--     ---dolphins-- ----geeks--------         -----type A/B fail----
         --chimps---         -------atheists------        -------------------nerds--------------------
  ---------------------------------------------whites-----------------------------------------------
   ---------------------------------------------asians-----------------------------------------------
    ---------------------------------------------jews-------------------------------------------------
   ----------likely called genius--------
 -------fascists-----                                                ------likely called retarded-----                                       
--influencers--                               _.---._
                                            .'       '.
                                          .'           '.
  |    |      |      |      |      |    .'|      |      |'.    |      |      |      |      |    |
  |    |      |      |      |      | _.'  |      |      |  '._ |      |      |      |      |    |
  |    |      |     _|_____.|..---'|'     |      |      |     '|'---..|._____|_     |      |    |
  +----+------+------+------+------+------+------+------+------+------+------+------+------+----+
  |    | SD 6 | SD 5 | SD 4 | SD 3 | SD 2 | SD 1 | SD 1 | SD 2 | SD 3 | SD 4 | SD 5 | SD 6 |    |
  0   10     25     40     55     70     85     100    115    130    145    160    175    190  200

  -----idiot--|-imbecile-|--moron--|   |-dull-|
  ----mental retardation-----------|
    (official medical terminology)        |---68.269%---|--------------------------------------1 in 6.3029----------
                                   |----------95.4499%---------|-------------------------------1 in 43.9558---------
                            |------------------99.73%-----------------|------------------------1 in 740.7956--------
                     |------------------------99.9936%-----------------------|-----------------1 in 31574.4272------
              |------------------------------99.999942%-----------------------------|----------1 in 3488550.5770----
       |-----------------------------------99.999999802%-----------------------------------|---1 in 1013594327.1152-
```

*IQ distribution along with approximate placement of certain groups and individuals. Notice how interesting people are either far to the right or far to the left. Also notice how the smartest you've rarely heard of while you've heard of all the dumbest.*

**IQ and [race](race.md) and [sex](sex.md)**: IQ is correlated with race and sex. The following is a comparison of average IQs of groups with various combination of the two factors:

*men (Jew) > men (Asian) > men (White) > men (Brown) > women (Jew) > women (Asian) > women (White) > women (Brown) > men (Black) > women (Black)*

**If you think you're smart, you are dumb**, see the infamous [Dunning Kruger](dunning_kruger.md) effect -- becoming smarter comes with feeling dumber and dumber, becoming more humble and less self confident as you just see all the new things you didn't even know you don't know -- Socrates, one of the greatest philosophers of all times and possibly the smartest man of his time, famously summed this up by saying "I know that I know nothing". A fool thinks he is close to knowing everything -- he admits he doesn't know everything, but he thinks he knows like 90% of what the smartest people on Earth know because he didn't even step over the borders of obtaining the basic knowledge, that border is as far as he can see and he doesn't know beyond it lies an infinitely large plain of knowledge into which some managed to get kilometers ahead of him, they are so far away he has no idea anyone can even get that far. It's similar to how the better we explore the space, the more we see how tiny we are -- not long ago we might have thought our galaxy was the whole Universe, now we know it's just a tiny speck in a cluster that's itself just a small speck in the observable Universe which is a nothing in the scale of the whole infinite Universe. Self confidence implies extreme stupidity. Also note that feeling dumb doesn't imply being smart but admitting retardedness is a prerequisite for being smart.

**Is IQ a useful measure and if so, how important is the score?** Firstly if you are insecure about your own IQ then just stop that shit -- you know yourself, you know if you're good at math or writing or whatever else you try to do, do you need a piece of paper patting you on the back or something? That's completely pointless, the only thing worth of discussion is IQ as some standardized tool of estimating intellectual abilities of other people on a bigger scale, e.g. as some kind of filter in education (with small groups you can really just interview the people and see if they're dumb or not, that's also more reliable than IQ tests). In this of course the question of the validity of IQ is a controversial one, discussed over and over. Modern "inclusive" society dismisses IQ as basically useless because it points out differences between [races](race.md) etc., some rightist are on the other hand obsessed with IQ too much as it creates a natural hierarchy assigning each man his rank among others. True significance of IQ as a measure seems to be somewhere in between the two extremes here. As it's always noted about IQ, we have to remember the term "intelligence" itself is fuzzy, there doesn't and cannot exist any universal definition of it, so we have trouble even grasping what we're measuring and however we define intelligence, it usually ends up hardly even correlating with "success" or "achievements" or anything similar, so firstly let's see IQ just as what it literally is: a score in some kind of game. Furthermore intelligence is extremely complex and multidimensional (there is spatial and visual intelligence, long and short term memory, language skills, social and emotional intelligence etc.), capturing all this with a single number is inevitably a simplification, the score is just a projected shadow of the intelligence with light cast from certain angle. IQ score definitely does say a lot about some specific kind of "mathematical" intelligence, though even if designed to be so, even in this narrow sense it isn't anywhere near a perfect measure -- though a minority, some mathematicians do score low on IQ tests (Richard Feynman, physics Nobel Prize laureate had famously a relatively low score of 125). It's perhaps good to keep the "IQ tests as a game" mindset -- intelligent people will be probably good at it but some won't, performance can be increased by training, there will be narrowly focused autists who excel at the game but are extremely dumb at everything else etc. Having IQ score predict what we normally understand to be "intelligence" is like having height, weight and age predict how good of a soldier someone will be -- there will be some good correlations, but not nearly perfect ones. Some general IQ range will be necessary for certain tasks such as [programming](programming.md), but rather than +5 on an IQ score things such as education and personality traits will play much more important roles in actually achieving something or creating something good; for example curiosity and determination, the habit of thinking about everything in depth, nonconformity, a skeptical mind, all these are much more important than being a human calculator -- remember, the cheapest calculator will beat the smartest man in multiplying numbers, would you say it is more intelligent?

{ Also consider this: even if you're average, or even a bit below average, you're still [homo](gay.md) sapiens, so as long as you're not a [feminist](feminism.md) or [capitalist](capitalism.md) you'll always be the absolute top organism in intelligence, a member of by far the absolutely most intelligent species that ever appeared on [Earth](earth.md), your intelligence greatly surpasses great majority of living organisms. If you are able to read this, you already possess the great genius, you mastered language and are among the top 0.1%, there's no need to compare yourself to others and aim to be in 0.01% instead of 0.02%. Rather think about what good to do with the gift of reason you've been given. ~drummyfish }

{ It's still more and more complicated the more you think of it, even for example success in mathematics may sometimes depend less on pure math skills and more on non-mathematical kind of intelligence, e.g. that of observation skills and communication -- that's what academia is about. Yes, you need some creativity, but the ability to quickly understand ideas of others may sometimes be superior, an idea you "steal" from someone else is as useful as idea you came up with yourself, you need to catch many ideas of others and connect them together; on the other hand struggling with communication is sometimes simply like not speaking a common language at all. Thinking back I for one have always been quite retarded at understanding what others wanted to say, even simple things, so in classes I frequently wouldn't understand what was being taught while others understood, but it wasn't because I wouldn't understand the concept itself, I rather didn't understand the way the teacher explained it because (I think) I think differently about things. When we were given tasks to solve on our own, I usually beat my classmates because that was only about creative intelligence, not communication, and in this I think I was better than most of my peers. I didn't go for PhD later on while some of my classmates did -- TBH I don't think it's because they were necessarily more intelligent in general (many of them for sure were), but because they felt better in this world of communication, sharing papers, talking to others, understanding their ideas and collaborating, they had the "better mix" of intelligence for today's academic world -- this I always had problems with, so it contributed to my decision to not go there. This is just to show that this world is quite complex. ~drummyfish }

**Fun fact**: in some US countries idiots and similar low IQ level classes are legally prohibited from voting :D

It's been observed that the **IQ of a group** is roughly equal to the IQ of its least intelligent member divided by the number of group members.

**Why are rich people dumb and smart people poor?** Let's clarify this because there is a very common misconception, purposefully established by [capitalist](capitalism.md) propaganda, that rich people are smart and vice versa, while the opposite is always true. Firstly succeeding on the market is basically just lottery, it's more about luck than anything else -- no one can predict the market, it's literally about betting on the right card and then being in many right places at right times. At best if anything gives you better odds, it's having a starting capital, knowing someone in the business, living in a good location etc., but not being smart. No matter what anyone tells you, business is at best an educated bet and a businessman is at best as smart as your average slot machine addict. Now of course, just by statistics, the few people who win the lottery are likely to fall in the majority, i.e. around the average IQ. This is additionally further biased towards lower IQ because success in business is actually favored by lower IQ for a number of reasons. One of them is a stupider man is going to make just plain stupid big risks, have the capitalism-aligned short term mindset, and making stupid risks is how you more likely win the game -- it is also how you more likely lose, but no one cares about the losers, these just disappear. It's like seeing what kind of people survive running through a minefield -- you will find only retards make it because only a retard would attempt it; many of them will die but some manage to run through by sheer luck, while all the smart people just retain from even trying to run through the mine field. That's why so many of the famous rich guys always made some hilariously risky moves like selling everything they had and putting it into their business -- that's just extremely retarded, only 1 in a million will succeed like that, but of course by survivorship bias you will only hear about those who succeed like this so they look smart (plus they will pay for their own propaganda painting them as smart), but no, it's still incredibly stupid. Furthermore success in business is about lack of morality to which intelligence is an obstacle -- an intelligent man sees that investing in some business will e.g. lead to someone in the third world dying, so for a smart man doing business is literally as if he had to murder people for money, which most normal people wouldn't do, but with the extra layer of indirection stupid people can't see the harm they do to others and they happily murder people without even realizing it. Again, this is why the rich guys are incredibly stupid assholes behaving like angry aggressive chimpanzees to their employees, like for example [Steve Jobs](steve_jobs.md) or [Elon Musk](elon_musk.md), they just lack brain cells that you need for empathy. Yet another reason why smart people aren't rich is simply that they see that pursuing money is incredibly retarded, it's just satisfying low material and social needs, it's just like overeating, drug addiction or gambling, it's an arbitrarily set unhealthy goal that achieves nothing but waste one's life on counting pieces of green paper while doing bullshit and immense harm as a side effect, smart people see through this, they want something more from life, they want to spend time with their family, create something that helps others, make art and so on, so they just won't go after money and they even turn down money if they can have it (see e.g. Grigori Perelman). And that is not all still, a stupid idiot may have further advantage in business because he can better predict behavior of idiots as he himself is an idiot, he thinks like one and so knows what idiots (most of population) wants better than someone who is smart.

{ Coincidentally after I wrote this I saw some "REAL STUDY" (as in peer censored etc.) which concluded income is slightly positively correlated with IQ, which is probably true around the average middle IQ (a slightly smarter wage slave will make a bit more money by pressing buttons on a computer than a wage slave moving crates), however the study also noted that by far the few richest individuals that took part in the study (probably some CEOs, they were literally sky high in the graph) were all quite significantly BELOW 100 IQ :D So now it's also official. ~drummyfish }

**Can you increase your IQ?**: Though they're not supposed to be trainable, IQ tests CAN be trained like anything else -- you can train for the tests themselves, they often have the same types of questions -- if you just practice 4 hours making IQ tests for a month before taking an actual IQ test, you'll probably score at genius level, but that's kinda cheating of course, it's better to REALLY train you brain skills by just doing various diverse intellectual challenges like [programming](programming.md), learning languages, playing puzzles, board games or reading books -- this will actually make you smarter. Some studies have shown that playing video games increases IQ, however it probably matters what sort of game it is, mindless grinding in [WoW](wow.md) or cybersexing in Roblox will probably have the opposite effect, you rather want to play puzzle games, strategy games and so on. There was one specific memory game that was shown to really increase IQ scores, though only temporarily (for a few months) -- in the game you saw symbols appearing on the screen and you had to press a button every time a symbol appeared that was the same as a symbol that appeared *N* steps back; you start at *N = 1* and keep training yourself towards higher values, and this basically boosts your short term memory. { Can't find the paper now but I swear I've seen it, I even played the game for a while. ~drummyfish } There are also things like the "Mozart effect" which says that listening to Mozart's music increases your IQ score, but who knows if that's bullshit or not.

TODO: smartest man?

## Real Genius VS Pseudogenius

Most people are called a genius nowadays -- any recent so called "genius" (such as [Steve Jobs](steve_jobs.md)) is in fact most likely of below average IQ; just barely above mediocre idea someone comes up with by chance will be celebrated as that of a genius, **real genius ideas will be met with hostility**; real genius ideas are too good and too far ahead and unacceptable to normal people. Furthermore success in [business](business.md) requires lack of intelligence so as to be unable to see the consequences of one's actions. Your cat watching you solve Riemann hypothesis will not even know what's happening, to it you are a retard wasting time on sliding a stick over table, on the other hand the cat will judge a monkey capable of opening a can of cat food a genius. Society is composed solely of idiots, they can only see if someone is a tiny bit better at what they do than them, and those they celebrate, if you are light years ahead of them they don't even have the capacity to comprehend how good you are at what you do because they can't even comprehend the thing you do. This includes even [PhD](phd.md)s and people with several Nobel Prizes, everyone except the few supporters of [LRS](lrs.md) are just blind idiots playing along with the system, some lucky to succeed in it and some not. This is why shit technology is prospering and [LRS](lrs.md) is being overlooked. It's just another confirmation our ideas as superior.

Consider this analogy (yes, analogies are good): in a race you can only see those who are plus or minus 20 meters away from you, you can assess everyone else's position only by someone else telling you, so if someone is 50 meters ahead of you, you can know but only by someone ahead of you telling you that someone ahead of him told him he saw him there way up in the front. Now since there are many fewer of high IQ people, they have lower probability of being recognized, simply because there are few people capable of recognizing them -- in mainstream places like Universities you still likely will be recognized as there are smart people around, and the knowledge of your genius will be chain propagated to the mainstream monkeys, but if you're a genius outside a mainstream place, the chance is almost zero you will be recognized (and if you're smart you will probably also not try to be recognized, only retards do that). With this mainstream will simply lack information about your intelligence, they will only see a question mark above your head -- they know you're not average, because averages get recognized very quickly, everyone can assess those -- so now they know you're either really smart or really dumb, and since you don't fit the false, twisted idea of mainstream pseudogenius (being rich, famous, ...), they will conclude you belong to the latter class, i.e. that you're a retard. Note that the same effect manifests also with the pseudogenius, just in the opposite way -- the dumbest people, like [CEOs](ceo.md), are too far away from the average (now towards lower values), so the mainstream isn't sure about their intelligence; here however the CEO applies manipulation, he has the money to pay for a biography book that paints him as a genius, he can pay someone to write him speeches so that he appears to say smart things, he pays people to invent things signed by his name, or he simply steals them with the power of money (Edison, Jobs, ...) etc., so he ends up being taken for genius, despite actually being dumber than many animals (even a dog has enough brain cells to feel for example empathy, something way too complex for a CEO).

{ The short story *Country of the Blind* by H. G. Wells is a nice story about this phenomenon of too much competence being seen as a lack of competence, illustrated on a story of a completely healthy man who finds himself in a village of people who are all blind. ~drummyfish }

## Quick IQ Estimates

If you are [American](usa.md) (or just someone else who happened to take the test), your [SAT](sat.md) is basically your IQ, it has been shown that SATs highly correlate with standardized psychologist IQ tests. Just take your percentile on SATs and convert it to IQ and you have your IQ.

If you play [chess](chess.md) and your [Elo](elo.md) rating (in any of the popular pools) is *X*, it's been stated that your IQ is at least *(X - 1000) / 10*. This is only a lower bound, it will approach your real IQ only if you dedicate great deal of your life to chess and reach very close to your true potential. But yeah, this kinda funny and super inaccurate.

IQ is a predictor of achieved education, so if you were good at school -- e.g. won some physics competitions -- you can draw some conclusions. If you went to University, you can kinda estimate your IQ, though not that accurately. If you have a degree in [math](math.md) or [physics](physics.md) your IQ is most likely at least 130, 135 and 140 for bachelor's, master's and [PhD](phd.md) respectively. This is similar for other "hard"/"STEM"/math-like fields like mechanical engineering, chemistry or [computer science](compsci.md) (webdev, software engineering and so on don't count though) -- maybe just subtract 5 or 10 from the lower bound here. This doesn't hold for shitty meme "universities" like those in India and for meme studies like "IT management" or "computer security without math" where they just teach you how to install antiviruses. For humanities and "soft" shittier fields like psychology or arts a degree says your IQ is maybe above 110. Also these estimates don't hold for degrees given to [women](woman.md) or minorities after they year 2000, sorry -- they now give degrees to women and blacks just for showing effort, you'll have to estimate your IQ another way. If you have a degree in [gender studies](gender_studies.md), your IQ is below 30.

**The LRS test**: Here is a quick but extremely accurate IQ estimate. Let *x* be the approximate amount to which you agree with [LRS](lrs.md), expressed in percents. You IQ (SD 15) is approximately *2 * x*. If you can't compute that, subtract 200.

DISCLAIMER: The previous paragraph is suitable to everyone. The following is a binding legal and health advice: STOP [CAPITALISM](capitalism.md).

{ NOTE: There used to be a joke about me being the smartest being on the planet by this test but I removed it because I realized it was probably [egoism](egoism.md) masked as a joke. ~drummyfish }

## See Also

- [divine intellect](terry_davis.md)


