# Implicit

Implicit means something that's assumed unless stated otherwise; it is the opposite of [explicit](explicit.md). For example many [floating point](float.md) formats assume an implicit (not physically stored) bit with value 1 prepended to the explicitly stored mantissa values. Though not the same, the term *implicit* is similar to *[default](default.md)*; for example an implicit/default background [color](color.md) of some image format may be defined as [white](white.md), meaning that unless background color is stated, we suppose the background to be white (though a *default* value may still be explicitly stored; default just means an initial, unchanged value). Implicit values may be important e.g. for saving space -- imagine we have some dataset in which 90% of values are [zero](zero.md); then it is convenient to state zero to be the implicit value and not store such values, by which we'll save 90% of space.