# Frameless Rendering

Frameless rendering is a technique of [rendering](rendering.md) animation by continuously updating an image on the screen by updating single "randomly" selected pixels rather than by showing a quick sequence of discrete frames. This is an alternative to the mainstream [double buffered](double_buffering.md) frame-based rendering traditionally used nowadays.

Typically this is done with [image order](image_order.md) rendering methods, i.e. methods that can immediately and independently compute the final color of any pixel on the screen -- for example with [raytracing](raytracing.md).

The main advantage of frameless rendering is of course saving a huge amount of memory usually needed for double buffering, and usually also increased performance (fewer pixels are processed per second). The animation may also seem more smooth and responsive -- reaction to input is seen faster. Another advantage, and possibly a disadvantage as well, is a **[motion blur](motion_blur.md)** effect that arises as a side effect of updating by individual pixels spread over the screen: some pixels show the scene at a newer time than others, so the previous images kind of blend with the newer ones. This may add realism and also prevent temporal [aliasing](aliasing.md), but blur may sometimes be undesirable, and also the kind of blur we get is "pixelated" and noisy.

Selecting the pixels to update can be done in many ways, usually with some [pseudorandom](pseudorandom.md) selection ([jittered sampling](jittered_sampling.md), [Halton sequence](halton_sequence.md), Poisson Disk sampling, ...), but regular patterns may also be used. There have been papers that implemented adaptive frameless rendering that detected where it is best to update pixels to achieve low noise.

Historically similar (though different) techniques were used on computers that didn't have enough memory for a double buffer or redrawing the whole screen each frame was too intensive on the CPU; programmers had to identify which pixels had to be redrawn and only update those. This resulted in techniques like *adaptive tile refresh* used in scrolling games such as [Commander Keen](commander_keen.md).