# Evil

*Evil always wins in the end. But that's not a reason to join it.*

Evil is something that's in conflict with our goal, it is the opposite of [good](good.md). What's evil therefore depends on what we are trying to achieve (and how, i.e. by which means, which we may technically consider part of the goal). For example when aiming to write efficient programs, [bloated](bloat.md) languages such as [Python](python.md) and [JavaScript](javascript.md) are evil because they are in conflict with the goal, similarly to achieve [well being for everyone](less_retarded_society.md) things such as [capitalism](capitalism.md) and [proprietary](proprietary.md) software are evil and so on.

As [Richard Stallman](rms.md) says, **all evil does some good, which is never a reason to support it**. Just as any good always does a little bit of evil, the opposite also holds: for example [Facebook](facebook.md), a [corporation](corporation.md) who accelerates and largely causes downfall of civilization and kills and tortures millions of people, may on occasion help do something good, for example help people communicate during an emergency, however it is no reason to support Facebook or to stop supporting its destruction.

If we consider evil to be that which is not restrained from amoral behavior, we conclude that in a [competitive](competition.md) system (such as [capitalism](capitalism.md)) evil always wins, simply because it's always in an advantage -- evil always has all possible options at hand to choose from, the amoral ones but also including the moral ones (evil will on occasion do good if it's in its interest), unlike good which limits itself to only choosing from morally sound options. It's like having two [chess](chess.md) players, one being limited by some further rules, for example only being able to take the opponent's pieces in self defense, not being able to attack first -- it is possible the disadvantaged player will win some games, but if they keep perpetually playing games over and over and reach about the same skill level, the disadvantage will inevitably make the crippled player to eventually be losing every single game. In other words good has tied hands, in a perpetual [fight](fight_culture.md) it will always fall behind and lose in the end. The only way for evil (as a form of behavior) to be eliminated is to establish a [non competitive system](less_retarded_society.md).

From now on we'll focus specifically on evil from our point of view, which is largely overlaps with the traditional view of evil before [21st century](21st_century.md). Some signs of such evil include:

- [Self interest](self_interest.md): no one seeking self interest can ever be good, even if on occasion pursuit of self interest may spawn a little bit of good, as mentioned above.
- "Ends justify the means": evil will always use any means necessary to achieve its goal while good will rather not achieve the goal than to use unethical means. It may even be that historically majority of evil is distinguished from good only by making this decision -- goals of many evil groups were many times noble, what made them evil was that they pursued that goal by any available means. The unethical means include for example [censorship](censorship.md), violence, lying and so on. 
- Using excuses such as "if I don't do it, someone else will", "[just doing my job](just_doing_my_job.md)", "[everyone does it](everyone_does_it.md)", "life is a [fight](fight_culture.md)", "people are inherently evil" etc.
- Constantly trying to make others do something, "shape" them, push them into having to behave in some way. A good man is interested in something and lets others live their lives as they want, an evil man is an "[entrepreneur](entrepreneur.md)" constantly stalking others and annoying them, never giving them peace, not interested in things but in making other people do some shit, as they were his toys. It is a [disease](disease.md) of psychopathy, he only desires power for its own sake, he doesn't care if his "business" is complete bullshit, only that it lets him be the king of his slaves, that he has power over them (which he will call by euphemisms such as "[responsibility](responsibility.md)", "caring about them", "feeding them" etc.).
- Using violence and forcing others into things: similarly to the points above, even if one's goals are noble and possibly good, trying to "enforce" them will always turn one into an evil entity, just as it was the case with various "communist" movement and so on. Good will only ever offer ideas, educate, leaving others to accept the ideas voluntarily.
- Being [popular](hero_culture.md): popularity is an unethical tool greatly useful for achieving goals. If it's popular, it's evil with 99% probability, good is practically never popular (it would only be so in [good society](less_retarded_society.md)).
- Manipulation, brainwashing, lying, misleading, pretending, ...
- Hostility towards [morality](morality.md) and [ethics](ethics.md) -- this manifests e.g. by phrases such as "get a job" ("shut up, stop thinking and conform"), "let's just get the work done", by ridiculing idealism of others and so on.
- Being rich. Focusing on money means being evil, additionally large amounts of money are impossible to be achieved ethically and also having a lot of money means sitting on resources that others could be using. So basically being rich is just 100% guarantee of being evil.
- Caring about looks (for example wearing a suit, uniform, makeup, having [tattoos](tattoo.md), piercing, hairstyle etc.). Good looks are cheap but effective form of manipulation, it shows someone wants to manipulate other in a very blatant way.
- ...